/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.budget.formplugin.report.style;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.budget.formplugin.report.style.sceneAndChangetype.SceneAndChangetypeModel;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.ebcommon.common.PresetConstant;
import kd.epm.eb.common.ebcommon.common.enums.ChangewayEnum;
import kd.epm.eb.common.ebcommon.common.enums.DChangeTypeEnum;
import kd.epm.eb.common.ebcommon.common.enums.DimEntityNumEnum;
import kd.epm.eb.common.ebcommon.common.enums.DimTypesEnum;
import kd.epm.eb.common.ebcommon.common.enums.ReportStatusEnum;
import kd.epm.eb.common.ebcommon.common.enums.StorageTypeEnum;
import kd.epm.eb.common.ebcommon.common.enums.TemplateDimEnum;
import kd.epm.eb.common.ebcommon.common.enums.TemplateUsageEnum;
import kd.epm.eb.common.ebcommon.common.enums.report.ReportType;
import kd.epm.eb.common.ebcommon.common.util.DataEntityUtils;
import kd.epm.eb.common.ebcommon.common.util.QFBuilder;
import kd.epm.eb.common.ebcommon.enums.TemplateTypeEnum;
import kd.epm.eb.common.utils.ToStringHelper;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.ebBusiness.allinone.model.McStatus;
import kd.epm.eb.ebBusiness.serviceHelper.ConfigServiceHelper;
import kd.epm.eb.ebBusiness.serviceHelper.MemberServiceHelper;
import kd.epm.eb.ebBusiness.serviceHelper.OrgCurrencyServiceHelper;
import kd.epm.eb.ebBusiness.template.model.Dimension;
import kd.epm.eb.ebBusiness.template.model.TemplateModel;
import kd.epm.eb.ebSpread.domain.Cell;
import kd.epm.eb.ebSpread.domain.view.SpreadManager;
import kd.epm.eb.ebSpread.model.IDimMember;

public class StyleContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String lock_all = "lock_all";
    private transient TemplateModel template;
    private transient SpreadManager sm;
    private transient Command command;
    private String spreadKey;
    private Map<String, String> dict;
    private Map<String, PageViewMemberProps> pageViewMemberPropsMap;
    private Map<String, RowColMemberProps> nonLeafOrLabelMemberPropsMap;
    private Set<String> haveQueryDimCache = new HashSet<String>();
    private Map<String, Map<String, Set<String>>> ebPermMng;
    private Map<String, Map<Integer, String>> orgToSeqToConvertCYs = new HashMap<String, Map<Integer, String>>();
    private Map<String, Boolean> orgToIsautoconvert = new HashMap<String, Boolean>();
    private Map<String, String> orgToCurrency = new HashMap<String, String>();
    private Map<DimTypesEnum, Object> commonNumFilter = new HashMap<DimTypesEnum, Object>();
    private Map<DimTypesEnum, Object> commonIdFilter = new HashMap<DimTypesEnum, Object>();
    private Map<String, Set<String>> changeTypeCollect;
    private Map<String, Set<Long>> parentIdsOfShareMemb = new HashMap<String, Set<Long>>();
    private SceneAndChangetypeModel sceneandchangetype;
    private String auditTrailMemberNumber = null;
    private String ProcessMemberNumber = null;
    private boolean currencyOrgEC = false;
    private String changetypeMemberNumber = null;
    private Set<String> lockStatus = new HashSet<String>();
    private Set<String> unlockStatus = new HashSet<String>();
    private boolean isCsl = false;
    private boolean isView = false;
    private boolean isAdjust = false;
    private boolean isCSTE = false;
    private boolean isQuery = false;
    private AbstractFormPlugin formPlugin;
    private Long reportId;
    private Long modelId;
    private Long taskProcessId;
    private boolean isCommitted;
    private static String[] PERM_KEY_ARRAY = new String[]{"read", "write", "noperm"};
    private Long orgId;

    public StyleContext(TemplateModel template, SpreadManager sm, String spreadKey) {
        this.template = template;
        this.sm = sm;
        this.spreadKey = spreadKey;
        this.command = new Command();
        this.dict = new HashMap<String, String>();
        this.pageViewMemberPropsMap = new HashMap<String, PageViewMemberProps>();
        this.nonLeafOrLabelMemberPropsMap = new HashMap<String, RowColMemberProps>();
        this.readyEnv();
        this.querySceneAndChangetypeOfPageView();
        this.queryProcessAndAuditTrailOfPageView();
    }

    public Long getTaskProcessId() {
        return this.taskProcessId;
    }

    public void setTaskProcessId(Long taskProcessId) {
        this.taskProcessId = taskProcessId;
    }

    public boolean getIsCommitted() {
        return this.isCommitted;
    }

    public void setIsCommitted(boolean isCommitted) {
        this.isCommitted = isCommitted;
    }

    public void setCsl(boolean isCsl) {
        this.isCsl = isCsl;
    }

    public boolean isCsl() {
        return this.isCsl;
    }

    public boolean isCWP() {
        return ("IRpt".equals(this.ProcessMemberNumber) || "CS".equals(this.ProcessMemberNumber)) && "CWP".equals(this.auditTrailMemberNumber);
    }

    public void setView(boolean isView) {
        this.isView = isView;
    }

    public boolean isView() {
        return this.isView;
    }

    public Long getReportId() {
        return this.reportId;
    }

    public void setReportId(Long reportId) {
        this.reportId = reportId;
    }

    public void setCSTE(boolean isCSTE) {
        this.isCSTE = isCSTE;
    }

    public boolean isCSTE() {
        return this.isCSTE;
    }

    public void setModelId(Long modelId) {
        this.modelId = modelId;
    }

    public AbstractFormPlugin getFormPlugin() {
        return this.formPlugin;
    }

    public void setFormPlugin(AbstractFormPlugin formPlugin) {
        this.formPlugin = formPlugin;
    }

    public void resume(TemplateModel template, SpreadManager sm) {
        this.template = template;
        this.sm = sm;
        this.command = new Command();
        this.initShareMembInfo();
        this.queryMemberInfoOfPageView();
        this.queryNonLeafOrLabelMemberInfoOfRowCol();
        this.querySceneAndChangetypeOfPageView();
        this.queryProcessAndAuditTrailOfPageView();
        this.cacheOrgEC();
    }

    private void readyEnv() {
        this.queryDim2MembRelation();
        if (this.isOnlyReadTemplate() || this.isUsageQueryTemplate()) {
            this.setStopCommand();
            return;
        }
        this.initShareMembInfo();
        this.queryMemberInfoOfPageView();
        this.queryNonLeafOrLabelMemberInfoOfRowCol();
        this.cacheOrgEC();
    }

    private void cacheOrgEC() {
        String ecCurrency = "";
        String currency = "";
        List list1 = this.sm.getFilter().getViewPointDomain().getAllMembers();
        for (IDimMember e : list1) {
            String dimenNum = e.getDimension().getNumber();
            if (DimTypesEnum.ENTITY.getNumber().equals(dimenNum)) {
                ecCurrency = this.getCurrencyDynaObjByOrgNumber(e.getNumber());
                continue;
            }
            if (!DimTypesEnum.CURRENCY.getNumber().equals(dimenNum)) continue;
            currency = e.getNumber();
        }
        List list2 = this.sm.getFilter().getPageDomain().getAllMembers();
        for (IDimMember e : list2) {
            String dimenNum = e.getDimension().getNumber();
            if (DimTypesEnum.ENTITY.getNumber().equals(dimenNum)) {
                ecCurrency = this.getCurrencyDynaObjByOrgNumber(e.getNumber());
                continue;
            }
            if (!DimTypesEnum.CURRENCY.getNumber().equals(dimenNum)) continue;
            currency = e.getNumber();
        }
        this.currencyOrgEC = !StringUtils.isEmpty((String)ecCurrency) && !StringUtils.isEmpty((String)currency) && ecCurrency.equals(currency) || "EC".equals(currency);
    }

    public Map<String, Set<String>> getChangeTypeCollect() {
        if (this.changeTypeCollect == null) {
            QFBuilder qf = new QFBuilder();
            qf.add("model", "=", (Object)this.modelId);
            qf.add("changeway", "in", Arrays.asList(ChangewayEnum.EARLYYEARADJUST.index, ChangewayEnum.EARLYYEARTURN.index));
            Collection changeType = BusinessDataServiceHelper.loadFromCache((String)DimEntityNumEnum.CHANGETYPE.getEntityNum(), (String)"id, number, changeway", (QFilter[])qf.toArray()).values();
            this.changeTypeCollect = changeType.stream().collect(Collectors.groupingBy(v -> v.getString("changeway"), Collectors.mapping(v -> v.getString("number"), Collectors.toSet())));
        }
        return this.changeTypeCollect;
    }

    private String getCurrencyDynaObjByOrgNumber(String orgNumber) {
        QFilter numberFilter = new QFilter("number", "=", (Object)orgNumber);
        QFilter modelFilter = new QFilter("model", "=", (Object)this.template.getModelId());
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((String)"epm_entitymembertree", (String)"id, currency, model", (QFilter[])new QFilter[]{numberFilter, modelFilter});
        if (org == null) {
            return "";
        }
        QFilter numberFilter1 = new QFilter("number", "=", (Object)org.getString("currency.number"));
        DynamicObject dynaCurrency = BusinessDataServiceHelper.loadSingleFromCache((String)"epm_currencymembertree", (String)"id, name, number", (QFilter[])new QFilter[]{numberFilter1, modelFilter});
        return dynaCurrency.getString("number");
    }

    public boolean getCurrencyOrgEC() {
        return this.currencyOrgEC;
    }

    public boolean hasNoneLeafOrLableMemberOnPageViewDim() {
        return this.pageViewMemberPropsMap.values().stream().anyMatch(p -> !p.isLeaf || p.isLabel);
    }

    public boolean isActual(String changetypeMemberNumber) {
        if (changetypeMemberNumber != null) {
            return "Occupation".equals(changetypeMemberNumber) || "Execute".equals(changetypeMemberNumber);
        }
        return false;
    }

    public boolean isDataIntegration(String changetypeMemberNumber) {
        if (changetypeMemberNumber != null) {
            return "DataIntegration".equals(changetypeMemberNumber);
        }
        return false;
    }

    public Map<String, String> getNoneLeafOrLableMemberOnPageViewDim() {
        HashMap<String, String> result = new HashMap<String, String>();
        this.pageViewMemberPropsMap.keySet().stream().forEach(e -> {
            PageViewMemberProps member = this.pageViewMemberPropsMap.get(e);
            if (!member.isLeaf || member.isLabel) {
                result.put((String)e, member.number);
            }
        });
        return result;
    }

    public boolean contrainsNoneLeafOrLableMemberOnRowColDim(String key) {
        return this.nonLeafOrLabelMemberPropsMap.containsKey(key);
    }

    public void getNoneLeafOrLableMemberOnRowColDim(String key, Set<String> set) {
        if (this.nonLeafOrLabelMemberPropsMap.containsKey(key)) {
            set.add(key);
        }
    }

    public boolean checLockLProcessAndCurrency(List<IDimMember> dimMembers, String masterCY, String orgNum) {
        String process = "";
        String currency = "";
        for (IDimMember dimMember : dimMembers) {
            if (this.pageViewMemberPropsMap.containsKey(DimTypesEnum.PROCESS.getNumber())) {
                process = this.pageViewMemberPropsMap.get((Object)DimTypesEnum.PROCESS.getNumber()).number;
            } else if (dimMember.getDimension().getNumber().equals(DimTypesEnum.PROCESS.getNumber())) {
                process = dimMember.getNumber();
            }
            if (this.pageViewMemberPropsMap.containsKey(DimTypesEnum.CURRENCY.getNumber())) {
                currency = this.pageViewMemberPropsMap.get((Object)DimTypesEnum.CURRENCY.getNumber()).number;
                continue;
            }
            if (!dimMember.getDimension().getNumber().equals(DimTypesEnum.CURRENCY.getNumber())) continue;
            currency = dimMember.getNumber();
        }
        if (this.getOrgToCurrency().get(orgNum) != null && this.getOrgToCurrency().get(orgNum).equals(currency)) {
            return false;
        }
        return "IRpt".equals(process) && (currency.equals(masterCY) || this.checkConvertCY(currency, orgNum));
    }

    public boolean checkConvertCY(String cyNum, String orgNum) {
        if ("EC".equals(cyNum) || this.getOrgToCurrency().get(orgNum) != null && this.getOrgToCurrency().get(orgNum).equals(cyNum)) {
            return false;
        }
        return this.getSeqToConvertCYs().get(orgNum) != null && this.getSeqToConvertCYs().get(orgNum).size() > 0 && !this.getSeqToConvertCYs().get(orgNum).get(1).equals(cyNum) && this.getSeqToConvertCYs().get(orgNum).values().contains(cyNum);
    }

    public boolean checkLockProcess(List<IDimMember> dimMembers, String process) {
        if (process != null && ("DADJ".equals(process) || "DEJE".equals(process) || "CS".equals(process) || "EJE".equals(process) || "CT".equals(process) || "CSTE".equals(process))) {
            return true;
        }
        if (dimMembers != null) {
            for (IDimMember dimMember : dimMembers) {
                if (!dimMember.getDimension().getNumber().equals(DimTypesEnum.PROCESS.getNumber()) || !"DADJ".equals(dimMember.getNumber()) && !"DEJE".equals(dimMember.getNumber()) && !"CS".equals(dimMember.getNumber()) && !"EJE".equals(process) && !"CT".equals(process) && !"CSTE".equals(process)) continue;
                return true;
            }
        }
        return false;
    }

    private void queryNonLeafOrLabelMemberInfoOfRowCol() {
        HashSet dimNumberSet = new HashSet();
        this.template.getAreaRangeEntries().forEach(e -> {
            e.getRowDimEntries().forEach(r -> dimNumberSet.add(r.getDimension().getNumber()));
            if (this.template.getTemplateType().equals(TemplateTypeEnum.MSN.getType())) {
                e.getColDimEntriesExt().forEach(c -> c.getDimMembers().forEach(dim -> dimNumberSet.add(((Dimension)dim.p1).getNumber())));
            } else {
                e.getColDimEntries().forEach(c -> dimNumberSet.add(c.getDimension().getNumber()));
            }
        });
        dimNumberSet.forEach(e -> {
            DynamicObjectCollection coll;
            if (this.haveQueryDimCache.contains(e)) {
                return;
            }
            QFilter filtNum = new QFilter("dimension.number", "=", e);
            QFilter filtModel = new QFilter("model.id", "=", (Object)this.template.getModelId());
            QFilter filtNonLeaf = new QFilter("isleaf", "=", (Object)false);
            QFilter filtLabel = new QFilter("storagetype", "=", (Object)StorageTypeEnum.LABEL.getOIndex());
            Set<Long> noLeafBaseMembIds = this.parentIdsOfShareMemb.get(e);
            if (noLeafBaseMembIds == null) {
                noLeafBaseMembIds = new HashSet<Long>();
            }
            QFilter filtShare = new QFilter("id", "in", noLeafBaseMembIds);
            if (DataEntityUtils.isIncludeShareField((String)this.ifGetOrSetDict((String)e))) {
                filtNum.and(new QFilter("storagetype", "!=", (Object)StorageTypeEnum.SHARE.getOIndex()));
            }
            if ((coll = QueryServiceHelper.query((String)this.ifGetOrSetDict((String)e), (String)"isleaf,storagetype,number,id", (QFilter[])new QFilter[]{filtNum.and(filtModel).and(filtNonLeaf.or(filtLabel).or(filtShare))})) != null) {
                coll.forEach(dyna -> this.nonLeafOrLabelMemberPropsMap.put(e + "|" + dyna.getString("number"), new RowColMemberProps(dyna.getString("number"), this.isLeaf((DynamicObject)dyna, (String)e), this.isLabel(dyna.getString("storagetype")))));
            }
            this.haveQueryDimCache.add((String)e);
        });
    }

    private void initShareMembInfo() {
        this.parentIdsOfShareMemb = MemberServiceHelper.getShareMembInfo((Long)this.getTemplate().getModelId());
    }

    private void queryMemberInfoOfPageView() {
        LinkedList<String> dimnumbers = new LinkedList<String>(this.getPageViewMemberPropsMap().keySet());
        this.sm.getFilter().getViewPointDomain().getAllMembers().forEach(e -> {
            this.refleshMember(e.getDimension().getNumber(), e.getNumber());
            dimnumbers.remove(e.getDimension().getNumber());
        });
        this.sm.getFilter().getPageDomain().getAllMembers().forEach(e -> {
            this.refleshMember(e.getDimension().getNumber(), e.getNumber());
            dimnumbers.remove(e.getDimension().getNumber());
        });
        dimnumbers.forEach(dimnumber -> this.getPageViewMemberPropsMap().remove(dimnumber));
    }

    private void querySceneAndChangetypeOfPageView() {
        QFilter qfroot;
        QFilter qfmodel;
        DynamicObjectCollection dot;
        this.sceneandchangetype = new SceneAndChangetypeModel();
        this.sm.getFilter().getViewPointDomain().getAllMembers().forEach(e -> {
            String dimenNum = e.getDimension().getNumber();
            if (DimTypesEnum.SCENARIO.getNumber().equals(dimenNum)) {
                this.sceneandchangetype.setSceneInWhere(TemplateDimEnum.View);
                this.sceneandchangetype.setSceneMemNum(e.getNumber());
                QFilter numberqf = new QFilter("number", "=", (Object)e.getNumber());
                QFilter modelqf = new QFilter("model", "=", (Object)this.template.getModelId());
                DynamicObject dot = QueryServiceHelper.queryOne((String)"epm_scenemembertree", (String)"dchangetype", (QFilter[])new QFilter[]{numberqf, modelqf});
                if (dot != null) {
                    String dchangetype = dot.getString("dchangetype");
                    this.sceneandchangetype.setSceneMemenum(dchangetype.equals("0") ? DChangeTypeEnum.YTD : (dchangetype.equals("1") ? DChangeTypeEnum.CurrentPeriods : DChangeTypeEnum.All));
                }
                if (DChangeTypeEnum.All == this.sceneandchangetype.getSceneMemenum()) {
                    this.sceneandchangetype.setNeedLock(false);
                    return;
                }
            } else if (DimTypesEnum.CHANGETYPE.getNumber().equals(dimenNum)) {
                this.sceneandchangetype.setChangetypeInWhere(TemplateDimEnum.View);
                this.sceneandchangetype.setChangeTypeMemNum(e.getNumber());
                if (!(this.sceneandchangetype.getChangeTypeMemNum().equals("CurrentPeriod") || this.sceneandchangetype.getChangeTypeMemNum().equals("YTD") || this.sceneandchangetype.getChangeTypeMemNum().equals("BFLY"))) {
                    this.sceneandchangetype.setNeedLock(false);
                    return;
                }
            } else if (DimTypesEnum.AUDITTRIAL.getNumber().equals(dimenNum)) {
                this.auditTrailMemberNumber = e.getNumber();
            }
        });
        this.sm.getFilter().getPageDomain().getAllMembers().forEach(e -> {
            String dimenNum = e.getDimension().getNumber();
            if (DimTypesEnum.SCENARIO.getNumber().equals(dimenNum)) {
                this.sceneandchangetype.setSceneInWhere(TemplateDimEnum.Page);
                this.sceneandchangetype.setSceneMemNum(e.getNumber());
                QFilter numberqf = new QFilter("number", "=", (Object)e.getNumber());
                QFilter modelqf = new QFilter("model", "=", (Object)this.template.getModelId());
                DynamicObject dot = QueryServiceHelper.queryOne((String)"epm_scenemembertree", (String)"dchangetype", (QFilter[])new QFilter[]{numberqf, modelqf});
                if (dot != null) {
                    String dchangetype = dot.getString("dchangetype");
                    this.sceneandchangetype.setSceneMemenum(dchangetype.equals("0") ? DChangeTypeEnum.YTD : (dchangetype.equals("1") ? DChangeTypeEnum.CurrentPeriods : DChangeTypeEnum.All));
                }
                if (DChangeTypeEnum.All == this.sceneandchangetype.getSceneMemenum()) {
                    this.sceneandchangetype.setNeedLock(false);
                    return;
                }
            } else if (DimTypesEnum.CHANGETYPE.getNumber().equals(dimenNum)) {
                this.sceneandchangetype.setChangetypeInWhere(TemplateDimEnum.Page);
                this.sceneandchangetype.setChangeTypeMemNum(e.getNumber());
                if (!this.sceneandchangetype.getChangeTypeMemNum().equals("CurrentPeriod") && !this.sceneandchangetype.getChangeTypeMemNum().equals("YTD")) {
                    this.sceneandchangetype.setNeedLock(false);
                    return;
                }
            } else if (DimTypesEnum.AUDITTRIAL.getNumber().equals(dimenNum)) {
                this.auditTrailMemberNumber = e.getNumber();
            }
        });
        if (DChangeTypeEnum.YTD == this.sceneandchangetype.getSceneMemenum() && "CurrentPeriod".equals(this.sceneandchangetype.getChangeTypeMemNum()) || DChangeTypeEnum.CurrentPeriods == this.sceneandchangetype.getSceneMemenum() && "YTD".equals(this.sceneandchangetype.getChangeTypeMemNum())) {
            this.sceneandchangetype.setLockAll(true);
        }
        if (this.sceneandchangetype.isNeedLock() && !this.sceneandchangetype.isLockAll() && (dot = QueryServiceHelper.query((String)"epm_scenemembertree", (String)"number,dchangetype", (QFilter[])new QFilter[]{qfmodel = new QFilter("model", "=", (Object)this.template.getModelId()), qfroot = new QFilter("level", "!=", (Object)1)})) != null) {
            HashMap<String, String> sceneMember = new HashMap<String, String>();
            for (DynamicObject scene : dot) {
                sceneMember.put(scene.getString("number"), scene.getString("dchangetype"));
            }
            this.sceneandchangetype.setSceneMem(sceneMember);
        }
    }

    private void queryProcessAndAuditTrailOfPageView() {
        this.sm.getFilter().getViewPointDomain().getAllMembers().forEach(e -> {
            String dimenNum = e.getDimension().getNumber();
            if (DimTypesEnum.PROCESS.getNumber().equals(dimenNum)) {
                this.setProcessMemberNumber(e.getNumber());
            } else if (DimTypesEnum.CHANGETYPE.getNumber().equals(dimenNum)) {
                this.changetypeMemberNumber = e.getNumber();
            } else if (DimTypesEnum.AUDITTRIAL.getNumber().equals(dimenNum)) {
                this.auditTrailMemberNumber = e.getNumber();
            }
        });
        this.sm.getFilter().getPageDomain().getAllMembers().forEach(e -> {
            String dimenNum = e.getDimension().getNumber();
            if (DimTypesEnum.PROCESS.getNumber().equals(dimenNum)) {
                this.setProcessMemberNumber(e.getNumber());
            } else if (DimTypesEnum.CHANGETYPE.getNumber().equals(dimenNum)) {
                this.changetypeMemberNumber = e.getNumber();
            } else if (DimTypesEnum.AUDITTRIAL.getNumber().equals(dimenNum)) {
                this.auditTrailMemberNumber = e.getNumber();
            }
        });
    }

    public void refleshMember(String dimNumber, String membNumber) {
        DynamicObject dyna;
        String key = dimNumber;
        PageViewMemberProps pageViewMemberProps = this.pageViewMemberPropsMap.get(key);
        if (pageViewMemberProps != null && pageViewMemberProps.number.equals(membNumber)) {
            return;
        }
        String entityNum = this.ifGetOrSetDict(dimNumber);
        QFilter filter = new QFilter("model.id", "=", (Object)this.template.getModelId());
        filter.and(new QFilter("number", "=", (Object)membNumber));
        filter.and(new QFilter("longNumber", "like", (Object)(dimNumber + "%")));
        if (DataEntityUtils.isIncludeShareField((String)entityNum)) {
            filter.and(new QFilter("storagetype", "!=", (Object)StorageTypeEnum.SHARE.getOIndex()));
        }
        Preconditions.checkArgument(((dyna = QueryServiceHelper.queryOne((String)entityNum, (String)"isleaf,storagetype,number,id", (QFilter[])new QFilter[]{filter})) != null ? 1 : 0) != 0, (Object)ResManager.loadResFormat((String)"\u6210\u5458\u7f16\u7801\u201c%1\u201d\u627e\u4e0d\u5230\u3002", (String)"StyleContext_0", (String)"epm-eb-budget", (Object[])new Object[]{membNumber}));
        this.pageViewMemberPropsMap.put(key, new PageViewMemberProps(membNumber, this.isLeaf(dyna, dimNumber), this.isLabel(dyna.getString("storagetype")), dyna.getLong("id")));
    }

    private boolean isLabel(String val) {
        return StorageTypeEnum.LABEL.getOIndex().equals(val);
    }

    public boolean isLeaf(DynamicObject membObj, String dimNum) {
        Set<Long> baseMembIds;
        boolean baseResult = membObj.getBoolean("isleaf");
        if (!baseResult && MemberServiceHelper.needCheckShareMemb((String)dimNum) && (baseMembIds = this.parentIdsOfShareMemb.get(dimNum)) != null) {
            baseResult = !this.parentIdsOfShareMemb.get(dimNum).contains(membObj.getLong("id"));
        }
        return baseResult;
    }

    private void queryDim2MembRelation() {
        DynamicObjectCollection dynaColl = QueryServiceHelper.query((String)"epm_dimension", (String)"number,membermodel", (QFilter[])new QFilter[]{new QFilter("model.id", "=", (Object)this.template.getModelId())});
        dynaColl.forEach(e -> this.dict.put(e.getString("number"), e.getString("membermodel")));
    }

    private String ifGetOrSetDict(String dimNumber) {
        if (!this.dict.containsKey(dimNumber)) {
            DynamicObject dynaDim = QueryServiceHelper.queryOne((String)"epm_dimension", (String)"membermodel", (QFilter[])new QFBuilder().add("model.id", "=", (Object)this.template.getModelId()).add("number", "=", (Object)dimNumber).toArray());
            this.dict.put(dimNumber, dynaDim.getString("membermodel"));
        }
        return this.dict.get(dimNumber);
    }

    public boolean isContinueCommand() {
        return this.command.isContinue;
    }

    public void setStopCommand() {
        this.command.isContinue = false;
    }

    public void setStartCommand() {
        this.command.isContinue = true;
    }

    public TemplateModel getTemplate() {
        return this.template;
    }

    public SpreadManager getSpreadManager() {
        return this.sm;
    }

    public String getSpreadKey() {
        return this.spreadKey;
    }

    public void setSpreadKey(String spreadKey) {
        this.spreadKey = spreadKey;
    }

    public boolean[] checkPageViewCurrencyStatus(StyleContext ctx, long modelId) {
        boolean issubmit0 = false;
        boolean isstop = false;
        if (!(ctx.getPageViewMemberPropsMap().containsKey(DimTypesEnum.SCENARIO.getNumber()) && ctx.getPageViewMemberPropsMap().containsKey(DimTypesEnum.YEAR.getNumber()) && ctx.getPageViewMemberPropsMap().containsKey(DimTypesEnum.PERIOD.getNumber()) && ctx.getPageViewMemberPropsMap().containsKey(DimTypesEnum.ENTITY.getNumber()) && ctx.getPageViewMemberPropsMap().containsKey(DimTypesEnum.CURRENCY.getNumber()))) {
            return new boolean[]{issubmit0, isstop};
        }
        String orgNum = ctx.getPageViewMemberPropsMap().get((Object)DimTypesEnum.ENTITY.getNumber()).number;
        long orgId = ctx.getPageViewMemberPropsMap().get(DimTypesEnum.ENTITY.getNumber()).getId();
        long scenarioId = ctx.getPageViewMemberPropsMap().get(DimTypesEnum.SCENARIO.getNumber()).getId();
        long yearId = ctx.getPageViewMemberPropsMap().get(DimTypesEnum.YEAR.getNumber()).getId();
        long periodId = ctx.getPageViewMemberPropsMap().get(DimTypesEnum.PERIOD.getNumber()).getId();
        String currencyNum = ctx.getPageViewMemberPropsMap().get((Object)DimTypesEnum.CURRENCY.getNumber()).number;
        if (StringUtils.isEmpty((String)currencyNum)) {
            isstop = false;
            issubmit0 = false;
            return new boolean[]{issubmit0, isstop};
        }
        String orgCurrencyNum = null;
        if (orgId != 0L) {
            DynamicObject orgCurrency = OrgCurrencyServiceHelper.getCurrencyDynByIdThrow((Long)orgId, (Long)yearId, (Long)periodId);
            orgCurrencyNum = orgCurrency.getString("number");
        }
        if ("EC".equals(currencyNum) || currencyNum.equals(orgCurrencyNum)) {
            if (modelId != 0L && orgId != 0L && scenarioId != 0L && yearId != 0L && periodId != 0L) {
                isstop = true;
                issubmit0 = McStatus.getMcStatus((Object)modelId, (Object)orgId, (Object)scenarioId, (Object)yearId, (Object)periodId).getFlow().isSubmit();
            } else {
                isstop = false;
                issubmit0 = false;
            }
        } else if (this.getOrgToCurrency().get(orgNum) == null) {
            isstop = false;
            issubmit0 = false;
        } else {
            isstop = true;
            issubmit0 = false;
        }
        return new boolean[]{issubmit0, isstop};
    }

    public boolean checkRowColCurrencyStatus(Cell e, StyleContext ctx, Long modelId) {
        QFilter modelqfilter = new QFilter("model", "=", (Object)modelId);
        boolean issubmit = false;
        if (!(ctx.getPageViewMemberPropsMap().containsKey(DimTypesEnum.SCENARIO.getNumber()) && ctx.getPageViewMemberPropsMap().containsKey(DimTypesEnum.YEAR.getNumber()) && ctx.getPageViewMemberPropsMap().containsKey(DimTypesEnum.PERIOD.getNumber()) && ctx.getPageViewMemberPropsMap().containsKey(DimTypesEnum.ENTITY.getNumber()) && ctx.getPageViewMemberPropsMap().containsKey(DimTypesEnum.CURRENCY.getNumber()))) {
            return issubmit;
        }
        if (e.isMdDataDomain()) {
            long orgId0 = ctx.getPageViewMemberPropsMap().get(DimTypesEnum.ENTITY.getNumber()).getId();
            long scenarioId0 = ctx.getPageViewMemberPropsMap().get(DimTypesEnum.SCENARIO.getNumber()).getId();
            long yearId0 = ctx.getPageViewMemberPropsMap().get(DimTypesEnum.YEAR.getNumber()).getId();
            long periodId0 = ctx.getPageViewMemberPropsMap().get(DimTypesEnum.PERIOD.getNumber()).getId();
            String currencyNum0 = ctx.getPageViewMemberPropsMap().get((Object)DimTypesEnum.PERIOD.getNumber()).number;
            String orgNum0 = null;
            String scenarioNum0 = null;
            String yearNum0 = null;
            String periodNum0 = null;
            List dimMembers = e.getMemberFromUserObject();
            for (IDimMember dimMember : dimMembers) {
                if (DimTypesEnum.CURRENCY.getNumber().equals(dimMember.getDimension().getNumber())) {
                    currencyNum0 = dimMember.getNumber();
                    continue;
                }
                if (DimTypesEnum.ENTITY.getNumber().equals(dimMember.getDimension().getNumber())) {
                    orgNum0 = dimMember.getNumber();
                    continue;
                }
                if (DimTypesEnum.SCENARIO.getNumber().equals(dimMember.getDimension().getNumber())) {
                    scenarioNum0 = dimMember.getNumber();
                    continue;
                }
                if (DimTypesEnum.YEAR.getNumber().equals(dimMember.getDimension().getNumber())) {
                    yearNum0 = dimMember.getNumber();
                    continue;
                }
                if (!DimTypesEnum.PERIOD.getNumber().equals(dimMember.getDimension().getNumber())) continue;
                periodNum0 = dimMember.getNumber();
            }
            String orgCurrencyNum = null;
            if (orgId0 != 0L) {
                DynamicObject orgCurrency = OrgCurrencyServiceHelper.getCurrencyDynByIdThrow((Long)orgId0, (Long)yearId0, (Long)periodId0);
                orgCurrencyNum = orgCurrency.getString("number");
            }
            if (StringUtils.isNotEmpty((String)currencyNum0) && ("EC".equals(currencyNum0) || currencyNum0.equals(orgCurrencyNum))) {
                if (StringUtils.isNotEmpty(orgNum0)) {
                    orgId0 = BusinessDataServiceHelper.loadSingleFromCache((String)"epm_entitymembertree", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)orgNum0), modelqfilter}).getLong("id");
                } else if (StringUtils.isNotEmpty(scenarioNum0)) {
                    scenarioId0 = BusinessDataServiceHelper.loadSingleFromCache((String)"epm_entitymembertree", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)scenarioNum0), modelqfilter}).getLong("id");
                } else if (StringUtils.isNotEmpty(yearNum0)) {
                    yearId0 = BusinessDataServiceHelper.loadSingleFromCache((String)"epm_entitymembertree", (QFilter[])new QFilter[]{new QFilter("number", "=", yearNum0), modelqfilter}).getLong("id");
                } else if (StringUtils.isNotEmpty(periodNum0)) {
                    periodId0 = BusinessDataServiceHelper.loadSingleFromCache((String)"epm_entitymembertree", (QFilter[])new QFilter[]{new QFilter("number", "=", periodNum0), modelqfilter}).getLong("id");
                }
                issubmit = McStatus.getMcStatus((Object)modelId, (Object)orgId0, (Object)scenarioId0, (Object)yearId0, (Object)periodId0).getFlow().isSubmit();
            }
        }
        return issubmit;
    }

    public boolean checkInPageView(StyleContext ctx, DimTypesEnum[] dims) {
        for (DimTypesEnum e : dims) {
            if (ctx.getPageViewMemberPropsMap().containsKey(e.getNumber())) continue;
            return false;
        }
        return true;
    }

    public boolean isOnlyReadTemplate() {
        return this.template.getIsOnlyRead();
    }

    public boolean isUsageQueryTemplate() {
        return TemplateUsageEnum.FORQUERY.getValue().equals(this.template.getUsage());
    }

    public Map<String, Set<String>> getEbDimPermMng(String dimNum) {
        Map<String, Set<String>> dimPerm = null;
        if (this.ebPermMng == null) {
            this.ebPermMng = new HashMap<String, Map<String, Set<String>>>();
        }
        if ((dimPerm = this.ebPermMng.get(dimNum)) == null || dimPerm.isEmpty()) {
            dimPerm = new HashMap<String, Set<String>>(16);
            Long userId = UserUtils.getUserId();
            Map newPermInfo = DimMembPermHelper.getAllDataPermInfoOfEB((Long)this.modelId, (String)dimNum, (long)userId);
            int maxSize = -1;
            int size = -1;
            String key = null;
            for (String permKey : PERM_KEY_ARRAY) {
                size = ((Set)newPermInfo.get(permKey)).size();
                if (size > maxSize) {
                    maxSize = size;
                    key = permKey;
                }
                dimPerm.put(permKey, (Set<String>)newPermInfo.get(permKey));
            }
            dimPerm.remove(key);
            this.ebPermMng.put(dimNum, dimPerm);
        }
        return dimPerm;
    }

    public boolean isQuery() {
        return this.isQuery;
    }

    public void setQuery(boolean query) {
        this.isQuery = query;
    }

    public Map<String, Map<Integer, String>> getSeqToConvertCYs() {
        return this.orgToSeqToConvertCYs;
    }

    public Map<String, PageViewMemberProps> getPageViewMemberPropsMap() {
        return this.pageViewMemberPropsMap;
    }

    public SceneAndChangetypeModel getSceneandchangetype() {
        return this.sceneandchangetype;
    }

    public Set<String> getLockStatus() {
        return this.lockStatus;
    }

    public void lockCell(Cell cell) {
        this.lockStatus.add("" + cell.getRow() + "," + cell.getCol());
        this.removeUnLockStatus(cell);
    }

    public void lockCell(int r, int c) {
        this.lockStatus.add("" + r + "," + c);
        this.removeUnLockStatus(r, c);
    }

    public boolean hasLockCell(Cell cell) {
        return this.lockStatus.contains("" + cell.getRow() + "," + cell.getCol());
    }

    public Set<String> getUnLockStatus() {
        return this.unlockStatus;
    }

    public boolean removeUnLockStatus(Cell cell) {
        return this.unlockStatus.remove("" + cell.getRow() + "," + cell.getCol());
    }

    public boolean removeUnLockStatus(int r, int c) {
        return this.unlockStatus.remove("" + r + "," + c);
    }

    public void unlockCell(Cell cell) {
        this.unlockStatus.add("" + cell.getRow() + "," + cell.getCol());
    }

    public void setLockStatus(Set<String> lockStatus) {
        this.lockStatus = lockStatus;
    }

    public Map<String, String> getOrgToCurrency() {
        return this.orgToCurrency;
    }

    public String getAuditTrailMemberNumber() {
        return this.auditTrailMemberNumber;
    }

    public Map<String, Boolean> getOrgToIsautoconvert() {
        return this.orgToIsautoconvert;
    }

    public void setOrgToIsautoconvert(Map<String, Boolean> orgToIsautoconvert) {
        this.orgToIsautoconvert = orgToIsautoconvert;
    }

    public String getProcessMemberNumber() {
        return this.ProcessMemberNumber;
    }

    public String getChangetypeMemberNumber() {
        return this.changetypeMemberNumber;
    }

    public void setProcessMemberNumber(String processMemberNumber) {
        this.ProcessMemberNumber = processMemberNumber;
    }

    public Map<DimTypesEnum, Object> getCommonNumFilter() {
        return this.commonNumFilter;
    }

    public void setCommonNumFilter(Map<DimTypesEnum, Object> commonFilter) {
        this.commonNumFilter = commonFilter;
    }

    public Map<DimTypesEnum, Object> getCommonIdFilter() {
        return this.commonIdFilter;
    }

    public void setCommonIdFilter(Map<DimTypesEnum, Object> commonIdFilter) {
        this.commonIdFilter = commonIdFilter;
    }

    public boolean checkCSTECanEdit(StyleContext ctx) {
        if (ctx.isCSTE()) {
            QFilter type;
            QFilter temfilter;
            QFilter currency;
            QFilter period;
            QFilter year;
            QFilter scenario;
            if (!(ctx.getPageViewMemberPropsMap().containsKey(DimTypesEnum.SCENARIO.getNumber()) && ctx.getPageViewMemberPropsMap().containsKey(DimTypesEnum.YEAR.getNumber()) && ctx.getPageViewMemberPropsMap().containsKey(DimTypesEnum.PERIOD.getNumber()) && ctx.getPageViewMemberPropsMap().containsKey(DimTypesEnum.ENTITY.getNumber()) && ctx.getPageViewMemberPropsMap().containsKey(DimTypesEnum.CURRENCY.getNumber()))) {
                return true;
            }
            QFilter model = new QFilter("model", "=", (Object)this.getTemplate().getModelId());
            QFilter org = new QFilter("entity", "=", (Object)ctx.getPageViewMemberPropsMap().get(DimTypesEnum.ENTITY.getNumber()).getId());
            DynamicObject dot = QueryServiceHelper.queryOne((String)"eb_reportentity", (String)"reportstatus", (QFilter[])new QFilter[]{org, scenario = new QFilter("scene", "=", (Object)ctx.getPageViewMemberPropsMap().get(DimTypesEnum.SCENARIO.getNumber()).getId()), year = new QFilter("fyear", "=", (Object)ctx.getPageViewMemberPropsMap().get(DimTypesEnum.YEAR.getNumber()).getId()), period = new QFilter("period", "=", (Object)ctx.getPageViewMemberPropsMap().get(DimTypesEnum.PERIOD.getNumber()).getId()), currency = new QFilter("currency", "=", (Object)ctx.getPageViewMemberPropsMap().get(DimTypesEnum.CURRENCY.getNumber()).getId()), model, temfilter = new QFilter("template", "=", (Object)ctx.getTemplate().getId()), type = new QFilter("reporttype", "!=", (Object)ReportType.CSTE.index)});
            if (dot != null && dot.getString("reportstatus").equals(ReportStatusEnum.COMMIT.status())) {
                return false;
            }
        }
        return true;
    }

    public boolean checkBboy(Cell cell) {
        String audittrail = this.getAuditTrailMemberNumber();
        String process = this.getProcessMemberNumber();
        if (audittrail == null || process == null) {
            ListIterator idimmember = cell.getMemberFromUserObject().listIterator();
            if (cell.isMdDataDomain()) {
                while (idimmember.hasNext()) {
                    IDimMember idim = (IDimMember)idimmember.next();
                    String dimnum = idim.getDimension().getNumber();
                    if (DimTypesEnum.PROCESS.getNumber().equals(dimnum)) {
                        process = idim.getNumber();
                        continue;
                    }
                    if (!DimTypesEnum.AUDITTRIAL.getNumber().equals(dimnum)) continue;
                    audittrail = idim.getNumber();
                }
            }
        }
        if (this.isCsl() && ("EntityInput".equals(audittrail) || "ATTotal".equals(audittrail)) && "CS".equals(process)) {
            if (this.isBBOYCell(this, cell)) {
                return true;
            }
            if (this.isBFlyCell(this, cell) && ConfigServiceHelper.getBoolParam((Long)this.getModelId(), (String)"CM001")) {
                return true;
            }
        } else if (this.isCSTE() && ("EntityInput".equals(audittrail) || "ATTotal".equals(audittrail)) && "CSTE".equals(process)) {
            if (this.isBBOYCell(this, cell)) {
                return true;
            }
            if (this.isBFlyCell(this, cell) && ConfigServiceHelper.getBoolParam((Long)this.getModelId(), (String)"CM001")) {
                return true;
            }
        }
        return false;
    }

    protected boolean isBFlyCell(StyleContext ctx, Cell cell) {
        String member = null;
        member = ctx.getPageViewMemberPropsMap().containsKey(PresetConstant.CHANGETYPE_DIM) ? ctx.getPageViewMemberPropsMap().get(PresetConstant.CHANGETYPE_DIM).getNumber() : (String)cell.getMemberFromUserObjectDimNumbers().get(PresetConstant.CHANGETYPE_DIM);
        return "BFLY".equals(member);
    }

    protected boolean isBBOYCell(StyleContext ctx, Cell cell) {
        String member = null;
        member = ctx.getPageViewMemberPropsMap().containsKey(PresetConstant.CHANGETYPE_DIM) ? ctx.getPageViewMemberPropsMap().get(PresetConstant.CHANGETYPE_DIM).getNumber() : (String)cell.getMemberFromUserObjectDimNumbers().get(PresetConstant.CHANGETYPE_DIM);
        return "BBOY".equals(member) || "BBOY01".equals(member) || "BBOY02".equals(member) || "BBOY03".equals(member) || "BBOY04".equals(member);
    }

    public boolean isAdjust() {
        return this.isAdjust;
    }

    public void setAdjust(boolean isAdjust) {
        this.isAdjust = isAdjust;
    }

    public boolean isRpt() {
        return !this.isAdjust && !this.isCsl && !this.isView && !this.isCWP();
    }

    public Long getModelId() {
        return this.modelId;
    }

    public Long getOrgId() {
        return this.orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public static class QueryStatusParam {
        private Long modelid = 0L;
        private Long orgid = 0L;
        private Long scenarioid = 0L;
        private Long yearid = 0L;
        private Long periodid = 0L;
        private String currencyMemNumber;

        public String getCurrencyMemNumber() {
            return this.currencyMemNumber;
        }

        public void setCurrencyMemNumber(String currencyMemNumber) {
            this.currencyMemNumber = currencyMemNumber;
        }

        public Long getModelid() {
            return this.modelid;
        }

        public void setModelid(Long modelid) {
            this.modelid = modelid;
        }

        public Long getOrgid() {
            return this.orgid;
        }

        public void setOrgid(Long orgid) {
            this.orgid = orgid;
        }

        public Long getScenarioid() {
            return this.scenarioid;
        }

        public void setScenarioid(Long scenarioid) {
            this.scenarioid = scenarioid;
        }

        public Long getYearid() {
            return this.yearid;
        }

        public void setYearid(Long yearid) {
            this.yearid = yearid;
        }

        public Long getPeriodid() {
            return this.periodid;
        }

        public void setPeriodid(Long periodid) {
            this.periodid = periodid;
        }
    }

    public static class NoPermController
    extends AbstractPermController {
        private static final long serialVersionUID = 1L;

        public NoPermController(Collection<String> list) {
            super(list);
        }

        @Override
        public boolean hasPermission(String membNum) {
            return !this.containMemb(membNum);
        }
    }

    public static class OwnerPermController
    extends AbstractPermController {
        private static final long serialVersionUID = 1L;

        public OwnerPermController(Collection<String> list) {
            super(list);
        }

        @Override
        public boolean hasPermission(String membNum) {
            return this.containMemb(membNum);
        }
    }

    static abstract class AbstractPermController
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Set<String> permMembSet = new HashSet<String>();

        AbstractPermController(Collection<String> list) {
            this.permMembSet.addAll(list);
        }

        boolean containMemb(String membNum) {
            return this.permMembSet.contains(membNum);
        }

        abstract boolean hasPermission(String var1);
    }

    protected static class RowColMemberProps
    extends MemberProps {
        private static final long serialVersionUID = 1L;

        RowColMemberProps(String number, boolean isLeaf, boolean isLabel) {
            super(number, isLeaf, isLabel);
        }
    }

    public static class PageViewMemberProps
    extends MemberProps {
        private static final long serialVersionUID = 1L;
        private long id = 0L;

        public PageViewMemberProps(String number, boolean isLeaf, boolean isLabel) {
            super(number, isLeaf, isLabel);
        }

        PageViewMemberProps(String number, boolean isLeaf, boolean isLabel, long id) {
            super(number, isLeaf, isLabel);
            this.id = id;
        }

        public long getId() {
            return this.id;
        }

        public void setId(long id) {
            this.id = id;
        }
    }

    public static class MemberProps
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected String number;
        protected boolean isLeaf;
        protected boolean isLabel;

        public MemberProps(String number, boolean isLeaf, boolean isLabel) {
            this.number = number;
            this.isLeaf = isLeaf;
            this.isLabel = isLabel;
        }

        public String toString() {
            return ToStringHelper.deepToString((Object)this);
        }

        public String getNumber() {
            return this.number;
        }
    }

    private static class Command {
        private boolean isContinue = true;

        private Command() {
        }
    }
}

