/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.budget.formplugin.report.style;

import java.util.ArrayList;
import java.util.List;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IPageCache;
import kd.epm.eb.budget.formplugin.bg.perm.EbPermissionLockController;
import kd.epm.eb.budget.formplugin.report.style.AfterController;
import kd.epm.eb.budget.formplugin.report.style.BeforeController;
import kd.epm.eb.budget.formplugin.report.style.CellLockController;
import kd.epm.eb.budget.formplugin.report.style.CellLockControllerByCTAndCvt;
import kd.epm.eb.budget.formplugin.report.style.DataLockController;
import kd.epm.eb.budget.formplugin.report.style.EBApproveBillCellLockController;
import kd.epm.eb.budget.formplugin.report.style.EbChangetypeCellLockController;
import kd.epm.eb.budget.formplugin.report.style.EbSheetStyleLockController;
import kd.epm.eb.budget.formplugin.report.style.IStyleController;
import kd.epm.eb.budget.formplugin.report.style.SheetLockController;
import kd.epm.eb.budget.formplugin.report.style.StyleContext;
import kd.epm.eb.common.ebcommon.common.log.BcmLogFactory;
import kd.epm.eb.common.ebcommon.common.log.WatchLogger;

public class StyleControlChain {
    private List<IStyleController> chain;
    private WatchLogger log = BcmLogFactory.getWatchLogInstance(this.getClass());

    private StyleControlChain() {
        this.chain = new ArrayList<IStyleController>();
    }

    private void registStyleControl(IStyleController c) {
        this.chain.add(c);
    }

    public void excStyleControl(StyleContext ctx, IClientViewProxy view) {
        for (IStyleController e : this.chain) {
            this.log.startWatch();
            e.controlStyle(ctx, view);
            this.log.info(String.format("[%s] style-->%s", ctx.getTemplate().getName(), e.getClass().getName()));
        }
    }

    public static StyleControlChain getFloatStyleControl() {
        StyleControlChain chain = new StyleControlChain();
        chain.registStyleControl(new BeforeController());
        chain.registStyleControl(new DataLockController());
        chain.registStyleControl(new CellLockController());
        chain.registStyleControl(new CellLockControllerByCTAndCvt());
        chain.registStyleControl(new EbPermissionLockController());
        chain.registStyleControl(new EbChangetypeCellLockController());
        chain.registStyleControl(new EbSheetStyleLockController());
        chain.registStyleControl(new AfterController());
        return chain;
    }

    public static StyleControlChain getEbStyleControl(IPageCache pageCache, String appID) {
        StyleControlChain chain = new StyleControlChain();
        chain.registStyleControl(new BeforeController());
        chain.registStyleControl(new DataLockController());
        chain.registStyleControl(new SheetLockController());
        chain.registStyleControl(new CellLockController());
        chain.registStyleControl(new EbPermissionLockController());
        chain.registStyleControl(new EBApproveBillCellLockController(appID));
        chain.registStyleControl(new EbChangetypeCellLockController());
        chain.registStyleControl(new EbSheetStyleLockController());
        chain.registStyleControl(new AfterController());
        return chain;
    }
}

