/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.budget.formplugin.report.style;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.budget.formplugin.report.style.PermissionLockController;
import kd.epm.eb.budget.formplugin.report.style.StyleContext;
import kd.epm.eb.common.ebcommon.common.enums.AccountTypeEnum;
import kd.epm.eb.common.ebcommon.common.enums.CurrencyEnum;
import kd.epm.eb.common.ebcommon.common.enums.DChangeTypeEnum;
import kd.epm.eb.common.ebcommon.common.enums.DimTypesEnum;
import kd.epm.eb.common.ebcommon.common.enums.PermEnum;
import kd.epm.eb.common.ebcommon.common.util.PeriodUtils;
import kd.epm.eb.common.ebcommon.common.util.QFBuilder;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.ebBusiness.convert.query.ExchangeQueryService;
import kd.epm.eb.ebBusiness.serviceHelper.ConfigServiceHelper;
import kd.epm.eb.ebBusiness.serviceHelper.InitPeriodServiceHelper;
import kd.epm.eb.ebBusiness.serviceHelper.MemberPermHelper;
import kd.epm.eb.ebBusiness.serviceHelper.OrgCurrencyServiceHelper;
import kd.epm.eb.ebSpread.common.variant.Variant;
import kd.epm.eb.ebSpread.domain.Cell;
import kd.epm.eb.ebSpread.model.IDimMember;

public class StyleController {
    private static final String LOCKED = "locked";
    private Map<String, Object> spread;
    private static final String[] PERM_KEY_ARRAY = new String[]{"write", "read", "noperm"};

    public StyleController(Map<String, Object> spread) {
        this.spread = spread;
    }

    public void controlStyle(StyleContext ctx) {
        Map<String, Object> sp = (Map<String, Object>)this.spread.get("spread");
        if (sp == null) {
            sp = this.spread;
        }
        Map sheets = (Map)sp.get("sheets");
        for (Map.Entry entry : sheets.entrySet()) {
            Map sheet = (Map)entry.getValue();
            Map data = (Map)sheet.get("data");
            Map dataTable = (Map)data.get("dataTable");
            this.lockCell(ctx, dataTable, (Map)this.spread.get("styles"));
        }
    }

    private void lockCell(StyleContext ctx, Map<String, Map<String, Object>> dataTable, Map<Object, Object> styles) {
        List<AbstractCellLock> lockList = this.getLockList(ctx, dataTable, styles);
        boolean isContinue = ctx.isContinueCommand();
        ctx.getSpreadManager().getBook().getSheet(0).iteratorCells(c -> {
            if (isContinue) {
                ctx.setStartCommand();
            } else {
                ctx.setStopCommand();
            }
            for (AbstractCellLock lock : lockList) {
                lock.lock(ctx, (Cell)c);
            }
        });
    }

    private List<AbstractCellLock> getLockList(StyleContext ctx, Map<String, Map<String, Object>> dataTable, Map<Object, Object> styles) {
        ArrayList<AbstractCellLock> lockList = new ArrayList<AbstractCellLock>();
        lockList.add(new SheetLock(ctx, dataTable, styles));
        lockList.add(new CellLock(ctx, dataTable, styles));
        lockList.add(new PermissionLock(ctx, dataTable, styles));
        lockList.add(new CellLockControllerBySecne(ctx, dataTable, styles));
        lockList.add(new CellLockControllerByProcessCY(ctx, dataTable, styles));
        lockList.add(new CellControllerByProcess(ctx, dataTable, styles));
        lockList.add(new ConvertCurrencySaveController(ctx, dataTable, styles));
        lockList.add(new CellLockControllerByInitPeriod(ctx, dataTable, styles));
        lockList.add(new CellLockControllerByAuditTrail(ctx, dataTable, styles));
        lockList.add(new CellLockEcAndPc(ctx, dataTable, styles));
        lockList.add(new CellLockControllerByChangeType(ctx, dataTable, styles));
        return lockList;
    }

    private class CellLockControllerByChangeType
    extends AbstractCellLock {
        private boolean canEdit;

        CellLockControllerByChangeType(StyleContext ctx, Map<String, Map<String, Object>> dataTable, Map<Object, Object> styles) {
            super(ctx, dataTable, styles);
            this.canEdit = false;
            this.canEdit = ConfigServiceHelper.getBoolParam((Long)ctx.getModelId(), (String)"CM001");
        }

        @Override
        void lock(StyleContext ctx, Cell c) {
            if (!ctx.isCsl() || !c.isMdDataDomain()) {
                return;
            }
            String changetypeNum = ctx.getSceneandchangetype().getChangeTypeMemNum();
            ListIterator idimmember = c.getMemberFromUserObject().listIterator();
            while (idimmember.hasNext()) {
                IDimMember idim = (IDimMember)idimmember.next();
                String dimnum = idim.getDimension().getNumber();
                if (!DimTypesEnum.CHANGETYPE.getNumber().equals(dimnum)) continue;
                changetypeNum = idim.getNumber();
                break;
            }
            if ("BFLY".equals(changetypeNum)) {
                if (this.canEdit) {
                    this.removeLockStyle(c);
                }
            } else {
                boolean isNotAllLeaf = c.getMemberFromUserObject().stream().anyMatch(m -> ctx.contrainsNoneLeafOrLableMemberOnRowColDim(m.getDimension().getNumber() + "|" + m.getNumber()));
                if (!ctx.isView() && !isNotAllLeaf) {
                    this.removeLockStyle(c);
                }
            }
        }
    }

    private class CellLockEcAndPc
    extends AbstractCellLock {
        private boolean issubmit0;
        private boolean isstop;

        CellLockEcAndPc(StyleContext ctx, Map<String, Map<String, Object>> dataTable, Map<Object, Object> styles) {
            super(ctx, dataTable, styles);
            this.issubmit0 = false;
            this.isstop = false;
            long modelId = ctx.getTemplate().getModelId();
            boolean[] bool = ctx.checkPageViewCurrencyStatus(ctx, modelId);
            this.issubmit0 = bool[0];
            this.isstop = bool[1];
        }

        @Override
        void lock(StyleContext ctx, Cell c) {
            if (!ctx.isContinueCommand()) {
                return;
            }
            if (this.issubmit0 || !this.isstop && ctx.checkRowColCurrencyStatus(c, ctx, ctx.getTemplate().getModelId())) {
                this.setLockStyle(c);
            }
        }
    }

    public class CellLockControllerByAuditTrail
    extends AbstractCellLock {
        private boolean isAMD;

        CellLockControllerByAuditTrail(StyleContext ctx, Map<String, Map<String, Object>> dataTable, Map<Object, Object> styles) {
            super(ctx, dataTable, styles);
            this.isAMD = false;
            String auditTrailMemberNumber = ctx.getAuditTrailMemberNumber();
            if (StringUtils.isNotEmpty((String)auditTrailMemberNumber)) {
                this.isAMD = "AutoJournal".equals(auditTrailMemberNumber) || "ManualJournal".equals(auditTrailMemberNumber) || "DataCollection".equals(auditTrailMemberNumber);
            }
        }

        @Override
        void lock(StyleContext ctx, Cell c) {
            if (!ctx.isContinueCommand() || !c.isMdDataDomain()) {
                return;
            }
            if (StringUtils.isNotEmpty((String)ctx.getAuditTrailMemberNumber())) {
                if (this.isAMD) {
                    this.setLockStyle(c);
                }
            } else {
                ListIterator idimmember = c.getMemberFromUserObject().listIterator();
                String auditTrailMemberNumber1 = null;
                while (idimmember.hasNext()) {
                    IDimMember idim = (IDimMember)idimmember.next();
                    String dimnum = idim.getDimension().getNumber();
                    if (!DimTypesEnum.AUDITTRIAL.getNumber().equals(dimnum)) continue;
                    auditTrailMemberNumber1 = idim.getNumber();
                    break;
                }
                if ("AutoJournal".equals(auditTrailMemberNumber1) || "ManualJournal".equals(auditTrailMemberNumber1) || "DataCollection".equals(auditTrailMemberNumber1)) {
                    this.setLockStyle(c);
                }
            }
        }
    }

    public class CellLockControllerByInitPeriod
    extends AbstractCellLock {
        private boolean isProcess;
        private boolean existBlank;
        private boolean orgIsLeaf;
        private boolean isInitPeriod;
        private boolean isFirstPeriod;
        private boolean isEcOrCnyCurrency;

        CellLockControllerByInitPeriod(StyleContext ctx, Map<String, Map<String, Object>> dataTable, Map<Object, Object> styles) {
            super(ctx, dataTable, styles);
            this.isProcess = false;
            this.existBlank = false;
            this.orgIsLeaf = false;
            this.isInitPeriod = false;
            this.isFirstPeriod = false;
            this.isEcOrCnyCurrency = false;
            Map<String, StyleContext.PageViewMemberProps> props = ctx.getPageViewMemberPropsMap();
            StyleContext.PageViewMemberProps entityProps = props.get(DimTypesEnum.ENTITY.getNumber());
            StyleContext.PageViewMemberProps yearProps = props.get(DimTypesEnum.YEAR.getNumber());
            StyleContext.PageViewMemberProps periodProps = props.get(DimTypesEnum.PERIOD.getNumber());
            boolean bl = this.existBlank = props.get(DimTypesEnum.CURRENCY.getNumber()) == null || entityProps == null || props.get(DimTypesEnum.SCENARIO.getNumber()) == null || yearProps == null || periodProps == null || props.get(DimTypesEnum.PROCESS.getNumber()) == null;
            if (entityProps != null) {
                this.orgIsLeaf = entityProps.isLeaf;
                this.isProcess = "CS".equals(props.get((Object)DimTypesEnum.PROCESS.getNumber()).number);
                this.isInitPeriod = this.isInitPeriod(ctx.getTemplate().getModelId(), props);
                this.isFirstPeriod = this.isFirstPeriod(props);
                String selectCurrency = props.get((Object)DimTypesEnum.CURRENCY.getNumber()).number;
                String localCurrency = ctx.getOrgToCurrency().get(entityProps.number);
                if (localCurrency == null && yearProps != null && periodProps != null) {
                    localCurrency = OrgCurrencyServiceHelper.getOrgModelAndCurrency((Long)entityProps.getId(), (String)yearProps.number, (Long)periodProps.getId()).getString("currency.number");
                }
                this.isEcOrCnyCurrency = CurrencyEnum.EC.number.equals(selectCurrency) || selectCurrency.equals(localCurrency);
            }
        }

        @Override
        void lock(StyleContext ctx, Cell c) {
            if (this.existBlank || !c.isMdDataDomain()) {
                return;
            }
            String changetypeNum = null;
            ListIterator idimmember = c.getMemberFromUserObject().listIterator();
            while (idimmember.hasNext()) {
                IDimMember idim = (IDimMember)idimmember.next();
                String dimnum = idim.getDimension().getNumber();
                if (!DimTypesEnum.CHANGETYPE.getNumber().equals(dimnum)) continue;
                changetypeNum = idim.getNumber();
                break;
            }
            if (this.orgIsLeaf && "BOP".equals(changetypeNum) && (!this.isEcOrCnyCurrency || !this.isInitPeriod || this.isFirstPeriod || c.getMemberFromUserObject().stream().anyMatch(m -> ctx.contrainsNoneLeafOrLableMemberOnRowColDim(m.getDimension().getNumber() + "|" + m.getNumber())))) {
                this.setLockStyle(c);
            }
            if (!this.orgIsLeaf && this.isProcess && this.isEcOrCnyCurrency && this.isInitPeriod && !this.isFirstPeriod && "BOP".equals(changetypeNum) && c.getMemberFromUserObject().stream().noneMatch(m -> ctx.contrainsNoneLeafOrLableMemberOnRowColDim(m.getDimension().getNumber() + "|" + m.getNumber()))) {
                this.removeLockStyle(c);
            }
        }

        private boolean isInitPeriod(long modelId, Map<String, StyleContext.PageViewMemberProps> props) {
            long orgId = props.get(DimTypesEnum.ENTITY.getNumber()).getId();
            long scenarioId = props.get(DimTypesEnum.SCENARIO.getNumber()).getId();
            String selectYearNum = props.get((Object)DimTypesEnum.YEAR.getNumber()).number;
            long selectPeriodId = props.containsKey(DimTypesEnum.PERIOD.getNumber()) ? props.get(DimTypesEnum.PERIOD.getNumber()).getId() : ((Long)this.ctx.getCommonIdFilter().get(DimTypesEnum.PERIOD)).longValue();
            return InitPeriodServiceHelper.isInitPeriod((Object)modelId, (Object)orgId, (Object)scenarioId, (String)selectYearNum, (Object)selectPeriodId);
        }

        private boolean isFirstPeriod(Map<String, StyleContext.PageViewMemberProps> props) {
            String periodNum = props.containsKey(DimTypesEnum.PERIOD.getNumber()) ? props.get((Object)DimTypesEnum.PERIOD.getNumber()).number : (String)this.ctx.getCommonNumFilter().get(DimTypesEnum.PERIOD);
            return PeriodUtils.isFirstPeriod((String)periodNum);
        }
    }

    private class ConvertCurrencySaveController
    extends AbstractCellLock {
        private boolean notInPageView;
        private boolean psIsSc;

        ConvertCurrencySaveController(StyleContext ctx, Map<String, Map<String, Object>> dataTable, Map<Object, Object> styles) {
            String currencyNum;
            boolean currencyIsNull;
            boolean isautoconvert;
            super(ctx, dataTable, styles);
            this.notInPageView = false;
            this.psIsSc = false;
            this.notInPageView = !ctx.getPageViewMemberPropsMap().containsKey(DimTypesEnum.SCENARIO.getNumber()) || !ctx.getPageViewMemberPropsMap().containsKey(DimTypesEnum.YEAR.getNumber()) || !ctx.getPageViewMemberPropsMap().containsKey(DimTypesEnum.PERIOD.getNumber()) || !ctx.getPageViewMemberPropsMap().containsKey(DimTypesEnum.ENTITY.getNumber());
            long modelId = ctx.getTemplate().getModelId();
            long sceneId = ctx.getPageViewMemberPropsMap().get(DimTypesEnum.SCENARIO.getNumber()).getId();
            long yearId = ctx.getPageViewMemberPropsMap().get(DimTypesEnum.YEAR.getNumber()).getId();
            long periodId = ctx.getPageViewMemberPropsMap().get(DimTypesEnum.PERIOD.getNumber()).getId();
            Long orgId = ctx.getOrgId();
            if (orgId == null) {
                orgId = ctx.getPageViewMemberPropsMap().get(DimTypesEnum.ENTITY.getNumber()).getId();
            }
            if ((isautoconvert = ((Boolean)ExchangeQueryService.queryOrgRate((Long)modelId, (Long)orgId, (Long)sceneId, (Long)yearId, (Long)periodId).get("isautoconvert")).booleanValue()) && !(currencyIsNull = StringUtils.isEmpty((String)(currencyNum = ctx.getPageViewMemberPropsMap().get((Object)DimTypesEnum.CURRENCY.getNumber()).number)))) {
                String parentC = OrgCurrencyServiceHelper.getParentCurrencyDynByIdThrow((Long)orgId, (Long)yearId, (Long)periodId).getString("number");
                String selfC = OrgCurrencyServiceHelper.getCurrencyDynByIdThrow((Long)orgId, (Long)yearId, (Long)periodId).getString("number");
                this.psIsSc = "PC".equals(currencyNum) || parentC.equals(currencyNum) && !parentC.equals(selfC);
            }
        }

        @Override
        void lock(StyleContext ctx, Cell c) {
            if (this.notInPageView) {
                return;
            }
            if (this.psIsSc) {
                this.setLockStyle(c);
            }
        }
    }

    public class CellControllerByProcess
    extends AbstractCellLock {
        private boolean notContainEntity;
        private boolean notContainPro;
        private boolean isLeaf;
        private boolean checkLockProcess;

        CellControllerByProcess(StyleContext ctx, Map<String, Map<String, Object>> dataTable, Map<Object, Object> styles) {
            super(ctx, dataTable, styles);
            this.notContainEntity = false;
            this.notContainPro = false;
            this.isLeaf = false;
            this.checkLockProcess = false;
            this.notContainEntity = !ctx.getPageViewMemberPropsMap().containsKey(DimTypesEnum.ENTITY.getNumber());
            this.notContainPro = !ctx.getPageViewMemberPropsMap().containsKey(DimTypesEnum.PROCESS.getNumber());
            this.isLeaf = ctx.getPageViewMemberPropsMap().get((Object)DimTypesEnum.ENTITY.getNumber()).isLeaf;
            String processNumber = ctx.getPageViewMemberPropsMap().get((Object)DimTypesEnum.PROCESS.getNumber()).number;
            this.checkLockProcess = ctx.checkLockProcess(null, processNumber);
        }

        @Override
        void lock(StyleContext ctx, Cell c) {
            if (!ctx.isContinueCommand() || !c.isMdDataDomain()) {
                return;
            }
            if (this.notContainEntity) {
                if (this.notContainPro) {
                    if (c.getMemberFromUserObject().stream().anyMatch(m -> {
                        if (m.getDimension().getNumber().equals(DimTypesEnum.PROCESS.getNumber())) {
                            return ctx.checkLockProcess(null, m.getNumber());
                        }
                        return false;
                    })) {
                        this.setLockStyle(c);
                    }
                } else if (this.checkLockProcess) {
                    this.setLockStyle(c);
                }
            } else if (this.notContainPro) {
                if (this.isLeaf && ctx.checkLockProcess(c.getMemberFromUserObject(), "")) {
                    this.setLockStyle(c);
                }
            } else if (this.isLeaf && this.checkLockProcess) {
                this.setLockStyle(c);
            }
        }
    }

    private class CellLockControllerByProcessCY
    extends AbstractCellLock {
        private boolean lock;
        private boolean isLeaf;
        private boolean notContainEntity;
        private boolean containProCur;
        private boolean notContainScheme;
        private String masterCY;
        private String orgNum;

        CellLockControllerByProcessCY(StyleContext ctx, Map<String, Map<String, Object>> dataTable, Map<Object, Object> styles) {
            super(ctx, dataTable, styles);
            this.lock = false;
            this.isLeaf = false;
            this.notContainEntity = false;
            this.containProCur = this.ctx.getPageViewMemberPropsMap().containsKey(DimTypesEnum.PROCESS.getNumber()) && this.ctx.getPageViewMemberPropsMap().containsKey(DimTypesEnum.CURRENCY.getNumber());
            this.notContainScheme = false;
            this.isLeaf = ctx.getPageViewMemberPropsMap().get((Object)DimTypesEnum.ENTITY.getNumber()).isLeaf;
            this.notContainEntity = !ctx.getPageViewMemberPropsMap().containsKey(DimTypesEnum.ENTITY.getNumber());
            long modelId = ctx.getTemplate().getModelId();
            Long yearId = ctx.getPageViewMemberPropsMap().get(DimTypesEnum.YEAR.getNumber()).getId();
            Long periodId = ctx.getPageViewMemberPropsMap().get(DimTypesEnum.PERIOD.getNumber()).getId();
            if (this.notContainEntity) {
                QFBuilder qfBuilder = new QFBuilder();
                qfBuilder.add("model.id", "=", (Object)modelId);
                DynamicObjectCollection orgsCurrency = OrgCurrencyServiceHelper.getOrgsCurrency((QFilter[])qfBuilder.toArray(), (Long)yearId, (Long)periodId);
                for (DynamicObject cur : orgsCurrency) {
                    ctx.getOrgToCurrency().put(cur.getString("number"), cur.getString("currency.number"));
                }
            } else {
                this.orgNum = ctx.getPageViewMemberPropsMap().get((Object)DimTypesEnum.ENTITY.getNumber()).number;
                QFBuilder qfBuilder = new QFBuilder();
                qfBuilder.add("model.id", "=", (Object)modelId);
                qfBuilder.add("number", "=", (Object)this.orgNum);
                DynamicObject orgCurrency = OrgCurrencyServiceHelper.getOrgAndParentCurrency((QFilter[])qfBuilder.toArray(), (Long)yearId, (Long)periodId);
                String defaultCY = orgCurrency != null ? orgCurrency.getString("currency.number") : "";
                ctx.getOrgToCurrency().put(this.orgNum, defaultCY);
                boolean bl = this.notContainScheme = !ctx.getOrgToIsautoconvert().containsKey(this.orgNum) || ctx.getOrgToIsautoconvert().get(this.orgNum) == false;
                if (orgCurrency != null) {
                    this.masterCY = orgCurrency.getString("parent.number").equals(DimTypesEnum.ENTITY.getNumber()) ? "" : orgCurrency.getString("parent.currency.number");
                }
                Predicate<String> isOneECPC = pc -> defaultCY.equals(pc);
                if (this.containProCur && this.isLeaf && "IRpt".equals(ctx.getPageViewMemberPropsMap().get((Object)DimTypesEnum.PROCESS.getNumber()).number) && !isOneECPC.test(ctx.getPageViewMemberPropsMap().get((Object)DimTypesEnum.CURRENCY.getNumber()).number) && (this.masterCY.equals(ctx.getPageViewMemberPropsMap().get((Object)DimTypesEnum.CURRENCY.getNumber()).number) || ctx.checkConvertCY(ctx.getPageViewMemberPropsMap().get((Object)DimTypesEnum.CURRENCY.getNumber()).number, this.orgNum))) {
                    this.lock = true;
                }
            }
        }

        @Override
        void lock(StyleContext ctx, Cell c) {
            if (!ctx.isContinueCommand()) {
                return;
            }
            if (this.notContainEntity || this.notContainScheme) {
                return;
            }
            if (this.containProCur) {
                if (this.lock) {
                    this.setLockStyle(c);
                }
            } else if (this.isLeaf && c.isMdDataDomain() && ctx.checLockLProcessAndCurrency(c.getMemberFromUserObject(), this.masterCY, this.orgNum)) {
                this.setLockStyle(c);
            }
        }
    }

    private class CellLockControllerBySecne
    extends AbstractCellLock {
        private Map<String, String> accountTypeMap;
        private String dchangetype;

        CellLockControllerBySecne(StyleContext ctx, Map<String, Map<String, Object>> dataTable, Map<Object, Object> styles) {
            super(ctx, dataTable, styles);
            this.accountTypeMap = this.getAccountType(ctx);
            this.dchangetype = ctx.getSceneandchangetype().getSceneMemenum() == null ? null : ctx.getSceneandchangetype().getSceneMemenum().getIndex();
        }

        @Override
        void lock(StyleContext ctx, Cell c) {
            if (!ctx.isContinueCommand() || !c.isMdDataDomain()) {
                return;
            }
            if (ctx.getSceneandchangetype().isLockAll()) {
                this.setLockStyle(c);
            } else if (ctx.getSceneandchangetype().isNeedLock()) {
                String changetypeNum = ctx.getSceneandchangetype().getChangeTypeMemNum();
                String accountNum = "";
                ListIterator idimmember = c.getMemberFromUserObject().listIterator();
                while (idimmember.hasNext()) {
                    IDimMember idim = (IDimMember)idimmember.next();
                    String dimnum = idim.getDimension().getNumber();
                    if (DimTypesEnum.SCENARIO.getNumber().equals(dimnum)) {
                        this.dchangetype = ctx.getSceneandchangetype().getSceneMem().get(idim.getNumber());
                    }
                    if (DimTypesEnum.CHANGETYPE.getNumber().equals(dimnum)) {
                        changetypeNum = idim.getNumber();
                    }
                    if (!DimTypesEnum.ACCOUNT.getNumber().equals(dimnum)) continue;
                    accountNum = idim.getNumber();
                }
                if ("BFLY".equals(changetypeNum)) {
                    this.setLockStyle(c);
                } else if ((DChangeTypeEnum.YTD.getIndex().equals(this.dchangetype) && "CurrentPeriod".equals(changetypeNum) || DChangeTypeEnum.CurrentPeriods.getIndex().equals(this.dchangetype) && "YTD".equals(changetypeNum)) && DChangeTypeEnum.YTD.getIndex().equals(this.dchangetype) && this.accountTypeMap != null && (AccountTypeEnum.LOSS.index.equals(this.accountTypeMap.get(accountNum)) || AccountTypeEnum.CASHFLOW.index.equals(this.accountTypeMap.get(accountNum)))) {
                    this.setLockStyle(c);
                }
            }
        }

        public final Map<String, String> getAccountType(StyleContext ctx) {
            long modelId = ctx.getTemplate().getModelId();
            QFBuilder qfBuilder = new QFBuilder();
            qfBuilder.add(new QFilter("model.id", "=", (Object)modelId));
            DynamicObject[] dys = BusinessDataServiceHelper.load((String)"epm_accountmembertree", (String)"number,accounttype", (QFilter[])qfBuilder.toArray());
            if (dys != null && dys.length > 0) {
                HashMap<String, String> accountTypeEnumMap = new HashMap<String, String>(16);
                for (DynamicObject dy : dys) {
                    accountTypeEnumMap.put(dy.getString("number"), dy.getString("accounttype"));
                }
                return accountTypeEnumMap;
            }
            return null;
        }
    }

    private class PermissionLock
    extends AbstractCellLock {
        private boolean isAdmin;
        private PermissionLockController.PermTypePack pack;

        PermissionLock(StyleContext ctx, Map<String, Map<String, Object>> dataTable, Map<Object, Object> styles) {
            super(ctx, dataTable, styles);
            this.isAdmin = MemberPermHelper.ifUserHasRootPermByModel((long)UserUtils.getUserId(), (String)String.valueOf(this.ctx.getTemplate().getModelId()));
            this.pack = new PermissionLockController.PermTypePack();
            this.pack.setPermType(PermEnum.READWRITE);
            ArrayList<String> dimNumbers = new ArrayList<String>(10);
            for (IDimMember dm : ctx.getSpreadManager().getFilter().getViewPointDomain().getAllMembers()) {
                dimNumbers.add(dm.getDimension().getNumber());
            }
            for (IDimMember dm : ctx.getSpreadManager().getFilter().getPageDomain().getAllMembers()) {
                dimNumbers.add(dm.getDimension().getNumber());
            }
            this.cacheUserDispPerms(dimNumbers, ctx.getModelId());
            this.cycleComparedPermType(ctx, ctx.getSpreadManager().getFilter().getViewPointDomain().getAllMembers(), this.pack);
            this.cycleComparedPermType(ctx, ctx.getSpreadManager().getFilter().getPageDomain().getAllMembers(), this.pack);
        }

        @Override
        void lock(StyleContext ctx, Cell c) {
            if (this.isAdmin || !c.isMdDataDomain()) {
                return;
            }
            boolean isLockCell = false;
            boolean isEncryptedCell = false;
            if (PermEnum.NOPERM == this.pack.getPermType()) {
                isLockCell = true;
                isEncryptedCell = true;
            } else {
                PermissionLockController.PermTypePack newPack = this.pack.copyPack();
                this.cycleComparedPermType(ctx, c.getMemberFromUserObject(), newPack);
                if (PermEnum.NOPERM == newPack.getPermType()) {
                    isLockCell = true;
                    isEncryptedCell = true;
                } else if (PermEnum.READONLY == newPack.getPermType()) {
                    isLockCell = true;
                }
            }
            if (isLockCell) {
                this.setLockStyle(c);
            }
            if (isEncryptedCell) {
                c.setValue((Object)Variant.encryptVariant.toString());
            }
        }

        private void cycleComparedPermType(StyleContext ctx, List<IDimMember> membs, PermissionLockController.PermTypePack remainPack) {
            membs.forEach(memb -> {
                if (PermEnum.NOPERM != remainPack.getPermType()) {
                    Map<String, Set<String>> permInfo = ctx.getEbDimPermMng(memb.getDimension().getNumber());
                    PermEnum membPerm = null;
                    int permVal = 1;
                    int emptyPermVal = 1;
                    Set<String> membPermInfo = null;
                    for (String permKey : PERM_KEY_ARRAY) {
                        membPermInfo = permInfo.get(permKey);
                        if (membPermInfo != null) {
                            if (membPermInfo.contains(memb.getNumber())) {
                                membPerm = PermEnum.getPermTypeByVal((int)permVal);
                                break;
                            }
                        } else {
                            emptyPermVal = permVal;
                        }
                        ++permVal;
                    }
                    if (membPerm == null) {
                        membPerm = PermEnum.getPermTypeByVal((int)emptyPermVal);
                    }
                    if (membPerm.getValue() > remainPack.getPermType().getValue()) {
                        remainPack.setPermType(membPerm);
                    }
                }
            });
        }

        private void cacheUserDispPerms(List<String> dimNumbers, Object modelId) {
        }

        private Map<String, Long> getDimId(Object modelId, List<String> dimNum) {
            HashMap<String, Long> dim = new HashMap<String, Long>();
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"epm_dimension", (String)"id, number", (QFilter[])new QFilter[]{new QFilter("number", "in", dimNum), new QFilter("model", "=", modelId)}, null);){
                for (Row row : ds) {
                    dim.put(row.getString("number"), row.getLong("id"));
                }
            }
            return dim;
        }

        private PermEnum comparedPerm(PermEnum srcPermType, PermEnum targPermType) {
            return srcPermType.getValue() - targPermType.getValue() > 0 ? srcPermType : targPermType;
        }
    }

    private class CellLock
    extends AbstractCellLock {
        CellLock(StyleContext ctx, Map<String, Map<String, Object>> dataTable, Map<Object, Object> styles) {
            super(ctx, dataTable, styles);
        }

        @Override
        void lock(StyleContext ctx, Cell c) {
            if (!ctx.isContinueCommand() || !c.isMdDataDomain()) {
                return;
            }
            if (c.getMemberFromUserObject() != null && c.getMemberFromUserObject().stream().anyMatch(m -> "CSTE".equals(ctx.getProcessMemberNumber()) && DimTypesEnum.ENTITY.getNumber().equals(m.getDimension().getNumber()) ? false : ctx.contrainsNoneLeafOrLableMemberOnRowColDim(m.getDimension().getNumber() + "|" + m.getNumber()))) {
                this.setLockStyle(c);
            }
        }
    }

    private class SheetLock
    extends AbstractCellLock {
        private boolean lock;

        SheetLock(StyleContext ctx, Map<String, Map<String, Object>> dataTable, Map<Object, Object> styles) {
            super(ctx, dataTable, styles);
            this.lock = false;
            this.lock = this.isLock(ctx);
        }

        @Override
        void lock(StyleContext ctx, Cell c) {
            if (this.lock) {
                if (c.isMdDataDomain()) {
                    this.setLockStyle(c);
                }
                ctx.setStopCommand();
            }
        }

        private boolean isLock(StyleContext ctx) {
            if (ctx.isOnlyReadTemplate() || ctx.isUsageQueryTemplate()) {
                return true;
            }
            if (ctx.hasNoneLeafOrLableMemberOnPageViewDim()) {
                return !"CSTE".equals(ctx.getProcessMemberNumber());
            }
            return false;
        }
    }

    private abstract class AbstractCellLock {
        protected StyleContext ctx;
        private Map<String, Map<String, Object>> dataTable;
        private Map<Object, Object> styles;
        private Map<Map<String, Object>, Integer> lockedStyles = new HashMap<Map<String, Object>, Integer>();

        AbstractCellLock(StyleContext ctx, Map<String, Map<String, Object>> dataTable, Map<Object, Object> styles) {
            this.ctx = ctx;
            this.dataTable = dataTable;
            this.styles = styles;
        }

        protected boolean isContinue() {
            return true;
        }

        protected void setLockStyle(Cell c) {
            String colIndex;
            HashMap<String, Integer> cell;
            String rowIndex = String.valueOf(c.getRow());
            Map<String, Object> row = this.dataTable.get(rowIndex);
            if (row == null) {
                row = new HashMap<String, Object>();
                this.dataTable.put(rowIndex, row);
            }
            if ((cell = (HashMap<String, Integer>)row.get(colIndex = String.valueOf(c.getCol()))) == null) {
                cell = new HashMap<String, Integer>();
                this.dataTable.put(colIndex, cell);
            }
            Integer styleId = (Integer)cell.get("s");
            HashMap<String, Boolean> style = new HashMap<String, Boolean>();
            if (styleId != null) {
                style.putAll((Map)this.styles.get(styleId.toString()));
            }
            style.put(StyleController.LOCKED, true);
            styleId = this.lockedStyles.get(style);
            if (styleId == null) {
                styleId = this.styles.size() + 1;
                this.styles.put(styleId.toString(), style);
                this.lockedStyles.put(style, styleId);
            }
            cell.put("s", styleId);
        }

        protected void removeLockStyle(Cell c) {
            Map<String, Object> row = this.dataTable.get(String.valueOf(c.getRow()));
            if (row == null) {
                return;
            }
            Map cell = (Map)row.get(String.valueOf(c.getCol()));
            if (cell == null) {
                return;
            }
            Integer styleId = (Integer)cell.get("s");
            if (styleId == null) {
                return;
            }
            HashMap style = new HashMap();
            style.putAll((Map)this.styles.get(styleId.toString()));
            style.remove(StyleController.LOCKED);
            styleId = this.lockedStyles.get(style);
            if (styleId == null) {
                styleId = this.styles.size() + 1;
                this.styles.put(styleId.toString(), style);
                this.lockedStyles.put(style, styleId);
            }
            cell.put("s", styleId);
        }

        abstract void lock(StyleContext var1, Cell var2);
    }
}

