/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.budget.formplugin.report.style.adjust;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.budget.formplugin.report.floatreport.FloatLogicImpl;
import kd.epm.eb.budget.formplugin.template.util.TemplateFloatUtil;
import kd.epm.eb.budget.formplugin.util.SpreadMemUtil;
import kd.epm.eb.common.ebcommon.common.Pair;
import kd.epm.eb.common.ebcommon.common.PresetConstant;
import kd.epm.eb.common.ebcommon.common.enums.DimTypesEnum;
import kd.epm.eb.common.ebcommon.common.enums.FacTabFieldDefEnum;
import kd.epm.eb.ebBusiness.olap.IRelaMembSupplier;
import kd.epm.eb.ebBusiness.olap.OrgRelaProcessMembPool;
import kd.epm.eb.ebBusiness.serviceHelper.OlapServiceHelper;
import kd.epm.eb.ebBusiness.serviceHelper.QueryDimensionServiceHelper;
import kd.epm.eb.ebBusiness.serviceHelper.TreeStructureServiceHelper;
import kd.epm.eb.ebBusiness.sql.MDResultSet;
import kd.epm.eb.ebBusiness.sql.MemberGroupKey;
import kd.epm.eb.ebBusiness.sql.Row;
import kd.epm.eb.ebBusiness.sql.SQLBuilder;
import kd.epm.eb.ebBusiness.sql.util.TypeConversionUtils;
import kd.epm.eb.ebBusiness.template.model.TemplateModel;
import kd.epm.eb.ebSpread.domain.Cell;
import kd.epm.eb.ebSpread.domain.view.SpreadManager;
import kd.epm.eb.ebSpread.domain.view.builder.PositionInfo;
import kd.epm.eb.ebSpread.domain.view.builder.dynamic.BasePointInfo;
import kd.epm.eb.ebSpread.domain.view.builder.dynamic.BasePointInnerLineInfo;
import kd.epm.eb.ebSpread.domain.view.builder.dynamic.DynaMembScopeInfo;
import kd.epm.eb.ebSpread.model.IDimMember;
import kd.epm.eb.ebSpread.model.IDimension;

public class FloatDataProvider {
    public static final String unleafsign = "unleaf";

    public static List<Row> getResultRowByArea(Map<String, MDResultSet> setmap, String area) {
        Object value;
        Row row;
        MDResultSet set = setmap.get(area);
        ArrayList<Row> rows = new ArrayList<Row>();
        if (set != null) {
            while (set.next()) {
                row = set.getRow();
                value = row.getOriginalValue(FacTabFieldDefEnum.FIELD_MONEY.getField());
                if (value == null) continue;
                rows.add(set.getRow());
            }
        }
        if ((set = setmap.get(area + unleafsign)) != null) {
            while (set.next()) {
                row = set.getRow();
                value = row.getOriginalValue(FacTabFieldDefEnum.FIELD_MONEY.getField());
                if (value == null) continue;
                rows.add(set.getRow());
            }
        }
        return rows;
    }

    public static List<Row> getResultRowByArea(TemplateModel template, SpreadManager spread, Map<String, MDResultSet> setmap, PositionInfo positionInfo, BasePointInfo basePointInfo) {
        Set floatDims;
        MDResultSet set = setmap.get(basePointInfo.getOriginalDynaRange());
        ArrayList<Row> rows = new ArrayList<Row>();
        if (set != null) {
            while (set.next()) {
                rows.add(set.getRow());
            }
        }
        if ((set = setmap.get(basePointInfo.getOriginalDynaRange() + unleafsign)) != null) {
            while (set.next()) {
                rows.add(set.getRow());
            }
        }
        if (rows.isEmpty()) {
            return rows;
        }
        ArrayList<Row> newrows = new ArrayList<Row>();
        if (positionInfo.isFloatPosition() && positionInfo.getBasePoints() != null && positionInfo.getBasePoints().size() > 0 && !(floatDims = (Set)SpreadMemUtil.getFixAndFloatDimByPositionInfo((PositionInfo)positionInfo).p2).isEmpty()) {
            Map<String, List<Row>> groupRows = rows.parallelStream().collect(Collectors.groupingBy(d -> {
                StringBuilder sb = new StringBuilder();
                for (String dim : floatDims) {
                    sb.append(d.getString(dim)).append(';');
                }
                return sb.deleteCharAt(sb.length() - 1).toString();
            }));
            groupRows.forEach((k, v) -> {
                boolean isNotAllZero = v.stream().anyMatch(e -> {
                    try {
                        BigDecimal vv = TypeConversionUtils.objToBigDecimal((Object)e.getOriginalValue(FacTabFieldDefEnum.FIELD_MONEY.getField()));
                        if (vv != null && vv.compareTo(BigDecimal.ZERO) != 0) {
                            return true;
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    return false;
                });
                if (isNotAllZero) {
                    newrows.addAll((Collection<Row>)v);
                }
            });
        }
        return newrows;
    }

    public static List<Row> sortRowByDim(List<Row> rows, final String ... dimnum) {
        Collections.sort(rows, new Comparator<Row>(){

            @Override
            public int compare(Row o1, Row o2) {
                for (String num : dimnum) {
                    String mem02;
                    String mem01 = o1.getString(num);
                    if (mem01.compareTo(mem02 = o2.getString(num)) == 0) continue;
                    return mem01.compareTo(mem02);
                }
                return 0;
            }
        });
        return rows;
    }

    public static Map<String, String> getOrgNameMap(long modelId, List<Row> rows) {
        HashSet<String> orgnum = new HashSet<String>(rows.size());
        int entityColIndex = -1;
        for (Row row : rows) {
            if (entityColIndex < 0) {
                entityColIndex = row.getColIndex(DimTypesEnum.ENTITY.getNumber());
            }
            String number = TypeConversionUtils.objToString((Object)row.getValue(entityColIndex));
            orgnum.add(number);
        }
        Map orgname = QueryDimensionServiceHelper.getOrgNameByNum((long)modelId, (String[])orgnum.toArray(new String[orgnum.size()]));
        return orgname;
    }

    public static Map<String, MDResultSet> queryMDResultSetMapByPageAndView(SpreadManager spread, long modelId, boolean isDirectHoriz, IRelaMembSupplier<String, String> relaMembSupplier) {
        ArrayList<IDimension> pageAndViewDim = new ArrayList<IDimension>(spread.getFilter().getPageDomain().getDimensions());
        pageAndViewDim.addAll(spread.getFilter().getViewPointDomain().getDimensions());
        HashMap<String, MDResultSet> mdResultSetMap = new HashMap<String, MDResultSet>();
        String modelNumber = QueryDimensionServiceHelper.getModelNumber((long)modelId);
        boolean isCS = FloatDataProvider.isCS(pageAndViewDim);
        String[] dimNumList = FloatDataProvider.getDimensionNums(modelId);
        for (PositionInfo positionInfo : FloatLogicImpl.sortPositionInfo(spread.getAreaManager().getPostionInfoSet(), isDirectHoriz)) {
            if (positionInfo.getBasePoints() != null && positionInfo.getBasePoints().isEmpty()) continue;
            for (BasePointInfo bp : FloatLogicImpl.sortBasePoint(positionInfo.getBasePoints())) {
                if (isCS && positionInfo.getFloatSummaryWay() == PositionInfo.FloatSummaryWay.NONSUPPORT) {
                    if (positionInfo.getFloatOrgRange() == PositionInfo.FloatOrgRange.LEAF) {
                        FloatDataProvider.setLeafResult(modelId, modelNumber, pageAndViewDim, dimNumList, mdResultSetMap, bp);
                        continue;
                    }
                    if (positionInfo.getFloatOrgRange() != PositionInfo.FloatOrgRange.DIRECT) continue;
                    FloatDataProvider.setDirectResult(modelId, modelNumber, pageAndViewDim, dimNumList, mdResultSetMap, bp);
                    continue;
                }
                SQLBuilder sql = new SQLBuilder(modelNumber);
                sql.addMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
                for (IDimension dim : pageAndViewDim) {
                    String[] values = new String[dim.getMembers().size()];
                    for (int i = 0; i < values.length; ++i) {
                        values[i] = ((IDimMember)dim.getMembers().get(i)).getNumber();
                    }
                    sql.addFilter(dim.getNumber(), values);
                }
                FloatDataProvider.addFixMemberFilter(bp, sql, modelId);
                sql.addSelectField(dimNumList);
                FloatDataProvider.appendOrgRelaMemb(sql, relaMembSupplier);
                MDResultSet set = OlapServiceHelper.queryData((SQLBuilder)sql);
                mdResultSetMap.put(bp.getOriginalDynaRange(), set);
            }
        }
        return mdResultSetMap;
    }

    private static void appendOrgRelaMemb(SQLBuilder sql, IRelaMembSupplier<String, String> relaMembSupplier) {
        AtomicBoolean existRelaProcess = new AtomicBoolean(false);
        ArrayList allProcess = new ArrayList(2);
        sql.getFilters().forEach(e -> {
            if (DimTypesEnum.PROCESS.getNumber().equals(e.p1)) {
                for (String s : (String[])e.p2) {
                    existRelaProcess.set(OrgRelaProcessMembPool.isRelaProcess((String)s));
                    allProcess.add(s);
                }
            }
        });
        if (existRelaProcess.get()) {
            List filters = sql.getFilters();
            boolean isOnlyRelaEntityFilter = allProcess.stream().allMatch(p -> OrgRelaProcessMembPool.isRelaProcess((String)p));
            for (int i = 0; i < filters.size(); ++i) {
                if (!DimTypesEnum.ENTITY.getNumber().equals(((Pair)filters.get((int)i)).p1)) continue;
                String[] p2Array = (String[])((Pair)filters.get((int)i)).p2;
                HashSet orgs = Sets.newHashSetWithExpectedSize((int)p2Array.length);
                for (String s : p2Array) {
                    orgs.add(relaMembSupplier.access((Object)s));
                    if (isOnlyRelaEntityFilter) continue;
                    orgs.add(s);
                }
                Pair filter = Pair.onePair((Object)((Pair)filters.get((int)i)).p1, (Object)orgs.toArray(new String[0]));
                filters.set(i, filter);
            }
        }
    }

    private static boolean isCS(List<IDimension> pageAndViewDim) {
        String processNumber = DimTypesEnum.PROCESS.getNumber();
        for (IDimension dim : pageAndViewDim) {
            if (!processNumber.equals(dim.getNumber())) continue;
            for (IDimMember mem : dim.getMembers()) {
                if (!"CS".equals(mem.getNumber())) continue;
                return true;
            }
        }
        return false;
    }

    private static void addBasePointInlineFixMemberFilter(BasePointInfo bp, SQLBuilder sql) {
        HashMap dim2MembMap = new HashMap();
        bp.getBasePointInnerLineInfo().forEach(l -> {
            if (!l.isFloated()) {
                dim2MembMap.put(l.getDimension().getNumber(), ((DynaMembScopeInfo)l.getDynaMembScopes().get(0)).getMember().getNumber());
            }
        });
        dim2MembMap.entrySet().forEach(e -> sql.addFilter((String)e.getKey(), new String[]{(String)e.getValue()}));
    }

    private static void setLeafResult(long modelId, String modelNumber, List<IDimension> pageAndViewDim, String[] dimNumList, Map<String, MDResultSet> mdResultSetMap, BasePointInfo bp) {
        SQLBuilder sql = new SQLBuilder(modelNumber);
        sql.addMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
        String[] processnumber = null;
        for (IDimension dim : pageAndViewDim) {
            int i;
            String[] values;
            if (dim.getNumber().equals(DimTypesEnum.ENTITY.getNumber())) {
                List<String> orgLeafChildList = FloatDataProvider.getOrgLeafChildList(dim, modelId);
                if (orgLeafChildList.isEmpty()) {
                    sql.addFilter(dim.getNumber(), new String[]{((IDimMember)dim.getMembers().get(0)).getNumber()});
                    continue;
                }
                sql.addFilter(dim.getNumber(), orgLeafChildList.toArray(new String[0]));
                processnumber = new String[]{"IRpt"};
                continue;
            }
            if (dim.getNumber().equals(DimTypesEnum.PROCESS.getNumber())) {
                values = new String[dim.getMembers().size()];
                for (i = 0; i < values.length; ++i) {
                    values[i] = ((IDimMember)dim.getMembers().get(i)).getNumber();
                }
                if (processnumber != null) continue;
                processnumber = values;
                continue;
            }
            values = new String[dim.getMembers().size()];
            for (i = 0; i < values.length; ++i) {
                values[i] = ((IDimMember)dim.getMembers().get(i)).getNumber();
            }
            sql.addFilter(dim.getNumber(), values);
        }
        FloatDataProvider.addFixMemberFilter(bp, sql, modelId);
        sql.addFilter(DimTypesEnum.PROCESS.getNumber(), processnumber);
        sql.addSelectField(dimNumList);
        MDResultSet set = OlapServiceHelper.queryData((SQLBuilder)sql);
        mdResultSetMap.put(bp.getOriginalDynaRange(), set);
    }

    private static void setDirectResult(long modelId, String modelNumber, List<IDimension> pageAndViewDim, String[] dimNumList, Map<String, MDResultSet> mdResultSetMap, BasePointInfo bp) {
        int i;
        String[] values;
        SQLBuilder sql;
        List<String> orgLeafChildList = null;
        List<String> orgDirectUnleafChildList = null;
        List<String> orgDirectLeafChildList = null;
        for (IDimension iDimension : pageAndViewDim) {
            if (!iDimension.getNumber().equals(DimTypesEnum.ENTITY.getNumber())) continue;
            orgLeafChildList = FloatDataProvider.getOrgLeafChildList(iDimension, modelId);
            orgDirectUnleafChildList = FloatDataProvider.getOrgDirectChildList(iDimension, modelId);
            orgDirectLeafChildList = FloatDataProvider.getOrgDirectChildList(iDimension, modelId);
            orgDirectLeafChildList.retainAll(orgLeafChildList);
            orgDirectUnleafChildList.removeAll(orgDirectLeafChildList);
            break;
        }
        if (orgLeafChildList == null || orgLeafChildList.isEmpty()) {
            FloatDataProvider.setLeafResult(modelId, modelNumber, pageAndViewDim, dimNumList, mdResultSetMap, bp);
            return;
        }
        if (!orgDirectLeafChildList.isEmpty()) {
            sql = new SQLBuilder(modelNumber);
            sql.addMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
            for (IDimension dim : pageAndViewDim) {
                if (dim.getNumber().equals(DimTypesEnum.ENTITY.getNumber())) {
                    sql.addFilter(dim.getNumber(), orgDirectLeafChildList.toArray(new String[0]));
                    continue;
                }
                if (dim.getNumber().equals(DimTypesEnum.PROCESS.getNumber())) continue;
                values = new String[dim.getMembers().size()];
                for (i = 0; i < values.length; ++i) {
                    values[i] = ((IDimMember)dim.getMembers().get(i)).getNumber();
                }
                sql.addFilter(dim.getNumber(), values);
            }
            FloatDataProvider.addFixMemberFilter(bp, sql, modelId);
            sql.addFilter(DimTypesEnum.PROCESS.getNumber(), new String[]{"IRpt"});
            sql.addSelectField(dimNumList);
            MDResultSet mDResultSet = OlapServiceHelper.queryData((SQLBuilder)sql);
            mdResultSetMap.put(bp.getOriginalDynaRange(), mDResultSet);
        }
        if (!orgDirectUnleafChildList.isEmpty()) {
            sql = new SQLBuilder(modelNumber);
            sql.addMeasures(new String[]{FacTabFieldDefEnum.FIELD_MONEY.getField()});
            for (IDimension dim : pageAndViewDim) {
                if (dim.getNumber().equals(DimTypesEnum.ENTITY.getNumber())) {
                    sql.addFilter(dim.getNumber(), orgDirectUnleafChildList.toArray(new String[0]));
                    continue;
                }
                if (dim.getNumber().equals(DimTypesEnum.PROCESS.getNumber())) continue;
                values = new String[dim.getMembers().size()];
                for (i = 0; i < values.length; ++i) {
                    values[i] = ((IDimMember)dim.getMembers().get(i)).getNumber();
                }
                sql.addFilter(dim.getNumber(), values);
            }
            FloatDataProvider.addFixMemberFilter(bp, sql, modelId);
            sql.addFilter(DimTypesEnum.PROCESS.getNumber(), new String[]{"CS"});
            sql.addSelectField(dimNumList);
            MDResultSet mDResultSet = OlapServiceHelper.queryData((SQLBuilder)sql);
            mdResultSetMap.put(bp.getOriginalDynaRange() + unleafsign, mDResultSet);
        }
    }

    public static String[] getDimensionNums(long modelId) {
        QFilter qf = new QFilter("model.id", "=", (Object)modelId);
        QFilter[] qfs = new QFilter[]{qf};
        Collection dcs = BusinessDataServiceHelper.loadFromCache((String)"epm_dimension", (String)"number", (QFilter[])qfs).values();
        ArrayList list = new ArrayList();
        dcs.forEach(p -> list.add(p.getString("number")));
        return list.toArray(new String[0]);
    }

    public static List<String> getOrgLeafChildList(IDimension dim, long modelId) {
        ArrayList<String> list = new ArrayList<String>();
        QFilter filterModel = new QFilter("model", "=", (Object)modelId);
        QFilter filterNumber = new QFilter("number", "=", (Object)((IDimMember)dim.getMembers().get(0)).getNumber());
        DynamicObject orgObj = BusinessDataServiceHelper.loadSingleFromCache((String)"epm_entitymembertree", (String)"id, number, longnumber", (QFilter[])new QFilter[]{filterModel, filterNumber});
        if (orgObj != null) {
            List directChildren = TreeStructureServiceHelper.getLeafChildren((String)"epm_entitymembertree", (Long)orgObj.getLong("id"), (Object)modelId);
            directChildren.forEach(e -> list.add(e.number));
            return list;
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u65e0\u4e0b\u7ea7\u7ec4\u7ec7\u3002", (String)"FloatDataProvider_0", (String)"epm-eb-budget", (Object[])new Object[0]));
    }

    public static List<String> getOrgDirectChildList(IDimension dim, long modelId) {
        ArrayList<String> list = new ArrayList<String>();
        QFilter filterModel = new QFilter("model", "=", (Object)modelId);
        QFilter filterNumber = new QFilter("number", "=", (Object)((IDimMember)dim.getMembers().get(0)).getNumber());
        DynamicObject orgObj = BusinessDataServiceHelper.loadSingleFromCache((String)"epm_entitymembertree", (String)"id, number, longnumber", (QFilter[])new QFilter[]{filterModel, filterNumber});
        if (orgObj != null) {
            List directChildren = TreeStructureServiceHelper.getDirectChild((String)"epm_entitymembertree", (Object)orgObj.get("id"), (Object)modelId);
            directChildren.forEach(e -> list.add(e.number));
            return list;
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u65e0\u4e0b\u7ea7\u7ec4\u7ec7\u3002", (String)"FloatDataProvider_0", (String)"epm-eb-budget", (Object[])new Object[0]));
    }

    public static void dealRowByPack(Map<MemberGroupKey, List<Row>> rowMap, MemberGroupKey key, List<Map<String, Object>> cellsets, Cell cell, String reportOrgNumber, int moneyColIndex) {
        List<Row> rows = rowMap.get(key);
        if (rows != null && !rows.isEmpty()) {
            Row row = rows.get(0);
            Object value = row.getValue(moneyColIndex);
            Object oldvalue = cell.getValue();
            String dataOregNumber = row.getString(DimTypesEnum.ENTITY.getNumber());
            if (value == null) {
                if (oldvalue != null) {
                    cell.setValue(value);
                }
            } else if (oldvalue == null || !value.toString().equals(oldvalue.toString())) {
                cell.setValue(value);
            }
            cell.setUserObject("floatmd", (Object)true);
            rowMap.remove(key);
        }
    }

    public static void addFixMemberFilter(BasePointInfo bs, SQLBuilder sql, long modelId) {
        Map<String, Set<String>> dim2mem = FloatDataProvider.getFixMembers(bs);
        for (Map.Entry<String, Set<String>> entry : dim2mem.entrySet()) {
            Set<String> value = entry.getValue();
            if (value == null) continue;
            sql.addFilter(entry.getKey(), value.toArray(new String[0]));
        }
        FloatDataProvider.addBasePointInlineFixMemberFilter(bs, sql);
        FloatDataProvider.addFloatDimMemberFilter(bs, sql, modelId);
    }

    private static void addFloatDimMemberFilter(BasePointInfo bs, SQLBuilder sql, long modelId) {
        HashMap<String, Set> membScope = new HashMap<String, Set>();
        for (BasePointInnerLineInfo l : bs.getBasePointInnerLineInfo()) {
            if (!l.isFloated()) continue;
            String dimNum = l.getDimension().getNumber();
            Set members = membScope.computeIfAbsent(dimNum, key -> new HashSet());
            Set<String> numbers = TemplateFloatUtil.getNumbersByInnerInfo(l, modelId);
            if (numbers == null) continue;
            if (numbers.size() > 0) {
                members.addAll(numbers);
                continue;
            }
            sql.setCancel(true);
        }
        membScope.entrySet().forEach(e -> {
            if (!((Set)e.getValue()).isEmpty()) {
                sql.addFilter((String)e.getKey(), ((Set)e.getValue()).toArray(new String[0]));
            }
        });
    }

    public static boolean isIncludeFilterDim(String dimNum) {
        return !PresetConstant.MYCOMPANY_DIM.equals(dimNum) && !PresetConstant.INTERNALCOMPANY_DIM.equals(dimNum);
    }

    private static Map<String, Set<String>> getFixMembers(BasePointInfo bp) {
        Map map = bp.getFixMemberPosition();
        HashMap<String, Set<String>> dimMap = new HashMap<String, Set<String>>();
        for (List mems : map.values()) {
            for (IDimMember mem : mems) {
                String dim = mem.getDimension().getNumber();
                HashSet<String> memnums = (HashSet<String>)dimMap.get(dim);
                if (memnums == null) {
                    memnums = new HashSet<String>();
                    dimMap.put(dim, memnums);
                }
                memnums.add(mem.getNumber());
            }
        }
        return dimMap;
    }
}

