/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.budget.formplugin.sharememberf7;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ValueTextItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.SelectRowsEvent;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.F7SelectedList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.F7SelectedListRemoveEvent;
import kd.bos.list.events.F7SelectedListRemoveListener;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.IntegerField;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.budget.formplugin.util.DimensionUtil;
import kd.epm.eb.business.utils.EPMTreeUtils;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.ebcommon.common.enums.dimension.SysDimensionEnum;
import kd.epm.eb.common.model.MemberEntity;
import kd.epm.eb.common.permission.enums.DimMembPermType;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.ebBusiness.serviceHelper.MemberPermHelper;
import kd.epm.eb.ebSpread.common.util.StringUtil;

public class EbCustomShareF7Plugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
SearchEnterListener,
SelectRowsEventListener,
F7SelectedListRemoveListener {
    private String entryKey = "entrysingle";
    private boolean isMulti = false;
    public static final String ROOTID = "rootid";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView treeView = this.getLeftTreeControl();
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        Search search = (Search)this.getControl("searchap1");
        search.addEnterListener((SearchEnterListener)this);
        this.addClickListeners(new String[]{"img_first", "img_pre", "img_next", "img_last", "btnok"});
        F7SelectedList selectedList = (F7SelectedList)this.getControl("f7selectedlistap");
        selectedList.addF7SelectedListRemoveListener((F7SelectedListRemoveListener)this);
        selectedList.addF7SelectedListRemoveAllListener((F7SelectedListRemoveListener)this);
    }

    public void selectRowsChange(SelectRowsEvent evt) {
        List newSelectRows = evt.getNewRows();
        List oldSelectRows = evt.getOldRows();
        List addRows = newSelectRows.stream().filter(num -> !oldSelectRows.contains(num)).collect(Collectors.toList());
        List removeRows = oldSelectRows.stream().filter(num -> !newSelectRows.contains(num)).collect(Collectors.toList());
        List<Long> selectMembIds = null;
        selectMembIds = this.isMulti ? this.getSelectedMembIds() : new ArrayList<Long>();
        IDataModel dataModel = this.getModel();
        DynamicObject row = null;
        if (!addRows.isEmpty()) {
            for (Integer rowNum : addRows) {
                row = dataModel.getEntryRowEntity(this.entryKey, rowNum.intValue());
                selectMembIds.add(row.getLong(this.entryKey + "_id"));
            }
        }
        if (!removeRows.isEmpty()) {
            for (Integer rowNum : removeRows) {
                row = dataModel.getEntryRowEntity(this.entryKey, rowNum.intValue());
                selectMembIds.remove(row.getLong(this.entryKey + "_id"));
            }
        }
        ArrayList<ValueTextItem> valueTextItems = new ArrayList<ValueTextItem>();
        F7SelectedList list = (F7SelectedList)this.getControl("f7selectedlistap");
        if (!selectMembIds.isEmpty()) {
            Map<String, Map<String, String>> allMembs = this.getCacheNodeMap();
            for (Long membId : selectMembIds) {
                Map<String, String> m = allMembs.get(String.valueOf(membId));
                if (m == null) continue;
                ValueTextItem item = new ValueTextItem(String.valueOf(membId), m.get("name"));
                valueTextItems.add(item);
            }
        }
        list.addItems(valueTextItems);
        this.cacheSelectedMembIds(selectMembIds);
    }

    private Map<Long, MemberEntity> getAllMemb() {
        HashMap<Long, MemberEntity> members = new HashMap<Long, MemberEntity>(16);
        MemberEntity memb = null;
        String dimNumber = this.getDimensionNum();
        Long modelId = this.getModelId();
        QFBuilder qf = new QFBuilder("model", "=", (Object)modelId);
        qf.add("dimension.number", "=", (Object)dimNumber);
        String memberModel = EbCustomShareF7Plugin.getMemberTreemodelByNumber(dimNumber);
        if (kd.epm.eb.common.enums.SysDimensionEnum.AuditTrail.getMemberTreemodel().equals(memberModel)) {
            qf.add("number", "not in", Arrays.asList("ADJE", "CWP", "ManualJournal", "AutoJournal"));
        }
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)memberModel, (String)"id,number,parent,dseq", (QFilter[])qf.toArray(), null);
        Row row = null;
        while (dataSet.hasNext()) {
            row = dataSet.next();
            Long id = row.getLong("id");
            memb = new MemberEntity(id.longValue(), row.getLong("parent").longValue(), null, row.getString("number"), 0, row.getInteger("dseq").intValue());
            members.put(id, memb);
        }
        DataSet dataSet1 = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"eb_dimsharemember", (String)"id,number,parent,dseq", (QFilter[])qf.toArray(), null);
        while (dataSet1.hasNext()) {
            row = dataSet1.next();
            Long shareMemid = row.getLong("id");
            memb = new MemberEntity(shareMemid.longValue(), row.getLong("parent").longValue(), null, row.getString("number"), 0, row.getInteger("dseq").intValue());
            members.put(shareMemid, memb);
        }
        if (!members.isEmpty()) {
            members.values().forEach(member -> {
                MemberEntity parent = (MemberEntity)members.get(member.getParentId());
                if (parent != null) {
                    parent.getChilds().add(member);
                }
            });
        }
        return members;
    }

    private List<Long> queryMemberByRange(String range, MemberEntity member, Map<Long, MemberEntity> allMembs) {
        ArrayList<Long> childrenId;
        if (member == null) {
            return new ArrayList<Long>(16);
        }
        Long id = member.getId();
        switch (range) {
            case "20": {
                childrenId = new ArrayList<Long>();
                member.getChilds().forEach(memb -> childrenId.add(memb.getId()));
                break;
            }
            case "30": {
                childrenId = new ArrayList();
                childrenId.add(member.getId());
                member.getChilds().forEach(memb -> childrenId.add(memb.getId()));
                break;
            }
            case "40": {
                childrenId = new ArrayList();
                member.iterate(20, memb -> childrenId.add(memb.getId()));
                childrenId.remove(member.getId());
                break;
            }
            case "50": {
                childrenId = new ArrayList();
                member.iterate(20, memb -> childrenId.add(memb.getId()));
                break;
            }
            case "60": {
                MemberEntity parent = allMembs.get(member.getParentId());
                childrenId = new ArrayList();
                parent.getChilds().forEach(memb -> {
                    if (!memb.getId().equals(member.getId())) {
                        childrenId.add(memb.getId());
                    }
                });
                break;
            }
            case "70": {
                MemberEntity parent = allMembs.get(member.getParentId());
                childrenId = new ArrayList();
                parent.getChilds().forEach(memb -> childrenId.add(memb.getId()));
                break;
            }
            case "90": {
                childrenId = new ArrayList();
                member.iterate(20, memb -> {
                    if (memb.getChilds().isEmpty() && !memb.getId().equals(id)) {
                        childrenId.add(memb.getId());
                    }
                });
                break;
            }
            case "110": {
                childrenId = new ArrayList();
                member.iterate(20, memb -> {
                    if (!memb.getChilds().isEmpty() && !memb.getId().equals(id)) {
                        childrenId.add(memb.getId());
                    }
                });
                break;
            }
            default: {
                childrenId = new ArrayList();
            }
        }
        return childrenId;
    }

    private List getDimmensionRang() {
        String memberlist = (String)this.getView().getFormShowParameter().getCustomParam("dimRang");
        if (StringUtils.isNotEmpty((String)memberlist)) {
            return SerializationUtils.fromJsonStringToList((String)memberlist, Map.class);
        }
        return new ArrayList();
    }

    public List<Long> getSelectedMembIds() {
        String cacheStr = this.getPageCache().get("selectMembIds");
        ArrayList<Long> membIds = null;
        membIds = cacheStr != null ? (ArrayList<Long>)SerializationUtils.deSerializeFromBase64((String)cacheStr) : new ArrayList<Long>();
        return membIds;
    }

    public void cacheSelectedMembIds(List<Long> membIds) {
        this.getPageCache().put("selectMembIds", SerializationUtils.serializeToBase64(membIds));
    }

    public void setReturnData() {
        List<Long> selectMembIds = this.getSelectedMembIds();
        if (!selectMembIds.isEmpty()) {
            ListSelectedRowCollection selectedRows = new ListSelectedRowCollection();
            ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
            Object needNameAndNum = listShowParameter.getCustomParam("needNameAndNum");
            for (Long membId : selectMembIds) {
                selectedRows.add((Object)new ListSelectedRow((Object)membId));
            }
            if (needNameAndNum != null) {
                Map<String, Map<String, String>> membs = this.getCacheNodeMap();
                for (ListSelectedRow row : selectedRows) {
                    Map<String, String> memb = membs.get(String.valueOf(row.getPrimaryKeyValue()));
                    if (memb == null) continue;
                    row.setName(memb.get("name"));
                    row.setNumber(memb.get("number"));
                    HashMap<String, String> dataMap = new HashMap<String, String>(memb);
                    row.setDataMap(dataMap);
                }
            }
            this.getView().returnDataToParent((Object)selectedRows);
        }
        this.getView().close();
    }

    public void initialize() {
        super.initialize();
        this.isMulti = ((ListShowParameter)this.getView().getFormShowParameter()).isMultiSelect();
        if (this.isMulti) {
            this.entryKey = "entrymutil";
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl(this.entryKey);
        entryGrid.addSelectRowsListener((SelectRowsEventListener)this);
    }

    public TreeView getLeftTreeControl() {
        TreeView treeView = (TreeView)this.getControl("treeview1");
        return treeView;
    }

    public BillList getRightListControl() {
        BillList billList = (BillList)this.getControl("billlistap");
        return billList;
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("getall", (Object)Boolean.TRUE);
        this.buildLeftTree();
        this.initEntity();
        this.cacheSelectIdsOnInit();
        this.refleshRightList(true);
    }

    public void cacheSelectIdsOnInit() {
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        ArrayList<Long> selectMembIds = new ArrayList<Long>();
        for (ListSelectedRow row : listShowParameter.getListSelectedRowCollection()) {
            selectMembIds.add((Long)row.getPrimaryKeyValue());
        }
        this.cacheSelectedMembIds(selectMembIds);
    }

    public void initEntity() {
        if (this.entryKey.equals("entrymutil")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"entrysingle"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"entrymutil"});
        }
    }

    private List<Long> getNeedDimensionMap() {
        List<Long> childIds = new ArrayList<Long>();
        ArrayList<Long> containsId = new ArrayList<Long>();
        List memberList = this.getDimmensionRang();
        if (memberList.isEmpty()) {
            return containsId;
        }
        Map<Long, MemberEntity> allMembs = this.getAllMemb();
        for (Map memberCondition : memberList) {
            childIds.clear();
            String range = (String)memberCondition.get("scope");
            if ("10".equals(range)) {
                childIds.add(Long.valueOf((String)memberCondition.get("id")));
            } else {
                MemberEntity member = allMembs.get(Long.valueOf((String)memberCondition.get("id")));
                childIds = this.queryMemberByRange(range, member, allMembs);
            }
            containsId.addAll(childIds);
        }
        return containsId;
    }

    public void buildLeftTree() {
        String headId;
        TreeView tree = this.getLeftTreeControl();
        Long dimensionId = this.getDimensionId();
        DynamicObjectCollection dcs = this.getPresetMemberDoc(dimensionId);
        Set noPermMembIds = DimMembPermHelper.getPermMembIds((String)this.getDimensionNum(), (Long)this.getModelId(), (Long)0L, null, (DimMembPermType)DimMembPermType.READ, (boolean)false);
        List<Long> rangeMemb = this.getNeedDimensionMap();
        if (rangeMemb.size() > 0) {
            dcs.removeIf(e -> !rangeMemb.contains(e.getLong("id")));
        } else {
            dcs.clear();
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6210\u5458\u8303\u56f4\u5185\u4e0d\u5b58\u5728\u53ef\u7528\u6210\u5458\u3002", (String)"EbCustomShareF7Plugin_1", (String)"epm-eb-budget", (Object[])new Object[0]));
        }
        List<Map<String, String>> menberList = this.getMemberList(dcs);
        this.delNoPermMember(menberList, noPermMembIds);
        TreeNode membertree = new TreeNode();
        membertree.setId("0");
        membertree.setText(ResManager.loadKDString((String)"\u5168\u90e8\u6210\u5458", (String)"EbCustomShareF7Plugin_0", (String)"epm-eb-budget", (Object[])new Object[0]));
        String string = headId = menberList.isEmpty() ? "0" : menberList.get(0).get("parentid");
        if (this.getView().getFormShowParameter().getCustomParam(ROOTID) != null) {
            long rootId = (Long)this.getView().getFormShowParameter().getCustomParam(ROOTID);
            DynamicObject oo = QueryServiceHelper.queryOne((String)this.getPageCache().get("membermodel"), (String)"parent.id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)rootId)});
            if (oo != null) {
                headId = oo.getString("parent.id");
            }
        }
        EPMTreeUtils.setEntryNodeWithBreak((TreeNode)membertree, menberList, (String)headId);
        List filter = (List)this.getView().getFormShowParameter().getCustomParam("filter");
        if (filter != null) {
            membertree = EPMTreeUtils.filterTree((TreeNode)membertree, p -> filter.contains(p.getId()));
        }
        if (membertree == null) {
            membertree = new TreeNode();
            membertree.setId("0");
            membertree.setText(ResManager.loadKDString((String)"\u5168\u90e8\u6210\u5458", (String)"EbCustomShareF7Plugin_0", (String)"epm-eb-budget", (Object[])new Object[0]));
        }
        tree.addNode(membertree);
        if (DimensionUtil.isExpand2SecondLevel4MultiMemberF7(this.getMemberModel())) {
            tree.expand(membertree.getId());
            if (membertree.getChildren() != null) {
                membertree.getChildren().forEach(c -> {
                    if (c.getChildren() != null && c.getChildren().size() > 0) {
                        tree.expand(c.getId());
                    }
                });
            }
        } else {
            EPMTreeUtils.spreadAllNode((TreeNode)membertree);
        }
        tree.focusNode(membertree);
        this.cacheLeftNodeId(membertree.getId());
        this.cacheLeftTree(membertree);
        this.cacheNodeMap(membertree);
    }

    public static String getMemberTreemodelByNumber(String number) {
        for (kd.epm.eb.common.enums.SysDimensionEnum se : kd.epm.eb.common.enums.SysDimensionEnum.values()) {
            if (!number.equals(se.getNumber())) continue;
            return se.getMemberTreemodel();
        }
        return "epm_userdefinedmembertree";
    }

    private void cacheNodeMap(TreeNode root) {
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>(16);
        this.getNode(root, map);
        this.getPageCache().put("allMember", SerializationUtils.toJsonString(map));
    }

    private Map<String, Map<String, String>> getCacheNodeMap() {
        String str = this.getPageCache().get("allMember");
        Map<String, Map<String, String>> map = new HashMap<String, Map<String, String>>(16);
        if (StringUtils.isNotEmpty((String)str)) {
            map = (Map)SerializationUtils.fromJsonString((String)str, Map.class);
        }
        return map;
    }

    private void getNode(TreeNode root, Map<String, Map<String, String>> map) {
        if (root == null) {
            return;
        }
        Map data = (Map)root.getData();
        map.put(root.getId(), data);
        if (root.getChildren() != null) {
            List children = root.getChildren();
            for (TreeNode child : children) {
                this.getNode(child, map);
            }
        }
    }

    private String getMemberModel() {
        return kd.epm.eb.common.enums.SysDimensionEnum.getMemberTreemodelByNumber((String)this.getDimensionNum());
    }

    public List<Map<String, String>> getMemberList(DynamicObjectCollection dcs) {
        ArrayList<Map<String, String>> menberList = new ArrayList<Map<String, String>>();
        if (dcs != null && dcs.size() > 0) {
            for (DynamicObject task : dcs) {
                HashMap<String, String> memberMap = new HashMap<String, String>();
                memberMap.put("id", task.get("id").toString());
                memberMap.put("number", task.getString("number"));
                memberMap.put("name", task.getString("number") + "\n\n" + task.getString("name"));
                memberMap.put("parentid", task.get("parent").toString());
                memberMap.put("storagetype", task.getString("storagetype"));
                memberMap.put("isleaf", task.getString("isleaf"));
                memberMap.put("level", task.getString("level"));
                memberMap.put("dseq", task.getString("dseq"));
                memberMap.put("memberid", task.getString("memberid"));
                memberMap.put("sharememberid", task.getString("sharememberid"));
                menberList.add(memberMap);
            }
        }
        return menberList;
    }

    protected void delNoPermMember(List<Map<String, String>> menberList, Set<Long> noPermIds) {
        Long modelid = this.getModelId();
        Set modelIds = MemberPermHelper.getLimitedModelListByUser();
        if (modelIds.contains(modelid)) {
            this.getPageCache().put("rootuser", "true");
            return;
        }
        if (noPermIds == null || noPermIds.isEmpty()) {
            return;
        }
        Iterator<Map<String, String>> permIt = menberList.iterator();
        Long membId = null;
        while (permIt.hasNext()) {
            Map<String, String> map = permIt.next();
            membId = Long.valueOf(map.get("memberid"));
            if (!noPermIds.contains(membId)) continue;
            permIt.remove();
        }
    }

    protected DynamicObjectCollection getPresetMemberDoc(Long dimensionid) {
        DynamicObjectCollection shareMembers;
        ListShowParameter showParameter = (ListShowParameter)this.getView().getFormShowParameter();
        List qFilters = showParameter.getListFilterParameter().getQFilters();
        String entityName = kd.epm.eb.common.enums.SysDimensionEnum.getMemberTreemodelByNumber((String)this.getDimensionNum());
        String memberFields = "id,name,number,parent,storagetype,longnumber,level,dseq,isleaf,id as memberid,'0' as sharememberid";
        String shareMemberFields = "id,id as sharememberid,name,number,parent,storagetype,longnumber,level,dseq,isleaf,memberid";
        QFilter filter1 = new QFilter("dimension", "=", (Object)dimensionid);
        if ("epm_audittrialmembertree".equals(entityName)) {
            filter1.and(new QFilter("number", "not in", Arrays.asList("ADJE", "CWP", "ManualJournal", "AutoJournal")));
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        filters.add(filter1);
        if (qFilters != null) {
            filters.addAll(qFilters);
        }
        String orderBys = "level,dseq";
        String tag = "\n\n" + ResManager.loadKDString((String)"\uff08\u5171\u4eab\uff09", (String)"EbCustomShareF7Plugin_2", (String)"epm-eb-budget", (Object[])new Object[0]);
        if ("epm_entitymembertree".equals(entityName)) {
            DynamicObjectCollection shareMembers2;
            memberFields = memberFields + ",isoffsetentry";
            DynamicObjectCollection query = QueryServiceHelper.query((String)entityName, (String)memberFields, (QFilter[])filters.toArray(new QFilter[0]), (String)orderBys);
            query.removeIf(dy -> dy.getBoolean("isoffsetentry"));
            if (this.isContainShare() && (shareMembers2 = QueryServiceHelper.query((String)"eb_dimsharemember", (String)shareMemberFields, (QFilter[])new QFilter[]{filter1}, (String)orderBys)) != null && shareMembers2.size() > 0) {
                shareMembers2.forEach(e -> e.set("name", (Object)(e.getString("name") + tag)));
                query.addAll((Collection)shareMembers2);
            }
            return query;
        }
        DynamicObjectCollection members = QueryServiceHelper.query((String)entityName, (String)memberFields, (QFilter[])filters.toArray(new QFilter[0]), (String)orderBys);
        this.cacheStoragetypeMap(members);
        if (this.isContainShare() && (shareMembers = QueryServiceHelper.query((String)"eb_dimsharemember", (String)shareMemberFields, (QFilter[])new QFilter[]{filter1}, (String)orderBys)) != null && shareMembers.size() > 0) {
            shareMembers.forEach(e -> e.set("name", (Object)(e.getString("name") + tag)));
            members.addAll((Collection)shareMembers);
        }
        return members;
    }

    private void cacheStoragetypeMap(DynamicObjectCollection members) {
        HashMap<Long, String> map = new HashMap<Long, String>(16);
        for (DynamicObject member : members) {
            map.put(member.getLong("id"), member.getString("storagetype"));
        }
        this.getPageCache().put("storagetypemap", SerializationUtils.toJsonString(map));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propKey;
        switch (propKey = e.getProperty().getName()) {
            case "getall": 
            case "page_size_select": {
                this.refleshRightList(false);
                break;
            }
            case "pageinput": {
                int newPageNum = (Integer)e.getChangeSet()[0].getNewValue();
                if (newPageNum <= 0) {
                    return;
                }
                if (newPageNum == 1 && this.getPageCache().get("isinit") != null) {
                    return;
                }
                this.getPageCache().remove("isinit");
                this.pageTurn(newPageNum);
                break;
            }
        }
    }

    public void click(EventObject evt) {
        String clickKey = ((Control)evt.getSource()).getKey();
        String currentPageStr = this.getPageCache().get("currentPage");
        String allCountStr = this.getPageCache().get("allCount");
        String pageSizeStr = (String)this.getModel().getValue("page_size_select");
        if (currentPageStr == null || allCountStr == null || pageSizeStr == null) {
            return;
        }
        int currentPage = Integer.parseInt(currentPageStr);
        int allCount = Integer.parseInt(allCountStr);
        int pageSize = Integer.parseInt(pageSizeStr);
        switch (clickKey) {
            case "img_first": {
                this.firstPage(currentPage, allCount, pageSize);
                break;
            }
            case "img_pre": {
                this.prePage(currentPage, allCount, pageSize);
                break;
            }
            case "img_next": {
                this.nextPage(currentPage, allCount, pageSize);
                break;
            }
            case "img_last": {
                this.lastPage(currentPage, allCount, pageSize);
                break;
            }
            case "btnok": {
                this.setReturnData();
                break;
            }
        }
    }

    public void nextPage(int currentPage, int allCount, int pageSize) {
        int allPage = allCount / pageSize + 1;
        if (allCount % pageSize == 0) {
            --allPage;
        }
        if (currentPage + 1 <= allPage) {
            this.getModel().setValue("pageinput", (Object)(currentPage + 1));
        }
    }

    public void prePage(int currentPage, int allCount, int pageSize) {
        if (currentPage > 1) {
            this.getModel().setValue("pageinput", (Object)(currentPage - 1));
        }
    }

    public void firstPage(int currentPage, int allCount, int pageSize) {
        if (currentPage > 1) {
            this.getModel().setValue("pageinput", (Object)1);
        }
    }

    public void lastPage(int currentPage, int allCount, int pageSize) {
        int allPage = allCount / pageSize + 1;
        if (allCount % pageSize == 0) {
            --allPage;
        }
        if (currentPage < allPage) {
            this.getModel().setValue("pageinput", (Object)allPage);
        }
    }

    public void pageTurn(int newPageNum) {
        List searchMatchMemb;
        int pageSize = Integer.parseInt((String)this.getModel().getValue("page_size_select"));
        String cacheStr = this.getPageCache().get("searchMatch");
        if (cacheStr != null && !(searchMatchMemb = (List)SerializationUtils.deSerializeFromBase64((String)cacheStr)).isEmpty()) {
            IDataModel dataModel = this.getModel();
            dataModel.deleteEntryData(this.entryKey);
            int sub = searchMatchMemb.size() - newPageNum * pageSize;
            int membCounts = sub < 0 ? pageSize + sub : pageSize;
            dataModel.batchCreateNewEntryRow(this.entryKey, membCounts);
            DynamicObject row = null;
            TreeNode memb = null;
            String idFile = this.entryKey + "_id";
            String nameFile = this.entryKey + "_name";
            String numberFile = this.entryKey + "_number";
            String storageFile = this.entryKey + "_storagetype";
            int beginIndex = (newPageNum - 1) * pageSize;
            List<Long> selectMembIds = this.getSelectedMembIds();
            ArrayList<Integer> rowNums = new ArrayList<Integer>();
            for (int i = 0; i < membCounts; ++i) {
                row = dataModel.getEntryRowEntity(this.entryKey, i);
                memb = (TreeNode)searchMatchMemb.get(beginIndex + i);
                if (selectMembIds.contains(Long.parseLong(memb.getId()))) {
                    rowNums.add(i);
                }
                Map data = (Map)memb.getData();
                row.set(idFile, (Object)Long.parseLong(memb.getId()));
                row.set(nameFile, (Object)((String)data.get("name")).split("\n\n")[1]);
                row.set(numberFile, data.get("number"));
                row.set(storageFile, data.get("storagetype"));
            }
            this.getView().updateView(this.entryKey);
            if (rowNums.size() > 0) {
                int[] rowIndexs = new int[rowNums.size()];
                for (int i = 0; i < rowNums.size(); ++i) {
                    rowIndexs[i] = (Integer)rowNums.get(i);
                }
                EntryGrid entryGrid = (EntryGrid)this.getControl(this.entryKey);
                entryGrid.selectRows(rowIndexs, rowIndexs[0]);
            }
            this.getPageCache().put("currentPage", String.valueOf(newPageNum));
        }
    }

    public void refleshRightList(boolean selectLeftMemb) {
        TreeView treeView = this.getLeftTreeControl();
        String leftNodeId = treeView.getTreeState().getFocusNodeId();
        boolean isAll = (Boolean)this.getModel().getValue("getall");
        String searchKey = this.getPageCache().get("searchField");
        TreeNode root = this.getLeftTreeCache();
        if (root == null) {
            return;
        }
        TreeNode node = root.getTreeNode(leftNodeId, 20);
        ArrayList<TreeNode> listMemb = new ArrayList<TreeNode>(16);
        if (node != null) {
            if (!isAll) {
                node.iterate(1, child -> {
                    if (!"0".equals(child.getId())) {
                        listMemb.add((TreeNode)child);
                    }
                });
            } else {
                node.iterate(20, child -> {
                    if (!"0".equals(child.getId())) {
                        listMemb.add((TreeNode)child);
                    }
                });
            }
        }
        if (searchKey != null && searchKey.trim().length() > 0) {
            String searchFile = searchKey.trim();
            listMemb.removeIf(child -> !child.getText().contains(searchFile));
        }
        int pageSize = Integer.parseInt((String)this.getModel().getValue("page_size_select"));
        int allMembCount = listMemb.size();
        int maxSize = allMembCount / pageSize + 1;
        if (allMembCount % pageSize == 0) {
            --maxSize;
        }
        this.initPagePanel(allMembCount, maxSize);
        IDataModel iDataModel = this.getModel();
        iDataModel.deleteEntryData(this.entryKey);
        if (allMembCount > 0) {
            iDataModel.batchCreateNewEntryRow(this.entryKey, pageSize < allMembCount ? pageSize : allMembCount);
            DynamicObject row = null;
            TreeNode memb = null;
            List<Long> selectMembIds = null;
            if (!this.isMulti && selectLeftMemb) {
                selectMembIds = new ArrayList<Long>();
                selectMembIds.add(Long.parseLong(leftNodeId));
            } else {
                selectMembIds = this.getSelectedMembIds();
            }
            ArrayList<Integer> rowNums = new ArrayList<Integer>();
            String idFile = this.entryKey + "_id";
            String nameFile = this.entryKey + "_name";
            String numberFile = this.entryKey + "_number";
            String storageFile = this.entryKey + "_storagetype";
            for (int rowIndex = 0; rowIndex < pageSize && rowIndex < allMembCount; ++rowIndex) {
                row = iDataModel.getEntryRowEntity(this.entryKey, rowIndex);
                memb = (TreeNode)listMemb.get(rowIndex);
                if (selectMembIds.contains(Long.parseLong(memb.getId()))) {
                    rowNums.add(rowIndex);
                }
                Map data = (Map)memb.getData();
                row.set(idFile, (Object)memb.getId());
                row.set(nameFile, (Object)((String)data.get("name")).split("\n\n")[1]);
                row.set(numberFile, data.get("number"));
                row.set(storageFile, data.get("storagetype"));
            }
            this.getView().updateView(this.entryKey);
            if (rowNums.size() > 0) {
                int[] rowIndexs = new int[rowNums.size()];
                for (int i = 0; i < rowNums.size(); ++i) {
                    rowIndexs[i] = (Integer)rowNums.get(i);
                }
                EntryGrid entryGrid = (EntryGrid)this.getControl(this.entryKey);
                entryGrid.selectRows(rowIndexs, rowIndexs[0]);
            }
            if (!this.isMulti && selectLeftMemb) {
                if (rowNums.isEmpty()) {
                    selectMembIds.clear();
                }
                this.cacheSelectedMembIds(selectMembIds);
            }
        }
        this.getPageCache().put("searchMatch", SerializationUtils.serializeToBase64(listMemb));
        this.getPageCache().put("currentPage", "1");
        this.getPageCache().put("allCount", String.valueOf(listMemb.size()));
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.getPageCache().get("firsttime") == null) {
            List<Long> selectIds = this.getSelectedMembIds();
            this.selectRowsOnEntity(selectIds);
            this.getPageCache().put("firsttime", "true");
        }
    }

    public void initPagePanel(int allSize, int maxSize) {
        int pageSize = Integer.parseInt((String)this.getModel().getValue("page_size_select"));
        int pageNum = allSize / pageSize + 1;
        if (allSize % pageSize == 0) {
            --pageNum;
        }
        this.getPageCache().put("isinit", "true");
        this.getModel().setValue("allpage", (Object)pageNum);
        this.getModel().setValue("pageinput", (Object)1);
        this.updatePageSize(maxSize);
    }

    public void updatePageSize(int maxSize) {
        FieldAp fieldAp = new FieldAp();
        fieldAp.setKey("pageinput");
        IntegerField field = new IntegerField();
        field.setKey("pageinput");
        fieldAp.setField((Field)field);
        field.setDataScope("[1," + maxSize + "]");
        this.getView().updateControlMetadata(fieldAp.getKey(), fieldAp.createControl());
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        this.refleshRightList(true);
    }

    public String getDimensionNum() {
        ListShowParameter showParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String dimNum = (String)showParameter.getCustomParam("dimensionNum");
        return dimNum;
    }

    private Long getDimensionId() {
        if (this.getPageCache().get("dimension") != null) {
            Long dimensionId = Long.parseLong(this.getPageCache().get("dimension"));
            return dimensionId;
        }
        String dimensionNum = this.getDimensionNum();
        String membertree = kd.epm.eb.common.enums.SysDimensionEnum.getMemberTreemodelByNumber((String)dimensionNum);
        if (StringUtils.isEmpty((String)membertree)) {
            return 0L;
        }
        QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
        QFilter qFilter1 = new QFilter("number", "=", (Object)dimensionNum);
        DynamicObject dimension = QueryServiceHelper.queryOne((String)"epm_dimension", (String)"id", (QFilter[])new QFilter[]{qFilter, qFilter1});
        return dimension.getLong("id");
    }

    public Long getModelId() {
        ListShowParameter showParameter = (ListShowParameter)this.getView().getFormShowParameter();
        Object model = showParameter.getCustomParam("model");
        if (model == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u4f53\u7cfb\u5931\u8d25\u3002", (String)"EbCustomShareF7Plugin_3", (String)"epm-eb-budget", (Object[])new Object[0]));
        }
        Long modelId = model instanceof String ? Long.valueOf((String)model) : (Long)model;
        return modelId;
    }

    public TreeNode getLeftTreeCache() {
        String cacheStr = this.getPageCache().get("LeftTreeCache");
        if (cacheStr == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u5de6\u6811\u7f13\u5b58\u5931\u8d25\u3002", (String)"EbCustomShareF7Plugin_4", (String)"epm-eb-budget", (Object[])new Object[0]));
        }
        TreeNode leftTreeNode = (TreeNode)SerializationUtils.deSerializeFromBase64((String)cacheStr);
        return leftTreeNode;
    }

    public void cacheLeftTree(TreeNode leftTreeRoot) {
        this.getPageCache().put("LeftTreeCache", SerializationUtils.serializeToBase64((Object)leftTreeRoot));
    }

    public void cacheLeftNodeId(String leftTreeNodeId) {
        this.getPageCache().put("CacheLeftNodeId", leftTreeNodeId);
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        TreeNode leftRoot = this.getLeftTreeCache();
        this.getLeftTreeControl().focusNode(leftRoot);
        this.getPageCache().put("searchField", searchEnterEvent.getText());
        this.refleshRightList(false);
    }

    public void RemoveClick(F7SelectedListRemoveEvent f7SelectedListRemoveEvent) {
        Object param = f7SelectedListRemoveEvent.getParam();
        this.removeSelectRow(param);
    }

    public void removeSelectRow(Object membId) {
        List<Long> selectMembs = this.getSelectedMembIds();
        if (membId == null) {
            selectMembs.clear();
        } else {
            Long id = membId instanceof String ? Long.valueOf((String)membId) : (Long)membId;
            selectMembs.remove(id);
        }
        this.selectRowsOnEntity(selectMembs);
        this.cacheSelectedMembIds(selectMembs);
    }

    public void selectRowsOnEntity(List<Long> selectMembs) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(this.entryKey);
        DynamicObjectCollection rows = this.getModel().getEntryEntity(this.entryKey);
        if (selectMembs.size() > 0) {
            ArrayList<Integer> rowNums = new ArrayList<Integer>();
            for (DynamicObject row : rows) {
                if (!selectMembs.contains(row.getLong(this.entryKey + "_id"))) continue;
                rowNums.add(row.getInt("seq") - 1);
            }
            if (rowNums.size() > 0) {
                int[] rowIndexs = new int[rowNums.size()];
                for (int i = 0; i < rowNums.size(); ++i) {
                    rowIndexs[i] = (Integer)rowNums.get(i);
                }
                entryGrid.selectRows(rowIndexs, rowIndexs[0]);
            }
        } else {
            entryGrid.clearEntryState();
        }
    }

    private boolean isContainShare() {
        return this.isHasShareDim(this.getDimensionNum());
    }

    private boolean isHasShareDim(String dimNumber) {
        if (StringUtil.isEmptyString((String)dimNumber)) {
            return false;
        }
        List enums = Arrays.asList(SysDimensionEnum.values()).stream().map(SysDimensionEnum::getNumber).collect(Collectors.toList());
        enums.remove(SysDimensionEnum.Account.getNumber());
        enums.remove(SysDimensionEnum.Entity.getNumber());
        return !enums.contains(dimNumber);
    }
}

