/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.budget.formplugin.sharememberf7;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.formop.Close;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.budget.formplugin.database.MultipleMemberF7BasePlugin;
import kd.epm.eb.budget.formplugin.util.DimensionUtil;
import kd.epm.eb.business.utils.EPMTreeUtils;
import kd.epm.eb.common.ebcommon.common.enums.PermEnum;
import kd.epm.eb.common.ebcommon.common.enums.RangeEnum;
import kd.epm.eb.common.ebcommon.common.enums.dimension.SysDimensionEnum;
import kd.epm.eb.common.ebcommon.common.util.ObjectSerialUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.ebBusiness.serviceHelper.MemberPermHelper;
import kd.epm.eb.ebSpread.common.util.StringUtil;

public class MultipleMemberF7TemSharePlugin
extends MultipleMemberF7BasePlugin {
    private static final String NUMBER = "number";
    private static final String SCOPE = "scope";
    private static final String RADIO = "radio";
    private static final String MEMBER_TREE_AP = "membertreeap";
    private static final String ENTRY_ENTITY1 = "entryentity1";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btntop", "btnup", "btndown", "btnbottom"});
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String sign = (String)this.getView().getFormShowParameter().getCustomParam("sign");
        this.setScope();
        this.initModelId();
        this.setVisual();
        IPageCache pageCache = (IPageCache)this.getView().getParentView().getService(IPageCache.class);
        String filtervalue = (String)this.getFormCustomParam(sign);
        if (StringUtils.isEmpty((CharSequence)filtervalue)) {
            filtervalue = pageCache.get(sign);
        } else {
            pageCache.put(sign, filtervalue);
        }
        if (StringUtils.isNotEmpty((CharSequence)filtervalue)) {
            List membColl = (List)SerializationUtils.fromJsonString((String)filtervalue, List.class);
            IDataModel model = this.getModel();
            int index = 0;
            for (Map map : membColl) {
                index = model.createNewEntryRow(this.entryentity);
                String id = (String)map.get("id");
                String sharememberid = (String)map.get("sharememberid");
                model.setValue("mid1", (Object)id, index);
                model.setValue("mnum1", map.get(NUMBER), index);
                model.setValue("mname1", map.get("name"), index);
                model.setValue("filltypevalue1", map.get(SCOPE), index);
                if (StringUtils.isNotEmpty((CharSequence)sharememberid)) {
                    model.setValue("storagetype", (Object)"3", index);
                } else {
                    Map storageMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("storagetypemap"), Map.class);
                    String storageType = (String)storageMap.get(Long.parseLong(id));
                    if (StringUtils.isNotEmpty((CharSequence)storageType)) {
                        model.setValue("storagetype", (Object)storageType, index);
                    } else {
                        model.setValue("storagetype", (Object)"2", index);
                    }
                }
                model.setValue("sharememberid", (Object)sharememberid, index);
            }
            if (membColl.size() > 0 && ((Map)membColl.get(0)).get("pid") != null && StringUtils.isNotEmpty((CharSequence)((String)((Map)membColl.get(0)).get("pid")).trim())) {
                this.getModel().setValue(RADIO, (Object)20);
                this.refrushMember();
                this.getPageCache().remove("membername");
                this.setVisual();
            }
        }
        if (sign != null && pageCache.get(sign) == null && sign.startsWith("row") && !StringUtil.isEmptyString((String)pageCache.get("parentSelectedParam"))) {
            String entity = this.FromFieldKeyToFormIdentity(sign);
            String parentSelectedParam = pageCache.get("parentSelectedParam");
            if (!StringUtil.isEmptyString((String)parentSelectedParam)) {
                Map<String, Object> temp = this.getSelected(parentSelectedParam, entity);
                DynamicObjectCollection membColl = (DynamicObjectCollection)temp.get("dimensions");
                Map scope = (Map)temp.get(SCOPE);
                IDataModel model = this.getModel();
                int index = 0;
                for (DynamicObject map : membColl) {
                    index = model.createNewEntryRow(this.entryentity);
                    Long id = map.getLong("id");
                    String sharememberid = map.getString("sharememberid");
                    model.setValue("mid1", map.get("id"), index);
                    model.setValue("mnum1", map.get(NUMBER), index);
                    model.setValue("mname1", map.get("name"), index);
                    model.setValue("filltypevalue1", scope.get(map.get("id") + ""), index);
                    if (StringUtils.isNotEmpty((CharSequence)sharememberid)) {
                        model.setValue("storagetype", (Object)"3", index);
                    } else {
                        Map storageMap = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("storagetypemap"), Map.class);
                        String storageType = (String)storageMap.get(id);
                        if (StringUtils.isNotEmpty((CharSequence)storageType)) {
                            model.setValue("storagetype", (Object)storageType, index);
                        } else {
                            model.setValue("storagetype", (Object)"2", index);
                        }
                    }
                    model.setValue("sharememberid", map.get("sharememberid"), index);
                }
            }
        }
    }

    private void setScope() {
        String showScopesStr = (String)this.getView().getFormShowParameter().getCustomParam("showScopes");
        if (showScopesStr != null) {
            int[] showScopes = (int[])ObjectSerialUtil.deSerializedBytes((String)showScopesStr);
            ArrayList<ComboItem> data = new ArrayList<ComboItem>(showScopes.length);
            for (int scope : showScopes) {
                RangeEnum range = RangeEnum.getRangeByVal((int)scope);
                data.add(new ComboItem(new LocaleString(range.getName()), range.getValue() + ""));
            }
            ComboEdit comboEdit = (ComboEdit)this.getControl("memrangdecombo");
            comboEdit.setComboItems(data);
            ComboEdit comboEdit2 = (ComboEdit)this.getControl("filltypevalue1");
            comboEdit2.setComboItems(data);
        }
    }

    private Map<String, Object> getSelected(String parentSelectedParam, String entity) {
        String[] cache_Param = parentSelectedParam.split("\uff0c");
        ArrayList<Long> ids = new ArrayList<Long>(cache_Param.length);
        HashMap<String, String> scope = new HashMap<String, String>(cache_Param.length);
        for (String id : cache_Param) {
            String[] params = id.split("_");
            scope.put(params[0], params[1]);
            ids.add(IDUtils.toLong((Object)params[0]));
        }
        DynamicObjectCollection dimensions = QueryServiceHelper.query((String)entity, (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        result.put(SCOPE, scope);
        result.put("dimensions", dimensions);
        return result;
    }

    private String FromFieldKeyToFormIdentity(String fieldKey) {
        if (fieldKey.contains("accountbefore")) {
            return "epm_accountmembertree";
        }
        if (fieldKey.contains("changetypebefore")) {
            return "epm_changetypemembertree";
        }
        if (fieldKey.contains("dim")) {
            return "epm_userdefinedmembertree";
        }
        return null;
    }

    private void setVisual() {
        this.getView().setVisible(Boolean.valueOf(true), new String[]{MEMBER_TREE_AP});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"splitcontainerap1"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelap31"});
    }

    private void initModelId() {
        IPageCache pageCache = (IPageCache)this.getView().getParentView().getService(IPageCache.class);
        String str = pageCache.get("KEY_MODEL_ID");
        if (kd.bos.util.StringUtils.isEmpty((String)str)) {
            str = (String)this.getFormCustomParam("KEY_MODEL_ID");
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)str)) {
            long l = Long.parseLong(str);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "radio": {
                this.setVisual();
            }
        }
        super.propertyChanged(e);
    }

    @Override
    public void click(EventObject evt) {
        this.setCurrentTabPage();
        String key = ((Control)evt.getSource()).getKey();
        String sign = (String)this.getView().getFormShowParameter().getCustomParam("sign");
        if (key.equals("addoneb") || key.equals("addallb")) {
            String showScope = (String)this.getView().getFormShowParameter().getCustomParam("showScope");
            if (showScope != null && "1".equals(showScope) && ("entity".equals(sign) || "oppunit".equals(sign))) {
                TreeView tree = (TreeView)this.getControl(MEMBER_TREE_AP);
                List selectedNodes = tree.getTreeState().getSelectedNodes();
                for (Map node : selectedNodes) {
                    String[] text = node.get("text").toString().split("\n\n");
                    if (!"entity".equalsIgnoreCase(text[0])) continue;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5177\u4f53\u7ec4\u7ec7\uff0c\u8bf7\u52ff\u9009\u62e9\u6839\u7ec4\u7ec7\u3002", (String)"MultipleMemberF7TemSharePlugin_0", (String)"epm-eb-budget", (Object[])new Object[0]));
                    return;
                }
            }
            this.getPageCache().put("key", key);
        } else if (key.equals("btntop")) {
            this.moveTop();
        } else if (key.equals("btnup")) {
            this.moveUp();
        } else if (key.equals("btndown")) {
            this.moveDown();
        } else if (key.equals("btnbottom")) {
            this.moveBottom();
        }
        super.click(evt);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Close) {
            ThreadCache.put((Object)"close", (Object)true);
        }
    }

    protected void moveTop() {
        DynamicObject obj;
        DynamicObjectCollection objs;
        int rowIndex;
        EntryGrid entry = (EntryGrid)this.getControl(ENTRY_ENTITY1);
        if (entry != null && (rowIndex = entry.getEntryState().getFocusRow()) > 0 && (objs = this.getModel().getEntryEntity(ENTRY_ENTITY1)) != null && (obj = objs.remove(rowIndex)) != null) {
            this.getModel().deleteEntryRow(ENTRY_ENTITY1, rowIndex);
            this.getModel().createNewEntryRow(ENTRY_ENTITY1, 0, obj);
            entry.selectRows(0);
        }
    }

    protected void moveUp() {
        DynamicObject obj;
        DynamicObjectCollection objs;
        int rowIndex;
        EntryGrid entry = (EntryGrid)this.getControl(ENTRY_ENTITY1);
        if (entry != null && (rowIndex = entry.getEntryState().getFocusRow()) > 0 && (objs = this.getModel().getEntryEntity(ENTRY_ENTITY1)) != null && (obj = objs.remove(rowIndex)) != null) {
            this.getModel().deleteEntryRow(ENTRY_ENTITY1, rowIndex);
            this.getModel().createNewEntryRow(ENTRY_ENTITY1, rowIndex - 1, obj);
            entry.selectRows(rowIndex - 1);
        }
    }

    protected void moveDown() {
        DynamicObject obj;
        DynamicObjectCollection objs;
        int rowIndex;
        EntryGrid entry = (EntryGrid)this.getControl(ENTRY_ENTITY1);
        if (entry != null && (rowIndex = entry.getEntryState().getFocusRow()) >= 0 && (objs = this.getModel().getEntryEntity(ENTRY_ENTITY1)) != null && rowIndex < objs.size() - 1 && (obj = objs.remove(rowIndex)) != null) {
            this.getModel().deleteEntryRow(ENTRY_ENTITY1, rowIndex);
            this.getModel().createNewEntryRow(ENTRY_ENTITY1, rowIndex + 1, obj);
            entry.selectRows(rowIndex + 1);
        }
    }

    protected void moveBottom() {
        DynamicObject obj;
        DynamicObjectCollection objs;
        int rowIndex;
        EntryGrid entry = (EntryGrid)this.getControl(ENTRY_ENTITY1);
        if (entry != null && (rowIndex = entry.getEntryState().getFocusRow()) >= 0 && (objs = this.getModel().getEntryEntity(ENTRY_ENTITY1)) != null && rowIndex < objs.size() - 1 && (obj = this.getModel().getEntryRowEntity(ENTRY_ENTITY1, rowIndex)) != null) {
            this.getModel().deleteEntryRow(ENTRY_ENTITY1, rowIndex);
            this.getModel().createNewEntryRow(ENTRY_ENTITY1, obj);
            entry.selectRows(objs.size() - 1);
        }
    }

    @Override
    protected void initTree(TreeView tree) {
        String headId;
        String dimensionId = this.getPageCache().get("dimension");
        DynamicObjectCollection dcs = this.getPresetMemberDoc(dimensionId);
        Map relationMap = MemberPermHelper.BuildPCRelation((DynamicObjectCollection)dcs);
        Map<Long, Integer> permMap = this.getMembPermInfo(dimensionId);
        this.getPageCache().put("permMap", SerializationUtils.toJsonString(permMap));
        List<Map<String, String>> menberList = this.getMemberList(dcs);
        this.delNoPermMember(menberList, relationMap, permMap);
        TreeNode membertree = new TreeNode();
        membertree.setId("0");
        membertree.setText(ResManager.loadKDString((String)"\u5168\u90e8\u6210\u5458", (String)"MultipleMemberF7TemSharePlugin_1", (String)"epm-eb-budget", (Object[])new Object[0]));
        String string = headId = menberList.isEmpty() ? "0" : menberList.get(0).get("parentid");
        if (this.getView().getFormShowParameter().getCustomParam("rootid") != null) {
            long rootId = (Long)this.getView().getFormShowParameter().getCustomParam("rootid");
            DynamicObject oo = QueryServiceHelper.queryOne((String)this.getPageCache().get("membermodel"), (String)"parent.id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)rootId)});
            if (oo != null) {
                headId = oo.getString("parent.id");
            }
        }
        EPMTreeUtils.setEntryNodeWithBreak((TreeNode)membertree, menberList, (String)headId);
        List filter = (List)this.getView().getFormShowParameter().getCustomParam("filter");
        if (filter != null) {
            membertree = EPMTreeUtils.filterTree((TreeNode)membertree, p -> filter.contains(p.getId()));
        }
        if (membertree == null) {
            membertree = new TreeNode();
            membertree.setId("0");
            membertree.setText(ResManager.loadKDString((String)"\u5168\u90e8\u6210\u5458", (String)"MultipleMemberF7TemSharePlugin_1", (String)"epm-eb-budget", (Object[])new Object[0]));
        }
        tree.addNode(membertree);
        if (DimensionUtil.isExpand2SecondLevel4MultiMemberF7(this.getPageCache().get("membermodel"))) {
            tree.expand(membertree.getId());
            if (membertree.getChildren() != null) {
                membertree.getChildren().forEach(c -> tree.expand(c.getId()));
            }
        } else {
            EPMTreeUtils.spreadAllNode((TreeNode)membertree);
        }
        this.getPageCache().put("memberlist", SerializationUtils.toJsonString(menberList));
        this.getPageCache().put("treeroot", SerializationUtils.toJsonString((Object)membertree));
    }

    @Override
    protected DynamicObjectCollection getPresetMemberDoc(String dimensionid) {
        DynamicObjectCollection shareMembers;
        QFilter customFilter;
        long rootId;
        DynamicObject oo;
        String entityName = this.getPageCache().get("membermodel");
        String memberFields = "id,name,number,parent,storagetype,longnumber,level,dseq,isleaf,id as memberid,'0' as sharememberid";
        String shareMemberFields = "id,id as sharememberid,name,number,parent,storagetype,longnumber,level,dseq,isleaf,memberid";
        QFilter filter1 = new QFilter("dimension", "=", (Object)Convert.toLong((Object)dimensionid));
        filter1.and(new QFilter("enable", "=", (Object)true));
        if (this.getView().getFormShowParameter().getCustomParam("rootid") != null && (oo = QueryServiceHelper.queryOne((String)entityName, (String)"longnumber", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)(rootId = ((Long)this.getView().getFormShowParameter().getCustomParam("rootid")).longValue()))})) != null) {
            String longnumber = oo.getString("longnumber");
            filter1.and(new QFilter("longnumber", "like", (Object)(longnumber + "!%")));
            filter1.or(new QFilter("id", "=", (Object)rootId));
        }
        this.filterFyAndPeriod(filter1, entityName);
        if ("epm_audittrialmembertree".equals(entityName)) {
            filter1.and(new QFilter(NUMBER, "not in", Arrays.asList("ADJE", "CWP", "ManualJournal", "AutoJournal")));
        }
        if ((customFilter = this.getCustomFilter()) != null) {
            filter1.and(customFilter);
        }
        QFilter[] filters = new QFilter[]{filter1};
        String orderBys = this.getPresetMemberOrder();
        String tag = ResManager.loadKDString((String)"\n\n\uff08\u5171\u4eab\uff09", (String)"MultipleMemberF7TemSharePlugin_2", (String)"epm-eb-budget", (Object[])new Object[0]);
        if ("epm_entitymembertree".equals(entityName)) {
            DynamicObjectCollection shareMembers2;
            memberFields = memberFields + ",isoffsetentry";
            DynamicObjectCollection query = QueryServiceHelper.query((String)entityName, (String)memberFields, (QFilter[])filters, (String)orderBys);
            query.removeIf(dy -> dy.getBoolean("isoffsetentry"));
            if (this.isContainShare() && (shareMembers2 = QueryServiceHelper.query((String)"eb_dimsharemember", (String)shareMemberFields, (QFilter[])new QFilter[]{filter1}, (String)orderBys)) != null && shareMembers2.size() > 0) {
                shareMembers2.forEach(e -> e.set("name", (Object)(e.getString("name") + tag)));
                query.addAll((Collection)shareMembers2);
            }
            this.cacheStoragetypeMap(query);
            return query;
        }
        DynamicObjectCollection members = QueryServiceHelper.query((String)entityName, (String)memberFields, (QFilter[])filters, (String)orderBys);
        this.cacheStoragetypeMap(members);
        if (this.isContainShare() && (shareMembers = QueryServiceHelper.query((String)"eb_dimsharemember", (String)shareMemberFields, (QFilter[])new QFilter[]{filter1}, (String)orderBys)) != null && shareMembers.size() > 0) {
            shareMembers.forEach(e -> e.set("name", (Object)(e.getString("name") + tag)));
            members.addAll((Collection)shareMembers);
        }
        return members;
    }

    private void cacheStoragetypeMap(DynamicObjectCollection members) {
        HashMap<Long, String> map = new HashMap<Long, String>(16);
        for (DynamicObject member : members) {
            map.put(member.getLong("id"), member.getString("storagetype"));
        }
        this.getPageCache().put("storagetypemap", SerializationUtils.toJsonString(map));
    }

    @Override
    protected void move2right(List<Map<String, String>> oldmemberlist, String radioval, DynamicObjectCollection hasSelectdoc, IDataModel model, String filltypenum) {
        ArrayList<Map<String, String>> newmemberlist = new ArrayList<Map<String, String>>();
        boolean isExist = false;
        for (Map<String, String> member : oldmemberlist) {
            DynamicObject dt;
            isExist = false;
            Iterator iterator = hasSelectdoc.iterator();
            while (iterator.hasNext() && !(isExist = this.checkExist(member, dt = (DynamicObject)iterator.next()))) {
            }
            if (isExist) continue;
            newmemberlist.add(member);
        }
        if (newmemberlist.size() < 1) {
            return;
        }
        Map permMap = new HashMap();
        String permMapCache = this.getPageCache().get("permMap");
        if (permMapCache != null) {
            permMap = (Map)SerializationUtils.fromJsonString((String)permMapCache, Map.class);
        }
        int index = 0;
        int size = 0;
        int[] rows = model.batchCreateNewEntryRow(this.entryentity, newmemberlist.size());
        for (Map map : newmemberlist) {
            String memId = (String)map.get("id");
            if (permMap.get(memId) != null && ((Integer)permMap.get(memId)).intValue() == PermEnum.NOPERM.getValue() && !Boolean.parseBoolean(this.getPageCache().get("rootuser"))) {
                ++size;
                continue;
            }
            model.setValue("mid1", map.get("memberid"), rows[index]);
            model.setValue("mnum1", map.get(NUMBER), rows[index]);
            model.setValue("mname1", (Object)((String)map.get("name")).split("\n\n")[1], rows[index]);
            model.setValue("storagetype", map.get("storagetype"), rows[index]);
            model.setValue("sharememberid", map.get("sharememberid"), rows[index]);
            model.setValue("filltypevalue1", (Object)filltypenum, rows[index]);
            ++index;
        }
        for (int i = 1; i <= size; ++i) {
            model.deleteEntryRow(this.entryentity, rows[rows.length - i]);
        }
    }

    public List<Map<String, String>> getMemberList(DynamicObjectCollection dcs) {
        ArrayList<Map<String, String>> menberList = new ArrayList<Map<String, String>>();
        if (dcs != null && dcs.size() > 0) {
            for (DynamicObject task : dcs) {
                HashMap<String, String> memberMap = new HashMap<String, String>();
                memberMap.put("id", task.get("id").toString());
                memberMap.put(NUMBER, task.getString(NUMBER));
                memberMap.put("name", task.getString(NUMBER) + "\n\n" + task.getString("name"));
                memberMap.put("parentid", task.get("parent").toString());
                memberMap.put("storagetype", task.getString("storagetype"));
                memberMap.put("isleaf", task.getString("isleaf"));
                memberMap.put("level", task.getString("level"));
                memberMap.put("dseq", task.getString("dseq"));
                memberMap.put("memberid", task.getString("memberid"));
                memberMap.put("sharememberid", task.getString("sharememberid"));
                menberList.add(memberMap);
            }
        }
        return menberList;
    }

    @Override
    protected boolean checkExist(Map<String, String> member, DynamicObject dt) {
        return member.get("memberid").equals(dt.getString(this.mid));
    }

    private boolean isContainShare() {
        String dimNumber = this.getPageCache().get("mnumber");
        return this.isHasShareDim(dimNumber);
    }

    private boolean isHasShareDim(String dimNumber) {
        if (StringUtil.isEmptyString((String)dimNumber)) {
            return false;
        }
        List enums = Arrays.asList(SysDimensionEnum.values()).stream().map(SysDimensionEnum::getNumber).collect(Collectors.toList());
        enums.remove(SysDimensionEnum.Account.getNumber());
        enums.remove(SysDimensionEnum.Entity.getNumber());
        return !enums.contains(dimNumber);
    }
}

