/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.budget.formplugin.sharememberf7;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.budget.formplugin.util.FormUtils;
import kd.epm.eb.budget.formplugin.util.TreeEntryEntityUtil;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.ebcommon.common.MessageConstant;
import kd.epm.eb.common.ebcommon.common.enums.PermEnum;
import kd.epm.eb.common.ebcommon.common.enums.dimension.SysDimensionEnum;
import kd.epm.eb.common.ebcommon.common.util.ObjectSerialUtil;
import kd.epm.eb.common.utils.BusinessModelServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.ebBusiness.ebMembPerm.IgnorePermPageUtil;
import kd.epm.eb.ebBusiness.exchangeRate.ExchageRateServiceHelper;
import kd.epm.eb.ebBusiness.serviceHelper.MemberPermHelper;
import kd.epm.eb.ebSpread.common.util.StringUtil;

public class SingleShareMemberF7Plugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final String dimension = "dimensioncombo";
    protected static final String treeentryentity = "treeentryentity";
    private static final String ROWLIST = "rowlist";
    private static final String FOCUS = "focus";

    public void initialize() {
        this.addClickListeners(new String[]{"btnok", "imageup", "imagedown"});
        TreeEntryGrid treeentry = (TreeEntryGrid)this.getControl(treeentryentity);
        treeentry.addRowClickListener((RowClickEventListener)this);
        Search se = (Search)this.getControl("searchap");
        se.addEnterListener(new SearchEnterListener(){

            public void search(SearchEnterEvent var1) {
                if (var1.getText() != null && !"".equals(var1.getText())) {
                    SingleShareMemberF7Plugin.this.searchMember(var1.getText().toLowerCase().trim());
                } else {
                    SingleShareMemberF7Plugin.this.getPageCache().put(SingleShareMemberF7Plugin.ROWLIST, null);
                    SingleShareMemberF7Plugin.this.getView().showTipNotification(MessageConstant.getMEMBER_NOINPUT());
                }
            }
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        BaseDataProperties properties = this.prepareProperties(true);
        if (!properties.ready) {
            return;
        }
        this.handleControlState(properties);
        QueryParam queryParam = this.prepareBuildTree(properties);
        this.setCustomerFilter(queryParam);
        this.buildDimEntryTree(queryParam, properties);
        this.finish(properties);
    }

    private boolean isContainShare() {
        String dimNumber = this.getPageCache().get("dimNumber");
        return this.isHasShareDim(dimNumber);
    }

    private boolean isHasShareDim(String dimNumber) {
        if (StringUtil.isEmptyString((String)dimNumber)) {
            return false;
        }
        List enums = Arrays.asList(SysDimensionEnum.values()).stream().map(SysDimensionEnum::getNumber).collect(Collectors.toList());
        enums.remove(SysDimensionEnum.Account.getNumber());
        enums.remove(SysDimensionEnum.Entity.getNumber());
        return !enums.contains(dimNumber);
    }

    private void setCustomerFilter(QueryParam queryParam) {
        String str = (String)this.getView().getFormShowParameter().getCustomParam("customFilter");
        if (str != null) {
            QFilter qFilter = QFilter.fromSerializedString((String)str);
            queryParam.filters = queryParam.filters.and(qFilter);
        }
    }

    private void handleControlState(BaseDataProperties properties) {
        if (!properties.init) {
            return;
        }
        String modelId = properties.modelId;
        this.setDimensionCombo(Long.valueOf(modelId));
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String showDimCombo = (String)showParameter.getCustomParam("showDimCombo");
        if (showDimCombo != null) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{dimension});
        }
    }

    private BaseDataProperties prepareProperties(boolean init) {
        DynamicObject defaultBusModel;
        long _modelId;
        DynamicObject model;
        BaseDataProperties properties = new BaseDataProperties(init);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String entity = (String)showParameter.getCustomParam("entity");
        if (entity == null) {
            properties.ready = false;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u6307\u5b9a\u7ef4\u5ea6\u5b9e\u4f53", (String)"SingleShareMemberF7Plugin_0", (String)"epm-eb-budget", (Object[])new Object[0]));
            return properties;
        }
        properties.entity = entity;
        String modelId = showParameter.getCustomParam("modelId").toString();
        properties.modelId = modelId;
        properties.dimId = (Long)showParameter.getCustomParam("dimId");
        Long dimensionId = (Long)showParameter.getCustomParam("dimId");
        DynamicObject dimension = QueryServiceHelper.queryOne((String)"epm_dimension", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)dimensionId)});
        if (dimension == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u4e0d\u5b58\u5728", (String)"SingleShareMemberF7Plugin_1", (String)"epm-eb-budget", (Object[])new Object[0]));
        }
        if (properties.modelId != null && !Model.of((DynamicObject)(model = BusinessDataServiceHelper.loadSingleFromCache((Object)(_modelId = IDUtils.toLong((Object)properties.modelId).longValue()), (String)"epm_model"))).isModelByEB() && (defaultBusModel = BusinessModelServiceHelper.getInstance().getDefaultBusModel(Long.valueOf(_modelId), null)) != null) {
            properties.busModelId = defaultBusModel.getLong("id");
            Map viewIds = BusinessModelServiceHelper.getViewIds((Long)properties.busModelId);
            properties.viewId = viewIds != null ? (Long)viewIds.get(dimension.getString("number")) : null;
        }
        this.getPageCache().put("dimNumber", dimension.getString("number"));
        return properties;
    }

    private QueryParam prepareBuildTree(BaseDataProperties properties) {
        String entity;
        QueryParam queryParam = new QueryParam();
        Long dimId = properties.dimId;
        QFilter dimFilter = new QFilter("model", "=", (Object)this.getModelId());
        if (dimId != null) {
            dimFilter.and("dimension", "=", (Object)dimId);
        }
        if ("epm_accountmembertree".equals(entity = properties.entity)) {
            dimFilter.and("accounttype", "!=", (Object)"8");
        }
        ExchageRateServiceHelper.delExchangeRatePlanFilter((QFilter)dimFilter, (String)entity);
        if ("epm_audittrialmembertree".equals(entity)) {
            dimFilter.and("number", "not in", Arrays.asList("ADJE", "CWP", "ManualJournal", "AutoJournal"));
        }
        boolean isDisplayAllFyOrPeriodMemb = false;
        if (this.getView().getFormShowParameter().getCustomParam("isDisplayAllFyOrPeriodMemb") != null) {
            isDisplayAllFyOrPeriodMemb = (Boolean)this.getView().getFormShowParameter().getCustomParam("isDisplayAllFyOrPeriodMemb");
        }
        if (!isDisplayAllFyOrPeriodMemb) {
            if ("epm_yearmembertree".equals(entity)) {
                dimFilter.and("number", "!=", (Object)"LastYear").and("number", "!=", (Object)"CurrentYear");
            } else if ("epm_periodmembertree".equals(entity)) {
                dimFilter.and("number", "!=", (Object)"LastPeriod").and("number", "!=", (Object)"CurrentPeriod");
            }
        }
        if ("epm_currencymembertree".equals(entity)) {
            dimFilter.and("number", "!=", (Object)"PC");
        }
        String selectFields = "id,number,name,parent,level,isleaf,dimension,dseq,longnumber,storagetype";
        if (isDisplayAllFyOrPeriodMemb) {
            selectFields = "id,number,name,parent,level,isleaf,dseq,storagetype";
        }
        if ("epm_entitymembertree".equals(entity)) {
            selectFields = selectFields + ",isoffsetentry";
        }
        queryParam.selectFields = selectFields;
        queryParam.filters = dimFilter;
        return queryParam;
    }

    private void buildDimEntryTree(QueryParam queryParam, BaseDataProperties properties) {
        DynamicObjectCollection memberColls = this.queryDimDoc(queryParam, properties);
        this.fillEntryData(memberColls, properties);
    }

    private DynamicObjectCollection queryDimDoc(QueryParam queryParam, BaseDataProperties properties) {
        String entity = properties.entity;
        String selectFields = queryParam.selectFields + ",id as memberid,'0' as sharememberid";
        DynamicObjectCollection memberColls = QueryServiceHelper.query((String)((Object)((Object)this)).getClass().getName(), (String)entity, (String)selectFields, (QFilter[])queryParam.filters.toArray(), (String)"level desc");
        if (this.isContainShare()) {
            Long dimId = properties.dimId;
            QFilter dimFilter = new QFilter("model", "=", (Object)this.getModelId());
            if (dimId != null) {
                dimFilter.and("dimension", "=", (Object)dimId);
            }
            String shareSelectFields = "id,number,name,parent,level,isleaf,dimension,dseq,longnumber,storagetype,memberid,id as sharememberid";
            DynamicObjectCollection shareMembers = QueryServiceHelper.query((String)((Object)((Object)this)).getClass().getName(), (String)"eb_dimsharemember", (String)shareSelectFields, (QFilter[])new QFilter[]{dimFilter}, (String)"level desc");
            memberColls.addAll((Collection)shareMembers);
        }
        return memberColls;
    }

    private void fillEntryData(DynamicObjectCollection memberColls, BaseDataProperties properties) {
        this.addEntryData(memberColls, properties);
        this.handleEntryState(properties);
    }

    private void addEntryData(DynamicObjectCollection memberColls, BaseDataProperties properties) {
        if (memberColls != null && memberColls.size() > 0) {
            this.getModel().deleteEntryData(treeentryentity);
            String modelId = properties.modelId;
            Long dimId = properties.dimId;
            boolean noRoot = false;
            ArrayList propertyList = Lists.newArrayList((Object[])new String[]{"number", "name", "memberid", "isleaf", "storagetype", "storagetypeid", "sharememberid"});
            ArrayList dynamicObjecPpropertyList = Lists.newArrayList((Object[])new String[]{"number", "name", "memberid", "isleaf", "storagetype", "storagetype", "sharememberid"});
            boolean modelManage = MemberPermHelper.getLimitedModelListByUser().contains(Long.valueOf(modelId));
            this.getPageCache().put("isroot", String.valueOf(modelManage));
            if (this.isUnCheckPerm()) {
                TreeEntryEntityUtil.fillTreeEntryEntityUserSeq(this.getModel(), memberColls, (List<String>)propertyList, dynamicObjecPpropertyList, noRoot);
            } else if (modelManage) {
                TreeEntryEntityUtil.fillTreeEntryEntityUserSeq(this.getModel(), memberColls, (List<String>)propertyList, dynamicObjecPpropertyList, noRoot);
            } else {
                this.dealEbEntity(memberColls, properties, propertyList, dynamicObjecPpropertyList);
            }
            this.getView().updateView(treeentryentity);
        }
    }

    private boolean isUnCheckPerm() {
        String unCheckPerm = (String)this.getView().getFormShowParameter().getCustomParam("unCheckPerm");
        return StringUtils.isEmpty((String)unCheckPerm);
    }

    private void handleEntryState(BaseDataProperties properties) {
        int count;
        String entity = properties.entity;
        TreeEntryGrid treeEntryGrid = (TreeEntryGrid)this.getView().getControl(treeentryentity);
        treeEntryGrid.setCollapse(false);
        if ((entity.equals("epm_entitymembertree") || entity.equals("epm_accountmembertree") || entity.equals("epm_changetypemembertree")) && (count = this.getModel().getEntryRowCount(treeentryentity)) > 1) {
            int[] col = this.getModel().getEntryNextRows(treeentryentity, 1, true);
            IClientViewProxy po = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            po.invokeControlMethod(treeentryentity, "collapseAllNode", new Object[]{col});
        }
    }

    private void finish(BaseDataProperties properties) {
        if (!properties.init) {
            return;
        }
        Object obj = this.getView().getFormShowParameter().getCustomParam("isFromExcel");
        if (obj != null) {
            this.getPageCache().put("isFromExcel", obj.toString());
        }
    }

    private void dealEbEntity(DynamicObjectCollection objs, BaseDataProperties properties, List<String> propertyList, List<String> dynamicPropertyList) {
        Long modelId = this.getModelId();
        DynamicObject dim = QueryServiceHelper.queryOne((String)"epm_dimension", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)properties.dimId)});
        String dimNum = dim.getString("number");
        Set noPermMembIds = null;
        if (!IgnorePermPageUtil.checkIgnore((String)this.getView().getFormShowParameter().getParentFormId())) {
            noPermMembIds = DimMembPermHelper.getReadPermMembIds((String)dimNum, (Long)modelId, (Long)properties.busModelId, (Long)properties.viewId, (boolean)false);
        }
        Long rootId = null;
        if (noPermMembIds != null) {
            Iterator iterator = objs.iterator();
            while (iterator.hasNext()) {
                DynamicObject memb = (DynamicObject)iterator.next();
                if (!noPermMembIds.contains(memb.getLong("memberid"))) continue;
                if (memb.getString("number").equals(dimNum)) {
                    rootId = memb.getLong("id");
                    continue;
                }
                iterator.remove();
            }
        }
        HashMap<Long, Integer> permMap = new HashMap<Long, Integer>();
        if (rootId != null) {
            permMap.put(rootId, PermEnum.NOPERM.getValue());
        }
        this.getPageCache().put("permission", ObjectSerialUtil.toByteSerialized(permMap));
        TreeEntryEntityUtil.fillTreeEntryEntityUserSeq(this.getModel(), objs, propertyList, dynamicPropertyList, false);
    }

    private void setDimensionCombo(Long modelId) {
        ComboEdit dimensioncombo = (ComboEdit)this.getView().getControl(dimension);
        List<String[]> dimensionlist = this.getDimensionComData(modelId);
        FormUtils.customDynamicEnum(dimensionlist, dimensioncombo);
        int f7Value = (Integer)this.getView().getFormShowParameter().getCustomParam("f7Value");
        this.getModel().setValue(dimension, (Object)f7Value);
    }

    private List<String[]> getDimensionComData(Long modelId) {
        String algoKey = ((Object)((Object)this)).getClass().getName();
        String selectFields = "name,dseq,membermodel,membertable";
        QFilter fmodelid = new QFilter("model", "=", (Object)modelId);
        QFilter[] filters = new QFilter[]{fmodelid};
        DynamicObjectCollection colls = QueryServiceHelper.query((String)algoKey, (String)"epm_dimension", (String)selectFields, (QFilter[])filters, (String)"dseq");
        ArrayList<String[]> listDimension = new ArrayList<String[]>();
        if (colls != null && colls.size() > 0) {
            for (DynamicObject task : colls) {
                String[] dimensionMap = new String[]{task.getString("name"), task.getString("dseq"), task.getString("membermodel"), task.getString("membertable")};
                listDimension.add(dimensionMap);
            }
        }
        return listDimension;
    }

    protected void exitAndReturn(IDataModel iDataModel) {
        int row = iDataModel.getEntryCurrentRowIndex(treeentryentity);
        DynamicObject selectedRow = iDataModel.getEntryRowEntity(treeentryentity, row);
        if (selectedRow == null) {
            this.getView().close();
            return;
        }
        this.getView().setReturnData((Object)selectedRow);
        if (this.isFromExcel()) {
            this.getView().setReturnData((Object)selectedRow);
            if (this.isFromExcel()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", String.valueOf(selectedRow.get("id")));
                map.put("memberid", String.valueOf(selectedRow.get("memberid")));
                map.put("pid", String.valueOf(selectedRow.get("pid")));
                map.put("name", String.valueOf(selectedRow.get("name")));
                map.put("number", String.valueOf(selectedRow.get("number")));
                this.getView().setClientReturnData(map);
            }
            this.getView().setClientReturnData((Object)selectedRow);
        }
        this.getView().returnDataToParent((Object)selectedRow);
        this.getView().close();
    }

    private boolean isFromExcel() {
        String isFromExcel = this.getPageCache().get("isFromExcel");
        return isFromExcel != null;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control Control2 = (Control)evt.getSource();
        String key = Control2.getKey();
        if (key.equals("btnok")) {
            this.exitAndReturn(this.getModel());
        }
        if ("imageup".equals(key) || "imagedown".equals(key)) {
            String serial = this.getPageCache().get(ROWLIST);
            if (StringUtils.isEmpty((String)serial)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u641c\u7d22\u9700\u8981\u7684\u5185\u5bb9\u3002", (String)"SingleShareMemberF7Plugin_2", (String)"epm-eb-budget", (Object[])new Object[0]));
                return;
            }
            List list = (List)ObjectSerialUtil.deSerializedBytes((String)serial);
            if (list == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u641c\u7d22\u9700\u8981\u7684\u5185\u5bb9\u3002", (String)"SingleShareMemberF7Plugin_2", (String)"epm-eb-budget", (Object[])new Object[0]));
                return;
            }
            serial = this.getPageCache().get(FOCUS);
            int focusrow = (Integer)ObjectSerialUtil.deSerializedBytes((String)serial);
            if ("imageup".equals(key)) {
                if ((focusrow = ((Integer)list.get(list.indexOf(focusrow) - 1)).intValue()) == -1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u7b2c\u4e00\u6761\u5185\u5bb9\u3002", (String)"SingleShareMemberF7Plugin_3", (String)"epm-eb-budget", (Object[])new Object[0]));
                    return;
                }
            } else if ("imagedown".equals(key) && (focusrow = ((Integer)list.get(list.indexOf(focusrow) + 1)).intValue()) == -1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u6700\u540e\u4e00\u6761\u5185\u5bb9\u3002", (String)"SingleShareMemberF7Plugin_4", (String)"epm-eb-budget", (Object[])new Object[0]));
                return;
            }
            this.getPageCache().put(FOCUS, ObjectSerialUtil.toByteSerialized((Object)focusrow));
            int[] eids = TreeEntryEntityUtil.focus(this.getModel(), focusrow);
            TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(treeentryentity);
            treeEntry.expandOne(eids);
            treeEntry.selectRows(focusrow);
        }
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
        super.entryRowDoubleClick(evt);
        this.exitAndReturn(this.getModel());
    }

    private void searchMember(String text) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(-1);
        DynamicObjectCollection obj = this.getModel().getEntryEntity(treeentryentity);
        int i = 0;
        for (DynamicObject o : obj) {
            if ((o.getString("name") + o.getString("number")).toLowerCase().contains(text.toLowerCase())) {
                list.add(i);
            }
            ++i;
        }
        list.add(-1);
        TreeEntryGrid treeEntry = (TreeEntryGrid)this.getControl(treeentryentity);
        if (list.size() <= 2) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u76f8\u5173\u6570\u636e\u3002", (String)"SingleShareMemberF7Plugin_5", (String)"epm-eb-budget", (Object[])new Object[0]));
            return;
        }
        this.getPageCache().put(ROWLIST, ObjectSerialUtil.toByteSerialized(list));
        int focusrow = (Integer)list.get(1);
        this.getPageCache().put(FOCUS, ObjectSerialUtil.toByteSerialized((Object)focusrow));
        int[] eids = TreeEntryEntityUtil.focus(this.getModel(), focusrow);
        treeEntry.collapse(0);
        treeEntry.expandOne(eids);
        treeEntry.selectRows(focusrow);
    }

    private long getModelId() {
        String modelId = this.getView().getFormShowParameter().getCustomParam("modelId").toString();
        if (StringUtils.isEmpty((String)modelId)) {
            return 0L;
        }
        return Long.parseLong(modelId);
    }

    private static class BaseDataProperties {
        private String modelId;
        private Long dimId;
        private Long busModelId = 0L;
        private Long viewId = null;
        private String entity;
        private boolean ready = true;
        private boolean init = false;

        public BaseDataProperties(boolean init) {
            this.init = init;
        }
    }

    private static class QueryParam {
        private String selectFields;
        private QFilter filters;

        private QueryParam() {
        }
    }
}

