/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.budget.formplugin.spread;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.spread.SpreadPostDataInfo;
import kd.bos.form.spread.event.ISpreadAction;
import kd.bos.util.StringUtils;
import kd.epm.eb.budget.formplugin.AbstractBaseFormPlugin;
import kd.epm.eb.budget.formplugin.spread.SpreadClientInvoker;
import kd.epm.eb.budget.formplugin.template.model.AskExcuteInfo;
import kd.epm.eb.budget.formplugin.template.model.SpreadDataModel;
import kd.epm.eb.ebSpread.domain.view.SpreadSelector;
import kd.epm.eb.ebSpread.domain.view.event.EventConstant;
import kd.epm.eb.ebSpread.domain.view.event.IAfterEventHandle;
import kd.epm.eb.ebSpread.domain.view.event.IRegisterEvent;
import kd.epm.eb.ebSpread.domain.view.event.ISpreadListener;
import kd.epm.eb.ebSpread.domain.view.event.NotifyEvent;
import kd.epm.eb.ebSpread.domain.view.event.NotifyListener;
import kd.epm.eb.ebSpread.domain.view.event.SpreadEventChain;

public class SpreadBasePlugin
extends AbstractBaseFormPlugin
implements IRegisterEvent,
ISpreadListener,
IAfterEventHandle {
    private SpreadSelector selector;
    private SpreadEventChain eventChain = new SpreadEventChain();
    protected List<Map<String, Object>> commands;

    @Override
    public void initialize() {
        super.initialize();
        this.getView().addService(ISpreadAction.class, (Object)this.getSpreadDataModelService());
        this.initDefaultSpreadListener();
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        SpreadClientInvoker.invokeLockSwitchViewAndUploadFile(this.getClientViewProxy(), this.getSpreadKey());
    }

    protected ISpreadAction getSpreadDataModelService() {
        return new SpreadDataModel(this);
    }

    public void registerBeforeEvent(EventConstant.ActionName name, NotifyListener ls) {
        this.eventChain.registerBeforeEvent(name, ls);
    }

    public NotifyListener unregisterBeforeEvent(EventConstant.ActionName name) {
        return this.eventChain.unregisterBeforeEvent(name);
    }

    public void registerAfterEvent(EventConstant.ActionName name, NotifyListener ls) {
        this.eventChain.registerAfterEvent(name, ls);
    }

    public NotifyListener unregisterAfterEvent(EventConstant.ActionName name) {
        return this.eventChain.unregisterAfterEvent(name);
    }

    public void doBeforeNotify(NotifyEvent event) {
        if (this.eventChain.containsBeforeActionName(event.getActionName()) && !event.isCancel()) {
            this.eventChain.getListener(true, event.getActionName()).doNotify(event);
        }
    }

    public void doAfterNotify(NotifyEvent event) {
        if (this.eventChain.containsAfterActionName(event.getActionName()) && !event.isCancel()) {
            this.eventChain.getListener(false, event.getActionName()).doNotify(event);
        }
    }

    public SpreadSelector getSpreadSelector() {
        if (this.selector != null) {
            return this.selector;
        }
        String selectorSerial = this.getPageCache().get("spread_selector");
        if (!StringUtils.isNotEmpty((String)selectorSerial)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u5355\u5143\u683c\u3002", (String)"SpreadBasePlugin_0", (String)"epm-eb-budget", (Object[])new Object[0]));
        }
        this.selector = (SpreadSelector)this.deSerializedBytes(selectorSerial);
        return this.selector;
    }

    public void setSelector(SpreadSelector selector) {
        this.selector = selector;
    }

    protected int getSelectorStartRow() {
        return this.getSpreadSelector().getStartRow();
    }

    protected int getSelectorStartCol() {
        return this.getSpreadSelector().getStartCol();
    }

    protected String getSelectorRect() {
        return this.getSpreadSelector().getRect();
    }

    protected List<Integer> getSelectRows() {
        String selectorSerial = this.getPageCache().get("spread_selectrows");
        List list = null;
        if (!StringUtils.isNotEmpty((String)selectorSerial)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u884c\u3002", (String)"SpreadBasePlugin_1", (String)"epm-eb-budget", (Object[])new Object[0]));
        }
        list = (List)this.deSerializedBytes(selectorSerial);
        if (list.size() > 1) {
            for (int i = 0; i < list.size() - 1; ++i) {
                if ((Integer)list.get(i + 1) - (Integer)list.get(i) == 1) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u8fde\u7eed\u7684\u884c\u3002", (String)"SpreadBasePlugin_2", (String)"epm-eb-budget", (Object[])new Object[0]));
            }
        }
        return list;
    }

    public void doubleClickLockedCell(int row, int col) {
    }

    protected void mergeInvokeUpdateValueCommands(List<Map<String, Object>> item) {
        if (this.commands == null) {
            this.commands = new ArrayList<Map<String, Object>>();
        }
        this.commands.addAll(item);
    }

    protected void mergeInvokeUpdateValueCommands(Map<String, Object> item) {
        if (this.commands == null) {
            this.commands = new ArrayList<Map<String, Object>>();
        }
        this.commands.add(item);
    }

    public void afterSpreadEventHandle(EventConstant.ActionName actionName) {
        if (EventConstant.ActionName.UPDATE_VALUE == actionName && this.commands != null && this.getSpreadKey() != null) {
            SpreadClientInvoker.invokeUpdataValueMethod(this.getClientViewProxy(), this.getSpreadKey(), this.commands);
        }
    }

    public String getSpreadKey() {
        return null;
    }

    public void updateRowAndCol(AskExcuteInfo excuteinfo) {
        SpreadBasePlugin.updateRowAndCol2View(this.getClientViewProxy(), this.getSpreadKey(), excuteinfo);
    }

    public static void updateRowAndCol2View(IClientViewProxy view, String spreadKey, AskExcuteInfo excuteinfo) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("status", true);
        if (excuteinfo.getOperationdata().size() > 0) {
            if (excuteinfo.isCon()) {
                ArrayList rangeList = new ArrayList();
                HashMap<String, Integer> data = new HashMap<String, Integer>();
                data.put("index", excuteinfo.getOperationdata().get(0));
                data.put("count", excuteinfo.getOperationdata().size());
                rangeList.add(data);
                map.put("data", rangeList);
            } else {
                map.put("data", excuteinfo.getOperationdata());
            }
        } else if (!excuteinfo.getBatchOperationData().isEmpty()) {
            ArrayList rangeList = new ArrayList();
            excuteinfo.getBatchOperationData().forEach(e -> {
                HashMap<String, Integer> data = new HashMap<String, Integer>();
                data.put("index", e.getOprtPosition());
                data.put("count", e.getSize());
                rangeList.add(data);
            });
            map.put("data", rangeList);
        }
        if (map.containsKey("data")) {
            view.invokeControlMethod(spreadKey, excuteinfo.getMethod().getMethod(), new Object[]{map});
        }
    }

    private void initDefaultSpreadListener() {
        this.registerAfterEvent(EventConstant.ActionName.ADD_ROW, e -> {
            AskExcuteInfo excuteinfo = (AskExcuteInfo)e.getSource();
            this.updateRowAndCol(excuteinfo);
        });
        this.registerAfterEvent(EventConstant.ActionName.ADD_COL, e -> {
            AskExcuteInfo excuteinfo = (AskExcuteInfo)e.getSource();
            this.updateRowAndCol(excuteinfo);
        });
        this.registerAfterEvent(EventConstant.ActionName.REMOVE_COL, e -> {
            AskExcuteInfo excuteinfo = (AskExcuteInfo)e.getSource();
            this.updateRowAndCol(excuteinfo);
        });
        this.registerAfterEvent(EventConstant.ActionName.REMOVE_ROW, e -> {
            AskExcuteInfo excuteinfo = (AskExcuteInfo)e.getSource();
            this.updateRowAndCol(excuteinfo);
        });
    }

    public void insertRow() {
        this.updateRowAndCol2View("insertRow", this.getSpreadSelector().getStartRow());
    }

    public void insertCol() {
        this.updateRowAndCol2View("insertCol", this.getSpreadSelector().getStartCol());
    }

    public void deleteRow() {
        this.updateRowAndCol2View("deleteRow", this.getSpreadSelector().getStartRow());
    }

    public void deleteCol() {
        this.updateRowAndCol2View("deleteCol", this.getSpreadSelector().getStartCol());
    }

    public void updateRowAndCol2View(String method, Integer val) {
        SpreadPostDataInfo data = new SpreadPostDataInfo();
        LinkedHashMap<String, Object> invokeParams = new LinkedHashMap<String, Object>();
        ArrayList<Integer> vals = new ArrayList<Integer>();
        vals.add(val);
        invokeParams.put("method", method);
        invokeParams.put("data", vals);
        data.setInvokeParams(invokeParams);
        AskExcuteInfo askExcuteInfo = new AskExcuteInfo(data);
        SpreadBasePlugin.updateRowAndCol2View(this.getClientViewProxy(), this.getSpreadKey(), askExcuteInfo);
    }

    public void showFormulaPanel(int row, int col) {
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u516c\u5f0f\u7f16\u8f91\u3002", (String)"SpreadBasePlugin_3", (String)"epm-eb-budget", (Object[])new Object[0]));
    }
}

