/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.budget.formplugin.spread;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.form.IClientViewProxy;
import kd.epm.eb.budget.formplugin.spread.SpreadBasePlugin;
import kd.epm.eb.budget.formplugin.spread.SpreadClientInvoker;
import kd.epm.eb.budget.formplugin.template.model.AskExcuteInfo;
import kd.epm.eb.common.ebcommon.common.util.MapInitHelper;
import kd.epm.eb.common.ebcommon.common.util.RangeModel;
import kd.epm.eb.ebSpread.domain.Cell;
import kd.epm.eb.ebSpread.domain.view.SpreadManager;
import kd.epm.eb.ebSpread.domain.view.builder.dynamic.BasePointInfo;
import kd.epm.eb.ebSpread.domain.view.js.SpreadProperties;

public class SpreadEasyInvoker {
    private IClientViewProxy view;
    private String spreadKey;
    private Map<String, Object> orderlist;
    private boolean isBatch;

    public SpreadEasyInvoker(IClientViewProxy view, String spreadKey) {
        this.spreadKey = spreadKey;
        this.view = view;
        this.orderlist = new HashMap<String, Object>();
    }

    public void setBatch(boolean isBatch) {
        this.isBatch = isBatch;
    }

    public void startToInvoke() {
        Set<Map.Entry<String, Object>> set = this.orderlist.entrySet();
        for (Map.Entry<String, Object> s : set) {
            String key = s.getKey();
            if (key.contains(SpreadProperties.SetF7TypeCellMethod.SETF7TYPECELL.k())) {
                this.view.invokeControlMethod(this.spreadKey, SpreadProperties.SetF7TypeCellMethod.SETF7TYPECELL.k(), new Object[]{s.getValue()});
                continue;
            }
            if (key.contains(SpreadProperties.SetColumnsWidthMethod.SETCOLUMNSWIDTH.k())) {
                this.view.invokeControlMethod(this.spreadKey, SpreadProperties.SetColumnsWidthMethod.SETCOLUMNSWIDTH.k(), new Object[]{s.getValue()});
                continue;
            }
            this.view.invokeControlMethod(this.spreadKey, key, new Object[]{s.getValue()});
        }
    }

    public void setSpan(int r, int c, int rc, int cc) {
        HashMap features = new HashMap();
        ArrayList rangeList = new ArrayList();
        HashMap<String, Integer> rangeMap = new HashMap<String, Integer>();
        rangeMap.put(SpreadProperties.SetCellStyleMethod.R.k(), r);
        rangeMap.put(SpreadProperties.SetCellStyleMethod.C.k(), c);
        rangeMap.put(SpreadProperties.SetCellStyleMethod.RC.k(), rc);
        rangeMap.put(SpreadProperties.SetCellStyleMethod.CC.k(), cc);
        rangeList.add(rangeMap);
        features.put(SpreadProperties.SetSpanMethod.RANGE.k(), rangeList);
        if (this.isBatch) {
            HashMap oldparam = (HashMap)this.orderlist.get(SpreadProperties.SetSpanMethod.SETSPAN.k());
            if (oldparam == null) {
                oldparam = features;
            } else {
                List rm = (List)oldparam.get(SpreadProperties.SetSpanMethod.RANGE.k());
                rm.add(rangeMap);
            }
            this.orderlist.put(SpreadProperties.SetSpanMethod.SETSPAN.k(), oldparam);
        } else {
            SpreadClientInvoker.invokeSetSpanMethod(this.view, this.spreadKey, features);
        }
    }

    public void updataValue(int r, int c, Object value) {
        Map<String, Object> valMap = SpreadEasyInvoker.packedUpdateCellMap(r, c, value);
        if (this.isBatch) {
            ArrayList<Map<String, Object>> oldparam = (ArrayList<Map<String, Object>>)this.orderlist.get(SpreadProperties.UpdataValueMethod.UPDATAVALUE.k());
            if (oldparam == null) {
                oldparam = new ArrayList<Map<String, Object>>();
            }
            oldparam.add(valMap);
            this.orderlist.put(SpreadProperties.UpdataValueMethod.UPDATAVALUE.k(), oldparam);
        } else {
            ArrayList<Map<String, Object>> cellValues = new ArrayList<Map<String, Object>>();
            cellValues.add(valMap);
            SpreadClientInvoker.invokeUpdataValueMethod(this.view, this.spreadKey, cellValues);
        }
    }

    public void setFormula(int r, int c, Object value) {
        HashMap<String, Object> valMap = new HashMap<String, Object>();
        valMap.put(SpreadProperties.SetFormulaMethod.R.k(), r);
        valMap.put(SpreadProperties.SetFormulaMethod.C.k(), c);
        valMap.put(SpreadProperties.SetFormulaMethod.F.k(), value);
        if (this.isBatch) {
            ArrayList oldparam = (ArrayList)this.orderlist.get(SpreadProperties.SetFormulaMethod.SETFORMULA.k());
            if (oldparam == null) {
                oldparam = new ArrayList();
            }
            oldparam.add(valMap);
            this.orderlist.put(SpreadProperties.SetFormulaMethod.SETFORMULA.k(), oldparam);
        } else {
            ArrayList<HashMap<String, Object>> cellValues = new ArrayList<HashMap<String, Object>>();
            cellValues.add(valMap);
            SpreadClientInvoker.invokeSetFormulaMethod(this.view, this.spreadKey, cellValues);
        }
    }

    public void setF7TypeCell(int r, int c, int rc, int cc, int selectType, int dst) {
        HashMap<String, Integer> feature = new HashMap<String, Integer>();
        feature.put(SpreadProperties.SetF7TypeCellMethod.R.k(), r);
        feature.put(SpreadProperties.SetF7TypeCellMethod.C.k(), c);
        feature.put(SpreadProperties.SetF7TypeCellMethod.RC.k(), rc);
        feature.put(SpreadProperties.SetF7TypeCellMethod.CC.k(), cc);
        if (this.isBatch) {
            String key = SpreadProperties.SetF7TypeCellMethod.SETF7TYPECELL.k() + selectType + dst;
            HashMap<String, Serializable> features = (HashMap<String, Serializable>)this.orderlist.get(key);
            List<HashMap<String, Integer>> items = new ArrayList<HashMap<String, Integer>>();
            if (features != null) {
                items = (List)features.get(SpreadProperties.SetF7TypeCellMethod.RANGE.k());
            } else {
                features = new HashMap<String, Serializable>();
            }
            items.add(feature);
            features.put(SpreadProperties.SetF7TypeCellMethod.RANGE.k(), (Serializable)((Object)items));
            features.put(SpreadProperties.SetF7TypeCellMethod.SELECTTYPE.k(), Integer.valueOf(selectType));
            features.put(SpreadProperties.SetF7TypeCellMethod.DISPLAYSTYLE.k(), Integer.valueOf(dst));
            this.orderlist.put(key, features);
        } else {
            HashMap<String, Serializable> features = new HashMap<String, Serializable>();
            ArrayList<HashMap<String, Integer>> items = new ArrayList<HashMap<String, Integer>>();
            items.add(feature);
            features.put(SpreadProperties.SetF7TypeCellMethod.RANGE.k(), items);
            features.put(SpreadProperties.SetF7TypeCellMethod.SELECTTYPE.k(), Integer.valueOf(selectType));
            features.put(SpreadProperties.SetF7TypeCellMethod.DISPLAYSTYLE.k(), Integer.valueOf(dst));
            SpreadClientInvoker.invokeSetF7TypeCellMethod(this.view, this.spreadKey, features);
        }
    }

    public void lockCell(int r, int c, int rc, int cc) {
        HashMap<String, Integer> cell = new HashMap<String, Integer>();
        cell.put(SpreadProperties.LockCellMethod.R.k(), r);
        cell.put(SpreadProperties.LockCellMethod.C.k(), c);
        cell.put(SpreadProperties.LockCellMethod.RC.k(), rc);
        cell.put(SpreadProperties.LockCellMethod.CC.k(), cc);
        if (this.isBatch) {
            ArrayList cells = (ArrayList)this.orderlist.get(SpreadProperties.LockCellMethod.LOACKCELL.k());
            if (cells == null) {
                cells = new ArrayList();
            }
            cells.add(cell);
            this.orderlist.put(SpreadProperties.LockCellMethod.LOACKCELL.k(), cells);
        } else {
            ArrayList<HashMap<String, Integer>> cells = new ArrayList<HashMap<String, Integer>>();
            cells.add(cell);
            SpreadClientInvoker.invokeLockCellMethod(this.view, this.spreadKey, cells);
        }
    }

    public void unlockCell(int r, int c, int rc, int cc) {
        HashMap<String, Integer> cell = new HashMap<String, Integer>();
        cell.put(SpreadProperties.UnlockCellMethod.R.k(), r);
        cell.put(SpreadProperties.UnlockCellMethod.C.k(), c);
        cell.put(SpreadProperties.UnlockCellMethod.RC.k(), rc);
        cell.put(SpreadProperties.UnlockCellMethod.CC.k(), cc);
        if (this.isBatch) {
            ArrayList cells = (ArrayList)this.orderlist.get(SpreadProperties.UnlockCellMethod.UNLOACKCELL.k());
            if (cells == null) {
                cells = new ArrayList();
            }
            cells.add(cell);
            this.orderlist.put(SpreadProperties.UnlockCellMethod.UNLOACKCELL.k(), cells);
        } else {
            ArrayList<HashMap<String, Integer>> cells = new ArrayList<HashMap<String, Integer>>();
            cells.add(cell);
            SpreadClientInvoker.invokeUnLockCellMethod(this.view, this.spreadKey, cells);
        }
    }

    public void setColumnsWidth(int col, int num) {
        if (this.isBatch) {
            String key = SpreadProperties.SetColumnsWidthMethod.SETCOLUMNSWIDTH.k() + num;
            HashMap<String, Serializable> map = (HashMap<String, Serializable>)this.orderlist.get(key);
            List<Integer> colindex = new ArrayList<Integer>();
            if (map != null) {
                colindex = (List)map.get(SpreadProperties.SetColumnsWidthMethod.INDEX.k());
            } else {
                map = new HashMap<String, Serializable>();
            }
            colindex.add(col);
            map.put(SpreadProperties.SetColumnsWidthMethod.INDEX.k(), (Serializable)((Object)colindex));
            map.put(SpreadProperties.SetColumnsWidthMethod.NUM.k(), Integer.valueOf(num));
            this.orderlist.put(key, map);
        } else {
            HashMap<String, Object> map = new HashMap<String, Object>();
            int[] colindex = new int[]{col};
            map.put(SpreadProperties.SetColumnsWidthMethod.INDEX.k(), colindex);
            map.put(SpreadProperties.SetColumnsWidthMethod.NUM.k(), 100);
            SpreadClientInvoker.invokeSetColumsWidthMethod(this.view, this.spreadKey, map);
        }
    }

    public void setFrozenSheet(int r, int c, int tr, int tc, String flc, int si) {
        HashMap<String, Object> features = new HashMap<String, Object>();
        features.put(SpreadProperties.SetFrozenSheetMethod.R.k(), r);
        features.put(SpreadProperties.SetFrozenSheetMethod.C.k(), c);
        features.put(SpreadProperties.SetFrozenSheetMethod.TR.k(), tr);
        features.put(SpreadProperties.SetFrozenSheetMethod.TC.k(), tc);
        features.put(SpreadProperties.SetFrozenSheetMethod.FLC.k(), flc);
        features.put(SpreadProperties.SetFrozenSheetMethod.SI.k(), si);
        SpreadClientInvoker.invokeSetFrozenSheetMethod(this.view, this.spreadKey, features);
    }

    public void setStyle(int r, int c, int rc, int cc, Map<String, Object> styleMap) {
        HashMap<String, Object> features = new HashMap<String, Object>();
        ArrayList rangeList = new ArrayList();
        HashMap<String, Integer> rangeMap = new HashMap<String, Integer>();
        rangeMap.put(SpreadProperties.SetCellStyleMethod.R.k(), r);
        rangeMap.put(SpreadProperties.SetCellStyleMethod.C.k(), c);
        rangeMap.put(SpreadProperties.SetCellStyleMethod.RC.k(), rc);
        rangeMap.put(SpreadProperties.SetCellStyleMethod.CC.k(), cc);
        rangeList.add(rangeMap);
        features.put(SpreadProperties.SetCellStyleMethod.RANGE.k(), rangeList);
        features.put(SpreadProperties.SetCellStyleMethod.STYLE.k(), styleMap);
        SpreadClientInvoker.invokeSetCellStyleMethod(this.view, this.spreadKey, Lists.newArrayList((Object[])new Map[]{features}));
    }

    public static Map<String, Object> packedUpdateCellMap(int r, int c, Object value) {
        HashMap<String, Object> valMap = new HashMap<String, Object>();
        valMap.put(SpreadProperties.UpdataValueMethod.R.k(), r);
        valMap.put(SpreadProperties.UpdataValueMethod.C.k(), c);
        valMap.put(SpreadProperties.UpdataValueMethod.V.k(), value);
        return valMap;
    }

    public static Map<String, Object> packedFormulaCellMap(int r, int c, Object value) {
        HashMap<String, Object> valMap = new HashMap<String, Object>();
        valMap.put(SpreadProperties.SetFormulaMethod.R.k(), r);
        valMap.put(SpreadProperties.SetFormulaMethod.C.k(), c);
        valMap.put(SpreadProperties.SetFormulaMethod.F.k(), value);
        return valMap;
    }

    public static void setColumnVisble(IClientViewProxy view, String spreadKey, int[] colArray, boolean isVisible) {
        HashMap<String, Object> features = new HashMap<String, Object>();
        features.put(SpreadProperties.SetColumnsVisible.COLS.k(), colArray);
        features.put(SpreadProperties.SetColumnsVisible.VALUE.k(), isVisible);
        SpreadClientInvoker.invokeSetColumnsVisibleMethod(view, spreadKey, features);
    }

    public static void setRowsVisble(IClientViewProxy view, String spreadKey, int[] rowArray, boolean isVisible) {
        HashMap<String, Object> features = new HashMap<String, Object>();
        features.put(SpreadProperties.SetRowsVisible.ROWS.k(), rowArray);
        features.put(SpreadProperties.SetRowsVisible.VALUE.k(), isVisible);
        SpreadClientInvoker.invokeSetRowsVisibleMethod(view, spreadKey, features);
    }

    public void updateRowAndCol(AskExcuteInfo excuteinfo) {
        SpreadBasePlugin.updateRowAndCol2View(this.view, this.spreadKey, excuteinfo);
    }

    public void setWorksheetOptions(String optionkey, Object optionValue) {
        HashMap workSheetOptions = new HashMap();
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put(optionkey, optionValue);
        workSheetOptions.put(SpreadProperties.SetWorkSheetOptions.OPTIONS.k(), options);
        SpreadClientInvoker.invokeSetWorksheetOptions(this.view, this.spreadKey, Lists.newArrayList((Object[])new Map[]{workSheetOptions}));
    }

    public void syncSpreadJsData2SpreadModel(SpreadManager sm) {
        HashMap features = new HashMap();
        ArrayList list = new ArrayList();
        sm.getAreaManager().getPostionInfoSet().forEach(p -> {
            RangeModel model = new RangeModel(p.getAreaRange());
            int rc = model.getY_end() - model.getY_start() + 1;
            int cc = model.getX_end() - model.getX_start() + 1;
            if (p.getBasePoints().isEmpty()) {
                list.add(this.packRangeFeature(model.getY_start(), model.getX_start(), rc, cc));
            } else {
                boolean isDirectHoriz = ((BasePointInfo)p.getBasePoints().get(0)).isDirectHoriz();
                int start = isDirectHoriz ? model.getX_start() : model.getY_start();
                int end = isDirectHoriz ? model.getX_end() : model.getY_end();
                int startRow = 0;
                int startCol = 0;
                int maxCount = 0;
                for (int i = start; i <= end; ++i) {
                    Cell cell = sm.getBook().getSheet(0).getCell(isDirectHoriz ? model.getY_start() : i, isDirectHoriz ? i : model.getX_start());
                    if (cell.isMdDataDomain()) {
                        if (maxCount == 0) {
                            startRow = cell.getRow();
                            startCol = cell.getCol();
                        }
                        ++maxCount;
                        continue;
                    }
                    if (maxCount > 0) {
                        list.add(this.packRangeFeature(startRow, startCol, isDirectHoriz ? rc : maxCount, isDirectHoriz ? maxCount : cc));
                    }
                    maxCount = 0;
                }
                if (maxCount > 0) {
                    list.add(this.packRangeFeature(startRow, startCol, isDirectHoriz ? rc : maxCount, isDirectHoriz ? maxCount : cc));
                }
            }
        });
        if (list.isEmpty()) {
            return;
        }
        features.put(SpreadProperties.GetRangeValues.RANGE.k(), list);
        SpreadClientInvoker.invokeMethod(this.view, SpreadProperties.GetRangeValues.GETRANGEVALUES.k(), this.spreadKey, features);
    }

    private Map<String, Object> packRangeFeature(int r, int c, int rc, int cc) {
        HashMap<String, Object> feature = new HashMap<String, Object>();
        feature.put(SpreadProperties.GetRangeValues.R.k(), r);
        feature.put(SpreadProperties.GetRangeValues.C.k(), c);
        feature.put(SpreadProperties.GetRangeValues.RC.k(), rc);
        feature.put(SpreadProperties.GetRangeValues.CC.k(), cc);
        return feature;
    }

    public void addContextMenuItem(String itemName, String itemText, String[] workArea) {
        ArrayList<Map<String, Object>> items = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> item = new HashMap<String, Object>();
        item.put("itemName", itemName);
        item.put("itemText", itemText);
        item.put("workArea", workArea);
        items.add(item);
        this.addContextMenuItems(items);
    }

    public void addContextMenuItems(List<Map<String, Object>> itemList) {
        HashMap<String, Object> features = new HashMap<String, Object>();
        features.put(SpreadProperties.AddContextMenuItemsMethod.CALLBACK.k(), "invokeAction");
        ArrayList items = new ArrayList(itemList.size());
        for (Map<String, Object> map : itemList) {
            HashMap<String, Object> item = new HashMap<String, Object>();
            item.put(SpreadProperties.AddContextMenuItemsMethod.NAME.k(), map.get("itemName"));
            item.put(SpreadProperties.AddContextMenuItemsMethod.TEXT.k(), map.get("itemText"));
            item.put(SpreadProperties.AddContextMenuItemsMethod.WORKAREA.k(), map.get("workArea"));
            items.add(item);
        }
        features.put(SpreadProperties.AddContextMenuItemsMethod.ITEMS.k(), items);
        SpreadClientInvoker.addContextMenuItemsMethod(this.view, this.spreadKey, features);
    }

    public void setHyperLinkCellSimple(int r, int c, int rc, int cc, String callBackName) {
        HashMap<String, Object> features = new HashMap<String, Object>();
        ArrayList rangeList = new ArrayList();
        HashMap<String, Integer> rangeMap = new HashMap<String, Integer>();
        rangeMap.put(SpreadProperties.setHyperLinkCellMethod.R.k(), r);
        rangeMap.put(SpreadProperties.setHyperLinkCellMethod.C.k(), c);
        rangeMap.put(SpreadProperties.setHyperLinkCellMethod.RC.k(), rc);
        rangeMap.put(SpreadProperties.setHyperLinkCellMethod.CC.k(), cc);
        rangeList.add(rangeMap);
        features.put(SpreadProperties.setHyperLinkCellMethod.RANGE.k(), rangeList);
        features.put(SpreadProperties.setHyperLinkCellMethod.CALLBACK.k(), "invokeAction");
        features.put(SpreadProperties.setHyperLinkCellMethod.INVOKEMETHOD.k(), callBackName);
        SpreadClientInvoker.setHyperLinkCellMethod(this.view, this.spreadKey, features);
    }

    public void lockAllToolbarItems(boolean islock, SpreadProperties.ToolbarItemNamesEnum ... items) {
        int lockinfo = islock ? 1 : 0;
        ArrayList<Map> toolbarItems = new ArrayList<Map>(items.length);
        for (SpreadProperties.ToolbarItemNamesEnum itemNamesEnum : items) {
            toolbarItems.add(MapInitHelper.ofMap((Object)SpreadProperties.LockToolbarItemsMethod.NAME.k(), (Object)itemNamesEnum, (Object)SpreadProperties.LockToolbarItemsMethod.ISLOCK.k(), (Object)lockinfo));
        }
        SpreadClientInvoker.invokeLockToolbarItems(this.view, this.spreadKey, toolbarItems);
    }
}

