/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.budget.formplugin.template;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.budget.formplugin.spread.SpreadBasePlugin;
import kd.epm.eb.budget.formplugin.spread.SpreadClientInvoker;
import kd.epm.eb.budget.formplugin.spread.SpreadUtils;
import kd.epm.eb.budget.formplugin.template.model.ISpreadModelSupplier;
import kd.epm.eb.budget.formplugin.template.model.ISupportPageCacheProxy;
import kd.epm.eb.budget.formplugin.util.ObjectConvertUtils;
import kd.epm.eb.common.ebcommon.common.SystemSeparatorChar;
import kd.epm.eb.common.ebcommon.common.enums.DimEntityNumEnum;
import kd.epm.eb.common.ebcommon.common.enums.DimTypesEnum;
import kd.epm.eb.common.ebcommon.common.enums.RangeEnum;
import kd.epm.eb.common.ebcommon.common.log.BcmLogFactory;
import kd.epm.eb.common.ebcommon.common.log.WatchLogger;
import kd.epm.eb.common.ebcommon.common.proxy.ITransationHandle;
import kd.epm.eb.common.ebcommon.common.proxy.Interceptor;
import kd.epm.eb.common.ebcommon.common.util.ExcelUtils;
import kd.epm.eb.common.ebcommon.common.util.QFBuilder;
import kd.epm.eb.ebBusiness.template.model.AreaRangeEntry;
import kd.epm.eb.ebBusiness.template.model.Dimension;
import kd.epm.eb.ebBusiness.template.model.MembSettingBaseDetail;
import kd.epm.eb.ebBusiness.template.model.Member;
import kd.epm.eb.ebBusiness.template.model.TemplateModel;
import kd.epm.eb.ebBusiness.util.SerialSpliter;
import kd.epm.eb.ebSpread.domain.Cell;
import kd.epm.eb.ebSpread.domain.ColumnDimDomain;
import kd.epm.eb.ebSpread.domain.Domain;
import kd.epm.eb.ebSpread.domain.RowDimDomain;
import kd.epm.eb.ebSpread.domain.view.FilterView;
import kd.epm.eb.ebSpread.domain.view.JsonSerializerUtil;
import kd.epm.eb.ebSpread.domain.view.Sheet;
import kd.epm.eb.ebSpread.domain.view.SpreadManager;
import kd.epm.eb.ebSpread.domain.view.builder.FreeStyleTemplateBuilder;
import kd.epm.eb.ebSpread.domain.view.builder.PositionInfo;
import kd.epm.eb.ebSpread.domain.view.js.SpreadProperties;
import kd.epm.eb.ebSpread.model.IDimMember;
import kd.epm.eb.ebSpread.model.IDimension;
import kd.epm.eb.ebSpread.model.StatusBarModel;

public class AbstractTemplateBasePlugin
extends SpreadBasePlugin
implements ISpreadModelSupplier {
    protected String KEY_TEMPLATE_MODEL = "template_model";
    protected String KEY_SPREAD_MODEL = "KEY_SPREAD_MODEL";
    protected final String SPREAD_KEY = "template_spread";
    protected final String PREFIX = "epm_";
    protected final String SUFFIX = "4formula";
    protected static WatchLogger log = BcmLogFactory.getWatchLogInstance(AbstractTemplateBasePlugin.class);
    protected TemplateModel template;
    protected SpreadManager spread;
    private static final Log logger = LogFactory.getLog(AbstractTemplateBasePlugin.class);
    private boolean isInitFormViewInterceptor = false;

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public String getSpreadKey() {
        return "template_spread";
    }

    protected Sheet getEffectiveSheet() {
        return this.getSpreadModel().getBook().getSheet(0);
    }

    protected String sugarKey(String key) {
        return ("epm_" + key).toLowerCase(Locale.getDefault());
    }

    protected TemplateModel getTemplateModelFromSerial(String serial) {
        return (TemplateModel)this.deSerializedBytes(serial);
    }

    protected SpreadManager getSpreadModelFromSerial(String serial) {
        return JsonSerializerUtil.toSpreadManager((String)serial);
    }

    protected String toSerialTemplateModel(TemplateModel model) {
        return this.toByteSerialized(model);
    }

    public String toSerialSpreadModel(SpreadManager spread) {
        return JsonSerializerUtil.toJson((SpreadManager)spread);
    }

    protected boolean isTemplatePlugin() {
        return true;
    }

    @Override
    public SpreadManager getSpreadModel() {
        if (this.spread != null) {
            return this.spread;
        }
        String schema = this.getPageCache().get(this.KEY_SPREAD_MODEL);
        Predicate<String> p = t -> StringUtils.isEmpty((String)t);
        boolean hasCache = true;
        if (p.test(schema)) {
            String string = schema = this.isTemplatePlugin() ? this.getTemplateModel().getData() : this.getTemplateModel().getRptData();
            if (p.test(schema)) {
                schema = this.getTemplateModel().getData();
            }
            hasCache = false;
        }
        this.spread = !p.test(schema) ? JsonSerializerUtil.toSpreadManager((String)schema) : this.buildSpread(false);
        if (!hasCache) {
            SpreadUtils.updateCellOnUnchangeState(this.spread.getBook(), false);
            this.cacheSpreadModel();
        }
        return this.spread;
    }

    protected QFilter getQFilterByModelID() {
        return new QFilter("model", "=", (Object)this.getTemplateModel().getModelId());
    }

    @Override
    public Long getModelId() {
        Long id = super.getModelId();
        return id == 0L ? Long.valueOf(this.getTemplateModel().getModelId()) : id;
    }

    protected SpreadManager buildSpread(boolean hasSpread) {
        SpreadManager spread;
        TemplateModel template = this.getTemplateModel();
        if (hasSpread) {
            spread = this.getSpreadModel();
            spread.setFilter(this.builderFiltView());
            spread.getAreaManager().reSetRowColDimDomain();
        } else {
            spread = new SpreadManager(this.getTemplateModel().getName(), this.builderFiltView());
            for (AreaRangeEntry e : template.getAreaRangeEntries()) {
                PositionInfo p = new PositionInfo(e.getStartPosition(), e.getAreaRange());
                spread.getAreaManager().addArea(p, new RowDimDomain(), new ColumnDimDomain());
            }
        }
        if (this.getTemplateModel().getAreaRangeEntries().size() > 0) {
            for (AreaRangeEntry e : template.getAreaRangeEntries()) {
                PositionInfo p = new PositionInfo(e.getStartPosition(), e.getAreaRange());
                RowDimDomain rowDimDomain = spread.getAreaManager().getRowDimDoman(p);
                ColumnDimDomain colDimDomain = spread.getAreaManager().getColDimDomain(p);
                if (rowDimDomain == null) {
                    rowDimDomain = new RowDimDomain();
                }
                if (colDimDomain == null) {
                    colDimDomain = new ColumnDimDomain();
                }
                this.buildDom((Domain)rowDimDomain, e.getRowDimEntries());
                this.buildDom((Domain)colDimDomain, e.getColDimEntries());
                FreeStyleTemplateBuilder builder = new FreeStyleTemplateBuilder(this.getEffectiveSheet(), spread.getFilter(), rowDimDomain, colDimDomain, p);
                builder.doBuild();
                spread.getAreaManager().addArea(p, rowDimDomain, colDimDomain);
            }
        }
        this.spread = spread;
        this.getPageCache().put(this.KEY_SPREAD_MODEL, this.toSerialSpreadModel(spread));
        return spread;
    }

    protected FilterView builderFiltView() {
        return null;
    }

    private void buildDom(Domain dom, List<? extends MembSettingBaseDetail> entries) {
        for (MembSettingBaseDetail membSettingBaseDetail : entries) {
            Dimension d = membSettingBaseDetail.getDimension();
            IDimension dim = ObjectConvertUtils.toIDimension(d);
            dom.addDimension(dim);
            for (Member m : membSettingBaseDetail.getMembers()) {
                dim.addMember(m == null ? null : ObjectConvertUtils.toDimMember(m, dim));
            }
        }
    }

    public TemplateModel getTemplateModel() {
        if (this.template != null) {
            return this.template;
        }
        Predicate<String> p = t -> StringUtils.isEmpty((String)t);
        String serial = this.getPageCache().get(this.KEY_TEMPLATE_MODEL);
        if (p.test(serial)) {
            serial = (String)this.getFormCustomParam(this.KEY_TEMPLATE_MODEL);
            this.template = !p.test(serial) ? this.getTemplateModelFromSerial(serial) : new TemplateModel();
            this.getPageCache().put(this.KEY_TEMPLATE_MODEL, this.toSerialTemplateModel(this.template));
        } else {
            this.template = this.getTemplateModelFromSerial(serial);
        }
        return this.template;
    }

    protected void cacheTemplateModel() {
        this.getTemplateModel().setRptData(null);
        this.getPageCache().put(this.KEY_TEMPLATE_MODEL, this.getTemplateModelSerial());
    }

    protected void cacheTemplateModel(TemplateModel template) {
        this.getPageCache().put(this.KEY_TEMPLATE_MODEL, this.toSerialTemplateModel(template));
    }

    protected String getTemplateModelSerial() {
        return this.toSerialTemplateModel(this.getTemplateModel());
    }

    protected String getSpreadModelSerial() {
        return this.toSerialSpreadModel(this.getSpreadModel());
    }

    protected String getSpreadModelSerial(SpreadManager spread) {
        return this.toSerialSpreadModel(spread);
    }

    public SpreadManager getCopyOfSpread() {
        return this.getSpreadModelFromSerial(this.getSpreadModelSerial());
    }

    public void cacheSpreadModel() {
        this.cacheSpreadModel(this.getSpreadModel());
    }

    @Override
    public void cacheSpreadModel(SpreadManager spread) {
        this.getPageCache().put(this.KEY_SPREAD_MODEL, JsonSerializerUtil.toJson((SpreadManager)spread));
    }

    protected Dimension convertDynaObj2Dimension(DynamicObject dynaObj) {
        Dimension dim = new Dimension();
        dim.setId(dynaObj.getLong("id"));
        dim.setNumber(dynaObj.getString("number"));
        dim.setName(dynaObj.getString("name"));
        dim.setDataEntityNumber(dynaObj.getDataEntityType().getName());
        dim.setMemberEntityNumber(dynaObj.getString("membermodel"));
        return dim;
    }

    protected Member convertDynaObj2Member(DynamicObject dynaObj) {
        Member member = new Member();
        member.setId(dynaObj.getLong("id"));
        member.setNumber(dynaObj.getString("number"));
        member.setName(dynaObj.getString("name"));
        member.setDataEntityNumber(dynaObj.getDataEntityType().getName());
        return member;
    }

    protected DynamicObject convertDimension2DynaObject(Dimension dim) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)dim.getDataEntityNumber()), (Object)ResManager.loadKDString((String)"\u6210\u5458\u5bf9\u8c61\u5b9e\u4f53\u7f16\u7801\u4e0d\u80fd\u4e3anull", (String)"AbstractTemplateBasePlugin_0", (String)"epm-eb-budget", (Object[])new Object[0]));
        DynamicObject obj = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)dim.getDataEntityNumber()));
        obj.set("id", (Object)dim.getId());
        obj.set("name", (Object)dim.getName());
        obj.set("number", (Object)dim.getNumber());
        return obj;
    }

    protected DynamicObject convertMember2DynaObject(Member member) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)member.getDataEntityNumber()), (Object)ResManager.loadKDString((String)"\u6210\u5458\u5bf9\u8c61\u5b9e\u4f53\u7f16\u7801\u4e0d\u80fd\u4e3anull", (String)"AbstractTemplateBasePlugin_0", (String)"epm-eb-budget", (Object[])new Object[0]));
        DynamicObject obj = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)member.getDataEntityNumber()));
        obj.set("id", (Object)member.getId());
        obj.set("name", (Object)member.getName());
        obj.set("number", (Object)member.getNumber());
        return obj;
    }

    public PositionInfo getOverlapPosition(String tarArea) {
        for (PositionInfo e : this.getSpreadModel().getAreaManager().getPostionInfoSet()) {
            if (!ExcelUtils.isOverlap((String)e.getAreaRange(), (String)tarArea)) continue;
            return e;
        }
        return null;
    }

    public List<PositionInfo> getOverlapPositions(String tarArea) {
        ArrayList<PositionInfo> result = new ArrayList<PositionInfo>();
        for (PositionInfo e : this.getSpreadModel().getAreaManager().getPostionInfoSet()) {
            if (!ExcelUtils.isOverlap((String)e.getAreaRange(), (String)tarArea)) continue;
            result.add(e);
        }
        return result;
    }

    protected void invokeJsupdateCellValues(int r, int c) {
        String msg = this.getEffectiveSheet().getCell(r, c).displayDimMsg();
        this.getEffectiveSheet().getCell(r, c).setValue((Object)msg);
        ArrayList<Map<String, Object>> cellValues = new ArrayList<Map<String, Object>>();
        cellValues.add(this.packedUpdateCellMap(r, c, msg));
        this.invokeSpreadUpdateValueMethod(cellValues);
    }

    protected void invokeJsupdateCellValues(int r, int c, List<IDimMember> members) {
        String msg = Cell.formatDimMsg(members);
        this.getEffectiveSheet().getCell(r, c).setValue((Object)msg);
        this.getEffectiveSheet().getCell(r, c).setUserObject("cross_name", (Object)msg);
        ArrayList<Map<String, Object>> cellValues = new ArrayList<Map<String, Object>>();
        cellValues.add(this.packedUpdateCellMap(r, c, msg));
        this.invokeSpreadUpdateValueMethod(cellValues);
    }

    protected void invokeSpreadUpdateValueMethod(List<Map<String, Object>> cellValues) {
        SpreadClientInvoker.invokeUpdataValueMethod(this.getClientViewProxy(), "template_spread", cellValues);
    }

    public Map<String, Object> packedUpdateCellMap(int r, int c, Object value) {
        HashMap<String, Object> valMap = new HashMap<String, Object>();
        valMap.put(SpreadProperties.UpdataValueMethod.R.k(), r);
        valMap.put(SpreadProperties.UpdataValueMethod.C.k(), c);
        valMap.put(SpreadProperties.UpdataValueMethod.V.k(), value);
        return valMap;
    }

    protected PositionInfo checkAreaSetting(PositionInfo ps, boolean isFloat) {
        AreaRangeEntry area;
        String name;
        String string = name = isFloat ? ResManager.loadKDString((String)"\u6d6e\u52a8", (String)"AbstractTemplateBasePlugin_1", (String)"epm-eb-budget", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5faa\u73af", (String)"AbstractTemplateBasePlugin_2", (String)"epm-eb-budget", (Object[])new Object[0]);
        if (ps == null) {
            if (this.getSpreadModel().getAreaManager().getPostionInfoSet().size() > 0) {
                ps = (PositionInfo)this.getSpreadModel().getAreaManager().getPostionInfoSet().iterator().next();
            } else {
                throw new KDBizException(ResManager.loadResFormat((String)"\u6a21\u677f\u672a\u8bbe\u7f6e\u533a\u57df\uff0c\u4e0d\u53ef\u8bbe\u7f6e%1", (String)"AbstractTemplateBasePlugin_3", (String)"epm-eb-budget", (Object[])new Object[]{name}));
            }
        }
        if ((area = this.getTemplateModel().findAreaByArea(ps.getAreaRange())).getRowDimEntries().size() == 0 || area.getColDimEntries().size() == 0) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u8fdb\u884c%1\u8bbe\u7f6e\u4e4b\u524d\u5fc5\u987b\u5148\u8bbe\u7f6e\u884c\u5217\u7ef4", (String)"AbstractTemplateBasePlugin_4", (String)"epm-eb-budget", (Object[])new Object[]{name}));
        }
        return ps;
    }

    public void hideEbAppCtrl(Object modelId) {
        TemplateModel templateModel = this.getTemplateModel();
        HashSet dimensions = new HashSet();
        templateModel.getViewPointDimensionEntries().forEach(dimension -> dimensions.add(dimension.getDimension().getNumber()));
        templateModel.getPageDimensionEntries().forEach(dimension -> dimensions.add(dimension.getDimension().getNumber()));
        if (this.isEPM()) {
            List<String> hides = Arrays.asList(DimEntityNumEnum.SCENARIO.getNumber(), DimEntityNumEnum.PROCESS.getNumber(), DimEntityNumEnum.CHANGETYPE.getNumber());
            hides.forEach(hide -> {
                if (dimensions.contains(hide)) {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{this.sugarKey((String)hide)});
                }
            });
        }
    }

    protected void displaySelectCellDimCrossInfoUsedByTemplate() {
        SerialSpliter spliter;
        String[] entityNums;
        String serial = (String)this.getEffectiveSheet().getCell(this.getSelectorStartRow(), this.getSelectorStartCol()).getUserObject("cross_nums", (Object)"");
        StatusBarModel statusBarModel = new StatusBarModel();
        if (StringUtils.isNotEmpty((String)serial) && (entityNums = this.findEntityNumBySpecifiedArea(this.getSpreadSelector().getStartPosition())) != null && serial.split(String.valueOf('#')).length == entityNums.length && (spliter = new SerialSpliter(serial)).getPairs().size() == entityNums.length) {
            StringBuilder sb = new StringBuilder("[");
            for (int i = 0; i < entityNums.length; ++i) {
                DynamicObject dyna = this.getMemberInfo(entityNums[i], (String)spliter.getPairs().getPair((int)i).p1, (String)spliter.getPairs().getPair((int)i).p2);
                if (dyna != null) {
                    sb.append(dyna.getString("dimension.name")).append(SystemSeparatorChar.LONGNUMBER_SEPARAROT).append(dyna.getString("name")).append(SystemSeparatorChar.NAME_AND_NUMBER).append(dyna.getString("number"));
                    if (i >= entityNums.length - 1) continue;
                    sb.append(SystemSeparatorChar.ADJUST_ACCOUNT);
                    continue;
                }
                logger.error("displaySelectCellDimCrossInfoUsedByTemplate -> entityNums:{} ,dimNum:{} , memberNum:{}", new Object[]{entityNums[i], spliter.getPairs().getPair((int)i).p1, spliter.getPairs().getPair((int)i).p2});
                throw new KDBizException(ResManager.loadKDString((String)"\u7ef4\u5ea6\u6210\u5458\u4fe1\u606f\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u7ef4\u5ea6\u6210\u5458\u8bbe\u7f6e\u3002", (String)"AbstractTemplateTreePlugin_7", (String)"epm-eb-budget", (Object[])new Object[0]));
            }
            sb.append(']');
            statusBarModel.setCellNameStr(sb.toString());
        }
        SpreadClientInvoker.invokeSetDisplayContent(this.getClientViewProxy(), "template_spread", statusBarModel);
    }

    protected String[] findEntityNumBySpecifiedArea(String position) {
        ArrayList<String> items = new ArrayList<String>();
        for (AreaRangeEntry e : this.getTemplateModel().getAreaRangeEntries()) {
            PositionInfo spreadPositionInfo = this.getSpreadModel().getAreaManager().searchStorePositionInfo(new PositionInfo(e.getStartPosition(), e.getAreaRange()));
            String spreadArea = spreadPositionInfo.getAreaRange();
            if (!ExcelUtils.isWithInScope((String)spreadArea, (String)position)) continue;
            items.addAll(this.collectEntityNumbers(e.getRowDimEntries()));
            items.addAll(this.collectEntityNumbers(e.getColDimEntries()));
        }
        if (!items.isEmpty()) {
            return items.toArray(new String[0]);
        }
        return null;
    }

    protected List<String> collectEntityNumbers(List<? extends MembSettingBaseDetail> details) {
        return Lists.transform(details, t -> t.getDimension().getMemberEntityNumber());
    }

    protected DynamicObject getMemberInfo(String entityNum, String dimNum, String membNum) {
        QFilter filter = new QFilter("number", "=", (Object)membNum);
        filter.and(new QFilter("dimension.number", "=", (Object)dimNum));
        filter.and(new QFilter("model", "=", (Object)this.getModelId()));
        return QueryServiceHelper.queryOne((String)entityNum, (String)"id,number,name,dimension.name", (QFilter[])new QFilter[]{filter});
    }

    protected void initDefaultProcessAndAuditTrailMember(TemplateModel templateModel) {
        templateModel.getPageDimensionEntries().forEach(pageDimensionEntry -> {
            Dimension dimension;
            if (pageDimensionEntry.getDimension().getNumber().equals(DimTypesEnum.PROCESS.getNumber())) {
                dimension = ((Member)pageDimensionEntry.getMembers().get(0)).getDimension();
                pageDimensionEntry.getMembers().clear();
                pageDimensionEntry.getMembers().add(this.getProcessDefaultMember());
                ((Member)pageDimensionEntry.getMembers().get(0)).setDimension(dimension);
            }
            if (pageDimensionEntry.getDimension().getNumber().equals(DimTypesEnum.AUDITTRIAL.getNumber())) {
                dimension = ((Member)pageDimensionEntry.getMembers().get(0)).getDimension();
                pageDimensionEntry.getMembers().clear();
                pageDimensionEntry.getMembers().add(this.getAuditTrialDefaultMember());
                ((Member)pageDimensionEntry.getMembers().get(0)).setDimension(dimension);
            }
        });
    }

    private Member getProcessDefaultMember() {
        QFBuilder qf = new QFBuilder();
        qf.add("model", "=", (Object)this.getModelId());
        qf.add("number", "=", (Object)"Process");
        DynamicObject dyna = BusinessDataServiceHelper.loadSingleFromCache((String)"epm_processmembertree", (QFilter[])qf.toArray());
        Member member = this.convertDynaObj2Member(dyna);
        member.setScope(RangeEnum.VALUE_50.getValue());
        return member;
    }

    private Member getAuditTrialDefaultMember() {
        QFBuilder qf = new QFBuilder();
        qf.add("model", "=", (Object)this.getModelId());
        qf.add("number", "=", (Object)"AuditTrail");
        DynamicObject dyna = BusinessDataServiceHelper.loadSingleFromCache((String)"epm_audittrialmembertree", (String)"id,number,name,dimension", (QFilter[])qf.toArray());
        Member member = this.convertDynaObj2Member(dyna);
        member.setScope(RangeEnum.VALUE_50.getValue());
        return member;
    }

    public String getSUFFIX() {
        return "4formula";
    }

    protected void registSpreadShortcutKey() {
        SpreadClientInvoker.invokeRegistShortcutKey(this.getClientViewProxy(), this.getSpreadKey(), "openDebug", "F8", true, true, true);
        SpreadClientInvoker.invokeRegistShortcutKey(this.getClientViewProxy(), this.getSpreadKey(), "showDebugSwitcher", "F10", true, true, true);
        SpreadClientInvoker.invokeRegistShortcutKey(this.getClientViewProxy(), this.getSpreadKey(), "showCalcFormulaDebug", "F11", true, true, true);
    }

    public void showCalcFormulaDebug() {
        FormShowParameter formparam = new FormShowParameter();
        formparam.setFormId("eb_calcformuladebug");
        formparam.setParentPageId(this.getView().getPageId());
        formparam.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(formparam);
    }

    public void openDebug() {
        FormShowParameter formShowParameter = new FormShowParameter();
        IFormView parentView = this.getView().getParentView();
        formShowParameter.setFormId("eb_query_mainpage");
        formShowParameter.getOpenStyle().setShowType(ShowType.NewTabPage);
        formShowParameter.getOpenStyle().setTargetKey("_submaintab_");
        formShowParameter.setParentFormId(this.getView().getEntityId());
        formShowParameter.setParentPageId(this.getView().getPageId());
        parentView.showForm(formShowParameter);
        this.getView().sendFormAction(parentView);
    }

    public void showDebugSwitcher() {
        FormShowParameter formparam = new FormShowParameter();
        formparam.setFormId("eb_debugsetting");
        formparam.setParentPageId(this.getView().getPageId());
        formparam.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(formparam);
    }

    protected void beforeDestroy() {
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
    }

    public void setView(IFormView formView) {
        super.setView(formView);
        if (this.isInitFormViewInterceptor || this.batchExport()) {
            return;
        }
        this.getPageCache();
        final FormViewPluginProxy viewProxy = (FormViewPluginProxy)formView.getService(FormViewPluginProxy.class);
        if (viewProxy != null) {
            FormViewPluginProxy proxyService = (FormViewPluginProxy)new Interceptor((Object)viewProxy, new ITransationHandle(){

                public void beforeTransation(Method method, Object[] args) {
                }

                public void afterTransation(Method method, Object[] args) {
                    if ("fireClosedCallBack".equals(method.getName()) || "fireConfirmedCallBack".equals(method.getName())) {
                        for (IFormPlugin pl : viewProxy.getPlugIns()) {
                            if (!ISupportPageCacheProxy.class.isAssignableFrom(pl.getClass())) continue;
                            ((AbstractFormPlugin)AbstractFormPlugin.class.cast(pl)).destory();
                        }
                    }
                }
            }).createProxy();
            proxyService.registerPlugins(viewProxy.getPlugIns());
            formView.addService(FormViewPluginProxy.class, (Object)proxyService);
        }
        this.isInitFormViewInterceptor = true;
    }

    private boolean batchExport() {
        return "eb_exportdata_bg".equals(this.getView().getEntityId());
    }
}

