/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.budget.formplugin.template;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.events.CreateListColumnsListener;
import kd.bos.log.api.AppLogInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.budget.formplugin.AbstractBaseFormPlugin;
import kd.epm.eb.budget.formplugin.template.SearchResult;
import kd.epm.eb.budget.formplugin.util.FormUtils;
import kd.epm.eb.budget.formplugin.util.ReportListUtil;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.business.utils.CustomF7utils;
import kd.epm.eb.common.ebcommon.common.MessageConstant;
import kd.epm.eb.common.ebcommon.common.cache.MemberReader;
import kd.epm.eb.common.ebcommon.common.enums.DetailTypeEnum;
import kd.epm.eb.common.ebcommon.common.enums.DimTypesEnum;
import kd.epm.eb.common.ebcommon.common.util.BCMTreeUtils;
import kd.epm.eb.common.ebcommon.common.util.ObjectSerialUtil;
import kd.epm.eb.common.ebcommon.common.util.QFBuilder;
import kd.epm.eb.common.ebcommon.enums.TemplateCatalogTypeEnum;
import kd.epm.eb.common.ebcommon.enums.TemplateTypeEnum;
import kd.epm.eb.common.enums.F7RangeTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.OperationLogUtil;
import kd.epm.eb.common.utils.convert.Convert;
import kd.epm.eb.ebBusiness.serviceHelper.AppCacheServiceHelper;
import kd.epm.eb.ebBusiness.serviceHelper.QueryMemberDetailsHelper;

public class DistributionPlugin
extends AbstractBaseFormPlugin
implements SetFilterListener {
    public static final String selectOrg_entityID = "dentity";
    public static final String temCatalog_treeID = "temcatalogtree";
    private static final String ROOT_NODE = "rootNode";
    private static final String CACHE_SEARCH = "cache_search";
    private final TreeNodeCheckListener treeNodeCheckListener = new TreeNodeCheckListener(){

        public void treeNodeCheck(TreeNodeCheckEvent evt) {
            DistributionPlugin.this.refreshBillList();
        }
    };

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addListeners();
    }

    public void setFilter(SetFilterEvent evt) {
        Control source = (Control)evt.getSource();
        String viewid = (String)source.getModel().getValue("viewcombo");
        BillList billList = (BillList)source.getView().getControl("billlistap");
        List filters = evt.getQFilters();
        if (viewid.equals("20")) {
            FormUtils.setBillFormId4FormBill(billList, "eb_distributionentity");
        }
        QFilter filter1 = this.getTemQueryFilter(temCatalog_treeID, "template");
        QFilter filter2 = this.getOrgQueryFilter(selectOrg_entityID, "oid", "entity");
        if (filter1 == null && filter2 == null) {
            filters.add(new QFilter("1", "!=", (Object)1));
        } else if (filter1 == null) {
            filters.add(new QFilter("1", "!=", (Object)1));
        } else if (filter2 == null) {
            filters.add(filter1);
        } else {
            filters.add(filter1.and(filter2));
        }
    }

    private void addListeners() {
        this.addClickListeners(new String[]{"selectorg", "deleteorg", "deletedistribution", "details", "imageup", "imagedown"});
        this.addItemClickListeners(new String[]{"toolbarap"});
        EntryGrid orgeg = (EntryGrid)this.getControl(selectOrg_entityID);
        BillList billList = (BillList)this.getView().getControl("billlistap");
        billList.addSetFilterListener((SetFilterListener)this);
        TreeView tree = (TreeView)this.getControl(temCatalog_treeID);
        if (tree != null) {
            tree.addTreeNodeCheckListener(this.treeNodeCheckListener);
        }
        orgeg.addRowClickListener(new RowClickEventListener(){

            public void entryRowClick(RowClickEvent evt) {
                super.entryRowClick(evt);
                DistributionPlugin.this.refreshBillList();
            }
        });
        billList.addCreateListColumnsListener(new CreateListColumnsListener(){

            public void createListColumns(BeforeCreateListColumnsArgs args) {
                List listCol = args.getListColumns();
                String viewid = (String)DistributionPlugin.this.getModel().getValue("viewcombo");
                if (viewid != null && !viewid.equals(((IListColumn)listCol.get(0)).getListFieldKey())) {
                    if (viewid.equals("username")) {
                        Collections.swap(listCol, 0, 1);
                        Collections.swap(listCol, 0, 2);
                    } else if (viewid.equals("membername")) {
                        Collections.swap(listCol, 0, 1);
                        Collections.swap(listCol, 1, 2);
                    }
                }
            }
        });
        Search se = (Search)this.getControl("searchap");
        se.addEnterListener(new SearchEnterListener(){

            public void search(SearchEnterEvent var1) {
                String text = var1.getText();
                if (text != null && !"".equals(text)) {
                    DistributionPlugin.this.searchTemplate(text.trim());
                } else {
                    DistributionPlugin.this.getView().showTipNotification(MessageConstant.getMEMBER_NOINPUT());
                }
            }
        });
    }

    private void searchTemplate(String search) {
        TreeView tree = (TreeView)this.getControl(temCatalog_treeID);
        String rootNodeCache = this.getPageCache().get(ROOT_NODE);
        if (rootNodeCache != null) {
            TreeNode root = (TreeNode)ObjectSerialUtil.deSerializedBytes((String)rootNodeCache);
            ArrayList<TreeNode> hitNode = new ArrayList<TreeNode>();
            root.getTreeNodeListByText(hitNode, search, 999);
            SearchResult result = null;
            if (hitNode.size() > 0) {
                result = new SearchResult(hitNode);
                TreeNode next = result.next(1);
                tree.checkNode(next);
                this.refreshBillList();
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u76f8\u5173\u8282\u70b9\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u540d\u79f0\u540e\u91cd\u65b0\u641c\u7d22", (String)"DistributionPlugin_0", (String)"epm-eb-budget", (Object[])new Object[0]));
            }
            this.getPageCache().put(CACHE_SEARCH, result == null ? null : ObjectSerialUtil.toByteSerialized((Object)result));
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "btn_distribute": {
                this.distributeMember();
            }
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (c.getKey().toLowerCase()) {
            case "selectorg": {
                this.showSelectOrgView();
                break;
            }
            case "deleteorg": {
                this.deleteOrgMember();
                break;
            }
            case "deletedistribution": {
                this.deleteDistribution();
                break;
            }
            case "details": {
                this.showDetailsView();
                break;
            }
            case "imageup": {
                this.searchNext(-1);
                break;
            }
            case "imagedown": {
                this.searchNext(1);
            }
        }
    }

    private void searchNext(int i) {
        IPageCache pageCache = this.getPageCache();
        String searchResultCache = pageCache.get(CACHE_SEARCH);
        if (searchResultCache != null) {
            SearchResult result = (SearchResult)ObjectSerialUtil.deSerializedBytes((String)searchResultCache);
            TreeNode next = result.next(i);
            TreeView tree = (TreeView)this.getControl(temCatalog_treeID);
            if (next == null) {
                if (i > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u6700\u540e\u4e00\u6761\u5185\u5bb9\u3002", (String)"DistributionPlugin_1", (String)"epm-eb-budget", (Object[])new Object[0]));
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u4e2d\u7684\u662f\u7b2c\u4e00\u6761\u5185\u5bb9\u3002", (String)"DistributionPlugin_2", (String)"epm-eb-budget", (Object[])new Object[0]));
                }
            } else {
                tree.checkNode(next);
                tree.treeNodeClick(next.getParentid(), next.getId());
                pageCache.put(CACHE_SEARCH, ObjectSerialUtil.toByteSerialized((Object)result));
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u641c\u7d22\u9700\u8981\u7684\u5185\u5bb9\u3002", (String)"DistributionPlugin_3", (String)"epm-eb-budget", (Object[])new Object[0]));
        }
    }

    private void showDetailsView() {
        BillList billlist = (BillList)this.getControl("billlistap");
        FormShowParameter param = new FormShowParameter();
        param.setFormId("eb_distribution_details");
        param.setCaption(ResManager.loadKDString((String)"\u6a21\u677f\u5206\u914d\u8be6\u60c5", (String)"DistributionPlugin_4", (String)"epm-eb-budget", (Object[])new Object[0]));
        Object[] ids = null;
        ids = billlist.getSelectedRows().getPrimaryKeyValues().length < 1 ? billlist.getCurrentListAllRowCollection().getPrimaryKeyValues() : billlist.getSelectedRows().getPrimaryKeyValues();
        param.setCustomParam("ids", (Object)SerializationUtils.toJsonString((Object)ids));
        param.setCustomParam("modelid", (Object)this.getPageCache().get("KEY_MODEL_ID"));
        param.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(param);
    }

    private void deleteDistribution() {
        BillList billlist = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection list = billlist.getSelectedRows();
        if (list.size() < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u53cd\u5206\u914d\u8bb0\u5f55\u7684\u6570\u636e\u884c\u3002", (String)"DistributionPlugin_5", (String)"epm-eb-budget", (Object[])new Object[0]));
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u662f\u5426\u53cd\u5206\u914d\uff1f", (String)"DistributionPlugin_6", (String)"epm-eb-budget", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("delete_comfirm", (IFormPlugin)this));
    }

    private void distributeMember() {
        List<String> temlist = this.getTemSelectedAndResultList(temCatalog_treeID, false);
        List<DynamicObject> orglist = this.getOrgSelectedAndResultList(selectOrg_entityID);
        if (temlist.size() < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5206\u914d\u7684\u6a21\u677f\u3002", (String)"DistributionPlugin_7", (String)"epm-eb-budget", (Object[])new Object[0]));
            return;
        }
        if (orglist.size() < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5206\u914d\u7684\u7ec4\u7ec7\u3002", (String)"DistributionPlugin_8", (String)"epm-eb-budget", (Object[])new Object[0]));
            return;
        }
        String msg = this.removeOrgMenberTemplate(temlist);
        if (temlist.size() < 1) {
            return;
        }
        String modelid = this.getPageCache().get("KEY_MODEL_ID");
        this.saveDistributeRecord(this.mergeResult(orglist, temlist, modelid), msg);
    }

    private String removeOrgMenberTemplate(List<String> tlist) {
        List temids;
        String oo = this.getPageCache().get("orgids");
        if (!StringUtils.isEmpty((CharSequence)oo) && tlist.removeAll(temids = (List)SerializationUtils.fromJsonString((String)oo, List.class))) {
            String msg = ResManager.loadResFormat((String)"\u5df2\u8df3\u8fc7\u7ec4\u7ec7\u7ef4\u5ea6\u540d\u79f0\uff08%1\uff09\u5728\u89c6\u70b9\u7ef4\u7684\u62a5\u8868\u6a21\u677f", (String)"DistributionPlugin_9", (String)"epm-eb-budget", (Object[])new Object[]{this.getEntityName().getString("name")});
            return msg;
        }
        return "";
    }

    private DynamicObject getEntityName() {
        QFilter filter1 = new QFilter("model", "=", (Object)Convert.toLong((Object)this.getPageCache().get("KEY_MODEL_ID")));
        QFilter filter2 = new QFilter("number", "=", (Object)DimTypesEnum.ENTITY.getNumber());
        QFilter[] filters = new QFilter[]{filter1, filter2};
        return QueryServiceHelper.queryOne((String)"epm_dimension", (String)"name", (QFilter[])filters);
    }

    private List<String> getTemSelectedAndResultList(String entityid, Boolean isFilter) {
        TreeView tree = (TreeView)this.getControl(entityid);
        List<String> tids = tree.getTreeState().getSelectedNodeId();
        if (!isFilter.booleanValue() && tids.isEmpty()) {
            String cache = this.getPageCache().get("templeteids");
            tids = StringUtils.isNotEmpty((CharSequence)cache) ? (List)SerializationUtils.fromJsonString((String)cache, List.class) : new ArrayList();
            this.getPageCache().remove("templeteids");
        }
        DynamicObjectCollection doc = this.getTemplatecatalogList();
        LinkedList<String> clist = new LinkedList<String>();
        for (DynamicObject dd : doc) {
            clist.add(dd.getString("id"));
        }
        tids.removeIf(e -> StringUtils.isEmpty((CharSequence)e));
        tids.removeAll(clist);
        return tids;
    }

    private List<DynamicObject> getOrgSelectedAndResultList(String entityid) {
        EntryGrid eg = (EntryGrid)this.getControl(entityid);
        int[] rows = eg.getSelectRows();
        if (rows == null || rows.length < 1) {
            return new ArrayList<DynamicObject>(10);
        }
        Set collect = Arrays.stream(rows).boxed().collect(Collectors.toSet());
        ArrayList list = Lists.newArrayListWithExpectedSize((int)rows.length);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(entityid);
        for (int i = 0; i < entryEntity.size(); ++i) {
            if (!collect.contains(i)) continue;
            list.add(entryEntity.get(i));
        }
        return list;
    }

    private void saveDistributeRecord(List<DynamicObject> dlist, String msg) {
        String modelid = this.getPageCache().get("KEY_MODEL_ID");
        QFilter filter = new QFilter("model", "=", (Object)Convert.toLong((Object)modelid));
        QFilter[] filters = new QFilter[]{filter};
        String selectFields = "id,entity,template,memrangdecombo,definedpropertyvalue ";
        DynamicObjectCollection oldoc = QueryServiceHelper.query((String)"eb_distributionentity", (String)selectFields, (QFilter[])filters);
        int index = 0;
        block12: for (DynamicObject tem : oldoc) {
            index = 0;
            for (DynamicObject dd : dlist) {
                String cloname;
                Object entityid = dd.get("entity");
                String string = cloname = !ObjectUtils.isEmpty((Object)entityid) ? "entity" : "definedpropertyvalue";
                if (tem.getLong("template") == dd.getLong("template") && tem.get("memrangdecombo").equals(dd.get("memrangdecombo")) && tem.getLong(cloname) == dd.getLong(cloname)) {
                    dlist.remove(index);
                    continue block12;
                }
                ++index;
            }
        }
        if (dlist.size() < 1) {
            return;
        }
        try (TXHandle tx = TX.required((String)"eb_actionsave");){
            try {
                DynamicObject[] newdoc = dlist.toArray(new DynamicObject[dlist.size()]);
                Object[] oo = SaveServiceHelper.save((DynamicObject[])newdoc);
                List<AppLogInfo> appLogInfos = dlist.stream().map(obj -> {
                    MultiLangEnumBridge opNameBridge = new MultiLangEnumBridge("\u5206\u914d", "DistributionPlugin_11", "epm-eb-budget");
                    MultiLangEnumBridge opDescBridge = new MultiLangEnumBridge("\u6a21\u677f\uff1a %1$s \u5206\u914d\u7ed9: %2$s \u8303\u56f4\u4e3a: %3$s", "DistributionPlugin_12", "epm-eb-budget");
                    String[] args = new String[]{obj.getString("template"), obj.getString("textname"), obj.getString("memrangdecombo")};
                    return OperationLogUtil.buildLogInfo((String)this.getBizAppId(), (String)this.getBizEntityNumber(), null, (String)"distribution", (MultiLangEnumBridge)opNameBridge, (MultiLangEnumBridge)opDescBridge, (String[])args);
                }).collect(Collectors.toList());
                this.writeBatchLog(appLogInfos);
                if (oo.length > 0) {
                    this.getView().showSuccessNotification(ResManager.loadResFormat((String)"\u5206\u914d\u6210\u529f\u3002%1", (String)"DistributionPlugin_15", (String)"epm-eb-budget", (Object[])new Object[]{msg}));
                }
                AppCacheServiceHelper.removeTemplateDispenseCache((String)MemberReader.findModelNumberById((Object)modelid));
            }
            catch (KDBizException e) {
                tx.markRollback();
                throw e;
            }
            catch (Throwable e) {
                tx.markRollback();
                throw e;
            }
        }
        this.refreshBillList();
    }

    public void writeBatchLog(List<AppLogInfo> appLogInfos) {
        OperationLogUtil.log(appLogInfos);
    }

    @Override
    public String getBizEntityNumber() {
        return "eb_distributionentity";
    }

    private void refreshBillList() {
        QFilter filter2;
        BillList billlist = (BillList)this.getControl("billlistap");
        QFilter filter1 = this.getTemQueryFilter(temCatalog_treeID, "template");
        if (filter1 != null) {
            billlist.getFilterParameter().getQFilters().add(filter1);
        }
        if ((filter2 = this.getOrgQueryFilter(selectOrg_entityID, "oid", "entity")) != null) {
            billlist.getFilterParameter().getQFilters().add(filter2);
        }
        billlist.refresh();
        billlist.clearSelection();
    }

    private QFilter getTemQueryFilter(String entityid, String columnname) {
        List<String> rows = this.getTemSelectedAndResultList(entityid, true);
        List longs = IDUtils.toLongs(rows);
        QFilter filter = null;
        if (rows.size() > 0) {
            filter = new QFilter(columnname, "in", (Object)longs.toArray());
        }
        return filter;
    }

    private QFilter getOrgQueryFilter(String entityid, String idname, String columnname) {
        List<DynamicObject> orglist = this.getOrgSelectedAndResultList(entityid);
        LinkedList<Long> mrows = new LinkedList<Long>();
        LinkedList lrows = new LinkedList();
        Object[] orgids = new Long[orglist.size()];
        for (int i = 0; i < orglist.size(); ++i) {
            orgids[i] = orglist.get(i).getLong("oid");
        }
        Map orgs = BusinessDataServiceHelper.loadFromCache((Object[])orgids, (String)"epm_entitymembertree");
        for (DynamicObject org : orglist) {
            DynamicObject nowOrg = (DynamicObject)orgs.get(org.getLong(idname));
            if (nowOrg.get("copyfrom") != null) {
                mrows.add(nowOrg.getDynamicObject("copyfrom").getLong("id"));
                continue;
            }
            mrows.add(Long.valueOf(org.getString(idname)));
        }
        QFilter filter = null;
        if (mrows.size() > 0) {
            filter = new QFilter(columnname, "in", (Object)mrows.toArray());
        }
        if (lrows.size() > 0) {
            QFilter filter2 = new QFilter("definedpropertyvalue", "in", (Object)lrows.toArray());
            filter = filter == null ? filter2 : filter.or(filter2);
        }
        return filter;
    }

    private List<DynamicObject> mergeResult(List<DynamicObject> orglist, List<String> temlist, String modelid) {
        Object[] orgids = new Long[orglist.size()];
        for (int i = 0; i < orglist.size(); ++i) {
            orgids[i] = orglist.get(i).getLong("oid");
        }
        Map orgs = BusinessDataServiceHelper.loadFromCache((Object[])orgids, (String)"epm_entitymembertree");
        ArrayList<DynamicObject> dlist = new ArrayList<DynamicObject>();
        for (String tem : temlist) {
            for (DynamicObject org : orglist) {
                DynamicObject distribute = BusinessDataServiceHelper.newDynamicObject((String)"eb_distributionentity");
                DynamicObject nowOrg = (DynamicObject)orgs.get(org.getLong("oid"));
                if (nowOrg.get("copyfrom") != null) {
                    distribute.set("entity", nowOrg.getDynamicObject("copyfrom").get("id"));
                } else {
                    distribute.set("entity", org.get("oid"));
                }
                distribute.set("memrangdecombo", org.get("rangevalue"));
                distribute.set("template", (Object)tem);
                distribute.set("model", (Object)modelid);
                distribute.set("textname", org.get("entity"));
                dlist.add(distribute);
            }
        }
        return dlist;
    }

    private void showSelectOrgView() {
        Long modelId = this.getModelId();
        MemberF7Parameter f8Param = NewF7Utils.multipleF8((Long)modelId, (DynamicObject)NewF7Utils.getDimension((Long)modelId, (String)SysDimensionEnum.Entity.getNumber()), (String)DynamicObjectCollection.class.getName());
        f8Param.setRangeType(F7RangeTypeEnum.DEFAULT);
        CustomF7utils.loadCacheSelectedData((IFormView)this.getView(), (MemberF7Parameter)f8Param);
        NewF7Utils.openF8((IFormView)this.getView(), (MemberF7Parameter)f8Param, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "selectmember"));
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String modelid = (String)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID");
        this.getPageCache().put("KEY_MODEL_ID", modelid);
        FilterParameter fp = new FilterParameter();
        QFilter filter = new QFilter("model", "=", (Object)Convert.toLong((Object)modelid));
        fp.setFilter(filter);
        BillList billList = (BillList)this.getControl("billlistap");
        billList.setFilterParameter(fp);
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setTempalteDate2View(this.getPageCache().get("KEY_MODEL_ID"));
        this.getView().setVisible(Boolean.FALSE, new String[]{"viewcombo"});
        this.refreshBillList();
    }

    private void setTempalteDate2View(String modelid) {
        TreeNode rootview = null;
        DynamicObjectCollection temlist = this.getTemplateColls(modelid);
        rootview = ReportListUtil.getTemplateTree(this.mergeTemplatecatalogList(modelid), temlist, new ArrayList<TreeNode>(), "0", new TreeNode());
        this.getPageCache().put(ROOT_NODE, ObjectSerialUtil.toByteSerialized((Object)rootview));
        TreeView tree = (TreeView)this.getControl(temCatalog_treeID);
        BCMTreeUtils.spreadAllNode((TreeNode)rootview);
        List rows = (List)this.getView().getFormShowParameter().getCustomParam("rows");
        ArrayList<String> orgIds = new ArrayList<String>();
        ArrayList<TreeNode> selNodes = new ArrayList<TreeNode>();
        for (DynamicObject dd : temlist) {
            if (rows != null && rows.contains(dd.getString("number"))) {
                TreeNode node = rootview.getTreeNode(dd.getString("id"), 10);
                selNodes.add(node);
            }
            for (DynamicObject dim : this.getTemplateDimension(dd.getLong("id"))) {
                TreeNode node;
                if ("Entity".equals(dim.getString("mnumber"))) {
                    node = rootview.getTreeNode(dd.getString("id"), 10);
                    if (node != null) {
                        node.setColor("#999999");
                    }
                    orgIds.add(dd.getString("id"));
                    continue;
                }
                node = rootview.getTreeNode(dd.getString("id"), 10);
                if (node == null) continue;
                node.setColor("#333333");
            }
        }
        tree.addNode(rootview);
        if (selNodes.size() > 0) {
            tree.checkNodes(selNodes);
            this.getPageCache().put("templeteids", SerializationUtils.toJsonString(selNodes.stream().map(selNode -> selNode.getId()).collect(Collectors.toList())));
        }
        this.getPageCache().put("orgids", SerializationUtils.toJsonString(orgIds));
    }

    private DynamicObjectCollection getTemplateColls(String modelid) {
        QFilter filter = new QFilter("model", "=", (Object)Convert.toLong((Object)modelid));
        filter.and("templatetype", "!=", (Object)String.valueOf(TemplateTypeEnum.MSN.getType()));
        Object pks = this.getView().getFormShowParameter().getCustomParam("tpks");
        if (pks != null) {
            QFilter filter1 = new QFilter("id", "in", (Object)Convert.toLong((Object)pks));
            filter.and(filter1);
        }
        QFilter[] filters = new QFilter[]{filter};
        String selectFields = "id,name,templatecatalog,number,group";
        DynamicObjectCollection queryResult = QueryServiceHelper.query((String)"eb_templateentity_bg", (String)selectFields, (QFilter[])filters, (String)"number asc,versionnumber asc");
        return queryResult;
    }

    private DynamicObjectCollection getTemplateDimension(Long temId) {
        QFilter filter = new QFilter("id", "=", (Object)temId);
        QFilter[] filters = new QFilter[]{filter};
        String selectFields = "viewpointmembentry.viewdimension.number as mnumber";
        return QueryServiceHelper.query((String)"eb_templateentity_bg", (String)selectFields, (QFilter[])filters);
    }

    private List<Map<String, String>> mergeTemplatecatalogList(String modelid) {
        DynamicObjectCollection doc = this.getTemplatecatalogList();
        ArrayList<Map<String, String>> clist = new ArrayList<Map<String, String>>();
        for (DynamicObject dd : doc) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", dd.getString("id"));
            map.put("name", dd.getString("name"));
            map.put("parentid", dd.getString("parent"));
            clist.add(map);
        }
        return clist;
    }

    private DynamicObjectCollection getTemplatecatalogList() {
        QFilter filter = new QFilter("model", "=", (Object)Convert.toLong((Object)this.getPageCache().get("KEY_MODEL_ID")));
        QFilter typeFilter = new QFilter("catalogtype", "!=", (Object)Character.valueOf(TemplateCatalogTypeEnum.WPCATALOG.getType()));
        QFilter[] filters = new QFilter[]{filter, typeFilter};
        String selectFields = "id,parent,name";
        String orderBys = "longnumber";
        return QueryServiceHelper.query((String)"eb_templatecatalog_bg", (String)selectFields, (QFilter[])filters, (String)orderBys);
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "viewcombo": {
                this.refreshBillList();
            }
        }
    }

    private void selectOrgMember(DynamicObjectCollection olddoc, DynamicObjectCollection newdoc) {
        IDataModel model = this.getModel();
        boolean isexist = false;
        HashSet<Integer> list = new HashSet<Integer>(16);
        EntryGrid eg = (EntryGrid)this.getControl(selectOrg_entityID);
        int[] rows = eg.getSelectRows();
        for (DynamicObject newone : newdoc) {
            isexist = false;
            for (DynamicObject oldone : olddoc) {
                if (!newone.getString("id").equals(oldone.get("oid")) || !newone.get("scope").equals(oldone.get("rangevalue"))) continue;
                isexist = true;
                break;
            }
            if (isexist) continue;
            int index = model.createNewEntryRow(selectOrg_entityID);
            model.setValue("entity", newone.get("name"), index);
            model.setValue("rangevalue", newone.get("scope"), index);
            model.setValue("oid", newone.get("id"), index);
            model.setValue("pid", newone.get("pid"), index);
            list.add(index);
        }
        for (Object t : (Object)rows) {
            list.add((int)t);
        }
        if (list.size() == 0) {
            return;
        }
        rows = new int[list.size()];
        int index = 0;
        for (Integer row : list) {
            rows[index++] = row;
        }
        eg.selectRows(rows, rows[0]);
    }

    private void deleteOrgMember() {
        EntryGrid eg = (EntryGrid)this.getControl(selectOrg_entityID);
        int[] row = eg.getEntryState().getSelectedRows();
        if (row.length < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u64cd\u4f5c\u6570\u636e\u884c\u3002", (String)"DistributionPlugin_17", (String)"epm-eb-budget", (Object[])new Object[0]));
            return;
        }
        this.getModel().deleteEntryRows(selectOrg_entityID, row);
        this.refreshBillList();
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        DynamicObjectCollection olddoc = this.getModel().getEntryEntity(selectOrg_entityID);
        switch (actionId) {
            case "selectmember": {
                if (e.getReturnData() == null) break;
                DynamicObjectCollection newdoc = (DynamicObjectCollection)e.getReturnData();
                this.selectOrgMember(olddoc, newdoc);
                this.refreshBillList();
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackId;
        super.confirmCallBack(e);
        switch (callBackId = e.getCallBackId()) {
            case "delete_comfirm": {
                if (!e.getResult().equals((Object)MessageBoxResult.Yes)) break;
                BillList billlist = (BillList)this.getControl("billlistap");
                ListSelectedRowCollection listrows = billlist.getSelectedRows();
                String selectFields = "id,template,template.name,entity,memrangdecombo,definedpropertyvalue,definedpropertyvalue.id,definedpropertyvalue.number";
                Object[] rows = listrows.getPrimaryKeyValues();
                QFilter filter = new QFilter("id", "in", (Object)rows);
                DynamicObjectCollection doc = QueryServiceHelper.query((String)"eb_distributionentity", (String)selectFields, (QFilter[])new QFilter[]{filter});
                ArrayList<Long> idlist = new ArrayList<Long>();
                HashSet<Long> removeTempidList = new HashSet<Long>();
                HashSet<Long> removeOrgidList = new HashSet<Long>();
                QFilter removeacct = null;
                List temids = new ArrayList();
                String oo = this.getPageCache().get("orgids");
                if (!StringUtils.isEmpty((CharSequence)oo)) {
                    temids = (List)SerializationUtils.fromJsonString((String)oo, List.class);
                }
                String orgmsg = "";
                for (DynamicObject d : doc) {
                    Long tid = d.getLong("template");
                    if (temids.contains(tid.toString())) {
                        if (!StringUtils.isEmpty((CharSequence)orgmsg)) continue;
                        orgmsg = ResManager.loadResFormat((String)"\u5df2\u8df3\u8fc7%1\u5728\u9690\u85cf\u7ef4\u7684\u62a5\u8868\u6a21\u677f", (String)"DistributionPlugin_18", (String)"epm-eb-budget", (Object[])new Object[]{this.getEntityName().getString("name")});
                        continue;
                    }
                    Long oid = d.getLong("entity");
                    Set oids = new HashSet();
                    if (0L != oid) {
                        oids = QueryMemberDetailsHelper.queryMemberIdsByRange((String)"epm_entitymembertree", (Long)oid, (int)d.getInt("memrangdecombo"), (String)this.getPageCache().get("KEY_MODEL_ID"), (DetailTypeEnum)DetailTypeEnum.TEMPLATEDIS);
                    }
                    idlist.add(d.getLong("id"));
                    removeTempidList.add(tid);
                    removeOrgidList.add(oid);
                    if (removeacct == null) {
                        removeacct = new QFilter("template", "=", (Object)tid).and("org", "in", oids);
                        continue;
                    }
                    removeacct.or(new QFilter("template", "=", (Object)tid).and("org", "in", oids));
                }
                if (idlist.size() > 0) {
                    try (TXHandle tx = TX.required((String)"bcm_actionDelete");){
                        try {
                            BusinessDataServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"eb_distributionentity"), (Object[])idlist.toArray());
                            DeleteServiceHelper.delete((String)"eb_intergration_entity", (QFilter[])new QFilter[]{removeacct});
                            this.deletePageSelcetRecord(removeOrgidList, removeTempidList);
                        }
                        catch (KDBizException e1) {
                            tx.markRollback();
                            throw e1;
                        }
                        catch (Throwable e1) {
                            tx.markRollback();
                            throw e1;
                        }
                    }
                }
                AppCacheServiceHelper.removeTemplateDispenseCache((String)MemberReader.findModelNumberById((Object)this.getPageCache().get("KEY_MODEL_ID")));
                this.refreshBillList();
                this.getView().showSuccessNotification(ResManager.loadResFormat((String)"\u53cd\u5206\u914d\u5b8c\u6210\u3002%1", (String)"DistributionPlugin_20", (String)"epm-eb-budget", (Object[])new Object[]{orgmsg}));
            }
        }
    }

    private DynamicObjectCollection findAllVersionNeedDelete(DynamicObjectCollection doc) {
        HashSet templateIds = Sets.newHashSet();
        ArrayListMultimap id2CommonInfo = ArrayListMultimap.create();
        doc.forEach(arg_0 -> DistributionPlugin.lambda$findAllVersionNeedDelete$3(templateIds, (Multimap)id2CommonInfo, arg_0));
        HashMap group2Id = Maps.newHashMap();
        try (DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)"kd.fi.bcm.formplugin.template.DistributionPlugin.findAllVersionNeedDelete(DynamicObjectCollection)", (String)"eb_templateentity_bg", (String)"id, group", (QFilter[])new QFilter("id", "in", (Object)templateIds).toArray(), null);){
            queryDataSet.forEach(q -> {
                Long groupId = q.getLong("group");
                Long id = q.getLong("id");
                group2Id.put(groupId, id);
            });
        }
        HashMap tpl2Origin = Maps.newHashMap();
        try (DataSet templateDs = QueryServiceHelper.queryDataSet((String)"kd.fi.bcm.formplugin.template.DistributionPlugin.findAllVersionNeedDelete(DynamicObjectCollection)", (String)"eb_templateentity_bg", (String)"id, group", (QFilter[])new QFilter("group", "in", group2Id.keySet()).toArray(), null);){
            templateDs.forEach(ds -> {
                Long groupId = ds.getLong("group");
                tpl2Origin.put(ds.getLong("id"), group2Id.get(groupId));
            });
        }
        DynamicObjectCollection distributeRecord = QueryServiceHelper.query((String)"eb_distributionentity", (String)"id,template,template.name,entity,memrangdecombo,definedpropertyvalue,definedpropertyvalue.id,definedpropertyvalue.number", (QFilter[])new QFilter("template", "in", tpl2Origin.keySet()).toArray(), null);
        distributeRecord.forEach(arg_0 -> DistributionPlugin.lambda$findAllVersionNeedDelete$6((Multimap)id2CommonInfo, tpl2Origin, doc, arg_0));
        return doc;
    }

    private void deletePageSelcetRecord(Set<Long> idlist, Set<Long> removeTempidList) {
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("template", "in", removeTempidList);
        qfBuilder.add("org", "in", idlist);
        DynamicObject[] dys = BusinessDataServiceHelper.load((String)"eb_pageselect", (String)"id", (QFilter[])qfBuilder.toArray());
        if (dys.length > 0) {
            Object[] ids = new Object[dys.length];
            for (int i = 0; i < dys.length; ++i) {
                ids[i] = dys[i].getLong("id");
            }
            BusinessDataServiceHelper.delete((IDataEntityType)dys[0].getDataEntityType(), (Object[])ids);
        }
    }

    private static /* synthetic */ void lambda$findAllVersionNeedDelete$6(Multimap id2CommonInfo, Map tpl2Origin, DynamicObjectCollection doc, DynamicObject d) {
        Long templateId = d.getLong("template");
        StringBuilder sBuild = new StringBuilder();
        sBuild.append(d.getLong("entity"));
        sBuild.append(d.getLong("memrangdecombo"));
        sBuild.append(d.getLong("definedpropertyvalue"));
        if (id2CommonInfo.get(tpl2Origin.get(templateId)).contains(sBuild.toString())) {
            doc.add((Object)d);
        }
    }

    private static /* synthetic */ void lambda$findAllVersionNeedDelete$3(Set templateIds, Multimap id2CommonInfo, DynamicObject d) {
        long templateId = d.getLong("template");
        templateIds.add(templateId);
        StringBuilder sBuild = new StringBuilder();
        sBuild.append(d.getLong("entity"));
        sBuild.append(d.getLong("memrangdecombo"));
        sBuild.append(d.getLong("definedpropertyvalue"));
        id2CommonInfo.put((Object)templateId, (Object)sBuild.toString());
    }
}

