/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.budget.formplugin.template;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.epm.eb.budget.formplugin.template.AbstractTemplateBasePlugin;
import kd.epm.eb.budget.formplugin.tree.AbstractTreeNode;
import kd.epm.eb.budget.formplugin.tree.ITreeNode;
import kd.epm.eb.common.ebcommon.common.Tuple;
import kd.epm.eb.common.ebcommon.common.enums.DimEntityNumEnum;
import kd.epm.eb.common.ebcommon.common.util.ObjectSerialUtil;
import kd.epm.eb.common.ebcommon.common.util.SpreadAreaUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.ebBusiness.serviceHelper.DimensionServiceHelper;
import kd.epm.eb.ebBusiness.serviceHelper.OlapServiceHelper;
import kd.epm.eb.ebSpread.domain.view.MultiAreaPositionsManager;
import kd.epm.eb.ebSpread.domain.view.SpreadManager;
import kd.epm.eb.ebSpread.domain.view.builder.PositionInfo;
import kd.epm.eb.ebSpread.domain.view.builder.dynamic.BasePointInfo;
import kd.epm.eb.ebSpread.domain.view.builder.dynamic.BasePointInnerLineInfo;
import kd.epm.eb.ebSpread.model.DimMember;
import kd.epm.eb.ebSpread.model.IDimension;

public class FloatMaintainPlugin
extends AbstractTemplateBasePlugin
implements RowClickEventListener {
    protected static final String entryentity = "entryentity";
    private static String modelcache = "modelcache";
    protected static String entityname = "entitynamecache";
    private static String dimensionname = "dimensionname";
    protected static String dimensionnumber = "dimensionnumber";
    protected static String dimenmemberid = "dimenmemberid";
    protected static String dimenmembernumber = "dimenmembernumber";
    protected static String numbercache = "number";
    protected static String spreadCache = "spread";
    private static String selectrow = "selectrow";
    private static String isparent = "isparent";
    private static String floatarea = "floatarea";
    private static String beginsize = "beginsize";
    private static String notfloatnumber = "notfloatnumber";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_cancel", "btn_save"});
        this.addItemClickListeners(new String[]{"toolbar"});
        EntryGrid entryGrid = (EntryGrid)this.getControl(entryentity);
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        int[] selected = ((EntryGrid)evt.getSource()).getSelectRows();
        this.getPageCache().put(selectrow, ObjectSerialUtil.toByteSerialized((Object)selected));
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.cacheParam();
        this.initCombox();
        this.refreshEntity();
    }

    private void cacheParam() {
        String defaultModelId = this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID").toString();
        String spread = (String)this.getView().getFormShowParameter().getCustomParam("KEY_SPREAD_MODEL");
        String area = (String)this.getView().getFormShowParameter().getCustomParam("selectarea");
        this.getPageCache().put(modelcache, defaultModelId);
        this.getPageCache().put(spreadCache, spread);
        this.getPageCache().put(numbercache, "1");
        this.getPageCache().put(beginsize, "0");
        this.getPageCache().put("selectarea", area);
    }

    private void initCombox() {
        ArrayList<String> arealist;
        ComboEdit areaedit = (ComboEdit)this.getControl("floatarea");
        ComboEdit dimenedit = (ComboEdit)this.getControl("dimension");
        Map<String, List<FloatInfo>> map = this.analyseSpeadInfo();
        ArrayList<ComboItem> areas = new ArrayList<ComboItem>(10);
        String defaultArea = this.getArea(map);
        if (defaultArea == null && !(arealist = new ArrayList<String>(map.keySet())).isEmpty()) {
            Collections.sort(arealist);
            defaultArea = (String)arealist.get(0);
        }
        int location = 0;
        int i = 0;
        for (String area : map.keySet()) {
            areas.add(new ComboItem(new LocaleString(area), area));
            if (area.equals(defaultArea)) {
                location = i;
            }
            ++i;
        }
        areaedit.setComboItems(areas);
        if (areas.size() > 0) {
            List<FloatInfo> infos = map.get(((ComboItem)areas.get(location)).getValue());
            ArrayList<ComboItem> dimens = new ArrayList<ComboItem>(infos.size());
            for (FloatInfo info : infos) {
                String dimenname = info.getDimension().getName();
                ComboItem dimen = new ComboItem(new LocaleString(dimenname), dimenname);
                dimens.add(dimen);
            }
            dimenedit.setComboItems(dimens);
            FloatInfo deFloatInfo = infos.get(0);
            String membername = deFloatInfo.getMember().getName();
            String position = deFloatInfo.getPosition() == 1 ? ResManager.loadKDString((String)"\u76f4\u63a5\u4e0b\u7ea7", (String)"FloatMaintainPlugin_0", (String)"epm-eb-budget", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5e73\u7ea7", (String)"FloatMaintainPlugin_1", (String)"epm-eb-budget", (Object[])new Object[0]);
            this.getModel().getDataEntity().set("floatarea", (Object)((ComboItem)areas.get(location)).getValue());
            this.getModel().getDataEntity().set("dimension", (Object)((ComboItem)dimens.get(0)).getValue());
            this.getModel().setValue("textfield", (Object)ResManager.loadResFormat((String)"\u65b0\u589e\u6210\u5458\u4f5c\u4e3a\u201c%1\u201d\u7684%2", (String)"FloatMaintainPlugin_2", (String)"epm-eb-budget", (Object[])new Object[]{membername, position}));
            this.getPageCache().put(floatarea, ((ComboItem)areas.get(0)).getValue());
            this.writeToCache(deFloatInfo);
        }
    }

    private String getArea(Map<String, List<FloatInfo>> map) {
        String select = this.getPageCache().get("selectarea");
        for (String area : map.keySet()) {
            ArrayList<String> temp = new ArrayList<String>();
            temp.add(area);
            if (!SpreadAreaUtil.Area_Contains((String)select, temp)) continue;
            return area;
        }
        return null;
    }

    private boolean checkSaved() {
        IDataModel model = this.getModel();
        DynamicObjectCollection rateColl = model.getEntryEntity(entryentity);
        int size = Integer.parseInt(this.getPageCache().get(beginsize));
        boolean allsaved = true;
        if (rateColl.size() != size) {
            allsaved = false;
        }
        if (!rateColl.isEmpty() && rateColl.size() == size) {
            for (DynamicObject row : rateColl) {
                if (!row.get("saved").equals("false")) continue;
                allsaved = false;
                break;
            }
        }
        return allsaved;
    }

    protected void refreshEntity() {
        this.getPageCache().put("ischange", "true");
        IDataModel model = this.getModel();
        model.getDataEntity(true);
        model.deleteEntryData(entryentity);
        Long selectid = IDUtils.toLong((Object)this.getPageCache().get(dimenmemberid));
        String dimennumber = this.getPageCache().get(dimenmembernumber);
        Long parentid = this.getParent(selectid);
        QFilter qf = new QFilter("parent", "=", (Object)parentid);
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"", (String)this.getPageCache().get(entityname), (String)"id,number,name,membersource,creator,modifier,createtime,modifytime", (QFilter[])new QFilter[]{qf}, null);
        int temp = 1;
        int rowsize = 0;
        for (DynamicObject dot : dcs) {
            if (dot.getInt("membersource") != 5) continue;
            ++rowsize;
        }
        if (!dcs.isEmpty()) {
            if (rowsize > 0) {
                this.getModel().batchCreateNewEntryRow(entryentity, rowsize);
            }
            int i = 0;
            for (DynamicObject dot : dcs) {
                String number = dot.getString("number");
                if (dot.getInt("membersource") == 5) {
                    model.setValue("number", (Object)number, i);
                    model.setValue("name", (Object)dot.getString("name"), i);
                    model.setValue("createrfield", dot.get("creator"), i);
                    model.setValue("modifierfield", dot.get("modifier"), i);
                    model.setValue("createdatefield", dot.get("createtime"), i);
                    model.setValue("modifydatefield", dot.get("modifytime"), i);
                    model.setValue("id", dot.get("id"), i);
                    model.setValue("saved", (Object)true, i);
                    this.getView().setEnable(Boolean.valueOf(false), i++, new String[]{"name"});
                }
                if (!number.startsWith(dimennumber)) continue;
                number = number.substring(dimennumber.length());
                String reg = "[0-9]{6}";
                Pattern p = Pattern.compile(reg);
                Matcher m = p.matcher(number);
                if (!m.matches()) continue;
                int x = Integer.parseInt(number) + 1;
                temp = x > temp ? x : temp;
            }
        }
        this.getPageCache().put(notfloatnumber, String.valueOf(dcs.size() - rowsize));
        this.getPageCache().put(numbercache, String.valueOf(temp));
        this.getPageCache().put(beginsize, String.valueOf(rowsize));
        this.getPageCache().remove("ischange");
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (this.getPageCache().get("ischange") != null) {
            return;
        }
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String name = e.getProperty().getName();
        if (name.equals("floatarea") || name.equals("dimension")) {
            Map<String, List<FloatInfo>> map = this.analyseSpeadInfo();
            String area = (String)model.getValue("floatarea");
            List<FloatInfo> infos = map.get(area);
            if (name.equals("floatarea")) {
                if (!this.checkSaved()) {
                    view.showConfirm(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u4fdd\u5b58\u7684\u64cd\u4f5c\uff0c\u662f\u5426\u4fdd\u5b58\uff1f", (String)"FloatMaintainPlugin_4", (String)"epm-eb-budget", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("change_areacomfirm", (IFormPlugin)this));
                } else {
                    this.refreshAreaInfo(area, infos);
                }
            }
            if (name.equals("dimension")) {
                String dimen = (String)model.getValue("dimension");
                if (!this.checkSaved()) {
                    view.showConfirm(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u4fdd\u5b58\u7684\u64cd\u4f5c\uff0c\u662f\u5426\u4fdd\u5b58\uff1f", (String)"FloatMaintainPlugin_4", (String)"epm-eb-budget", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("change_dimencomfirm", (IFormPlugin)this));
                } else {
                    this.refreshDimenInfo(infos, dimen);
                }
            }
        }
    }

    private void refreshAreaInfo(String area, List<FloatInfo> infos) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        ArrayList<ComboItem> dimens = new ArrayList<ComboItem>(infos.size());
        for (FloatInfo info : infos) {
            String dimenname = info.getDimension().getName();
            ComboItem dimenitem = new ComboItem(new LocaleString(dimenname), dimenname);
            dimens.add(dimenitem);
        }
        ComboEdit dimenedit = (ComboEdit)this.getControl("dimension");
        dimenedit.setComboItems(dimens);
        FloatInfo deFloatInfo = infos.get(0);
        String membername = deFloatInfo.getMember().getName();
        String position = deFloatInfo.getPosition() == 1 ? ResManager.loadKDString((String)"\u76f4\u63a5\u4e0b\u7ea7", (String)"FloatMaintainPlugin_0", (String)"epm-eb-budget", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5e73\u7ea7", (String)"FloatMaintainPlugin_1", (String)"epm-eb-budget", (Object[])new Object[0]);
        model.getDataEntity().set("dimension", (Object)((ComboItem)dimens.get(0)).getValue());
        model.setValue("textfield", (Object)ResManager.loadResFormat((String)"\u65b0\u589e\u6210\u5458\u4f5c\u4e3a\u201c%1\u201d\u7684%2", (String)"FloatMaintainPlugin_2", (String)"epm-eb-budget", (Object[])new Object[]{membername, position}));
        view.updateView("dimension");
        this.getPageCache().put(numbercache, "1");
        this.getPageCache().put(floatarea, area);
        this.writeToCache(deFloatInfo);
        this.refreshEntity();
    }

    protected void refreshDimenInfo(List<FloatInfo> infos, String dimen) {
        IDataModel model = this.getModel();
        for (FloatInfo info : infos) {
            String dimenname = info.getDimension().getName();
            if (!dimen.equals(dimenname)) continue;
            String membername = info.getMember().getName();
            String position = info.getPosition() == 1 ? ResManager.loadKDString((String)"\u76f4\u63a5\u4e0b\u7ea7", (String)"FloatMaintainPlugin_0", (String)"epm-eb-budget", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5e73\u7ea7", (String)"FloatMaintainPlugin_1", (String)"epm-eb-budget", (Object[])new Object[0]);
            model.setValue("textfield", (Object)ResManager.loadResFormat((String)"\u65b0\u589e\u6210\u5458\u4f5c\u4e3a\u201c%1\u201d\u7684%2", (String)"FloatMaintainPlugin_2", (String)"epm-eb-budget", (Object[])new Object[]{membername, position}));
            this.writeToCache(info);
        }
        this.refreshEntity();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        var3_3 = key = evt.getItemKey();
        var4_4 = -1;
        switch (var3_3.hashCode()) {
            case -1422495335: {
                if (!var3_3.equals("addrow")) break;
                var4_4 = 0;
                break;
            }
            case -2050735099: {
                if (!var3_3.equals("similaritycheck")) break;
                var4_4 = 1;
                break;
            }
            case -358690737: {
                if (!var3_3.equals("deleterow")) break;
                var4_4 = 2;
            }
        }
        switch (var4_4) {
            case 0: {
                row = this.getModel().createNewEntryRow("entryentity");
                temp = Integer.parseInt(this.getPageCache().get(FloatMaintainPlugin.numbercache));
                dimennumber = this.getPageCache().get(FloatMaintainPlugin.dimenmembernumber);
                uid = UserUtils.getUserId();
                now = TimeServiceHelper.now();
                this.getView().setEnable(Boolean.valueOf(true), row, new String[]{"name"});
                lock = DLock.create((String)("fi/bcm/" + this.getPageCache().get(FloatMaintainPlugin.dimenmemberid)));
                var11_12 = null;
                try {
                    lock.lock();
                    number = this.createNumber(dimennumber, temp);
                    this.getModel().setValue("number", (Object)number, row);
                    this.getModel().setValue("createrfield", (Object)uid, row);
                    this.getModel().setValue("createdatefield", (Object)now, row);
                    lock.unlock();
                }
                finally {
                    lock.unlock();
                }
                if (lock == null) break;
                if (var11_12 == null) ** GOTO lbl46
                try {
                    lock.close();
                }
                catch (Throwable var12_15) {
                    var11_12.addSuppressed(var12_15);
                }
                break;
lbl46:
                // 1 sources

                lock.close();
                break;
                catch (Throwable var12_16) {
                    try {
                        var11_12 = var12_16;
                        throw var12_16;
                    }
                    catch (Throwable var14_18) {
                        if (lock != null) {
                            if (var11_12 != null) {
                                try {
                                    lock.close();
                                }
                                catch (Throwable var15_19) {
                                    var11_12.addSuppressed(var15_19);
                                }
                            } else {
                                lock.close();
                            }
                        }
                        throw var14_18;
                    }
                }
            }
            case 1: {
                break;
            }
            case 2: {
                select = this.getPageCache().get(FloatMaintainPlugin.selectrow);
                if (StringUtils.isEmpty((CharSequence)select)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u64cd\u4f5c\u6570\u636e\u884c\u3002", (String)"FloatMaintainPlugin_5", (String)"epm-eb-budget", (Object[])new Object[0]));
                    return;
                }
                selected = (int[])ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(FloatMaintainPlugin.selectrow));
                if (selected.length <= 0 || selected[0] == -1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u64cd\u4f5c\u6570\u636e\u884c\u3002", (String)"FloatMaintainPlugin_5", (String)"epm-eb-budget", (Object[])new Object[0]));
                    return;
                }
                this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u522a\u9664\uff1f", (String)"FloatMaintainPlugin_6", (String)"epm-eb-budget", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("delete_comfirm", (IFormPlugin)this));
                break;
            }
        }
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control Control2 = (Control)evt.getSource();
        String key = Control2.getKey();
        if (key.equals("btn_save")) {
            this.save();
        } else if (key.equals("btn_cancel")) {
            if (this.checkNeedSave()) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u4fdd\u5b58\u7684\u64cd\u4f5c\uff0c\u662f\u5426\u9000\u51fa\uff1f", (String)"FloatMaintainPlugin_7", (String)"epm-eb-budget", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("cancel_comfirm", (IFormPlugin)this));
            } else {
                this.getView().close();
            }
        }
    }

    private boolean checkNeedSave() {
        DynamicObjectCollection rateColl = this.getModel().getEntryEntity(entryentity);
        int saved = 0;
        int notsaved = 0;
        for (DynamicObject row : rateColl) {
            if (row.get("saved").equals("true")) {
                ++saved;
                continue;
            }
            ++notsaved;
        }
        return notsaved != 0 || Integer.parseInt(this.getPageCache().get(beginsize)) - saved != 0;
    }

    private void save() {
        DynamicObjectCollection rateColl = this.getModel().getEntryEntity(entryentity);
        ArrayList<Integer> todel = new ArrayList<Integer>();
        int i = 0;
        for (DynamicObject row : rateColl) {
            if (row.get("name").equals(" ")) {
                todel.add(i);
            }
            ++i;
        }
        int[] del = new int[todel.size()];
        for (int k = 0; k < del.length; ++k) {
            del[k] = (Integer)todel.get(k);
        }
        this.getModel().deleteEntryRows(entryentity, del);
        int saved = 0;
        DynamicObjectCollection notSaveCol = new DynamicObjectCollection();
        DynamicObjectCollection notDel = new DynamicObjectCollection();
        rateColl = this.getModel().getEntryEntity(entryentity);
        for (DynamicObject row : rateColl) {
            if (row.get("saved").equals("true")) {
                ++saved;
                continue;
            }
            notSaveCol.add((Object)row);
        }
        if (notSaveCol.isEmpty() && Integer.parseInt(this.getPageCache().get(beginsize)) - saved == 0) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u4efb\u4f55\u65b0\u589e/\u5220\u9664\u6570\u636e\u3002", (String)"FloatMaintainPlugin_8", (String)"epm-eb-budget", (Object[])new Object[0]));
            return;
        }
        if (!this.checkName(notSaveCol)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u540d\u79f0\uff0c\u540d\u79f0\u91cd\u590d\u6216\u8005\u4e3a\u7a7a\u3002", (String)"FloatMaintainPlugin_9", (String)"epm-eb-budget", (Object[])new Object[0]));
            return;
        }
        Long selectid = IDUtils.toLong((Object)this.getPageCache().get(dimenmemberid));
        Long parentid = this.getParent(selectid);
        QFilter qf = new QFilter("parent", "=", (Object)parentid);
        if (Integer.parseInt(this.getPageCache().get(beginsize)) - saved != 0) {
            QFilter qf1 = new QFilter("membersource", "=", (Object)5);
            DynamicObjectCollection dcs = QueryServiceHelper.query((String)"", (String)this.getPageCache().get(entityname), (String)"id,number,name,creator,modifier,createtime,modifytime", (QFilter[])new QFilter[]{qf, qf1}, null);
            for (DynamicObject dot : dcs) {
                for (DynamicObject viewdot : rateColl) {
                    if (!dot.get("number").equals(viewdot.get("number"))) continue;
                    notDel.add((Object)dot);
                }
            }
            for (DynamicObject dot : notDel) {
                dcs.remove((Object)dot);
            }
        }
        if (!notSaveCol.isEmpty()) {
            this.saveDimension(Integer.parseInt(this.getPageCache().get(notfloatnumber)), saved, notSaveCol, parentid, selectid);
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\uff0c\u662f\u5426\u9000\u51fa\uff1f", (String)"FloatMaintainPlugin_10", (String)"epm-eb-budget", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("save_comfirm", (IFormPlugin)this));
    }

    private void saveDimension(int notfloat, int saved, DynamicObjectCollection col, Long parentid, Long selectid) {
        String memberid;
        ArrayList<DynamicObject> listobj = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> memberlist = new ArrayList<DynamicObject>();
        ArrayList<String> derivenumlist = new ArrayList<String>();
        ArrayList sharelist = new ArrayList();
        DynamicObject type = null;
        DynamicObject parent = BusinessDataServiceHelper.loadSingle((Object)parentid, (String)this.getPageCache().get(entityname));
        DynamicObject brother = BusinessDataServiceHelper.loadSingle((Object)selectid, (String)this.getPageCache().get(entityname));
        if (brother.get("parent") == null) {
            QFilter filter = new QFilter("parent.id", "=", brother.get("id"));
            DynamicObjectCollection collection = QueryServiceHelper.query((String)this.getPageCache().get(entityname), (String)"id", (QFilter[])new QFilter[]{filter});
            String id = ((DynamicObject)collection.get(0)).getString("id");
            brother = BusinessDataServiceHelper.loadSingle((Object)id, (String)this.getPageCache().get(entityname));
        }
        ArrayList<TreeNode> parentlist = new ArrayList<TreeNode>(10);
        TreeNode parentnode = new TreeNode(parent.getString("id"), "", "0");
        for (DynamicObject dot : col) {
            String cs1;
            String entity = this.getPageCache().get(entityname);
            String membertable = entity.contains(cs1 = "icmembertree") ? "epm_intercompanymember" : entity.substring(0, entity.length() - 4);
            DynamicObject member = BusinessDataServiceHelper.newDynamicObject((String)membertable);
            Date now = TimeServiceHelper.now();
            member.set("id", (Object)DBServiceHelper.genGlobalLongId());
            member.set("number", dot.get("number"));
            member.set("dimension", parent.get("dimension"));
            member.set("model", parent.get("model"));
            member.set("status", (Object)"C");
            member.set("enable", (Object)1);
            member.set("modifytime", (Object)now);
            member.set("createtime", dot.get("createdatefield"));
            DynamicObject user = BusinessDataServiceHelper.newDynamicObject((String)"bos_user");
            user.set("id", (Object)UserUtils.getUserId());
            member.set("creator", dot.get("createrfield"));
            member.set("modifier", (Object)user);
            type = member;
            memberlist.add(member);
            DynamicObject dynamicObject = (DynamicObject)OrmUtils.clone((Object)brother, (IDataEntityType)brother.getDataEntityType(), (boolean)true, (boolean)true);
            long id = DBServiceHelper.genGlobalLongId();
            dynamicObject.set("id", (Object)id);
            dynamicObject.set("member", (Object)member);
            dynamicObject.set("name", dot.get("name"));
            dynamicObject.set("longnumber", (Object)(parent.get("longnumber") + "!" + dot.get("number")));
            dynamicObject.set("number", dot.get("number"));
            dynamicObject.set("level", (Object)String.valueOf((Integer)parent.get("level") + 1));
            dynamicObject.set("dseq", (Object)String.valueOf(++saved + notfloat));
            dynamicObject.set("storagetype", brother.get("storagetype"));
            dynamicObject.set("creator", dot.get("createrfield"));
            dynamicObject.set("createtime", dot.get("createdatefield"));
            dynamicObject.set("modifier", (Object)user);
            dynamicObject.set("modifytime", (Object)now);
            dynamicObject.set("parent", (Object)parent);
            dynamicObject.set("isleaf", (Object)true);
            dynamicObject.set("membersource", (Object)5);
            String deriveNum = dynamicObject.getString("number");
            derivenumlist.add(deriveNum);
            TreeNode childnode = new TreeNode(String.valueOf(id), (String)dot.get("number"), "0");
            childnode.setData(dynamicObject);
            parentnode.addChild(childnode);
            listobj.add(dynamicObject);
        }
        try {
            memberid = ((DynamicObject)parent.get("member")).getString("id");
        }
        catch (Exception e) {
            memberid = null;
        }
        String modelid = this.getPageCache().get(modelcache);
        String dimennumber = this.getPageCache().get(dimensionnumber);
        QFilter qf2 = new QFilter("model.id", "=", (Object)modelid);
        DynamicObjectCollection dots = QueryServiceHelper.query((String)"", (String)"epm_dimension", (String)"id,number", (QFilter[])new QFilter[]{qf2}, null);
        String dimensionid = null;
        for (Object dot : dots) {
            if (!dot.getString("number").equals(dimennumber)) continue;
            dimensionid = dot.getString("id");
            break;
        }
        parentlist.add(parentnode);
        this.alterIsleaf(parentid, this.getPageCache().get(entityname));
        Map<Object, Object> id_copyfrom = new HashMap();
        if (memberid != null) {
            id_copyfrom = FloatMaintainPlugin.getallShareCopyNode(this.getPageCache().get(entityname), modelid, memberid, parentid, dimensionid);
        }
        for (Map.Entry entry : id_copyfrom.entrySet()) {
            String nodeid = (String)entry.getKey();
            TreeNode parentnodetemp = new TreeNode(nodeid, "", (String)entry.getValue());
            parentlist.add(parentnodetemp);
            this.alterIsleaf(IDUtils.toLong((Object)nodeid), this.getPageCache().get(entityname));
        }
        HashSet<String> neadsave = new HashSet<String>();
        neadsave.add(parentnode.getId());
        block16: do {
            for (TreeNode node : parentlist) {
                if (neadsave.contains(node.getCopyfrom())) {
                    ArrayList<DynamicObject> share = new ArrayList<DynamicObject>(listobj.size());
                    DynamicObject parenttemp = BusinessDataServiceHelper.loadSingle((Object)node.getId(), (String)this.getPageCache().get(entityname));
                    for (DynamicObject a : listobj) {
                        TreeNode treeNode;
                        DynamicObject nodetemp = (DynamicObject)OrmUtils.clone((Object)a, (IDataEntityType)a.getDataEntityType(), (boolean)true, (boolean)true);
                        nodetemp.set("parent", (Object)parenttemp);
                        nodetemp.set("id", (Object)DBServiceHelper.genGlobalLongId());
                        TreeNode copyfrom = this.search(parentlist, node.getCopyfrom());
                        if (copyfrom == null || (treeNode = (TreeNode)this.searchChild(copyfrom, a.getString("number"))) == null) continue;
                        nodetemp.set("longnumber", (Object)(parenttemp.get("longnumber") + "!" + a.get("number")));
                        nodetemp.set("storagetype", parenttemp.get("storagetype"));
                        nodetemp.set("level", (Object)String.valueOf((Integer)parenttemp.get("level") + 1));
                        nodetemp.set("share", (Object)1);
                        nodetemp.set("membersource", (Object)5);
                        TreeNode childnode = new TreeNode(a.getString("id"), a.getString("number"), treeNode.getId());
                        childnode.setData(nodetemp);
                        node.addChild(childnode);
                        share.add(nodetemp);
                    }
                    neadsave.add(node.getId());
                    sharelist.add(share);
                }
                if (!this.checkFinish(parentlist)) continue;
                continue block16;
            }
        } while (!this.checkFinish(parentlist));
        QFilter qFilter = new QFilter("id", "=", (Object)Long.valueOf(dimensionid));
        DynamicObject dimension = QueryServiceHelper.queryOne((String)"epm_dimension", (String)"number", (QFilter[])new QFilter[]{qFilter});
        QFilter modelFilterID = new QFilter("id", "=", (Object)Long.valueOf(this.getPageCache().get(modelcache)));
        DynamicObject model = QueryServiceHelper.queryOne((String)"epm_model", (String)"number", (QFilter[])new QFilter[]{modelFilterID});
        try (TXHandle th = TX.requiresNew();){
            try {
                if (type != null) {
                    BusinessDataServiceHelper.save((IDataEntityType)type.getDynamicObjectType(), (Object[])memberlist.toArray());
                }
                BusinessDataServiceHelper.save((IDataEntityType)parent.getDynamicObjectType(), (Object[])listobj.toArray());
                ArrayList<Tuple> list = new ArrayList<Tuple>(listobj.size());
                for (DynamicObject dynamicObject : listobj) {
                    list.add(Tuple.create((Object)dynamicObject.getString("number"), (Object)dynamicObject.getInt("aggoprt"), (Object)DimensionServiceHelper.getMemberNumber((String)DimEntityNumEnum.getEntieyNumByNumber((String)dimension.getString("number")), (Object)dynamicObject.get("parent.id"))));
                }
                if (!derivenumlist.isEmpty()) {
                    OlapServiceHelper.batchCreateDimensionMembers((String)model.getString("number"), (String)dimension.getString("number"), (Object[])derivenumlist.toArray());
                }
                for (List list2 : sharelist) {
                    BusinessDataServiceHelper.save((IDataEntityType)parent.getDynamicObjectType(), (Object[])list2.toArray());
                }
                this.getPageCache().put(beginsize, String.valueOf(saved));
                this.getModel().setValue("saved", (Object)"true");
                this.refreshEntity();
            }
            catch (Exception e) {
                th.markRollback();
                throw new KDBizException(e.getMessage());
            }
        }
    }

    private static Map<String, String> getallShareCopyNode(String entityname, String modelid, String memberid, Long selectid, String dimensionid) {
        QFilter qf2 = new QFilter("model.id", "=", (Object)modelid);
        QFilter qf1 = new QFilter("dimension.id", "=", (Object)dimensionid);
        QFilter qf3 = new QFilter("member.id", "=", (Object)memberid);
        QFilter qf4 = new QFilter("id", "!=", (Object)selectid);
        QFilter qf5 = new QFilter("share", "=", (Object)"1");
        QFilter[] qfs = new QFilter[]{qf1, qf2, qf3, qf4, qf5};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"", (String)entityname, (String)"id,copyfrom.id", (QFilter[])qfs, null);
        HashMap<String, String> map = new HashMap<String, String>();
        for (DynamicObject a : dcs) {
            map.put(String.valueOf(a.get(0)), String.valueOf(a.get(1)));
        }
        return map;
    }

    private void UpdateParentIsLeafByParent(long parentId, String entityName) {
        QFilter filter = new QFilter("parent", "=", (Object)parentId);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)entityName, (String)"number", (QFilter[])filters);
        if (dcs == null || dcs.size() <= 0) {
            DynamicObject dynamicObject = null;
            try {
                dynamicObject = BusinessDataServiceHelper.loadSingle((Object)parentId, (String)entityName);
            }
            catch (Exception e) {
                return;
            }
            dynamicObject.set("isleaf", (Object)1);
            BusinessDataServiceHelper.save((IDataEntityType)dynamicObject.getDataEntityType(), (Object[])new Object[]{dynamicObject});
        }
    }

    private TreeNode search(List<TreeNode> list, String copyfrom) {
        for (TreeNode node : list) {
            if (!node.getId().equals(copyfrom)) continue;
            return node;
        }
        return null;
    }

    private ITreeNode<DynamicObject> searchChild(TreeNode root, String name) {
        List children = root.getChildren();
        for (ITreeNode<DynamicObject> iTreeNode : children) {
            if (!iTreeNode.getName().equals(name)) continue;
            return iTreeNode;
        }
        return null;
    }

    private boolean checkFinish(List<TreeNode> list) {
        int x = 0;
        for (TreeNode node : list) {
            if (!node.getChildren().isEmpty()) continue;
            ++x;
        }
        return x == 0;
    }

    protected Long getParent(Long selectid) {
        String position = this.getPageCache().get(isparent);
        if (position.equals("1")) {
            return selectid;
        }
        DynamicObject dot = BusinessDataServiceHelper.loadSingle((Object)selectid, (String)this.getPageCache().get(entityname));
        return dot.getDynamicObject("parent").getLong("id");
    }

    private void alterIsleaf(Long parentselectid, String entityname) {
        DynamicObject dot = BusinessDataServiceHelper.loadSingle((Object)parentselectid, (String)entityname);
        boolean isleaf = dot.getBoolean("isleaf");
        if (isleaf) {
            dot.set("isleaf", (Object)"0");
            BusinessDataServiceHelper.save((IDataEntityType)dot.getDataEntityType(), (Object[])new Object[]{dot});
        }
    }

    protected Map<String, List<FloatInfo>> analyseSpeadInfo() {
        QFilter qFilter = new QFilter("model", "=", (Object)this.getModelId());
        DataSet ds = QueryServiceHelper.queryDataSet((String)this.getPluginName(), (String)"epm_dimension", (String)"name,number", (QFilter[])new QFilter[]{qFilter}, null);
        HashMap<String, String> dims = new HashMap<String, String>(16);
        while (ds.hasNext()) {
            Row row = ds.next();
            dims.put(row.getString("number"), row.getString("name"));
        }
        HashMap<String, List<FloatInfo>> map = new HashMap<String, List<FloatInfo>>();
        SpreadManager spreadManager = this.getSpreadModelFromSerial(this.getPageCache().get(spreadCache));
        MultiAreaPositionsManager pm = spreadManager.getAreaManager();
        Set pSet = pm.getPostionInfoSet();
        for (PositionInfo info : pSet) {
            List basePointInfos = info.getBasePoints();
            for (BasePointInfo bInfo : basePointInfos) {
                List bininfo = bInfo.getBasePointInnerLineInfo();
                String area = bInfo.getDynaRange();
                ArrayList<FloatInfo> infolist = new ArrayList<FloatInfo>();
                for (BasePointInnerLineInfo xx : bininfo) {
                    if (!xx.isFloated() || xx.getAddPositionEnum() == null) continue;
                    int position = xx.getAddPositionEnum().getVal();
                    String number = xx.getDimension().getNumber();
                    xx.getDimension().setName((String)dims.get(number));
                    infolist.add(new FloatInfo(position, xx.getDimension(), (DimMember)xx.getMemberAddOf()));
                }
                map.put(area, infolist);
            }
        }
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            if (((List)map.get(iterator.next())).size() != 0) continue;
            iterator.remove();
        }
        return map;
    }

    private void writeToCache(FloatInfo info) {
        this.getPageCache().put(entityname, info.getDimension().getUqCode());
        this.getPageCache().put(dimenmemberid, String.valueOf(info.getMember().getId()));
        this.getPageCache().put(isparent, String.valueOf(info.getPosition()));
        this.getPageCache().put(dimenmembernumber, info.getMember().getNumber());
        this.getPageCache().put(dimensionname, info.getDimension().getName());
        this.getPageCache().put(dimensionnumber, info.getDimension().getNumber());
    }

    protected String createNumber(String pnumber, int num) {
        String result = pnumber + String.format("%06d", num);
        QFilter qf = new QFilter("number", "=", (Object)result);
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"", (String)this.getPageCache().get(entityname), (String)"number", (QFilter[])new QFilter[]{qf}, null);
        while (!dcs.isEmpty()) {
            result = pnumber + String.format("%06d", ++num);
            qf = new QFilter("number", "=", (Object)result);
            dcs = QueryServiceHelper.query((String)"", (String)this.getPageCache().get(entityname), (String)"number", (QFilter[])new QFilter[]{qf}, null);
        }
        this.getPageCache().put(numbercache, String.valueOf(++num));
        return result;
    }

    public void confirmCallBack(MessageBoxClosedEvent mbce) {
        List<FloatInfo> infos;
        String area;
        Map<String, List<FloatInfo>> map;
        IDataModel model;
        super.confirmCallBack(mbce);
        String callBackId = mbce.getCallBackId();
        if (callBackId.equals("delete_comfirm") && MessageBoxResult.Yes.equals((Object)mbce.getResult())) {
            int[] selected = (int[])ObjectSerialUtil.deSerializedBytes((String)this.getPageCache().get(selectrow));
            this.getModel().deleteEntryRows(entryentity, selected);
        }
        if (callBackId.equals("change_areacomfirm") || callBackId.equals("change_dimencomfirm")) {
            if (MessageBoxResult.Yes.equals((Object)mbce.getResult())) {
                this.save();
            }
            model = this.getModel();
            map = this.analyseSpeadInfo();
            area = (String)model.getValue("floatarea");
            infos = map.get(area);
            if (callBackId.equals("change_areacomfirm")) {
                this.refreshAreaInfo(area, infos);
            } else {
                String dimen = (String)model.getValue("dimension");
                this.refreshDimenInfo(infos, dimen);
            }
        }
        if (callBackId.equals("save_comfirm") && MessageBoxResult.Yes.equals((Object)mbce.getResult())) {
            this.getView().close();
        } else if (callBackId.equals("save_comfirm") && MessageBoxResult.Cancel.equals((Object)mbce.getResult())) {
            model = this.getModel();
            map = this.analyseSpeadInfo();
            area = (String)model.getValue("floatarea");
            infos = map.get(area);
            this.refreshAreaInfo(area, infos);
        }
        if (callBackId.equals("cancel_comfirm") && MessageBoxResult.Yes.equals((Object)mbce.getResult())) {
            this.getView().close();
        }
    }

    private boolean checkName(DynamicObjectCollection col) {
        QFilter qFilter = new QFilter("model", "=", (Object)this.getPageCache().get(modelcache));
        String entityName = this.getPageCache().get(entityname);
        DynamicObjectCollection saved = QueryServiceHelper.query((String)entityName, (String)"name", (QFilter[])new QFilter[]{qFilter});
        HashSet<String> nameset = new HashSet<String>();
        ArrayList<String> names = new ArrayList<String>();
        for (DynamicObject dy : saved) {
            names.add(dy.getString("name"));
        }
        for (DynamicObject dot : col) {
            if (StringUtils.isEmpty((CharSequence)dot.getString("name"))) {
                return false;
            }
            nameset.add(dot.getString("name"));
        }
        for (DynamicObject dot : col) {
            if (!names.contains(dot.getString("name"))) continue;
            return false;
        }
        return nameset.size() == col.size();
    }

    public static class FloatInfo {
        private IDimension dimension;
        private int position;
        private DimMember member;

        public FloatInfo(int position, IDimension dimension, DimMember member) {
            this.position = position;
            this.dimension = dimension;
            this.member = member;
        }

        public IDimension getDimension() {
            return this.dimension;
        }

        public int getPosition() {
            return this.position;
        }

        public DimMember getMember() {
            return this.member;
        }
    }

    public static class TreeNode
    extends AbstractTreeNode<DynamicObject> {
        private static final long serialVersionUID = 1L;
        private String copyfrom;

        public TreeNode(String id, String name, String copyfrom) {
            super(id, name);
            this.copyfrom = copyfrom;
        }

        public String getCopyfrom() {
            return this.copyfrom;
        }
    }
}

