/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.budget.formplugin.template;

import com.alibaba.fastjson.JSONArray;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.budget.formplugin.template.model.TemplateCopyUpdateDomain;
import kd.epm.eb.budget.formplugin.template.util.TemplateCopyUpdateUtils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.ebcommon.enums.TemplateCatalogTypeEnum;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.ebBusiness.template.model.TemplateCatalog;

public class TemplateCopyUpdatePlugin
extends AbstractListPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit cataLog = (BasedataEdit)this.getControl("templatecatalog");
        BasedataEdit beginYear = (BasedataEdit)this.getControl("beginyear");
        BasedataEdit beginMonth = (BasedataEdit)this.getControl("beginmonth");
        BasedataEdit endYear = (BasedataEdit)this.getControl("endyear");
        BasedataEdit endMonth = (BasedataEdit)this.getControl("endmonth");
        cataLog.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        beginYear.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        beginMonth.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        endYear.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        endMonth.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        JSONArray templateIds = (JSONArray)this.getView().getFormShowParameter().getCustomParam("templateIds");
        List ids = templateIds.toJavaList(Long.class);
        DynamicObject[] templates = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"eb_templateentity_bg"));
        String realTime = null;
        for (DynamicObject template : templates) {
            String trueTime;
            String begintime = template.getString("begintime");
            String endtime = template.getString("endtime");
            String string = trueTime = StringUtils.isEmpty((String)endtime) ? begintime : endtime;
            if (!StringUtils.isNotEmpty((String)trueTime) || realTime != null && realTime.compareTo(trueTime) >= 0) continue;
            realTime = trueTime;
        }
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
        TemplateCopyUpdateUtils.doFillBeginEndTime(true, modelCache, realTime, realTime, this.getModel());
    }

    public long getModelId() {
        String modelId = (String)this.getView().getFormShowParameter().getCustomParam("modelId");
        if (StringUtils.isEmpty((String)modelId)) {
            return 0L;
        }
        return Long.parseLong(modelId);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key = beforeF7SelectEvent.getProperty().getName();
        if ("templatecatalog".equals(key)) {
            BasedataEdit source = (BasedataEdit)beforeF7SelectEvent.getSource();
            if (source.isF7Click()) {
                this.catalogedit();
                beforeF7SelectEvent.setCancel(true);
            } else {
                QFilter qf = new QFilter("model", "=", (Object)this.getModelId());
                ListShowParameter param = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                param.getListFilterParameter().setFilter(qf);
            }
        } else if ("beginyear".equals(key) || "beginmonth".equals(key) || "endyear".equals(key) || "endmonth".equals(key)) {
            QFilter qf = new QFilter("model", "=", (Object)this.getModelId());
            QFilter qf2 = new QFilter("isleaf", "=", (Object)true);
            ListShowParameter param = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            param.getListFilterParameter().setFilter(qf.and(qf2));
        }
    }

    protected void catalogedit() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setCaption(ResManager.loadKDString((String)"\u9884\u7b97\u6a21\u677f\u5206\u7c7b", (String)"TemplateEditPlugin_6", (String)"epm-eb-budget", (Object[])new Object[0]));
        showParameter.setFormId("eb_templatemove");
        showParameter.setCustomParam("KEY_MODEL_ID", (Object)String.valueOf(this.getModelId()));
        showParameter.setCustomParam("cataLogType", (Object)TemplateCatalogTypeEnum.getTemplateCalcog().recombine());
        showParameter.setCustomParam("listPageID", (Object)this.getView().getPageId());
        showParameter.setCustomParam("justforedit", (Object)"true");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "catalogedit");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String key = evt.getActionId();
        if ("catalogedit".equals(key)) {
            if (evt.getReturnData() == null) {
                return;
            }
            String newId = (String)evt.getReturnData();
            TemplateCatalog catalog = new TemplateCatalog();
            DynamicObject dyna = BusinessDataServiceHelper.loadSingle((Object)newId, (String)catalog.getDataEntityNumber());
            catalog.setId(dyna.getLong("id"));
            catalog.setName(dyna.getString("name"));
            this.getModel().getDataEntity().set("templatecatalog", (Object)dyna);
            this.getView().updateView("templatecatalog");
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("btnok".equals(key)) {
            DynamicObject templatecatalog;
            TemplateCopyUpdateDomain domain = new TemplateCopyUpdateDomain();
            DynamicObject beginyear = (DynamicObject)this.getModel().getValue("beginyear");
            DynamicObject beginmonth = (DynamicObject)this.getModel().getValue("beginmonth");
            if (beginyear == null || beginmonth == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5f00\u59cb\u671f\u95f4\u3002", (String)"TemplateEditPlugin_4", (String)"epm-eb-budget", (Object[])new Object[0]));
                return;
            }
            String begintime = beginyear.getString("number") + "/" + beginmonth.getString("number");
            domain.setBeginTime(begintime);
            DynamicObject endyear = (DynamicObject)this.getModel().getValue("endyear");
            DynamicObject endmonth = (DynamicObject)this.getModel().getValue("endmonth");
            if (endyear != null && endmonth != null) {
                String endtime = endyear.getString("number") + "/" + endmonth.getString("number");
                if (endtime.compareTo(begintime) < 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u671f\u95f4\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u5f00\u59cb\u671f\u95f4\u3002", (String)"TemplateEditPlugin_5", (String)"epm-eb-budget", (Object[])new Object[0]));
                    return;
                }
                domain.setEndTime(endtime);
            }
            if ((templatecatalog = (DynamicObject)this.getModel().getValue("templatecatalog")) != null) {
                TemplateCatalog templateCatalog = new TemplateCatalog();
                templateCatalog.setId(templatecatalog.getLong("id"));
                templateCatalog.setName(templatecatalog.getString("name"));
                templateCatalog.setNumber(templatecatalog.getString("number"));
                domain.setTemplateCatalog(templateCatalog);
            }
            this.getView().returnDataToParent((Object)domain);
            this.getView().close();
        }
    }
}

