/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.budget.formplugin.template;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.TextProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.budget.formplugin.database.DimSingleBasedataedit;
import kd.epm.eb.budget.formplugin.database.LTreeRListEdit;
import kd.epm.eb.budget.formplugin.template.AbstractTemplateBasePlugin;
import kd.epm.eb.budget.formplugin.util.ModelUtil;
import kd.epm.eb.budget.formplugin.util.SingleMemberF7Util;
import kd.epm.eb.budget.formplugin.util.TemplateDimSettingUtil;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.business.utils.CustomF7utils;
import kd.epm.eb.common.ebcommon.bg.AppUtil;
import kd.epm.eb.common.ebcommon.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.ebcommon.common.enums.DimTypesEnum;
import kd.epm.eb.common.ebcommon.common.enums.RangeEnum;
import kd.epm.eb.common.ebcommon.common.enums.TemplateUsageEnum;
import kd.epm.eb.common.ebcommon.common.util.DataEntityUtils;
import kd.epm.eb.common.enums.F7RangeTypeEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.ebBusiness.dimension.data.DimensionMsgCache;
import kd.epm.eb.ebBusiness.exchangeRate.ExchageRateServiceHelper;
import kd.epm.eb.ebBusiness.permission.cache.MembRangeItem;
import kd.epm.eb.ebBusiness.serviceHelper.DimensionServiceHelper;
import kd.epm.eb.ebBusiness.serviceHelper.QueryDimensionServiceHelper;
import kd.epm.eb.ebBusiness.template.model.AreaRangeEntry;
import kd.epm.eb.ebBusiness.template.model.ColDimensionEntry;
import kd.epm.eb.ebBusiness.template.model.MembProperty;
import kd.epm.eb.ebBusiness.template.model.Member;
import kd.epm.eb.ebBusiness.template.model.PageDimPropEntry;
import kd.epm.eb.ebBusiness.template.model.PageDimensionEntry;
import kd.epm.eb.ebBusiness.template.model.RowDimensionEntry;
import kd.epm.eb.ebBusiness.template.model.TemplateModel;
import kd.epm.eb.ebBusiness.template.model.ViewPointDimensionEntry;

public class TemplateDimSettingPlugin
extends AbstractTemplateBasePlugin
implements ClickListener {
    private static final String VIEWPANEL = "panel1";
    private static final String PAGEPANEL = "panel2";
    private static final String RANKPANEL = "panel3";
    private static final String ALL = "allPoint";
    private static final String ISEDIT = "edit";
    private static final String VIEWSIGN = "s";
    private static final String PAGESIGN = "";
    private static final String RANKSIGN = "t";
    private static final String PAGEPOR = "p";
    private static final Set<String> RptUnUseDim = Sets.newHashSet((Object[])new String[]{DimTypesEnum.ENTITY.getNumber(), DimTypesEnum.PROCESS.getNumber(), DimTypesEnum.AUDITTRIAL.getNumber()});
    private DimensionMsgCache dims;

    @Override
    public void initialize() {
        super.initialize();
        this.bindCtrlMapping();
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{"btn_confirm", "btn_cancel"});
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getPageCache().put("change", "true");
        IPageCache pageCache = (IPageCache)this.getView().getParentView().getService(IPageCache.class);
        boolean hastemp = QueryServiceHelper.exists((String)"eb_templateentity_bg", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)this.getTemplateModel().getId())});
        if (hastemp && !"true".equals(pageCache.get("rankinit"))) {
            ArrayList list = new ArrayList(10);
            List<DynamicObject> rank = this.getRankDim();
            for (DynamicObject obj : rank) {
                if (DimTypesEnum.INTERCOMPANY.getNumber().equals(obj.getString("number")) && !QueryDimensionServiceHelper.checkIcEnt((long)this.getTemplateModel().getModelId())) continue;
                HashMap<String, String> map = new HashMap<String, String>();
                map = new HashMap();
                map.put("name", obj.getString("name"));
                map.put("entity", obj.getString("membermodel"));
                map.put("number", obj.getString("number"));
                String seq = QueryDimensionServiceHelper.getMsgByNumber((long)this.template.getModelId(), (String)obj.getString("number")).getString("dseq");
                map.put("seq", seq);
                map.put("sign", this.buildSign(obj.getString("membermodel"), obj.getString("number"), VIEWSIGN));
                map.put("panel", VIEWPANEL);
                list.add(map);
            }
            pageCache.put("rank", SerializationUtils.toJsonString(list));
            pageCache.put("rankinit", "true");
        }
        if (this.isEditState()) {
            TemplateModel template = this.getTemplateModel();
            this.loadPagePointEntry(template);
            this.loadRankPointEntry2(template);
            this.loadViewPointEntry(template);
            this.bindCtrlMapping();
            this.setRankValue();
            this.initData();
            this.setDraggable();
            this.hideEbAppCtrl(template.getModelId());
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u597d\u9884\u7f6e\u6210\u5458\uff0c\u914d\u7f6e\u9ed8\u8ba4\u503c\u65f6\u7f3a\u5c11\u6210\u5458\u4e86\u3002", (String)"TemplateDimSettingPlugin_0", (String)"epm-eb-budget", (Object[])new Object[0]));
        }
    }

    private void setDefaultValue() {
        List<Map<String, String>> list = this.getPointEntry();
        ApplicationTypeEnum app = ModelUtil.queryApp(this.getView());
        for (Map<String, String> map : list) {
            if (VIEWPANEL.equals(map.get("panel"))) {
                long id;
                if ("epm_scenemembertree".equals(map.get("entity"))) {
                    id = QueryDimensionServiceHelper.getMemberMsgByNumber((long)this.getTemplateModel().getModelId(), (String)DimensionServiceHelper.getDefaultScenarioNumber((long)this.getTemplateModel().getModelId(), (long)0L, (ApplicationTypeEnum)ModelUtil.queryApp(this.getView())), (String)"epm_scenemembertree").getLong("id");
                    this.getModel().setValue(map.get("sign"), (Object)id);
                    this.getPageCache().put(map.get("sign"), String.valueOf(id));
                }
                if ("epm_icmembertree".equals(map.get("entity"))) {
                    id = QueryDimensionServiceHelper.getMemberMsgByNumber((long)this.getTemplateModel().getModelId(), (String)"ICNone", (String)"epm_icmembertree").getLong("id");
                    this.getModel().setValue(map.get("sign"), (Object)id);
                    this.getPageCache().put(map.get("sign"), String.valueOf(id));
                }
                if ((ApplicationTypeEnum.BGMD == app || ApplicationTypeEnum.BGM == app) && "epm_datatypemembertree".equals(map.get("entity"))) {
                    id = QueryDimensionServiceHelper.getMemberMsgByNumber((long)this.getTemplateModel().getModelId(), (String)"Budget", (String)"epm_datatypemembertree").getLong("id");
                    this.getModel().setValue(map.get("sign"), (Object)id);
                    this.getPageCache().put(map.get("sign"), String.valueOf(id));
                    continue;
                }
                try {
                    long dimid = Long.parseLong(QueryDimensionServiceHelper.getDimIdByNumber((String)map.get("number"), (String)String.valueOf(this.getTemplateModel().getModelId())));
                    long id2 = QueryDimensionServiceHelper.getDefautDimMemId((long)dimid, (String)map.get("entity"));
                    this.getModel().setValue(map.get("sign"), (Object)id2);
                    this.getPageCache().put(map.get("sign"), String.valueOf(id2));
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                    this.getView().showErrorNotification(ResManager.loadResFormat((String)"\u7ef4\u5ea6\u6210\u5458%1\u7684\u9ed8\u8ba4\u6210\u5458\u4e0d\u5b58\u5728", (String)"TemplateDimSettingPlugin_1", (String)"epm-eb-budget", (Object[])new Object[]{map.get("number")}));
                }
                continue;
            }
            if (!PAGEPANEL.equals(map.get("panel"))) continue;
            if ("epm_scenemembertree".equals(map.get("entity"))) {
                this.initDefaultValue(map.get("sign"), map.get("entity"), DimensionServiceHelper.getDefaultScenarioNumber((long)this.getModelId(), (long)0L), "10");
            }
            if ("epm_yearmembertree".equals(map.get("entity"))) {
                this.initDefaultValue(map.get("sign"), map.get("entity"), "AllYear", "40");
            }
            if ("epm_periodmembertree".equals(map.get("entity"))) {
                this.initDefaultValue(map.get("sign"), map.get("entity"), "Period", "40");
            }
            if ("epm_currencymembertree".equals(map.get("entity"))) {
                this.initDefaultValue(map.get("sign"), map.get("entity"), "Currency", "40");
            }
            if ("epm_audittrialmembertree".equals(map.get("entity"))) {
                this.initDefaultValue(map.get("sign"), map.get("entity"), "EntityInput", "10");
            }
            if ("eb_rulemembertree".equals(map.get("entity"))) {
                this.initDefaultValue(map.get("sign"), map.get("entity"), "PRCGAAP", "10");
            }
            if ("epm_processmembertree".equals(map.get("entity"))) {
                String usage = this.getTemplateModel().getUsage();
                String number = usage.equals("1") ? "IRpt" : "Process";
                String scope = usage.endsWith("1") ? "10" : "40";
                this.initDefaultValue(map.get("sign"), map.get("entity"), number, scope);
            }
            if (!"eb_datasortmembertree".equals(map.get("entity"))) continue;
            this.initDefaultValue(map.get("sign"), map.get("entity"), "Actual", "10");
        }
    }

    private void initDefaultValue(String sign, String entity, String number, String scope) {
        DynamicObject obj = QueryDimensionServiceHelper.getMemberMsgByNumber((long)this.getTemplateModel().getModelId(), (String)number, (String)entity);
        if (obj == null && "MRpt".equals(number)) {
            number = "Scenario";
            obj = QueryDimensionServiceHelper.getMemberMsgByNumber((long)this.getTemplateModel().getModelId(), (String)number, (String)entity);
        }
        if (obj == null) {
            return;
        }
        long id = obj.getLong("id");
        Object[] ids = new Object[]{id};
        this.getModel().setValue(sign, (Object)ids);
        ArrayList li = new ArrayList();
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("id", String.valueOf(id));
        m.put("scope", scope);
        m.put("number", obj.getString("number"));
        m.put("name", obj.getString("name"));
        li.add(m);
        this.getPageCache().put(sign, SerializationUtils.toJsonString(li));
    }

    private String buildSign(String entity, String number, String sign) {
        return (entity + "!" + number + "!" + sign).toLowerCase();
    }

    private String getRealEntity(String sign) {
        return sign.split("!")[0];
    }

    private String getrealNumber(String sign) {
        return sign.split("!")[1];
    }

    private boolean checkSign(String key, String sign) {
        return key.startsWith("bcm") && key.endsWith("!" + sign);
    }

    private void loadViewPointEntry(TemplateModel template) {
        String seq;
        HashMap<String, String> map;
        FlexPanelAp pageviewpanel = new FlexPanelAp();
        pageviewpanel.setKey("viewpanel");
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>(10);
        ArrayList<String> numberlist = new ArrayList<String>();
        if (template.getViewPointDimensionEntries().size() > 0) {
            int size = template.getViewPointDimensionEntries().size();
            for (int i = 0; i < size; ++i) {
                ViewPointDimensionEntry vp = (ViewPointDimensionEntry)template.getViewPointDimensionEntries().get(i);
                if (!QueryDimensionServiceHelper.checkNumber((String)vp.getDimension().getNumber(), (String)String.valueOf(template.getModelId())) || DimTypesEnum.INTERCOMPANY.getNumber().equals(vp.getDimension().getNumber()) && !QueryDimensionServiceHelper.checkIcEnt((long)this.getTemplateModel().getModelId())) continue;
                map = new HashMap();
                map.put("name", vp.getDimension().getName());
                map.put("entity", vp.getDimension().getMemberEntityNumber());
                map.put("number", vp.getDimension().getNumber());
                seq = QueryDimensionServiceHelper.getMsgByNumber((long)template.getModelId(), (String)vp.getDimension().getNumber()).getString("dseq");
                map.put("seq", seq);
                map.put("sign", this.buildSign(vp.getDimension().getMemberEntityNumber(), vp.getDimension().getNumber(), VIEWSIGN));
                map.put("panel", VIEWPANEL);
                list.add(map);
                numberlist.add(vp.getDimension().getNumber());
            }
        }
        List<DynamicObject> rank = this.getOthersDim();
        for (DynamicObject obj : rank) {
            if (DimTypesEnum.INTERCOMPANY.getNumber().equals(obj.getString("number")) && !QueryDimensionServiceHelper.checkIcEnt((long)this.getTemplateModel().getModelId()) || numberlist.contains(obj.getString("number"))) continue;
            map = new HashMap<String, String>();
            map = new HashMap();
            map.put("name", obj.getString("name"));
            map.put("entity", obj.getString("membermodel"));
            map.put("number", obj.getString("number"));
            seq = QueryDimensionServiceHelper.getMsgByNumber((long)template.getModelId(), (String)obj.getString("number")).getString("dseq");
            map.put("seq", seq);
            map.put("sign", this.buildSign(obj.getString("membermodel"), obj.getString("number"), VIEWSIGN));
            map.put("panel", VIEWPANEL);
            list.add(map);
        }
        List<Map<String, String>> allp = this.getPointEntry();
        allp.addAll(list);
        this.getPageCache().put(ALL, SerializationUtils.toJsonString(allp));
        this.addF7Items(pageviewpanel, list, true, false);
        this.updateControlMetadata("viewpanel", pageviewpanel.createControl());
        StringBuilder sb = new StringBuilder();
        for (ControlAp ap : pageviewpanel.getItems()) {
            if (!this.checkControlKeyPrefix(this.getView(), ap.getKey())) continue;
            sb.append(ap.getKey()).append(';');
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        this.getPageCache().put("viewFields", sb.toString());
    }

    private void loadPagePointEntry(TemplateModel template) {
        String seq;
        HashMap<String, String> map;
        PageDimensionEntry pe;
        int i;
        int size;
        FlexPanelAp pageviewpanel = new FlexPanelAp();
        pageviewpanel.setKey("pagepanel");
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        if (template.getPageDimensionEntries().size() > 0) {
            size = template.getPageDimensionEntries().size();
            for (i = 0; i < size; ++i) {
                pe = (PageDimensionEntry)template.getPageDimensionEntries().get(i);
                if (!QueryDimensionServiceHelper.checkNumber((String)pe.getDimension().getNumber(), (String)String.valueOf(template.getModelId()))) continue;
                map = new HashMap<String, String>();
                map.put("name", pe.getDimension().getName());
                map.put("number", pe.getDimension().getNumber());
                map.put("entity", pe.getDimension().getMemberEntityNumber());
                seq = QueryDimensionServiceHelper.getMsgByNumber((long)template.getModelId(), (String)pe.getDimension().getNumber()).getString("dseq");
                map.put("seq", seq);
                map.put("sign", this.buildSign(pe.getDimension().getMemberEntityNumber(), pe.getDimension().getNumber(), PAGESIGN));
                map.put("panel", PAGEPANEL);
                list.add(map);
            }
        }
        if (template.getPagePropEntries().size() > 0) {
            size = template.getPagePropEntries().size();
            for (i = 0; i < size; ++i) {
                pe = (PageDimPropEntry)template.getPagePropEntries().get(i);
                if (!QueryDimensionServiceHelper.checkNumber((String)pe.getDimension().getNumber(), (String)String.valueOf(template.getModelId()))) continue;
                map = new HashMap();
                map.put("name", pe.getDimension().getName());
                map.put("number", pe.getDimension().getNumber());
                map.put("entity", pe.getDimension().getMemberEntityNumber());
                seq = QueryDimensionServiceHelper.getMsgByNumber((long)template.getModelId(), (String)pe.getDimension().getNumber()).getString("dseq");
                map.put("seq", seq);
                map.put("sign", this.buildSign(pe.getDimension().getMemberEntityNumber(), pe.getDimension().getNumber(), PAGEPOR));
                map.put("panel", PAGEPANEL);
                list.add(map);
            }
        }
        this.getPageCache().put(ALL, SerializationUtils.toJsonString(list));
        this.addF7Items(pageviewpanel, list, false, false);
        this.updateControlMetadata("pagepanel", pageviewpanel.createControl());
        StringBuilder sb = new StringBuilder();
        for (ControlAp ap : pageviewpanel.getItems()) {
            if (!this.checkControlKeyPrefix(this.getView(), ap.getKey())) continue;
            sb.append(ap.getKey()).append(';');
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        this.getPageCache().put("pageFields", sb.toString());
    }

    private void initData() {
        String sign;
        String number;
        String entity;
        HashMap<String, String> map;
        StringBuilder sb;
        int i;
        int size;
        if (this.template.getViewPointDimensionEntries().size() > 0) {
            size = this.template.getViewPointDimensionEntries().size();
            for (i = 0; i < size; ++i) {
                if (!QueryDimensionServiceHelper.checkNumber((String)((ViewPointDimensionEntry)this.template.getViewPointDimensionEntries().get(i)).getDimension().getNumber(), (String)String.valueOf(this.template.getModelId())) || DimTypesEnum.INTERCOMPANY.getNumber().equals(((ViewPointDimensionEntry)this.template.getViewPointDimensionEntries().get(i)).getDimension().getNumber()) && !QueryDimensionServiceHelper.checkIcEnt((long)this.getTemplateModel().getModelId())) continue;
                String entity2 = ((ViewPointDimensionEntry)this.template.getViewPointDimensionEntries().get(i)).getDimension().getMemberEntityNumber();
                String number2 = ((ViewPointDimensionEntry)this.template.getViewPointDimensionEntries().get(i)).getDimension().getNumber();
                String cacheKey = this.buildSign(entity2, number2, VIEWSIGN);
                this.getModel().setValue(cacheKey, (Object)((ViewPointDimensionEntry)this.template.getViewPointDimensionEntries().get(i)).getMember().getId());
                this.getPageCache().put(cacheKey, String.valueOf(((ViewPointDimensionEntry)this.template.getViewPointDimensionEntries().get(i)).getMember().getId()));
            }
        }
        if (this.template.getPageDimensionEntries().size() > 0) {
            size = this.template.getPageDimensionEntries().size();
            for (i = 0; i < size; ++i) {
                if (!QueryDimensionServiceHelper.checkNumber((String)((PageDimensionEntry)this.template.getPageDimensionEntries().get(i)).getDimension().getNumber(), (String)String.valueOf(this.template.getModelId()))) continue;
                List members = ((PageDimensionEntry)this.template.getPageDimensionEntries().get(i)).getMembers();
                ArrayList list = new ArrayList(members.size());
                sb = new StringBuilder();
                for (int j = 0; j < members.size(); ++j) {
                    map = new HashMap<String, String>();
                    map.put("id", String.valueOf(((Member)members.get(j)).getId()));
                    map.put("scope", String.valueOf(((Member)members.get(j)).getScope()));
                    map.put("number", String.valueOf(((Member)members.get(j)).getNumber()));
                    map.put("name", String.valueOf(((Member)members.get(j)).getName()));
                    list.add(map);
                    this.buildPageViewShowName(sb, String.valueOf(((Member)members.get(j)).getName()), ((Member)members.get(j)).getScope());
                }
                entity = ((PageDimensionEntry)this.template.getPageDimensionEntries().get(i)).getDimension().getMemberEntityNumber();
                number = ((PageDimensionEntry)this.template.getPageDimensionEntries().get(i)).getDimension().getNumber();
                sign = this.buildSign(entity, number, PAGESIGN);
                if (StringUtils.isNotEmpty((String)sb.toString())) {
                    this.getModel().setValue(sign, (Object)sb.substring(0, sb.length() - 1));
                }
                this.getPageCache().put(sign, SerializationUtils.toJsonString(list));
            }
        }
        if (this.template.getPagePropEntries().size() > 0) {
            size = this.template.getPagePropEntries().size();
            for (i = 0; i < size; ++i) {
                if (!QueryDimensionServiceHelper.checkNumber((String)((PageDimPropEntry)this.template.getPagePropEntries().get(i)).getDimension().getNumber(), (String)String.valueOf(this.template.getModelId()))) continue;
                ArrayList list = new ArrayList(10);
                List members = ((PageDimPropEntry)this.template.getPagePropEntries().get(i)).getAllMembProperties();
                sb = new StringBuilder();
                for (int j = 0; j < members.size(); ++j) {
                    map = new HashMap();
                    map.put("id", String.valueOf(((MembProperty)members.get(j)).getId()));
                    map.put("scope", String.valueOf(((MembProperty)members.get(j)).getScope()));
                    String number3 = ((MembProperty)members.get(j)).getCustomProperty().getNumber() + ":" + ((MembProperty)members.get(j)).getNumber();
                    map.put("number", number3);
                    String name = ((MembProperty)members.get(j)).getCustomProperty().getName() + ":" + ((MembProperty)members.get(j)).getName();
                    map.put("name", name);
                    map.put("pid", String.valueOf(((MembProperty)members.get(j)).getCustomProperty().getId()));
                    list.add(map);
                    this.buildPageViewShowName(sb, name, ((MembProperty)members.get(j)).getScope());
                }
                entity = ((PageDimPropEntry)this.template.getPagePropEntries().get(i)).getDimension().getMemberEntityNumber();
                number = ((PageDimPropEntry)this.template.getPagePropEntries().get(i)).getDimension().getNumber();
                sign = this.buildSign(entity, number, PAGEPOR);
                if (StringUtils.isNotEmpty((String)sb.toString())) {
                    this.getModel().setValue(sign, (Object)sb.substring(0, sb.length() - 1));
                }
                this.getPageCache().put(sign, SerializationUtils.toJsonString(list));
            }
        }
    }

    private boolean isEditState() {
        boolean is = false;
        is = this.getTemplateModel().getPageDimensionEntries().size() > 0 || this.getTemplateModel().getViewPointDimensionEntries().size() > 0;
        IPageCache pageCache = (IPageCache)this.getView().getParentView().getService(IPageCache.class);
        if (pageCache.get(ISEDIT) == null) {
            return is;
        }
        return pageCache.get(ISEDIT).equals("1");
    }

    private void setDraggable() {
        this.getControl(VIEWPANEL).setDroppable(true);
        this.getControl(PAGEPANEL).setDroppable(true);
        this.getControl(RANKPANEL).setDroppable(true);
        List ap = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(ALL), List.class);
        for (Map map : ap) {
            this.getControl((String)map.get("sign")).setDraggable(true);
            this.getControl((String)map.get("sign")).setDroppable(true);
        }
        if (ApplicationTypeEnum.RPT == ModelUtil.queryApp(this.getView())) {
            String seq;
            for (ViewPointDimensionEntry a : this.template.getViewPointDimensionEntries()) {
                if (!RptUnUseDim.contains(a.getDimension().getNumber())) continue;
                seq = QueryDimensionServiceHelper.getMsgByNumber((long)this.template.getModelId(), (String)a.getDimension().getNumber()).getString("dseq");
                this.getView().setVisible(Boolean.valueOf(false), new String[]{this.buildSign(a.getDimension().getMemberEntityNumber(), a.getDimension().getNumber(), VIEWSIGN)});
            }
            for (ViewPointDimensionEntry a : this.template.getPageDimensionEntries()) {
                if (!RptUnUseDim.contains(a.getDimension().getNumber())) continue;
                seq = QueryDimensionServiceHelper.getMsgByNumber((long)this.template.getModelId(), (String)a.getDimension().getNumber()).getString("dseq");
                this.getView().setVisible(Boolean.valueOf(false), new String[]{this.buildSign(a.getDimension().getMemberEntityNumber(), a.getDimension().getNumber(), PAGESIGN)});
            }
        }
    }

    private boolean isForWeaveAndProcessAuditTrail(Map<String, String> map) {
        String usage = this.getTemplateModel().getUsage();
        return TemplateUsageEnum.FORWEAVE.getValue().equals(usage) && (map.get("number").equals(DimTypesEnum.PROCESS.getNumber()) || map.get("number").equals(DimTypesEnum.AUDITTRIAL.getNumber()));
    }

    private void bindCtrlMapping(String item) {
        String f7MapFields = this.getPageCache().get(item + "Fields");
        if (StringUtils.isEmpty((String)f7MapFields)) {
            return;
        }
        String[] fields = f7MapFields.split(";");
        MainEntityType mainEntityType = this.getModel().getDataEntityType();
        DataEntityPropertyCollection props = mainEntityType.getProperties();
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)mainEntityType.getName(), (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        EntityMetadata entityMeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)formMeta.getEntityId(), (MetaCategory)MetaCategory.Entity);
        for (String field : fields) {
            String basedataEntity = this.getRealEntity(field);
            String dimnumber = this.getrealNumber(field);
            if (props.containsKey((Object)field)) continue;
            this.addTextFieldToMainEntity((Container)this.getControl(item + "panel"), mainEntityType, entityMeta, this.buildSign(basedataEntity, dimnumber, PAGESIGN), this.getModel(), this.getView());
            this.addTextFieldToMainEntity((Container)this.getControl(item + "panel"), mainEntityType, entityMeta, this.buildSign(basedataEntity, dimnumber, PAGEPOR), this.getModel(), this.getView());
            DataEntityUtils.addBasedataF7ToMainEntity((Container)((Container)this.getControl(item + "panel")), (MainEntityType)mainEntityType, (String)this.buildSign(basedataEntity, dimnumber, VIEWSIGN), (String)basedataEntity, (IDataModel)this.getModel(), (IFormView)this.getView());
            this.addTextFieldToMainEntity((Container)this.getControl(item + "panel"), mainEntityType, entityMeta, this.buildSign(basedataEntity, dimnumber, RANKSIGN), this.getModel(), this.getView());
            String name = this.getDims().getName(dimnumber);
            this.getModel().setValue(this.buildSign(basedataEntity, dimnumber, RANKSIGN), (Object)name);
        }
    }

    private void bindCtrlMapping() {
        this.bindCtrlMapping("view");
        this.bindCtrlMapping("page");
        this.bindCtrlMapping("rank");
    }

    @Override
    public void onGetControl(OnGetControlArgs e) {
        String ctrlKey = e.getKey();
        if (this.checkControlKeyPrefix(this.getView(), ctrlKey) && !ctrlKey.endsWith("_id")) {
            if (ctrlKey.endsWith(VIEWSIGN)) {
                String basedataEntity = this.getRealEntity(ctrlKey);
                DimSingleBasedataedit bsEdit = basedataEntity.startsWith("epm_icmembertree") ? new LTreeRListEdit() : new DimSingleBasedataedit();
                bsEdit.setF7Name(ctrlKey);
                bsEdit.setModelId(this.getTemplateModel().getModelId());
                bsEdit.setEntity(basedataEntity);
                bsEdit.setKey(ctrlKey);
                bsEdit.setModel(this.getModel());
                bsEdit.setView(this.getView());
                bsEdit.setDisplayProp("name");
                String number = this.getrealNumber(ctrlKey);
                int seq = this.getDims().getSeq(number);
                bsEdit.setF7Value(seq);
                bsEdit.setF7title(ResManager.loadResFormat((String)"\u6210\u5458\u9009\u62e9 - %1", (String)"TemplateDimSettingPlugin_4", (String)"epm-eb-budget", (Object[])new Object[]{this.getDims().getName(number)}));
                Long dimId = this.getDims().getDimId(number);
                QFilter dimFilter = new QFilter("dimension", "=", (Object)dimId);
                QFilter permissonFilter = SingleMemberF7Util.getPermissonFilter(basedataEntity, dimId, this.getTemplateModel().getModelId());
                ExchageRateServiceHelper.delExchangeRatePlanFilter((QFilter)dimFilter, (String)basedataEntity);
                if (e.getKey().startsWith("epm_audittrialmembertree") && this.isEPM()) {
                    dimFilter.and(new QFilter("number", "not in", Arrays.asList("ADJE", "CWP", "ManualJournal", "AutoJournal")));
                }
                bsEdit.setQFilter(dimFilter.and(permissonFilter));
                bsEdit.setDimId(dimId);
                bsEdit.addBeforeF7SelectListener(this);
                bsEdit.setFieldKey(ctrlKey);
                bsEdit.setDraggable(true);
                bsEdit.setDroppable(true);
                bsEdit.setFormId("eb_singlesharef7");
                e.setControl((Control)bsEdit);
            } else if (ctrlKey.endsWith(RANKSIGN)) {
                TextEdit edit = new TextEdit();
                edit.setKey(ctrlKey);
                edit.setModel(this.getModel());
                edit.setView(this.getView());
                edit.setDraggable(true);
                edit.setDroppable(true);
                e.setControl((Control)edit);
            } else {
                TextEdit edit = new TextEdit();
                edit.setKey(ctrlKey);
                edit.setModel(this.getModel());
                edit.setView(this.getView());
                edit.setDraggable(true);
                edit.setDroppable(true);
                edit.addClickListener((ClickListener)this);
                e.setControl((Control)edit);
                this.getPageCache().put("KEY_MODEL_ID", String.valueOf(this.getTemplateModel().getModelId()));
            }
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent p0) {
        super.beforeF7Select(p0);
    }

    private void initPageViewPanel(String item) {
        FlexPanelAp pageviewpanel = new FlexPanelAp();
        pageviewpanel.setKey(item + "panel");
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        switch (item) {
            case "view": {
                for (Map<String, String> map : this.getPointEntry()) {
                    if (!VIEWPANEL.equals(map.get("panel"))) continue;
                    list.add(map);
                }
                this.addF7Items(pageviewpanel, list, true, false);
                break;
            }
            case "page": {
                for (Map<String, String> map : this.getPointEntry()) {
                    if (!PAGEPANEL.equals(map.get("panel"))) continue;
                    list.add(map);
                }
                this.addF7Items(pageviewpanel, list, false, false);
                break;
            }
            case "rank": {
                for (Map<String, String> map : this.getPointEntry()) {
                    if (!RANKPANEL.equals(map.get("panel"))) continue;
                    list.add(map);
                }
                this.addF7Items(pageviewpanel, list, true, true);
                break;
            }
        }
        this.updateControlMetadata(item + "panel", pageviewpanel.createControl());
        StringBuilder sb = new StringBuilder();
        for (ControlAp ap : pageviewpanel.getItems()) {
            if (!this.checkControlKeyPrefix(this.getView(), ap.getKey())) continue;
            sb.append(ap.getKey()).append(';');
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        this.getPageCache().put(item + "Fields", sb.toString());
    }

    private void addF7Items(FlexPanelAp pageviewpanel, List<Map<String, String>> list, boolean single, boolean lock) {
        for (Map<String, String> e : list) {
            TextField basedata;
            EntryFieldAp f7Field = new EntryFieldAp();
            f7Field.setName(new LocaleString(e.get("name")));
            f7Field.setKey(e.get("sign"));
            if ("epm_entitymembertree".equals(e.get("entity")) && PAGEPANEL.equals(e.get("panel")) && !AppUtil.isBGMD((String)this.getBizAppId())) {
                f7Field.setLock("new,edit,view");
            }
            if (single && !lock) {
                f7Field.setLabelDirection("true");
                basedata = new BasedataField();
                if (basedata.getClass().equals(BasedataField.class)) {
                    basedata.setViewDetail(false);
                    basedata.setBaseEntityId(e.get("entity"));
                }
                f7Field.setField((Field)basedata);
            } else {
                f7Field.setShowTitle(false);
                basedata = new TextField();
                if (!lock) {
                    basedata.setEditStyle(1);
                    f7Field.setShowTitle(true);
                }
                f7Field.setField((Field)basedata);
            }
            f7Field.setFieldTextAlign("center");
            f7Field.setTextAlign("left");
            f7Field.setHeight(new LocaleString("40px"));
            f7Field.setFontSize(14);
            Style style = new Style();
            Margin margin = new Margin();
            Padding padding = new Padding();
            padding.setRight("14px");
            padding.setLeft("14px");
            padding.setTop("14px");
            margin.setLeft("30px");
            margin.setRight("1px");
            margin.setTop("1px");
            margin.setBottom("10px");
            style.setMargin(margin);
            style.setPadding(padding);
            f7Field.setStyle(style);
            f7Field.setLabelDirection("h");
            f7Field.setFireUpdEvt(true);
            f7Field.setQuickAddNew(false);
            pageviewpanel.getItems().add(f7Field);
        }
    }

    private List<Map<String, String>> getPointEntry() {
        return TemplateDimSettingUtil.getPointEntry(this, this.getTemplateModel(), false);
    }

    @Override
    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (this.checkControlKeyPrefix(this.getView(), key)) {
            int paramvalue = 0;
            List<Map<String, String>> list = this.getPointEntry();
            for (Map<String, String> map : list) {
                if (!key.equals(map.get("sign"))) continue;
                paramvalue = Integer.parseInt(map.get("seq"));
            }
            IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
            Long modelId = IDUtils.toLong((Object)pageCache.get("KEY_MODEL_ID"));
            DynamicObject dimension = QueryDimensionServiceHelper.getDimByDseq((int)paramvalue, (Long)modelId);
            MemberF7Parameter f8Param = NewF7Utils.multipleF8((Long)modelId, (DynamicObject)dimension, (String)DynamicObjectCollection.class.getName());
            f8Param.setRangeType(F7RangeTypeEnum.DEFAULT);
            f8Param.setViewSign(key);
            CustomF7utils.loadCacheSelectedData((IFormView)this.getView(), (MemberF7Parameter)f8Param);
            NewF7Utils.openF8((IFormView)this.getView(), (MemberF7Parameter)f8Param, (CloseCallBack)new CloseCallBack((IFormPlugin)this, key));
        }
    }

    private void getSceneMems(Set<Long> scenarioids, String temp) {
        Map docs;
        List list2 = (List)SerializationUtils.fromJsonString((String)temp, List.class);
        QFilter qf = null;
        for (Map scinfo : list2) {
            MembRangeItem item = new MembRangeItem("epm_scenemembertree", Long.valueOf((String)scinfo.get("id")), (String)scinfo.get("number"), RangeEnum.getRangeByVal((int)Integer.parseInt((String)scinfo.get("scope"))), StringUtils.isNotEmpty((String)((String)scinfo.get("pid"))), (Object)this.getModelId());
            if (qf == null) {
                qf = item.buildFilterByScope();
                continue;
            }
            qf.or(item.buildFilterByScope());
        }
        if (qf != null) {
            qf.and("model", "=", (Object)this.getModelId());
        }
        if ((docs = BusinessDataServiceHelper.loadFromCache((String)"epm_scenemembertree", (String)"id", (QFilter[])new QFilter[]{qf})) != null) {
            for (Object id : docs.keySet()) {
                scenarioids.add((Long)id);
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (this.checkControlKeyPrefix(this.getView(), actionId)) {
            DynamicObjectCollection doc = (DynamicObjectCollection)closedCallBackEvent.getReturnData();
            if (doc == null && ThreadCache.get((Object)"okbtn") == null) {
                return;
            }
            if (doc != null && doc.size() > 0) {
                StringBuilder sb = new StringBuilder();
                ArrayList list = new ArrayList(doc.size());
                for (DynamicObject dynamicObject : doc) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("id", dynamicObject.get("id").toString());
                    map.put("scope", dynamicObject.get("scope").toString());
                    map.put("number", dynamicObject.get("number").toString());
                    map.put("name", dynamicObject.get("name").toString());
                    map.put("pid", dynamicObject.get("pid").toString());
                    this.buildPageViewShowName(sb, dynamicObject.get("name").toString(), dynamicObject.getInt("scope"));
                    list.add(map);
                }
                if (sb.length() > 0) {
                    this.getModel().setValue(actionId, (Object)sb.substring(0, sb.length() - 1));
                }
                this.getPageCache().put(actionId, SerializationUtils.toJsonString(list));
            } else {
                this.getModel().setValue(actionId, (Object)" ");
                this.getPageCache().put(actionId, null);
            }
        }
    }

    private void buildPageViewShowName(StringBuilder sb, String name, int val) {
        if (RangeEnum.getRangeByVal((int)val) == RangeEnum.VALUE_10) {
            sb.append(name).append(",");
        } else {
            sb.append(name).append(ResManager.loadKDString((String)"\u7684", (String)"TemplateDimSettingPlugin_5", (String)"epm-eb-budget", (Object[])new Object[0])).append(RangeEnum.getRangeByVal((int)val).getName()).append(',');
        }
    }

    @Override
    public void getEntityType(GetEntityTypeEventArgs e) {
        try {
            e.setNewEntityType((MainEntityType)e.getOriginalEntityType().clone());
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void customEvent(CustomEventArgs e) {
        String name = e.getEventName();
        String appid = this.getView().getFormShowParameter().getAppId();
        if ("drop".equals(name)) {
            String eventArgs = e.getEventArgs();
            String[] msg = this.translateMessage(eventArgs);
            String target = msg[0];
            String source = msg[1];
            if (this.checkControlKeyPrefix(this.getView(), source)) {
                boolean hasSplit = (Boolean)this.getFormCustomParam("hasSplit");
                if (source.endsWith(RANKSIGN) && hasSplit) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u884c\u5217\u7ef4\u5df2\u7ecf\u8bbe\u7f6e\uff0c\u4e0d\u5141\u8bb8\u6539\u52a8\u884c\u5217\u7ef4\u3002", (String)"TemplateDimSettingPlugin_6", (String)"epm-eb-budget", (Object[])new Object[0]));
                    return;
                }
                boolean clear = this.interChange(target, source);
                if (clear) {
                    this.getPageCache().put(source, null);
                    this.getPageCache().put("change", "false");
                    this.getModel().setValue("changesign", (Object)PAGESIGN);
                    this.getPageCache().put("change", "true");
                    if (!AppUtil.isEpmAppId((String)appid) && source.startsWith("epm_scenemembertree") && !RANKPANEL.equals(target) && !target.endsWith(RANKSIGN)) {
                        this.clearPeriodValue();
                    }
                }
                this.initPageViewPanel("view");
                this.initPageViewPanel("page");
                this.initPageViewPanel("rank");
                this.setRankValue();
                this.setDraggable();
                this.getModel().setDataChanged(true);
            }
        }
    }

    private String[] translateMessage(String text) {
        text = text.substring(1, text.length() - 1);
        String[] msg = text.split(",");
        for (int i = 0; i < msg.length; ++i) {
            msg[i] = msg[i].substring(1, msg[i].length() - 1);
        }
        return msg;
    }

    private boolean interChange(String target, String source) {
        Map<String, String> map;
        boolean clear = false;
        String sourcePanel = PAGESIGN;
        int num = -1;
        List<Map<String, String>> list = this.getPointEntry();
        for (int i = 0; i < list.size(); ++i) {
            map = list.get(i);
            if (!source.equals(map.get("sign"))) continue;
            sourcePanel = map.get("panel");
            num = i;
            break;
        }
        if (!(StringUtils.isEmpty((String)sourcePanel) || StringUtils.isEmpty((String)target) || sourcePanel.equals(target))) {
            boolean hasSplit;
            if (VIEWPANEL.equals(target) || PAGEPANEL.equals(target) || RANKPANEL.equals(target)) {
                hasSplit = (Boolean)this.getFormCustomParam("hasSplit");
                if (hasSplit && RANKPANEL.equals(target)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u884c\u5217\u7ef4\u5df2\u7ecf\u8bbe\u7f6e\uff0c\u4e0d\u5141\u8bb8\u6539\u52a8\u884c\u5217\u7ef4\u3002", (String)"TemplateDimSettingPlugin_6", (String)"epm-eb-budget", (Object[])new Object[0]));
                    return false;
                }
                map = list.get(num);
                map.put("panel", target);
                list.remove(num);
                list.add(map);
                clear = true;
                this.getModel().setValue(source, null);
                if (source.endsWith(PAGEPOR)) {
                    this.getModel().setValue(source.substring(0, source.length() - 1), null);
                }
                this.getView().updateView(source);
                String sign = map.get("sign");
                sign = this.handelSign(sign, map.get("panel"));
                map.put("sign", sign);
            } else if (this.checkControlKeyPrefix(this.getView(), target)) {
                hasSplit = (Boolean)this.getFormCustomParam("hasSplit");
                if (target.endsWith(RANKSIGN) && hasSplit) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u884c\u5217\u7ef4\u5df2\u7ecf\u8bbe\u7f6e\uff0c\u4e0d\u5141\u8bb8\u6539\u52a8\u884c\u5217\u7ef4\u3002", (String)"TemplateDimSettingPlugin_6", (String)"epm-eb-budget", (Object[])new Object[0]));
                    return false;
                }
                int tarumn = -1;
                int sornum = -1;
                for (int i = 0; i < list.size(); ++i) {
                    Map<String, String> map2 = list.get(i);
                    if (target.equals(map2.get("sign"))) {
                        tarumn = i;
                    }
                    if (!source.equals(map2.get("sign"))) continue;
                    sornum = i;
                }
                if (tarumn == -1 || sornum == -1) {
                    return false;
                }
                Map<String, String> tar = list.get(tarumn);
                Map<String, String> sor = list.get(sornum);
                if (!tar.get("panel").equals(sor.get("panel"))) {
                    sor.put("panel", tar.get("panel"));
                    clear = true;
                    this.getModel().setValue(source, null);
                    if (source.endsWith(PAGEPOR)) {
                        this.getModel().setValue(source.substring(0, source.length() - 1), null);
                    }
                    this.getView().updateView(source);
                    String sign = sor.get("sign");
                    sign = this.handelSign(sign, sor.get("panel"));
                    sor.put("sign", sign);
                }
                list.remove(sor);
                list.add(tarumn, sor);
            }
        }
        this.getPageCache().put(ALL, SerializationUtils.toJsonString(list));
        return clear;
    }

    private String handelSign(String sign, String panel) {
        String string = sign = sign.endsWith(VIEWSIGN) || sign.endsWith(RANKSIGN) || sign.endsWith(PAGEPOR) ? sign.substring(0, sign.length() - 1) : sign;
        if (panel.equals(VIEWPANEL)) {
            sign = sign + VIEWSIGN;
        } else if (panel.equals(RANKPANEL)) {
            sign = sign + RANKSIGN;
        }
        return sign;
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        String objectId;
        super.afterDoOperation(eventArgs);
        switch (objectId = eventArgs.getOperateKey()) {
            case "confirm": {
                if (eventArgs.getOperationResult().isSuccess()) {
                    ThreadCache.put((Object)"unbind", (Object)true);
                    this.handlePageDataAndClose(true);
                    break;
                }
                List errorInfos = eventArgs.getOperationResult().getAllErrorOrValidateInfo();
                this.getView().showErrorNotification(((IOperateInfo)errorInfos.get(0)).getMessage());
            }
        }
    }

    private void handlePageDataAndClose(boolean reFillBackAreaRangeData) {
        if (this.fillBack2TemplateModel(reFillBackAreaRangeData)) {
            this.returnDataToParent(this.getTemplateModel());
            this.getView().close();
        }
    }

    private boolean fillBack2TemplateModel(boolean reFillBackAreaRangeData) {
        boolean is = TemplateDimSettingUtil.fillBack2TemplateModel(this, this.getTemplateModel(), false);
        return is;
    }

    private List<DynamicObject> getOthersDim() {
        ArrayList numbers = new ArrayList();
        List<Map<String, String>> allp = this.getPointEntry();
        allp.forEach(p -> numbers.add(p.get("number")));
        List rank = QueryDimensionServiceHelper.getOthersDim(numbers, (Long)this.getTemplateModel().getModelId());
        for (DynamicObject obj : rank) {
            if (!DimTypesEnum.INTERCOMPANY.getNumber().equals(obj.getString("number")) || QueryDimensionServiceHelper.checkIcEnt((long)this.getTemplateModel().getModelId())) continue;
            rank.remove(obj);
            break;
        }
        return rank;
    }

    private void loadRankPointEntry2(TemplateModel template) {
        FlexPanelAp pageviewpanel = new FlexPanelAp();
        pageviewpanel.setKey("rankpanel");
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        IPageCache pageCache = (IPageCache)this.getView().getParentView().getService(IPageCache.class);
        if (template.getAreaRangeEntries().size() != 0 && ((AreaRangeEntry)template.getAreaRangeEntries().get(0)).getColDimEntries().size() != 0) {
            String seq;
            HashMap<String, String> map;
            ColDimensionEntry vp;
            int i;
            int size = ((AreaRangeEntry)template.getAreaRangeEntries().get(0)).getColDimEntries().size();
            for (i = 0; i < size; ++i) {
                vp = (ColDimensionEntry)((AreaRangeEntry)template.getAreaRangeEntries().get(0)).getColDimEntries().get(i);
                if (!QueryDimensionServiceHelper.checkNumber((String)vp.getDimension().getNumber(), (String)String.valueOf(template.getModelId())) || DimTypesEnum.INTERCOMPANY.getNumber().equals(vp.getDimension().getNumber()) && !QueryDimensionServiceHelper.checkIcEnt((long)this.getTemplateModel().getModelId())) continue;
                map = new HashMap<String, String>();
                map.put("name", vp.getDimension().getName());
                map.put("number", vp.getDimension().getNumber());
                map.put("entity", vp.getDimension().getMemberEntityNumber());
                seq = QueryDimensionServiceHelper.getMsgByNumber((long)template.getModelId(), (String)vp.getDimension().getNumber()).getString("dseq");
                map.put("seq", seq);
                map.put("sign", this.buildSign(vp.getDimension().getMemberEntityNumber(), vp.getDimension().getNumber(), RANKSIGN));
                map.put("panel", RANKPANEL);
                list.add(map);
            }
            size = ((AreaRangeEntry)template.getAreaRangeEntries().get(0)).getRowDimEntries().size();
            for (i = 0; i < size; ++i) {
                vp = (RowDimensionEntry)((AreaRangeEntry)template.getAreaRangeEntries().get(0)).getRowDimEntries().get(i);
                if (!QueryDimensionServiceHelper.checkNumber((String)vp.getDimension().getNumber(), (String)String.valueOf(template.getModelId())) || DimTypesEnum.INTERCOMPANY.getNumber().equals(vp.getDimension().getNumber()) && !QueryDimensionServiceHelper.checkIcEnt((long)this.getTemplateModel().getModelId())) continue;
                map = new HashMap();
                map.put("name", vp.getDimension().getName());
                map.put("number", vp.getDimension().getNumber());
                map.put("entity", vp.getDimension().getMemberEntityNumber());
                seq = QueryDimensionServiceHelper.getMsgByNumber((long)template.getModelId(), (String)vp.getDimension().getNumber()).getString("dseq");
                map.put("seq", seq);
                map.put("sign", this.buildSign(vp.getDimension().getMemberEntityNumber(), vp.getDimension().getNumber(), RANKSIGN));
                map.put("panel", RANKPANEL);
                list.add(map);
            }
        } else if (pageCache.get("rank") != null) {
            List ranklist = (List)SerializationUtils.fromJsonString((String)pageCache.get("rank"), List.class);
            ranklist.forEach(p -> {
                HashMap map = new HashMap();
                map = new HashMap();
                map.put("name", p.get("name"));
                map.put("number", p.get("number"));
                map.put("entity", p.get("entity"));
                String seq = QueryDimensionServiceHelper.getMsgByNumber((long)template.getModelId(), (String)((String)p.get("number"))).getString("dseq");
                map.put("seq", seq);
                map.put("sign", this.buildSign((String)p.get("entity"), (String)p.get("number"), RANKSIGN));
                map.put("panel", RANKPANEL);
                list.add(map);
            });
        } else {
            HashMap<String, String> map = new HashMap<String, String>();
            map = new HashMap();
            map.put("name", DimTypesEnum.ACCOUNT.getName());
            map.put("number", DimTypesEnum.ACCOUNT.getNumber());
            map.put("entity", "epm_accountmembertree");
            String seq = QueryDimensionServiceHelper.getMsgByNumber((long)template.getModelId(), (String)DimTypesEnum.ACCOUNT.getNumber()).getString("dseq");
            map.put("seq", seq);
            map.put("sign", this.buildSign("epm_accountmembertree", DimTypesEnum.ACCOUNT.getNumber(), RANKSIGN));
            map.put("panel", RANKPANEL);
            list.add(map);
            map = new HashMap();
            map.put("name", DimTypesEnum.CHANGETYPE.getName());
            map.put("number", DimTypesEnum.CHANGETYPE.getNumber());
            map.put("entity", "epm_changetypemembertree");
            seq = QueryDimensionServiceHelper.getMsgByNumber((long)template.getModelId(), (String)DimTypesEnum.CHANGETYPE.getNumber()).getString("dseq");
            map.put("seq", seq);
            map.put("sign", this.buildSign("epm_changetypemembertree", DimTypesEnum.CHANGETYPE.getNumber(), RANKSIGN));
            map.put("panel", RANKPANEL);
            list.add(map);
        }
        List<Map<String, String>> allp = this.getPointEntry();
        allp.addAll(list);
        this.getPageCache().put(ALL, SerializationUtils.toJsonString(allp));
        this.addF7Items(pageviewpanel, list, true, true);
        this.updateControlMetadata("rankpanel", pageviewpanel.createControl());
        StringBuilder sb = new StringBuilder();
        for (ControlAp ap : pageviewpanel.getItems()) {
            if (!this.checkControlKeyPrefix(this.getView(), ap.getKey())) continue;
            sb.append(ap.getKey()).append(';');
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        this.getPageCache().put("rankFields", sb.toString());
    }

    private void updateControlMetadata(String key, Map<String, Object> ctl) {
        ArrayList<Object> paras = new ArrayList<Object>(2);
        paras.add(key);
        if (ctl.get("items") == null) {
            ctl.put("items", new Object[0]);
        }
        paras.add(ctl);
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("updateControlMetadata", paras);
    }

    private void addTextFieldToMainEntity(Container targContainer, MainEntityType targetEntity, EntityMetadata entityMeta, String fieldKey, IDataModel model, IFormView view) {
        TextProp fieldprop = new TextProp();
        fieldprop.setName(fieldKey);
        targetEntity.addProperty((DynamicProperty)fieldprop);
        if (targContainer instanceof EntryGrid) {
            ((EntryProp)targetEntity.getProperties().get((Object)targContainer.getKey()))._collectionItemPropertyType.addProperty((DynamicProperty)fieldprop);
        }
        FieldAp field = new FieldAp();
        field.setName(new LocaleString(fieldKey));
        field.setKey(fieldKey);
        TextField textFiled = new TextField();
        textFiled.setKey(fieldKey);
        textFiled.setEntityMetadata(entityMeta);
        entityMeta.getItems().add(textFiled);
        field.setField((Field)textFiled);
        FieldEdit control = field.buildRuntimeControl();
        control.setModel(model);
        control.setView(view);
        targContainer.getItems().add(control);
    }

    private void setRankValue() {
        List<Map<String, String>> list = this.getPointEntry();
        for (Map<String, String> map : list) {
            if (!map.get("sign").endsWith(RANKSIGN)) continue;
            this.getModel().setValue(map.get("sign"), (Object)map.get("name"));
            this.getView().setEnable(Boolean.valueOf(false), new String[]{map.get("sign")});
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String appid = this.getView().getFormShowParameter().getAppId();
        String realctr = e.getProperty().getName();
        if (this.checkControlKeyPrefix(this.getView(), realctr) && !realctr.endsWith("_id") && realctr.endsWith(VIEWSIGN)) {
            DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (newValue == null) {
                this.getPageCache().put(realctr, null);
            } else {
                this.getPageCache().put(realctr, newValue.getString("id"));
            }
        }
        if (this.checkSign(realctr, PAGESIGN)) {
            e.getChangeSet()[0].getNewValue();
            if (e.getChangeSet()[0].getNewValue() instanceof String && StringUtils.isEmpty((String)((String)e.getChangeSet()[0].getNewValue()))) {
                this.getPageCache().put(realctr, null);
            }
            if (!AppUtil.isEpmAppId((String)appid) && realctr.startsWith("epmscenemembertree")) {
                this.clearPeriodValue();
            }
        }
    }

    private void clearPeriodValue() {
        List<Map<String, String>> list = this.getPointEntry();
        list.forEach(p -> {
            String sign = (String)p.get("sign");
            if (sign.startsWith("epm_periodmembertree")) {
                this.getModel().setValue(sign, null);
                this.getPageCache().put(sign, null);
                this.getView().updateView(sign);
                return;
            }
        });
    }

    private int getMsgMapBySign(String sign) {
        List<Map<String, String>> list = this.getPointEntry();
        int m = -1;
        for (int i = 0; i < list.size(); ++i) {
            Map<String, String> map = list.get(i);
            if (!sign.equals(map.get("sign"))) continue;
            m = i;
            break;
        }
        return m;
    }

    private List<DynamicObject> getRankDim() {
        ArrayList<String> numbers = new ArrayList<String>(10);
        for (PageDimensionEntry pe : this.getTemplateModel().getPageDimensionEntries()) {
            numbers.add(pe.getDimension().getNumber());
        }
        for (PageDimensionEntry pe : this.getTemplateModel().getPagePropEntries()) {
            numbers.add(pe.getDimension().getNumber());
        }
        for (ViewPointDimensionEntry ve : this.getTemplateModel().getViewPointDimensionEntries()) {
            numbers.add(ve.getDimension().getNumber());
        }
        List rank = QueryDimensionServiceHelper.getOthersDim(numbers, (Long)this.getTemplateModel().getModelId());
        for (DynamicObject obj : rank) {
            if (!DimTypesEnum.INTERCOMPANY.getNumber().equals(obj.getString("number")) || QueryDimensionServiceHelper.checkIcEnt((long)this.getTemplateModel().getModelId())) continue;
            rank.remove(obj);
            break;
        }
        return rank;
    }

    @Override
    public void hideEbAppCtrl(Object modelId) {
        ApplicationTypeEnum app = ModelUtil.queryApp(this.getView());
        if (ApplicationTypeEnum.EB == app || ApplicationTypeEnum.BGMD == app) {
            String viewFields = this.getPageCache().get("viewFields");
            String scenKey = null;
            String processKey = null;
            if (viewFields != null) {
                for (String key : viewFields.split(";")) {
                    if (key.contains("epm_scenemembertree")) {
                        scenKey = key;
                        continue;
                    }
                    if (!key.contains("epm_processmembertree")) continue;
                    processKey = key;
                }
            }
            this.getView().setVisible(Boolean.valueOf(false), new String[]{scenKey});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{processKey});
        }
    }

    private DimensionMsgCache getDims() {
        if (this.dims == null) {
            this.dims = new DimensionMsgCache(this.getModelId().longValue());
        }
        return this.dims;
    }
}

