/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.budget.formplugin.template;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import java.math.BigDecimal;
import java.util.Base64;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.RichTextEditor;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.budget.formplugin.template.AbstractTemplateBasePlugin;
import kd.epm.eb.budget.formplugin.template.util.TemplateCopyUpdateUtils;
import kd.epm.eb.budget.formplugin.util.TemplateDimSettingUtil;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.ebcommon.bg.AppUtil;
import kd.epm.eb.common.ebcommon.common.enums.TemplateUsageEnum;
import kd.epm.eb.common.ebcommon.common.util.GlobalIdUtil;
import kd.epm.eb.common.ebcommon.common.util.QFBuilder;
import kd.epm.eb.common.ebcommon.enums.TemplateCatalogTypeEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.ebBusiness.template.model.TemplateCatalog;
import kd.epm.eb.ebBusiness.template.model.TemplateModel;
import kd.epm.eb.ebSpread.util.GZIPUtils;
import org.apache.commons.lang3.ObjectUtils;

public class TemplateEditPlugin
extends AbstractTemplateBasePlugin {
    private static final String nofinancial = "isnofinancial";
    private IModelCacheHelper modelCache;

    @Override
    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        if (this.isWeave()) {
            BasedataEdit cataLog = (BasedataEdit)this.getControl("templatecatalog");
            BasedataEdit beginYear = (BasedataEdit)this.getControl("beginyear");
            BasedataEdit beginMonth = (BasedataEdit)this.getControl("beginmonth");
            BasedataEdit endYear = (BasedataEdit)this.getControl("endyear");
            BasedataEdit endMonth = (BasedataEdit)this.getControl("endmonth");
            cataLog.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            beginYear.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            beginMonth.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            endYear.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            endMonth.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        String key = beforeF7SelectEvent.getProperty().getName();
        if ("templatecatalog".equals(key)) {
            BasedataEdit source = (BasedataEdit)beforeF7SelectEvent.getSource();
            if (source.isF7Click()) {
                this.catalogedit();
                beforeF7SelectEvent.setCancel(true);
            } else {
                QFilter qf = new QFilter("model", "=", (Object)this.getModelId());
                ListShowParameter param = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                param.getListFilterParameter().setFilter(qf);
            }
        } else if ("beginyear".equals(key) || "beginmonth".equals(key) || "endyear".equals(key) || "endmonth".equals(key)) {
            QFilter qf = new QFilter("model", "=", (Object)this.getModelId());
            QFilter qf2 = new QFilter("isleaf", "=", (Object)true);
            ListShowParameter param = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            param.getListFilterParameter().setFilter(qf.and(qf2));
        }
    }

    protected void catalogedit() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setCaption(ResManager.loadKDString((String)"\u9884\u7b97\u6a21\u677f\u5206\u7c7b", (String)"TemplateEditPlugin_6", (String)"epm-eb-budget", (Object[])new Object[0]));
        showParameter.setFormId("eb_templatemove");
        showParameter.setCustomParam("KEY_MODEL_ID", (Object)String.valueOf(this.getModelId()));
        showParameter.setCustomParam("cataLogType", (Object)TemplateCatalogTypeEnum.getTemplateCalcog().recombine());
        showParameter.setCustomParam("listPageID", (Object)this.getView().getPageId());
        showParameter.setCustomParam("justforedit", (Object)"true");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "catalogedit");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private void hideparams() {
        String isnofinancial = (String)this.getView().getFormShowParameter().getCustomParam(nofinancial);
        this.getPageCache().put(nofinancial, isnofinancial);
        if ("yes".equals(isnofinancial)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"usage", "isonlyread"});
            this.getPageCache().put(nofinancial, "yes");
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if ("usage".equals(e.getProperty().getName())) {
            String usage = (String)e.getChangeSet()[0].getNewValue();
            if (TemplateUsageEnum.FORQUERY.getValue().equals(usage)) {
                this.setValueOnModel("isonlyread", true);
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"isonlyread"});
            } else {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"isonlyread"});
                this.setValueOnModel("isonlyread", false);
            }
        }
        if ("isshowdescription".equals(e.getProperty().getName()) && (this.getPageCache().get("ischange") == null || this.getPageCache().get("ischange").equals("true"))) {
            this.isEmptyDescription();
        }
        if ("issavebydim".equals(e.getProperty().getName())) {
            if (!this.isAddNewStatus() && e.getChangeSet()[0].getNewValue() != null && "false".equals(e.getChangeSet()[0].getNewValue().toString()) && this.getTemplateModel().getAreaRangeEntries().size() > 0) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5c06\u4f1a\u6e05\u9664\u5df2\u9009\u62e9\u7684\u7ef4\u5ea6\u6210\u5458\u7b49\u4fe1\u606f\uff0c\u786e\u5b9a\u4e0d\u6309\u7ef4\u5ea6\u5b58\u50a8\u6570\u636e\uff1f", (String)"TemplateEditPlugin_0", (String)"epm-eb-budget", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("issavebydim", (IFormPlugin)this));
            }
            if (e.getChangeSet()[0].getNewValue() != null && "false".equals(e.getChangeSet()[0].getNewValue().toString())) {
                this.getModel().setValue("isautocalculate", (Object)true);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String key = e.getCallBackId();
        if ("issavebydim".equals(key) && e.getResult().equals((Object)MessageBoxResult.Cancel)) {
            this.getModel().setValue("issavebydim", (Object)true);
        }
    }

    @Override
    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String modelID = (String)this.getView().getFormShowParameter().getCustomParam("modelId");
        if (modelID != null) {
            this.getModel().setValue("model", (Object)modelID);
            int seq = this.getCurrMaxSequence(modelID);
            this.getModel().setValue("sequence", (Object)seq);
        }
        this.checkTypeAndhide();
        this.hideparams();
        if (this.isAddNewStatus()) {
            this.iniatialTemplate();
        } else {
            this.fillBackWebPage();
        }
        QFBuilder qf = new QFBuilder("model", "=", (Object)this.getModelId());
        qf.and("number", "=", (Object)this.getTemplateModel().getNumber());
        Object existOtherVersion = this.getView().getFormShowParameter().getCustomParam("exist");
        Boolean iscopy = this.isCopy();
        boolean canEditNumber = this.isAddNewStatus() || existOtherVersion != null && (Boolean)existOtherVersion != false || iscopy != false;
        this.getView().setEnable(Boolean.valueOf(canEditNumber), new String[]{"number"});
        if (this.getFormCustomParam("fromWorkPaper") != null) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"usage", "dataunit", "isonlyread", "issavebydim"});
        }
        if (iscopy.booleanValue()) {
            this.setDefaultNameAndNumber();
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"dataunit"});
        }
        if (TemplateUsageEnum.FORQUERY.getValue().equals((String)this.getModel().getValue("usage"))) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"isonlyread"});
        }
        if (this.isEPM()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap10", "issavebydim"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap10"});
        }
    }

    private Boolean isCopy() {
        return this.getView().getFormShowParameter().getCustomParam("iscopy") != null;
    }

    private void setDefaultNameAndNumber() {
        HashSet<String> numberSet = new HashSet<String>(16);
        HashSet<String> nameSet = new HashSet<String>(16);
        QFilter modelQfilter = new QFilter("model", "=", (Object)this.getModelId());
        try (DataSet allData = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"eb_templateentity_bg", (String)"name, number", (QFilter[])new QFilter[]{modelQfilter}, null);){
            while (allData.hasNext()) {
                Row row = allData.next();
                numberSet.add(row.getString("number"));
                nameSet.add(row.getString("name"));
            }
        }
        TemplateModel templateModel = this.getTemplateModel();
        String name = templateModel.getName().length() > 56 ? templateModel.getName().substring(0, 55) + "copy" : templateModel.getName() + "copy";
        this.setValue("name", this.getCopyName(name, nameSet, 1));
        String number = templateModel.getNumber().length() > 56 ? templateModel.getNumber().substring(0, 55) + "copy" : templateModel.getNumber() + "copy";
        this.setValue("number", this.getCopyName(number, numberSet, 1));
    }

    private String getCopyName(String name, Set<String> nameset, int i) {
        if (nameset.contains(name)) {
            if (name.length() > 56) {
                name = name.substring(0, 39);
                name = name + "copy" + i;
            } else {
                char ss = name.charAt(name.length() - 1);
                try {
                    Integer.parseInt(String.valueOf(ss));
                    name = name.substring(0, name.length() - 1) + i;
                }
                catch (NumberFormatException e) {
                    name = name + i;
                }
            }
            return this.getCopyName(name, nameset, i + 1);
        }
        return name;
    }

    private void iniatialTemplate() {
        TemplateModel template = this.getTemplateModel();
        if (StringUtils.isNotEmpty((String)((String)this.getFormCustomParam("catalog")))) {
            JSONObject obj = JSONObject.parseObject((String)((String)this.getFormCustomParam("catalog")));
            TemplateCatalog catalog = new TemplateCatalog();
            DynamicObject dyna = BusinessDataServiceHelper.loadSingle((Object)obj.getLongValue("id"), (String)catalog.getDataEntityNumber());
            catalog.setId(obj.getLongValue("id"));
            catalog.setName(dyna.getString("name"));
            template.setTemplateCatalog(catalog);
            this.getModel().getDataEntity().set("templatecatalog", (Object)dyna);
        }
        template.setIsOldTemplate(false);
        if (this.isRPT()) {
            template.setSaveByDim(false);
            this.setValueOnModel("issavebydim", false);
        }
        TemplateCopyUpdateUtils.setDefaultBeginTime(this.getModelCache(), this.getModel(), this.isCopy());
        this.getPageCache().put(this.KEY_TEMPLATE_MODEL, this.getTemplateModelSerial());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String operateKey = source.getOperateKey();
        String appnum = this.getView().getFormShowParameter().getAppId();
        if (AppUtil.isEpmAppId((String)appnum) && "confirm".equals(operateKey)) {
            QFilter filter = new QFilter("model", "=", (Object)this.getModelId());
            filter = filter.and(new QFilter("number", "=", this.getModel().getValue("number")));
            long templateid = this.getTemplateModel().getId();
            if (templateid != 0L) {
                filter.and(new QFilter("id", "!=", (Object)templateid));
            }
            if (QueryServiceHelper.exists((String)"eb_templateentity_bg", (QFilter[])new QFilter[]{filter})) {
                this.getView().showTipNotification(ResManager.loadResFormat((String)"\u540c\u4e00\u4f53\u7cfb\u4e0b\u5df2\u7ecf\u5b58\u5728\u7f16\u7801\u4e3a\u201c%1\u201d\u7684\u6a21\u677f\u3002", (String)"TemplateEditPlugin_2", (String)"epm-eb-budget", (Object[])new Object[]{this.getModel().getValue("number")}));
                args.setCancel(true);
            }
            if (this.isWeave()) {
                DynamicObject beginyear = (DynamicObject)this.getModel().getValue("beginyear");
                DynamicObject beginmonth = (DynamicObject)this.getModel().getValue("beginmonth");
                if (beginyear == null || beginmonth == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5f00\u59cb\u671f\u95f4\u3002", (String)"TemplateEditPlugin_4", (String)"epm-eb-budget", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                String begintime = beginyear.getString("number") + "/" + beginmonth.getString("number");
                this.getTemplateModel().setBeginTime(begintime);
                DynamicObject endyear = (DynamicObject)this.getModel().getValue("endyear");
                DynamicObject endmonth = (DynamicObject)this.getModel().getValue("endmonth");
                if (endyear != null && endmonth != null) {
                    String endtime = endyear.getString("number") + "/" + endmonth.getString("number");
                    if (endtime.compareTo(begintime) < 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u675f\u671f\u95f4\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u5f00\u59cb\u671f\u95f4\u3002", (String)"TemplateEditPlugin_5", (String)"epm-eb-budget", (Object[])new Object[0]));
                        args.setCancel(true);
                        return;
                    }
                    this.getTemplateModel().setEndTime(endtime);
                } else if (this.isCopy().booleanValue()) {
                    this.getTemplateModel().setEndTime("");
                }
                this.cacheTemplateModel();
                this.cacheSpreadModel();
            }
        }
    }

    private void copyTemplate() {
        TemplateModel templateModel = this.getTemplateModel();
        String name = (String)this.getModel().getValue("name");
        if (name.length() > 50) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u677f\u540d\u79f0\u8d85\u957f\u3002", (String)"TemplateListPlugin_35", (String)"epm-eb-budget", (Object[])new Object[0]));
        }
        templateModel.setName(name);
        String number = (String)this.getModel().getValue("number");
        if (number.length() > 50) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u677f\u7f16\u7801\u8d85\u957f\u3002", (String)"TemplateListPlugin_36", (String)"epm-eb-budget", (Object[])new Object[0]));
        }
        templateModel.setNumber(number);
        templateModel.setIsOnlyRead(((Boolean)this.getModel().getValue("isonlyread")).booleanValue());
        templateModel.setUsage((String)this.getModel().getValue("usage"));
        this.setSpreadJsonCopyName(templateModel);
        templateModel.setId(GlobalIdUtil.genGlobalLongId());
        templateModel.getAreaRangeEntries().forEach(p -> p.setId(GlobalIdUtil.genGlobalLongId()));
        templateModel.getPageDimensionEntries().forEach(p -> p.setId(GlobalIdUtil.genGlobalLongId()));
        templateModel.getViewPointDimensionEntries().forEach(p -> p.setId(GlobalIdUtil.genGlobalLongId()));
        templateModel.getPagePropEntries().forEach(p -> p.setId(GlobalIdUtil.genGlobalLongId()));
        Date time = new Date();
        templateModel.setCreatorId(UserUtils.getUserId().longValue());
        templateModel.setCreateTime(time);
        templateModel.setModifierId(UserUtils.getUserId().longValue());
        templateModel.setModifyTime(time);
        DynamicObject t = templateModel.genDynamicObject();
        t.set("status", (Object)"0");
        t.set("versionnumber", (Object)"1.0");
        t.set("versionstatus", (Object)"1");
        t.set("group", (Object)GlobalIdUtil.genGlobalLongId());
        SaveServiceHelper.save((IDataEntityType)t.getDynamicObjectType(), (Object[])new DynamicObject[]{t});
    }

    private void setSpreadJsonCopyName(TemplateModel model) {
        String ssjson = new String(GZIPUtils.uncompress((byte[])Base64.getDecoder().decode(model.getSpreadJson().substring(6))));
        JSONObject object = JSONObject.parseObject((String)ssjson, (Feature[])new Feature[]{Feature.OrderedField});
        JSONObject sheets = (JSONObject)object.get((Object)"sheets");
        String temName = model.getName();
        for (String k : sheets.keySet()) {
            sheets.put(temName, ObjectUtils.clone((Object)sheets.get((Object)k)));
            JSONObject name = (JSONObject)sheets.get((Object)temName);
            name.put("name", (Object)temName);
            sheets.remove((Object)k);
        }
        byte[] bb = Base64.getEncoder().encode(GZIPUtils.compress((String)object.toJSONString()));
        String bbs = new String(bb);
        model.setSpreadJson("base64" + bbs);
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        super.afterDoOperation(eventArgs);
        String objectId = eventArgs.getOperateKey();
        if ("confirm".equals(objectId)) {
            if (eventArgs.getOperationResult().isSuccess()) {
                String isnofinancial = this.getPageCache().get(nofinancial);
                TemplateModel templatemodel = this.fillBackTemplateModelAndReturn();
                if ("yes".equals(isnofinancial)) {
                    QFilter filter = new QFilter("model", "=", (Object)templatemodel.getModelId());
                    filter = filter.and(new QFilter("number", "=", (Object)templatemodel.getNumber()));
                    filter.and(new QFilter("id", "<>", (Object)templatemodel.getId()));
                    if (QueryServiceHelper.exists((String)"eb_templateentity_bg", (QFilter[])new QFilter[]{filter})) {
                        this.getView().showTipNotification(ResManager.loadResFormat((String)"\u540c\u4e00\u4f53\u7cfb\u4e0b\u5df2\u7ecf\u5b58\u5728\u7f16\u7801\u4e3a\u201c%1\u201d\u7684\u6a21\u677f\u3002", (String)"TemplateEditPlugin_2", (String)"epm-eb-budget", (Object[])new Object[]{templatemodel.getNumber()}));
                        return;
                    }
                }
                if (this.isCopy().booleanValue()) {
                    this.copyTemplate();
                }
                this.returnDataToParent(templatemodel);
                this.getView().close();
            } else {
                List list = eventArgs.getOperationResult().getAllErrorOrValidateInfo();
            }
        }
    }

    private void fillBackWebPage() {
        TemplateModel template = this.getTemplateModel();
        this.setValueOnModel("description", template.getDescription());
        RichTextEditor rap = (RichTextEditor)this.getControl("richtexteditorap");
        rap.setText(String.valueOf(this.getModel().getValue("description")));
        this.setValueOnModel("dataunit", template.getDataUnit());
        this.setValueOnModel("name", template.getName());
        this.setValueOnModel("number", template.getNumber());
        this.setValueOnModel("isshowdescription", template.getIsShowDescription());
        this.setValueOnModel("usage", template.getUsage());
        this.setValueOnModel("isonlyread", template.getIsOnlyRead());
        this.fillBeginTimeAndEndTime(this.isCopy());
        this.setValueOnModel("templateCatalog", this.defaultIfNull(Objects::isNull, template.getTemplateCatalog(), v -> {
            TemplateCatalog cata = (TemplateCatalog)v;
            DynamicObject d = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"eb_templatecatalog_bg"));
            d.set("id", (Object)cata.getId());
            d.set("number", (Object)cata.getNumber());
            d.set("name", (Object)cata.getName());
            return d;
        }));
    }

    private void fillBeginTimeAndEndTime(Boolean isCopy) {
        this.template = this.getTemplateModel();
        IModelCacheHelper modelCache = this.getModelCache();
        String beginTime = this.template.getBeginTime();
        String endTime = this.template.getEndTime();
        TemplateCopyUpdateUtils.doFillBeginEndTime(isCopy, modelCache, beginTime, endTime, this.getModel());
    }

    private void checkTypeAndhide() {
        if (this.isWeave()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap7", "isshowdescription"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap5"});
        }
    }

    private boolean isWeave() {
        return this.getFormCustomParam("weave") == null;
    }

    private TemplateModel fillBackTemplateModelAndReturn() {
        TemplateModel template = this.getTemplateModel();
        Predicate<Object> p = Objects::isNull;
        if (this.isAddNewStatus()) {
            template.setCreateOrgId(this.getOrgId());
            template.setCreateTime(this.getCurrentSysTime());
            template.setCreatorId(this.getUserId());
            template.setVersionNumber((BigDecimal)this.getValueOnModel("versionNumber"));
            template.setVersionStatus((String)this.getValueOnModel("versionStatus"));
            template.setModelId(this.getModelId().longValue());
            this.fillBackCommonPart(p, template);
            this.initViewAndPage(template);
        } else {
            this.fillBackCommonPart(p, template);
        }
        template.setDataUnit((String)this.getValueOnModel("dataunit"));
        return template;
    }

    private void initViewAndPage(TemplateModel template) {
        boolean fromWP = this.getFormCustomParam("fromWorkPaper") != null;
        TemplateDimSettingUtil.setDefaultValue(this, template, this.getView(), fromWP);
        TemplateDimSettingUtil.fillBack2TemplateModel(this, template, fromWP);
    }

    private void fillBackCommonPart(Predicate<Object> p, TemplateModel template) {
        RichTextEditor rap = (RichTextEditor)this.getControl("richtexteditorap");
        template.setUsage((String)this.getValueOnModel("usage"));
        template.setName((String)this.getValueOnModel("name"));
        template.setNumber((String)this.getValueOnModel("number"));
        if (rap.getText() != null) {
            template.setDescription(rap.getText());
        }
        template.setIsShowDescription(((Boolean)this.getModel().getValue("isshowdescription")).booleanValue());
        template.setIsOnlyRead(((Boolean)this.getValueOnModel("isonlyread")).booleanValue());
        template.setTemplateCatalog(this.defaultIfNull(p, this.getValueOnModel("templateCatalog"), value -> {
            TemplateCatalog catalog = new TemplateCatalog();
            DynamicObject v = (DynamicObject)value;
            catalog.setId(v.getLong("id"));
            catalog.setName(v.getString("name"));
            return catalog;
        }));
    }

    private <R> R defaultIfNull(Predicate<Object> p, Object obj, Function<Object, R> f) {
        if (p.test(obj)) {
            return null;
        }
        return f.apply(obj);
    }

    public void isEmptyDescription() {
        RichTextEditor rap = (RichTextEditor)this.getControl("richtexteditorap");
        TemplateModel template = this.getTemplateModel();
        if (template.getDescription() == null) {
            if (rap.getText() == null) {
                this.showTips();
            } else if (StringUtils.isEmpty((String)rap.getText().replaceAll("<br>", "").replaceAll("<p>", "").replaceAll("</p>", "").trim())) {
                this.showTips();
            }
        } else if ("".equals(template.getDescription().replaceAll("<br>", "").replaceAll("<p>", "").replaceAll("</p>", "").trim())) {
            if (rap.getText() == null) {
                this.showTips();
            } else {
                String text = rap.getText().replaceAll("<br>", "").replaceAll("<p>", "").replaceAll("</p>", "").trim();
                if (StringUtils.isEmpty((String)text)) {
                    this.showTips();
                }
            }
        } else if (rap.getText() != null && StringUtils.isEmpty((String)rap.getText().replaceAll("<br>", "").replaceAll("<p>", "").replaceAll("</p>", "").trim())) {
            this.showTips();
        }
    }

    public void showTips() {
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u5236\u8bf4\u660e\u4e3a\u7a7a,\u4e0d\u80fd\u8bbe\u7f6e\u4e3a\u81ea\u52a8\u663e\u793a", (String)"TemplateEditPlugin_3", (String)"epm-eb-budget", (Object[])new Object[0]));
        this.getPageCache().put("ischange", "false");
        this.getModel().setValue("isshowdescription", (Object)false);
        this.getPageCache().put("ischange", "true");
    }

    public int getCurrMaxSequence(String modelId) {
        QFilter model = new QFilter("model", "=", (Object)IDUtils.toLong((Object)modelId));
        QFilter[] filters = new QFilter[]{model};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)this.getClass().getName(), (String)"eb_templateentity_bg", (String)"sequence", (QFilter[])filters, (String)"sequence desc");
        if (dcs != null && dcs.size() > 0) {
            DynamicObject dyMaxSeq = (DynamicObject)dcs.iterator().next();
            String strSeq = dyMaxSeq.getString("sequence");
            return (strSeq.trim().isEmpty() ? 0 : Integer.parseInt(strSeq)) + 1;
        }
        return 1;
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String key = evt.getActionId();
        if ("catalogedit".equals(key)) {
            if (evt.getReturnData() == null) {
                return;
            }
            String newId = (String)evt.getReturnData();
            TemplateCatalog catalog = new TemplateCatalog();
            DynamicObject dyna = BusinessDataServiceHelper.loadSingle((Object)newId, (String)catalog.getDataEntityNumber());
            catalog.setId(dyna.getLong("id"));
            catalog.setName(dyna.getString("name"));
            this.template = this.getTemplateModel();
            this.template.setTemplateCatalog(catalog);
            this.cacheTemplateModel();
            this.getModel().getDataEntity().set("templatecatalog", (Object)dyna);
            this.getView().updateView("templatecatalog");
        }
    }

    public IModelCacheHelper getModelCache() {
        if (this.modelCache == null) {
            this.modelCache = ModelCacheContext.getOrCreate((Long)this.getModelId());
        }
        return this.modelCache;
    }
}

