/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.budget.formplugin.template;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.events.BasedataFuzzySearchEvent;
import kd.bos.form.field.events.BasedataFuzzySearchListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.budget.formplugin.database.BasedataEditSingleMemberF7;
import kd.epm.eb.budget.formplugin.report.floatreport.SeqLogicImpl;
import kd.epm.eb.budget.formplugin.template.AbstractTemplateBasePlugin;
import kd.epm.eb.budget.formplugin.template.util.TemplateFloatUtil;
import kd.epm.eb.budget.formplugin.util.DimensionUtil;
import kd.epm.eb.budget.formplugin.util.ModelUtil;
import kd.epm.eb.budget.formplugin.util.ObjectConvertUtils;
import kd.epm.eb.budget.formplugin.util.SingleMemberF7Util;
import kd.epm.eb.business.memberf7.NewF7Utils;
import kd.epm.eb.business.utils.CustomF7utils;
import kd.epm.eb.common.ebcommon.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.ebcommon.common.enums.DimTypesEnum;
import kd.epm.eb.common.ebcommon.common.enums.MembAddPositionEnum;
import kd.epm.eb.common.ebcommon.common.enums.SelectPageType;
import kd.epm.eb.common.ebcommon.common.enums.SingleF7TypeEnum;
import kd.epm.eb.common.ebcommon.common.enums.SpreadSelectTypeEnum;
import kd.epm.eb.common.ebcommon.common.util.DynamicEnum;
import kd.epm.eb.common.ebcommon.common.util.ExcelUtils;
import kd.epm.eb.common.ebcommon.common.util.ObjectSerialUtil;
import kd.epm.eb.common.ebcommon.common.util.SpreadAreaUtil;
import kd.epm.eb.common.enums.F7RangeTypeEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.member.f7.MemberF7Parameter;
import kd.epm.eb.common.pageinteraction.CommandParam;
import kd.epm.eb.common.pageinteraction.SubPage;
import kd.epm.eb.ebBusiness.serviceHelper.ConfigServiceHelper;
import kd.epm.eb.ebBusiness.serviceHelper.QueryDimensionServiceHelper;
import kd.epm.eb.ebBusiness.template.model.AreaRangeEntry;
import kd.epm.eb.ebBusiness.template.model.MembSettingBaseDetail;
import kd.epm.eb.ebBusiness.util.PlatUtil;
import kd.epm.eb.ebSpread.domain.view.builder.PositionInfo;
import kd.epm.eb.ebSpread.domain.view.builder.dynamic.BasePointInfo;
import kd.epm.eb.ebSpread.domain.view.builder.dynamic.BasePointInnerLineInfo;
import kd.epm.eb.ebSpread.domain.view.builder.dynamic.DynaMembScopeInfo;
import kd.epm.eb.ebSpread.model.DimMember;
import kd.epm.eb.ebSpread.model.Dimension;
import kd.epm.eb.ebSpread.model.IDimMember;
import kd.epm.eb.ebSpread.model.IDimension;

public class TemplateFloatSettingPlugin
extends AbstractTemplateBasePlugin
implements BeforeF7SelectListener,
BasedataFuzzySearchListener,
SubPage {
    private static final String entryentity = "entryentity";
    private static final String PAFETYPE = "pagetype";
    private static final String SELECTAREAS = "selectareas";
    private static final String FLOATTYPE = "floattype";
    private static final String FLOATMEMTEXT = "floatmemtext";
    private static final String NEWMEMBAS = "newmembas";
    private static final String ISSEQ = "isseq";
    private static final String NEWMEMAREA = "newmemarea";
    private static final String UNFLOATMEM = "unfloatmem";
    private static final String FLOATAREA = "showfloatarea";
    private static final String FLOATAREAINDEX = "floatareaindex";
    private static final String DELETEFLOATAREA = "deletefloatarea";
    private static final String AREALISTEDIT = "arealistedit";
    private static final String ORGINDEX = "orgindex";

    @Override
    public void initialize() {
        super.initialize();
        BasedataEdit unfloatmem = (BasedataEdit)this.getControl(UNFLOATMEM);
        unfloatmem.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"showpanel"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"areapanel"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"combopanel"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"orglocal"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"orglocal"});
        this.getPageCache().put(PAFETYPE, "show");
        String select = (String)this.getFormCustomParam("select");
        this.getModel().setValue("area", (Object)select);
        this.setDataList();
        this.loadFloatArea();
        this.lockUnFloatMembBtn();
        this.setValue("isshowseq", ConfigServiceHelper.getBoolParam((Long)this.getModelId(), (String)"CM007"));
    }

    private void setDataList() {
        HashMap<String, String> map = new HashMap<String, String>(16);
        String pssch = (String)this.getView().getFormShowParameter().getCustomParam("ps");
        PositionInfo ps = (PositionInfo)this.deSerializedBytes(pssch);
        ComboEdit comboEdit = (ComboEdit)this.getControl("dataarea");
        ArrayList items = new ArrayList();
        ArrayList<String[]> keysAndValues = new ArrayList<String[]>(10);
        int i = 1;
        int val = 1;
        for (PositionInfo e : this.getSpreadModel().getAreaManager().getPostionInfoSet()) {
            String[] keysAndValue = new String[]{e.getAreaRange(), String.valueOf(i)};
            map.put(keysAndValue[1], keysAndValue[0]);
            keysAndValues.add(keysAndValue);
            if (ps.getAreaRange().equals(e.getAreaRange())) {
                val = i;
            }
            ++i;
        }
        keysAndValues.forEach(new DynamicEnum(items));
        comboEdit.setComboItems(items);
        this.getPageCache().put("dataareamap", SerializationUtils.toJsonString(map));
        this.getModel().setValue("dataarea", (Object)val);
        if (i > 2) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"lab_datanoti"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"lab_datanoti"});
        }
    }

    private String getFloatTypeFromModel() {
        for (PositionInfo p : this.getSpreadModel().getAreaManager().getPostionInfoSet()) {
            Iterator iterator = p.getBasePoints().iterator();
            if (!iterator.hasNext()) continue;
            BasePointInfo bs = (BasePointInfo)iterator.next();
            if (1 == bs.getDirect()) {
                return "col";
            }
            return "row";
        }
        return null;
    }

    public void addFloatArea(String select) {
        this.checkCell(select);
        String pssch = (String)this.getView().getFormShowParameter().getCustomParam("ps");
        PositionInfo ps = (PositionInfo)this.deSerializedBytes(pssch);
        SpreadSelectTypeEnum type0 = SpreadAreaUtil.selectedInCanFloatArea((String)select, (String)ps.getStartPosition(), (String)ps.getAreaRange());
        String floattype = this.getPageCache().get(FLOATTYPE);
        DynamicObjectCollection dcs = this.getModel().getEntryEntity(entryentity);
        int index = dcs.size();
        if (index == 0) {
            floattype = null;
        }
        if (floattype == null) {
            floattype = this.getFloatTypeFromModel();
        }
        switch (type0) {
            case LEFT_BOTTOM: {
                if (StringUtils.isNotEmpty((String)floattype) && "col".equals(floattype)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u9875\u9762\u5df2\u8bbe\u7f6e\u5217\u6d6e\u52a8\uff0c\u4ec5\u652f\u6301\u5217\u6d6e\u52a8\u3002", (String)"TemplateFloatSettingPlugin_0", (String)"epm-eb-budget", (Object[])new Object[0]));
                }
                if (TemplateFloatUtil.isCanFloatSet(2, select, ps.getAreaRange(), this.getSpreadModel().getAreaManager().getPostionInfoSet())) {
                    this.getPageCache().put(FLOATTYPE, "row");
                    break;
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u662f\u7eaf\u4e0a\u4e0b\u7ed3\u6784\uff0c\u4e0d\u652f\u6301\u884c\u6d6e\u52a8\u3002", (String)"TemplateFloatSettingPlugin_1", (String)"epm-eb-budget", (Object[])new Object[0]));
            }
            case RIGHT_TOP: {
                if (StringUtils.isNotEmpty((String)floattype) && "row".equals(floattype)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u9875\u9762\u5df2\u7ecf\u8bbe\u7f6e\u884c\u6d6e\u52a8\uff0c\u53ea\u53ef\u652f\u6301\u884c\u6d6e\u52a8\u3002", (String)"TemplateFloatSettingPlugin_2", (String)"epm-eb-budget", (Object[])new Object[0]));
                }
                if (TemplateFloatUtil.isCanFloatSet(1, select, ps.getAreaRange(), this.getSpreadModel().getAreaManager().getPostionInfoSet())) {
                    this.getPageCache().put(FLOATTYPE, "col");
                    break;
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u662f\u7eaf\u5de6\u53f3\u7ed3\u6784\uff0c\u4e0d\u652f\u6301\u5217\u6d6e\u52a8\u3002", (String)"TemplateFloatSettingPlugin_3", (String)"epm-eb-budget", (Object[])new Object[0]));
            }
            default: {
                throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u8303\u56f4\u4e0d\u53ef\u8bbe\u7f6e\u5f53\u524d\u533a\u57df\u7684\u6d6e\u52a8\u3002", (String)"TemplateFloatSettingPlugin_4", (String)"epm-eb-budget", (Object[])new Object[0]));
            }
        }
        this.put2SelectAreas(select);
        MainEntityType maintype = this.getModel().getDataEntityType();
        EntryType entityType = (EntryType)maintype.getAllEntities().get(entryentity);
        floattype = this.getPageCache().get(FLOATTYPE);
        List list = null;
        AreaRangeEntry are = this.getAreaRangeEntryBySelectArea(ps.getAreaRange());
        list = "row".equals(floattype) ? are.getRowDimEntries() : are.getColDimEntries();
        for (MembSettingBaseDetail dim : list) {
            DynamicObject rowObj = new DynamicObject((DynamicObjectType)entityType);
            rowObj.set("selectarea", (Object)select);
            rowObj.set("dim", (Object)dim.getDimension().getMemberEntityNumber());
            rowObj.set("muldim", (Object)dim.getDimension().getMemberEntityNumber());
            rowObj.set("showdim", (Object)dim.getDimension().getName());
            rowObj.set("dimnumber", (Object)dim.getDimension().getNumber());
            this.getModel().createNewEntryRow(entryentity, index, rowObj);
            this.checkEnable(dim.getDimension().getMemberEntityNumber(), dim.getDimension().getNumber(), index);
            ++index;
        }
    }

    private AreaRangeEntry getAreaRangeEntryBySelectArea(String selectarea) {
        AreaRangeEntry are = null;
        for (AreaRangeEntry entity : this.getTemplateModel().getAreaRangeEntries()) {
            if (!SpreadAreaUtil.isInArea((String)selectarea, (String)entity.getAreaRange())) continue;
            are = entity;
            break;
        }
        if (are == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u7b26\u5408\u7684\u533a\u57df\u3002", (String)"TemplateFloatSettingPlugin_5", (String)"epm-eb-budget", (Object[])new Object[0]));
        }
        return are;
    }

    private void checkEnable(String entity, String dimnum, int index) {
        if ("epm_userdefinedmembertree".equals(entity) || "epm_icmembertree".equals(entity)) {
            if (!this.getTemplateModel().isAllowaddic() && "epm_icmembertree".equals(entity)) {
                this.getView().setEnable(Boolean.valueOf(false), index, new String[]{NEWMEMBAS});
            } else {
                this.getView().setEnable(Boolean.valueOf(true), index, new String[]{NEWMEMBAS});
            }
        } else {
            this.getView().setEnable(Boolean.valueOf(false), index, new String[]{NEWMEMBAS});
        }
        DimMember member = this.getSeqMem();
        if (dimnum != null && member != null) {
            if (dimnum.equals(member.getDimension().getNumber())) {
                this.getView().setEnable(Boolean.valueOf(true), index, new String[]{ISSEQ});
            } else {
                this.getView().setEnable(Boolean.valueOf(false), index, new String[]{ISSEQ});
            }
        } else {
            this.getView().setEnable(Boolean.valueOf(false), index, new String[]{ISSEQ});
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap", "toolbarap", "toolbarap1", "toolbaraporg"});
        this.addClickListeners(new String[]{"btn-cancel", "btn-confirm", AREALISTEDIT});
        this.addClickListeners(new String[]{NEWMEMBAS, FLOATMEMTEXT, FLOATAREA});
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "bar-add": {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"showpanel"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"areapanel"});
                this.getPageCache().put(PAFETYPE, SelectPageType.FLOAT.getName());
                break;
            }
            case "bar-confirm": {
                String select = (String)this.getModel().getValue("area");
                this.addFloatArea(select);
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"showpanel"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"areapanel"});
                this.getPageCache().put(PAFETYPE, "show");
                break;
            }
            case "bar-confirmfloat": {
                EntryGrid eg = (EntryGrid)this.getControl(entryentity);
                List<String> list = this.getSelectRowFloatRowOrCol();
                if (StringUtils.isNotEmpty((String)((String)this.getModel().getValue("combofield")))) {
                    int index = Integer.parseInt((String)this.getModel().getValue("combofield"));
                    this.getModel().setValue(FLOATAREAINDEX, (Object)index, eg.getSelectRows()[0]);
                    this.getModel().setValue(FLOATAREA, (Object)this.buildComboShowName(list.get(index)), eg.getSelectRows()[0]);
                }
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"showpanel"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"combopanel"});
                this.getPageCache().put(PAFETYPE, "show");
                break;
            }
            case "bar-del": {
                EntryGrid entry = (EntryGrid)this.getControl(entryentity);
                int[] selectrows = entry.getEntryState().getSelectedRows();
                if (selectrows.length < 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"TemplateFloatSettingPlugin_6", (String)"epm-eb-budget", (Object[])new Object[0]));
                    break;
                }
                StringBuilder sb = new StringBuilder();
                HashSet<String> areas = new HashSet<String>(selectrows.length);
                for (int selectttt : selectrows) {
                    DynamicObjectCollection dcs = this.getModel().getEntryEntity(entryentity);
                    String area = ((DynamicObject)dcs.get(selectttt)).getString("selectarea");
                    areas.add(area);
                }
                Object object = areas.iterator();
                while (object.hasNext()) {
                    String area = (String)object.next();
                    sb.append(area).append(",");
                }
                this.getView().showConfirm(ResManager.loadResFormat((String)"\u5220\u9664\u6d6e\u52a8\u8303\u56f4\uff1a%1\u3002", (String)"TemplateFloatSettingPlugin_7", (String)"epm-eb-budget", (Object[])new Object[]{sb.substring(0, sb.length() - 1)}), MessageBoxOptions.YesNo, new ConfirmCallBackListener(DELETEFLOATAREA, (IFormPlugin)this));
                break;
            }
            case "bar-confirmorg": {
                if (StringUtils.isNotEmpty((String)this.getModel().getValue("select").toString())) {
                    String orgindex = this.getModel().getValue("select").toString();
                    if (this.checkOrgIndex(orgindex)) {
                        this.getModel().setValue(AREALISTEDIT, this.getModel().getValue("select"));
                        this.getView().setVisible(Boolean.valueOf(true), new String[]{"showpanel"});
                        this.getView().setVisible(Boolean.valueOf(false), new String[]{"orglocal"});
                        this.getPageCache().put(PAFETYPE, "show");
                        break;
                    }
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6ca1\u6709\u8bbe\u7f6e\u6d6e\u52a8\u7684\u4f4d\u7f6e\u3002", (String)"TemplateFloatSettingPlugin_8", (String)"epm-eb-budget", (Object[])new Object[0]));
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u884c\u5217\u3002", (String)"TemplateFloatSettingPlugin_9", (String)"epm-eb-budget", (Object[])new Object[0]));
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callback;
        super.confirmCallBack(messageBoxClosedEvent);
        switch (callback = messageBoxClosedEvent.getCallBackId()) {
            case "deletefloatarea": {
                if (!messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) break;
                this.deleteFloatArea();
                break;
            }
            case "ICADDAS": {
                if (!messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) break;
                EntryGrid eg = (EntryGrid)this.getControl(entryentity);
                DynamicObject ic = QueryServiceHelper.queryOne((String)"epm_icmembertree", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)this.getModelId()), new QFilter("number", "=", (Object)"ICOEntity")});
                String showtext = this.buildNewmembasShowname(ic.getString("name"), 1);
                this.getModel().setValue(NEWMEMBAS, (Object)showtext, eg.getSelectRows()[0]);
                this.getModel().setValue(NEWMEMAREA, ic.get("id"), eg.getSelectRows()[0]);
                this.getModel().setValue("scope", (Object)1, eg.getSelectRows()[0]);
                break;
            }
        }
    }

    private void deleteFloatArea() {
        EntryGrid entry = (EntryGrid)this.getControl(entryentity);
        int[] selectrows = entry.getEntryState().getSelectedRows();
        DynamicObjectCollection dcs = this.getModel().getEntryEntity(entryentity);
        HashSet<Integer> deleteset = new HashSet<Integer>();
        for (int selectttt : selectrows) {
            String area = ((DynamicObject)dcs.get(selectttt)).getString("selectarea");
            for (int i = 0; i < dcs.size(); ++i) {
                if (!area.equals(((DynamicObject)dcs.get(i)).getString("selectarea"))) continue;
                String selectarea = ((DynamicObject)dcs.get(i)).getString("selectarea");
                this.removeFromSelectAreas(selectarea);
                deleteset.add(i);
            }
        }
        int[] focus = ArrayUtils.toPrimitive((Integer[])deleteset.toArray(new Integer[deleteset.size()]));
        this.getModel().deleteEntryRows(entryentity, focus);
    }

    private void loadFloatArea() {
        this.getModel().deleteEntryData(entryentity);
        String pssch = (String)this.getView().getFormShowParameter().getCustomParam("ps");
        PositionInfo ps = (PositionInfo)this.deSerializedBytes(pssch);
        PositionInfo posio = this.getSpreadModel().getAreaManager().searchStorePositionInfo(ps);
        if (posio != null) {
            List bps = posio.getBasePoints();
            if (bps == null) {
                return;
            }
            for (BasePointInfo basePointInfo : bps) {
                List lines = basePointInfo.getBasePointInnerLineInfo();
                int direct = basePointInfo.getDirect();
                String floattype = direct == 1 ? "col" : "row";
                this.getPageCache().put(FLOATTYPE, floattype);
                for (BasePointInnerLineInfo basePointInnerLineInfo : lines) {
                    int newrow = this.getModel().createNewEntryRow(entryentity);
                    DynamicObject rowObj = this.getModel().getEntryRowEntity(entryentity, newrow);
                    rowObj.set("selectarea", (Object)basePointInfo.getDynaRange());
                    String entity = DimensionUtil.getDimMembEntityNumByDimNum(basePointInnerLineInfo.getDimension().getNumber());
                    rowObj.set("dim", (Object)entity);
                    rowObj.set("muldim", (Object)entity);
                    rowObj.set("showdim", (Object)basePointInnerLineInfo.getDimension().getName());
                    rowObj.set("dimnumber", (Object)basePointInnerLineInfo.getDimension().getNumber());
                    rowObj.set("isfloat", (Object)basePointInnerLineInfo.isFloated());
                    rowObj.set(ISSEQ, (Object)basePointInnerLineInfo.isSeq());
                    if (basePointInnerLineInfo.isFloated()) {
                        if (basePointInnerLineInfo.getMemberAddOf() != null) {
                            DynamicObject newmemarea = BusinessDataServiceHelper.loadSingle((Object)((DimMember)basePointInnerLineInfo.getMemberAddOf()).getId(), (String)entity);
                            rowObj.set(NEWMEMAREA, (Object)newmemarea);
                            rowObj.set(NEWMEMBAS, (Object)this.buildNewmembasShowname(newmemarea.getString("name"), basePointInnerLineInfo.getAddPositionEnum().getVal()));
                            rowObj.set("scope", (Object)basePointInnerLineInfo.getAddPositionEnum().getVal());
                        }
                        List roclist = "row".equals(floattype) ? (List)SpreadAreaUtil.getCol((String)basePointInfo.getDynaRange()) : (List)SpreadAreaUtil.getRow((String)basePointInfo.getDynaRange());
                        if (!basePointInnerLineInfo.isSeq()) {
                            rowObj.set(FLOATAREAINDEX, (Object)basePointInnerLineInfo.getOffset());
                            rowObj.set(FLOATAREA, (Object)this.buildComboShowName((String)roclist.get(basePointInnerLineInfo.getOffset())));
                        }
                        List ds = basePointInnerLineInfo.getDynaMembScopes();
                        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>(ds.size());
                        StringBuilder sb = new StringBuilder();
                        for (DynaMembScopeInfo dynaMembScopeInfo : ds) {
                            HashMap<String, String> map = new HashMap<String, String>();
                            map.put("id", String.valueOf(dynaMembScopeInfo.getMember().getId()));
                            map.put("scope", String.valueOf(dynaMembScopeInfo.getRange().getValue()));
                            map.put("number", dynaMembScopeInfo.getMember().getNumber());
                            map.put("name", dynaMembScopeInfo.getMember().getName());
                            sb.append(this.buildFloatMemShowname(dynaMembScopeInfo.getMember().getName(), dynaMembScopeInfo.getRange().getValue())).append(',');
                            list.add(map);
                        }
                        if (sb.length() > 0) {
                            rowObj.set(FLOATMEMTEXT, (Object)sb.substring(0, sb.length() - 1));
                        }
                        this.put2FloatMemMap(basePointInfo.getDynaRange(), basePointInnerLineInfo.getDimension().getNumber(), list);
                    } else {
                        DynaMembScopeInfo ms = (DynaMembScopeInfo)basePointInnerLineInfo.getDynaMembScopes().get(0);
                        DynamicObject unfloatmem = BusinessDataServiceHelper.loadSingle((Object)((DimMember)ms.getMember()).getId(), (String)entity);
                        rowObj.set(UNFLOATMEM, (Object)unfloatmem);
                    }
                    this.checkEnable(entity, basePointInnerLineInfo.getDimension().getNumber(), newrow);
                }
                this.put2SelectAreas(basePointInfo.getDynaRange());
            }
            if (posio.getFloatSummaryWay() != null) {
                this.getModel().setValue("summaryway", (Object)(posio.getFloatSummaryWay().ordinal() + 1));
                if (posio.getFloatSummaryWay() == PositionInfo.FloatSummaryWay.SUPPORT) {
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{"orgrange", AREALISTEDIT});
                } else {
                    this.buildAreaeditString();
                }
            } else {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"orgrange", AREALISTEDIT});
            }
            if (posio.getFloatOrgRange() != null) {
                this.getModel().setValue("orgrange", (Object)(posio.getFloatOrgRange().ordinal() + 3));
            }
            if (posio.getFloatMemDisplayPattern() != null) {
                this.getModel().setValue("displaypattern", (Object)(posio.getFloatMemDisplayPattern().ordinal() + 5));
            }
            if (posio.getOffsetIndex() != null) {
                String value = Joiner.on((String)",").join((Iterable)posio.getOffsetIndex());
                this.getModel().setValue("offset", (Object)value);
            }
        }
    }

    private void lockUnFloatMembBtn() {
        DynamicObjectCollection rows = this.getModel().getEntryEntity(entryentity);
        for (int rowIndex = 0; rowIndex < rows.size(); ++rowIndex) {
            if (!((DynamicObject)rows.get(rowIndex)).getBoolean("isfloat")) continue;
            this.getView().setEnable(Boolean.valueOf(false), rowIndex, new String[]{UNFLOATMEM});
        }
    }

    private void buildAreaeditString() {
        if (this.getPageCache().get(FLOATTYPE) != null) {
            String pssch = (String)this.getView().getFormShowParameter().getCustomParam("ps");
            PositionInfo ps = (PositionInfo)this.deSerializedBytes(pssch);
            String stpo = ps.getStartPosition();
            String type = this.getPageCache().get(FLOATTYPE);
            String val = "";
            val = "col".equals(type) ? ResManager.loadResFormat((String)"\u7b2c%1\u884c", (String)"TemplateFloatSettingPlugin_10", (String)"epm-eb-budget", (Object[])new Object[]{ps.getOrgMemColIndex() + ExcelUtils.pos2Y((String)stpo) + 1}) : ResManager.loadResFormat((String)"\u7b2c%1\u5217", (String)"TemplateFloatSettingPlugin_11", (String)"epm-eb-budget", (Object[])new Object[]{ExcelUtils.int2pos((int)(ps.getOrgMemColIndex() + ExcelUtils.pos2X((String)stpo)))});
            this.getModel().setValue(ORGINDEX, (Object)ps.getOrgMemColIndex());
            this.getModel().setValue(AREALISTEDIT, (Object)val);
        }
    }

    /*
     * WARNING - void declaration
     */
    private String saveModel() {
        String pssch = (String)this.getView().getFormShowParameter().getCustomParam("ps");
        PositionInfo ps = (PositionInfo)this.deSerializedBytes(pssch);
        PositionInfo posio = this.getSpreadModel().getAreaManager().searchStorePositionInfo(ps);
        DynamicObjectCollection doc = this.getModel().getEntryEntity(entryentity);
        LinkedHashMap<Object, void> map = new LinkedHashMap<Object, void>();
        for (DynamicObject obj : doc) {
            void var9_9;
            String select = obj.getString("selectarea");
            if (map.get(select) == null) {
                ArrayList arrayList = new ArrayList();
            } else {
                List list = (List)map.get(select);
            }
            var9_9.add(obj);
            map.put(select, var9_9);
        }
        Set set = map.entrySet();
        ArrayList<BasePointInfo> basePoints = new ArrayList<BasePointInfo>(set.size());
        for (Map.Entry entry : set) {
            String floattype = this.getPageCache().get(FLOATTYPE);
            int direct = "row".equals(floattype) ? 2 : 1;
            BasePointInfo bp = new BasePointInfo((String)entry.getKey(), direct);
            List list = (List)entry.getValue();
            boolean hasFloat = false;
            for (DynamicObject obj : list) {
                boolean isFloated = obj.getBoolean("isfloat");
                boolean isSeq = obj.getBoolean(ISSEQ);
                String name = obj.getString("showdim");
                String number = obj.getString("dimnumber");
                String dimentity = obj.getString("dim");
                Dimension dimension = new Dimension(name, number, dimentity);
                BasePointInnerLineInfo bpl = new BasePointInnerLineInfo(bp, (IDimension)dimension, isFloated);
                if (isFloated) {
                    hasFloat = true;
                    this.dealMemRange(bpl, obj, dimension);
                    DynamicObject memto = obj.getDynamicObject(NEWMEMAREA);
                    if (memto != null && !isSeq) {
                        DimMember memberAddOf = (DimMember)ObjectConvertUtils.toDimMember(memto, (IDimension)dimension);
                        memberAddOf.setId(memto.getLong("id"));
                        bpl.setMemberAddOf((IDimMember)memberAddOf);
                        int scope = obj.getInt("scope");
                        if (scope == 1) {
                            bpl.setAddPositionEnum(MembAddPositionEnum.DirectChild);
                        } else {
                            bpl.setAddPositionEnum(MembAddPositionEnum.Brother);
                        }
                    }
                    if (!isSeq) {
                        if (StringUtils.isEmpty((String)obj.getString(FLOATAREAINDEX))) {
                            this.noDataWarning();
                        }
                        int offset = obj.getInt(FLOATAREAINDEX);
                        bpl.setOffset(offset);
                    }
                } else {
                    ArrayList<DynaMembScopeInfo> ds = new ArrayList<DynaMembScopeInfo>(1);
                    DynamicObject unfloatmem = obj.getDynamicObject(UNFLOATMEM);
                    if (unfloatmem == null) {
                        this.noDataWarning();
                    }
                    DimMember member = (DimMember)ObjectConvertUtils.toDimMember(unfloatmem, (IDimension)dimension);
                    member.setId(unfloatmem.getLong("id"));
                    DynaMembScopeInfo ms = new DynaMembScopeInfo((IDimMember)member, kd.epm.eb.common.ebcommon.common.enums.RangeEnum.VALUE_10);
                    ds.add(ms);
                    bpl.setDynaMembScopes(ds);
                }
                if (isSeq) {
                    bpl.setSeq(true);
                    bpl.setOffset(-1);
                }
                bp.addBasePointInnerLineInfo(bpl);
            }
            if (!hasFloat) {
                return ResManager.loadKDString((String)"\u540c\u6d6e\u52a8\u8303\u56f4\u81f3\u5c11\u8bbe\u7f6e\u4e00\u4e2a\u6d6e\u52a8\u6210\u5458\u3002", (String)"TemplateFloatSettingPlugin_122", (String)"epm-eb-budget", (Object[])new Object[0]);
            }
            basePoints.add(bp);
        }
        posio.setBasePoints(basePoints);
        this.setInfo(posio);
        IPageCache pageCache = (IPageCache)this.getView().getParentView().getService(IPageCache.class);
        pageCache.put("returnpositioninfo", ObjectSerialUtil.toByteSerialized((Object)posio));
        this.cacheSpreadModel();
        return null;
    }

    private void dealMemRange(BasePointInnerLineInfo bpl, DynamicObject obj, Dimension dimension) {
        String key = obj.getString("selectarea") + obj.getString("dimnumber");
        String memsc = this.getPageCache().get(key);
        if (StringUtils.isEmpty((String)memsc)) {
            return;
        }
        List list = (List)SerializationUtils.fromJsonString((String)memsc, List.class);
        ArrayList<DynaMembScopeInfo> ds = new ArrayList<DynaMembScopeInfo>(list.size());
        for (Map map : list) {
            DimMember member = new DimMember((String)map.get("name"), (String)map.get("number"), null, (IDimension)dimension);
            member.setId(Long.parseLong((String)map.get("id")));
            String scope = (String)map.get("scope");
            kd.epm.eb.common.ebcommon.common.enums.RangeEnum range = kd.epm.eb.common.ebcommon.common.enums.RangeEnum.getRangeByVal((int)Integer.parseInt(scope));
            DynaMembScopeInfo ms = StringUtils.isEmpty((String)((String)map.get("propid"))) ? new DynaMembScopeInfo((IDimMember)member, range) : new DynaMembScopeInfo((IDimMember)member, range, true);
            ds.add(ms);
        }
        bpl.setDynaMembScopes(ds);
    }

    @Override
    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btn-confirm": {
                String s = this.saveModel();
                if (StringUtils.isNotEmpty((String)s)) {
                    this.getView().showTipNotification(s);
                    return;
                }
                CommandParam com = new CommandParam("eb_template_floatsetting", null, "changeMark", new Object[]{this.getSpreadModel()});
                this.sendMsg(this.getView(), com);
                if (ModelUtil.queryApp(this.getView()) == ApplicationTypeEnum.RPT) {
                    this.getView().returnDataToParent((Object)this.getSpreadModel());
                }
                this.getView().close();
                break;
            }
            case "arealistedit": {
                if (this.getPageCache().get(FLOATTYPE) == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u6dfb\u52a0\u6d6e\u52a8\u8303\u56f4\u3002", (String)"TemplateFloatSettingPlugin_13", (String)"epm-eb-budget", (Object[])new Object[0]));
                    break;
                }
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"showpanel"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"orglocal"});
                this.getPageCache().put(PAFETYPE, SelectPageType.FLOAT.getName());
                break;
            }
            case "newmembas": {
                if (!this.isFloatRow()) {
                    return;
                }
                EntryGrid eg = (EntryGrid)this.getControl(entryentity);
                DynamicObject obj = this.getModel().getEntryRowEntity(entryentity, eg.getSelectRows()[0]);
                if (DimTypesEnum.INTERCOMPANY.getNumber().equals(obj.getString("dimnumber"))) {
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5f80\u6765\u7ec4\u7ec7\u786e\u8ba4\u8981\u5141\u8bb8\u65b0\u589e\u4e0b\u7ea7\uff1f", (String)"TemplateFloatSettingPlugin_14", (String)"epm-eb-budget", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5f80\u6765\u7ec4\u7ec7\u53ea\u80fd\u9009\u62e9\u5916\u90e8\u7ec4\u7ec7\u53ca\u5176\u4e0b\u7ea7\u4f5c\u4e3a\u65b0\u589e\u6210\u5458\u4f4d\u7f6e\u3002", (String)"TemplateFloatSettingPlugin_15", (String)"epm-eb-budget", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("ICADDAS", (IFormPlugin)this));
                    break;
                }
                this.showSingleF7(key, SingleF7TypeEnum.COMMON);
                break;
            }
            case "floatmemtext": {
                if (!this.isFloatRow()) {
                    return;
                }
                EntryGrid eg = (EntryGrid)this.getControl(entryentity);
                DynamicObject obj = this.getModel().getEntryRowEntity(entryentity, eg.getSelectRows()[0]);
                Long modelId = this.getTemplateModel().getModelId();
                DynamicObject dim = QueryDimensionServiceHelper.getMsgByNumber((long)modelId, (String)obj.getString("dimnumber"));
                this.getPageCache().put("KEY_MODEL_ID", String.valueOf(this.getTemplateModel().getModelId()));
                MemberF7Parameter f8Param = NewF7Utils.multipleF8((Long)modelId, (DynamicObject)dim, (String)DynamicObjectCollection.class.getName());
                f8Param.setRangeType(F7RangeTypeEnum.DEFAULT);
                f8Param.setDefRangeValue(RangeEnum.ALL_DETAIL);
                f8Param.setViewSign(obj.getString("selectarea") + obj.getString("dimnumber"));
                CustomF7utils.loadCacheSelectedData((IFormView)this.getView(), (MemberF7Parameter)f8Param);
                NewF7Utils.openF8((IFormView)this.getView(), (MemberF7Parameter)f8Param, (CloseCallBack)new CloseCallBack((IFormPlugin)this, FLOATMEMTEXT));
                break;
            }
            case "showfloatarea": {
                if (!this.isFloatRow()) {
                    return;
                }
                List<String> list = this.getSelectRowFloatRowOrCol();
                ComboEdit comboEdit = (ComboEdit)this.getControl("combofield");
                ArrayList items = new ArrayList();
                ArrayList<String[]> keysAndValues = new ArrayList<String[]>(list.size());
                for (int i = 0; i < list.size(); ++i) {
                    String[] keysAndValue = new String[]{this.buildComboShowName(list.get(i)), String.valueOf(i)};
                    keysAndValues.add(keysAndValue);
                }
                keysAndValues.forEach(new DynamicEnum(items));
                comboEdit.setComboItems(items);
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"showpanel"});
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"combopanel"});
                this.getModel().setValue("combofield", (Object)0);
                this.getPageCache().put(PAFETYPE, SelectPageType.FLOAT.getName());
                break;
            }
        }
    }

    private boolean isFloatRow() {
        return (Boolean)this.getModel().getValue("isfloat", this.getModel().getEntryCurrentRowIndex(entryentity));
    }

    private String buildComboShowName(String in) {
        String floattype = this.getPageCache().get(FLOATTYPE);
        String name = "row".equals(floattype) ? ResManager.loadKDString((String)"\u5217", (String)"TemplateFloatSettingPlugin_12", (String)"epm-eb-budget", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u884c", (String)"TemplateFloatSettingPlugin_121", (String)"epm-eb-budget", (Object[])new Object[0]);
        return ResManager.loadResFormat((String)"\u7b2c%1%2", (String)"TemplateFloatSettingPlugin_22", (String)"epm-eb-budget", (Object[])new Object[]{in, name});
    }

    private List<String> getSelectRowFloatRowOrCol() {
        EntryGrid eg = (EntryGrid)this.getControl(entryentity);
        DynamicObject obj = this.getModel().getEntryRowEntity(entryentity, eg.getSelectRows()[0]);
        String floattype = this.getPageCache().get(FLOATTYPE);
        List list = new ArrayList();
        list = "row".equals(floattype) ? (List)SpreadAreaUtil.getCol((String)obj.getString("selectarea")) : (List)SpreadAreaUtil.getRow((String)obj.getString("selectarea"));
        return list;
    }

    private void showSingleF7(String key, SingleF7TypeEnum typeEnum) {
        EntryGrid eg = (EntryGrid)this.getControl(entryentity);
        DynamicObject obj = this.getModel().getEntryRowEntity(entryentity, eg.getSelectRows()[0]);
        QFilter numberFilter = new QFilter("number", "=", obj.get("dimnumber"));
        DynamicObject dimObj = BusinessDataServiceHelper.loadSingle((String)"epm_dimension", (String)"id,number,name,dseq,membermodel", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)this.getTemplateModel().getModelId()), numberFilter});
        BasedataEditSingleMemberF7 f7 = SingleMemberF7Util.createBasedataEditSingleMemberF7(this.getView(), this.getModel(), this.getTemplateModel().getModelId(), dimObj.getLong("id"), key, null, true, typeEnum);
        f7.setF7title(ResManager.loadKDString((String)"\u6210\u5458\u9009\u62e9", (String)"TemplateFloatSettingPlugin_17", (String)"epm-eb-budget", (Object[])new Object[0]));
        if (NEWMEMBAS.equals(key)) {
            f7.setFormId("eb_singlemember_float");
        }
        f7.setCallBackClassName(this.getClass().getName());
        f7.setStatus(OperationStatus.EDIT);
        f7.setScope(obj.getInt("scope"));
        f7.click();
    }

    @Override
    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String pagetype = this.getPageCache().get(PAFETYPE);
        if (SelectPageType.FLOAT.getName().equals(pagetype)) {
            e.setCancel(true);
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"showpanel"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"areapanel", "combopanel", "orglocal"});
            this.getPageCache().put(PAFETYPE, "show");
        }
    }

    private boolean checkCell(String area) {
        try {
            int[] rangeSxy = ExcelUtils.pos2XY((String)area.split(":")[0]);
            int[] rangeExy = ExcelUtils.pos2XY((String)area.split(":")[1]);
            int cc = rangeExy[0] - rangeSxy[0] + 1;
            int rc = rangeExy[1] - rangeSxy[1] + 1;
            if (cc == 0 || rc == 0) {
                throw new NumberFormatException();
            }
            return true;
        }
        catch (Exception e3) {
            log.error((Throwable)e3);
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u5355\u5143\u683c\u8303\u56f4\u3002", (String)"TemplateFloatSettingPlugin_18", (String)"epm-eb-budget", (Object[])new Object[0]));
        }
    }

    private void noDataWarning() {
        throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5b8c\u6574\u586b\u5199\u6bcf\u4e00\u884c\u3002", (String)"TemplateFloatSettingPlugin_19", (String)"epm-eb-budget", (Object[])new Object[0]));
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        BasedataEdit bs = (BasedataEdit)arg0.getSource();
        String methodName = PlatUtil.getOpMethod();
        if ("click".equalsIgnoreCase(methodName)) {
            arg0.setCancel(true);
            this.showSingleF7(bs.getKey(), SingleF7TypeEnum.LEAF);
        } else if ("getLookupList".equalsIgnoreCase(methodName)) {
            EntryGrid eg = (EntryGrid)this.getControl(entryentity);
            DynamicObject obj = this.getModel().getEntryRowEntity(entryentity, eg.getSelectRows()[0]);
            QFilter filter = null;
            QFilter numberFilter = new QFilter("number", "=", obj.get("dimnumber"));
            DynamicObject dimObj = BusinessDataServiceHelper.loadSingle((String)"epm_dimension", (String)"id,number,name,dseq,membermodel", (QFilter[])new QFilter[]{this.getQFilterByModelID(), numberFilter});
            if (filter == null) {
                filter = new QFilter("dimension", "=", (Object)dimObj.getLong("id"));
            }
            ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            qFilters.add(filter);
            showParameter.setListFilterParameter(new ListFilterParameter(qFilters, (String)null));
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (FLOATMEMTEXT.equals(actionId)) {
            DynamicObjectCollection doc = (DynamicObjectCollection)closedCallBackEvent.getReturnData();
            EntryGrid eg = (EntryGrid)this.getControl(entryentity);
            DynamicObject selobj = this.getModel().getEntryRowEntity(entryentity, eg.getSelectRows()[0]);
            ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
            if (doc == null) {
                return;
            }
            if (!doc.isEmpty()) {
                this.getModel().setValue("muldim", this.getModel().getValue("dim"), eg.getSelectRows()[0]);
                StringBuilder sb = new StringBuilder();
                Object[] ids = new Object[doc.size()];
                for (int i = 0; i < doc.size(); ++i) {
                    DynamicObject object = (DynamicObject)doc.get(i);
                    ids[i] = object.get("id");
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("id", object.getString("id"));
                    map.put("scope", object.getString("scope"));
                    map.put("number", object.getString("number"));
                    map.put("name", object.getString("name"));
                    map.put("pid", object.getString("pid"));
                    sb.append(this.buildFloatMemShowname(object.getString("name"), object.getInt("scope"))).append(',');
                    list.add(map);
                }
                this.getModel().setValue(FLOATMEMTEXT, (Object)sb.substring(0, sb.length() - 1), eg.getSelectRows()[0]);
            } else {
                this.getModel().setValue(FLOATMEMTEXT, null, eg.getSelectRows()[0]);
            }
            this.put2FloatMemMap(selobj.getString("selectarea"), selobj.getString("dimnumber"), list);
        } else if (NEWMEMBAS.equals(actionId) && closedCallBackEvent.getReturnData() != null) {
            DynamicObject result = (DynamicObject)closedCallBackEvent.getReturnData();
            EntryGrid eg = (EntryGrid)this.getControl(entryentity);
            String showtext = this.buildNewmembasShowname(result.getString("name"), result.getInt("scopeval"));
            this.getModel().setValue(actionId, (Object)showtext, eg.getSelectRows()[0]);
            this.getModel().setValue(NEWMEMAREA, result.get("id"), eg.getSelectRows()[0]);
            this.getModel().setValue("scope", result.get("scopeval"), eg.getSelectRows()[0]);
        } else if (closedCallBackEvent.getReturnData() != null) {
            DynamicObject result = (DynamicObject)closedCallBackEvent.getReturnData();
            EntryGrid eg = (EntryGrid)this.getControl(entryentity);
            this.getModel().setValue(actionId, result.get("id"), eg.getSelectRows()[0]);
        }
    }

    public void handleData(BasedataFuzzySearchEvent arg0) {
    }

    private void put2SelectAreas(String select) {
        String floattype;
        SpreadSelectTypeEnum areainwhere;
        String selectarea = this.getPageCache().get(SELECTAREAS);
        List alist = StringUtils.isEmpty((String)selectarea) ? new ArrayList() : (List)SerializationUtils.fromJsonString((String)selectarea, List.class);
        if (SpreadAreaUtil.Area_contains_xy((String)select, alist, (SpreadSelectTypeEnum)(areainwhere = "col".equals(floattype = this.getPageCache().get(FLOATTYPE)) ? SpreadSelectTypeEnum.RIGHT_TOP : SpreadSelectTypeEnum.LEFT_BOTTOM))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u533a\u57df\u548c\u5df2\u9009\u62e9\u7684\u8303\u56f4\u91cd\u53e0\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"TemplateFloatSettingPlugin_20", (String)"epm-eb-budget", (Object[])new Object[0]));
        }
        alist.add(select);
        this.getPageCache().put(SELECTAREAS, SerializationUtils.toJsonString(alist));
    }

    private void removeFromSelectAreas(String select) {
        String selectarea = this.getPageCache().get(SELECTAREAS);
        if (StringUtils.isNotEmpty((String)selectarea)) {
            List alist = (List)SerializationUtils.fromJsonString((String)selectarea, List.class);
            alist.remove(select);
            this.getPageCache().put(SELECTAREAS, SerializationUtils.toJsonString((Object)alist));
        }
    }

    private void put2FloatMemMap(String select, String dimnum, List<Map<String, String>> doc) {
        String key = select + dimnum;
        this.getPageCache().put(key, SerializationUtils.toJsonString(doc));
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        List<String> list;
        String area;
        EntryGrid eg;
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (this.getPageCache() == null || "false".equals(this.getPageCache().get("change"))) {
            return;
        }
        if (FLOATMEMTEXT.equals(key) && e.getChangeSet()[0].getNewValue() == null) {
            eg = (EntryGrid)this.getControl(entryentity);
            DynamicObject selobj = this.getModel().getEntryRowEntity(entryentity, eg.getSelectRows()[0]);
            String cakey = selobj.getString("selectarea") + selobj.getString("dimnumber");
            this.getPageCache().put(cakey, null);
        }
        if ("summaryway".equals(key)) {
            if (this.getModel().getValue("summaryway").equals("1")) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"orgrange", AREALISTEDIT});
                this.getModel().setValue(AREALISTEDIT, (Object)"");
            } else {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"orgrange", AREALISTEDIT});
            }
        }
        if ("area".equals(key)) {
            area = e.getChangeSet()[0].getNewValue().toString();
            this.checkCell(area);
            String cell = area.split(":")[0];
            if (this.getPageCache().get(FLOATTYPE) != null && StringUtils.isNotEmpty((String)cell)) {
                String pssch = (String)this.getView().getFormShowParameter().getCustomParam("ps");
                PositionInfo ps = (PositionInfo)this.deSerializedBytes(pssch);
                String stpo = ps.getStartPosition();
                String type = this.getPageCache().get(FLOATTYPE);
                String val = "";
                if ("col".equals(type)) {
                    ExcelUtils.pos2Y((String)stpo);
                    val = ResManager.loadResFormat((String)"\u7b2c%1\u884c", (String)"TemplateFloatSettingPlugin_10", (String)"epm-eb-budget", (Object[])new Object[]{ExcelUtils.pos2Y((String)cell) + 1});
                    this.getModel().setValue(ORGINDEX, (Object)(ExcelUtils.pos2Y((String)cell) - ExcelUtils.pos2Y((String)stpo)));
                } else {
                    val = ResManager.loadResFormat((String)"\u7b2c%1\u5217", (String)"TemplateFloatSettingPlugin_11", (String)"epm-eb-budget", (Object[])new Object[]{ExcelUtils.int2pos((int)ExcelUtils.pos2X((String)cell))});
                    this.getModel().setValue(ORGINDEX, (Object)(ExcelUtils.pos2X((String)cell) - ExcelUtils.pos2X((String)stpo)));
                }
                this.getModel().setValue("select", (Object)val);
            }
        }
        if ("dataarea".equals(key)) {
            area = e.getChangeSet()[0].getNewValue().toString();
            String ca = this.getPageCache().get("dataareamap");
            Map map = (Map)SerializationUtils.fromJsonString((String)ca, Map.class);
            this.switchDataArea((String)map.get(area));
        }
        if ("isfloat".equals(key)) {
            eg = (EntryGrid)this.getControl(entryentity);
            int currentRow = eg.getSelectRows()[0];
            if (e.getChangeSet()[0].getNewValue().equals(true)) {
                list = this.getSelectRowFloatRowOrCol();
                if (list.size() == 1) {
                    this.getModel().setValue(FLOATAREAINDEX, (Object)0, currentRow);
                    this.getModel().setValue(FLOATAREA, (Object)this.buildComboShowName(list.get(0)), currentRow);
                }
                this.getView().setEnable(Boolean.valueOf(false), currentRow, new String[]{UNFLOATMEM});
            } else {
                this.getView().setEnable(Boolean.valueOf(true), currentRow, new String[]{UNFLOATMEM});
            }
        }
        if (ISSEQ.equals(key)) {
            if (e.getChangeSet()[0].getNewValue().equals(true)) {
                DimMember mem = SeqLogicImpl.getParentSeqMem(this.getModelId());
                StringBuilder sb = new StringBuilder();
                list = new ArrayList<String>();
                EntryGrid eg2 = (EntryGrid)this.getControl(entryentity);
                DynamicObject selobj = this.getModel().getEntryRowEntity(entryentity, eg2.getSelectRows()[0]);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", String.valueOf(mem.getId()));
                map.put("scope", String.valueOf(kd.epm.eb.common.ebcommon.common.enums.RangeEnum.VALUE_90.getValue()));
                map.put("number", mem.getNumber());
                map.put("name", mem.getName());
                map.put("pid", "");
                sb.append(this.buildFloatMemShowname(mem.getName(), kd.epm.eb.common.ebcommon.common.enums.RangeEnum.VALUE_90.getValue())).append(",");
                list.add((String)((Object)map));
                this.getModel().setValue(FLOATMEMTEXT, (Object)sb.substring(0, sb.length() - 1), eg2.getSelectRows()[0]);
                this.getModel().setValue(NEWMEMBAS, null, eg2.getSelectRows()[0]);
                this.getModel().setValue(NEWMEMAREA, null, eg2.getSelectRows()[0]);
                this.getModel().setValue("scope", null, eg2.getSelectRows()[0]);
                this.put2FloatMemMap(selobj.getString("selectarea"), selobj.getString("dimnumber"), list);
            } else {
                eg = (EntryGrid)this.getControl(entryentity);
                this.getModel().setValue("isfloat", (Object)false, eg.getSelectRows()[0]);
            }
        }
    }

    private void switchDataArea(String area) {
        PositionInfo p = null;
        for (PositionInfo e : this.getSpreadModel().getAreaManager().getPostionInfoSet()) {
            if (!e.getAreaRange().equals(area)) continue;
            p = e;
            break;
        }
        if (p != null) {
            this.getView().getFormShowParameter().setCustomParam("ps", (Object)this.toByteSerialized(p));
            this.getView().cacheFormShowParameter();
            this.getPageCache().put("change", "false");
            this.getPageCache().put(SELECTAREAS, null);
            this.loadFloatArea();
            this.getView().updateView(entryentity);
            this.lockUnFloatMembBtn();
            this.getPageCache().put("change", "true");
        }
    }

    private void setInfo(PositionInfo posio) {
        Object summaryWay = this.getModel().getValue("summaryway");
        Object orgRange = this.getModel().getValue("orgrange");
        Object displayPattern = this.getModel().getValue("displaypattern");
        if (summaryWay.equals("1")) {
            posio.setOrgMemColIndex(-1);
            posio.setFloatSummaryWay(PositionInfo.FloatSummaryWay.SUPPORT);
        } else {
            if (StringUtils.isNotEmpty((String)this.getModel().getValue(AREALISTEDIT).toString()) && StringUtils.isNotEmpty((String)this.getModel().getValue(ORGINDEX).toString())) {
                posio.setOrgMemColIndex(Integer.parseInt((String)this.getModel().getValue(ORGINDEX)));
            }
            posio.setFloatSummaryWay(PositionInfo.FloatSummaryWay.NONSUPPORT);
        }
        if (orgRange.equals("3")) {
            posio.setFloatOrgRange(PositionInfo.FloatOrgRange.LEAF);
        } else {
            posio.setFloatOrgRange(PositionInfo.FloatOrgRange.DIRECT);
        }
        if (displayPattern.equals("5")) {
            posio.setFloatMemDisplayPattern(PositionInfo.FloatMemDisplayPattern.NAME);
        } else if (displayPattern.equals("6")) {
            posio.setFloatMemDisplayPattern(PositionInfo.FloatMemDisplayPattern.NAMEANDNUMBER);
        } else {
            posio.setFloatMemDisplayPattern(PositionInfo.FloatMemDisplayPattern.NUMBER);
        }
        if (this.getModel().getValue("offset") != null) {
            String offset = this.getModel().getValue("offset").toString();
            ArrayList offsetindex = new ArrayList();
            Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)offset).forEach(i -> offsetindex.add(Integer.valueOf(i)));
            posio.setOffsetIndex(offsetindex);
        }
    }

    private String buildNewmembasShowname(String name, int scope) {
        String showtext = ResManager.loadResFormat((String)"\"%1\"\u7684%2", (String)"TemplateFloatSettingPlugin_21", (String)"epm-eb-budget", (Object[])new Object[]{name, MembAddPositionEnum.getMembAddPositionEnumByVal((int)scope).getName()});
        return showtext;
    }

    private String buildFloatMemShowname(String name, int scope) {
        String showtext = kd.epm.eb.common.ebcommon.common.enums.RangeEnum.getRangeByVal((int)scope) == kd.epm.eb.common.ebcommon.common.enums.RangeEnum.VALUE_10 ? name : ResManager.loadResFormat((String)"\"%1\"\u7684%2", (String)"TemplateFloatSettingPlugin_21", (String)"epm-eb-budget", (Object[])new Object[]{name, kd.epm.eb.common.ebcommon.common.enums.RangeEnum.getRangeByVal((int)scope).getName()});
        return showtext;
    }

    private boolean checkOrgIndex(String orgindex) {
        DynamicObjectCollection doc = this.getModel().getEntryEntity(entryentity);
        for (DynamicObject obj : doc) {
            String select = obj.getString(FLOATAREA);
            if (!orgindex.equals(select)) continue;
            return false;
        }
        return true;
    }

    private DimMember getSeqMem() {
        return null;
    }
}

