/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.budget.formplugin.template;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.OperationStatus;
import kd.bos.data.BusinessDataReader;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.eb.budget.formplugin.common.IRefreshList;
import kd.epm.eb.budget.formplugin.template.AbstractTemplateListPlugin;
import kd.epm.eb.budget.formplugin.template.model.TemplateCopyUpdateDomain;
import kd.epm.eb.budget.formplugin.template.util.EBOldTemplateDataResolveUtil;
import kd.epm.eb.budget.formplugin.template.util.TemplateCopyUpdateUtils;
import kd.epm.eb.budget.formplugin.template.util.TemplateExportPlugin;
import kd.epm.eb.budget.formplugin.util.ApplicationUtils;
import kd.epm.eb.budget.formplugin.util.TemplateUtil;
import kd.epm.eb.business.utils.ImportAndExportUtil;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.ebcommon.common.MessageConstant;
import kd.epm.eb.common.ebcommon.common.util.GlobalIdUtil;
import kd.epm.eb.common.ebcommon.common.util.ObjectSerialUtil;
import kd.epm.eb.common.ebcommon.common.util.PeriodUtils;
import kd.epm.eb.common.ebcommon.enums.TemplateTypeEnum;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.enums.memberQuote.MemberQuoteResourceEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.ebBusiness.serviceHelper.QueryMemberDetailsHelper;
import kd.epm.eb.ebBusiness.serviceHelper.TemplateServiceHelper;
import kd.epm.eb.ebBusiness.template.model.TemplateCatalog;
import kd.epm.eb.ebBusiness.template.model.TemplateModel;
import kd.epm.eb.ebBusiness.util.dynamicobject.DynamicObjectCollectionUtil;
import kd.epm.eb.ebSpread.common.util.StringUtil;
import kd.epm.eb.ebSpread.util.GZIPUtils;
import kd.epm.eb.model.utils.UserSelectUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;

public class TemplateListPlugin
extends AbstractTemplateListPlugin
implements IRefreshList {
    private static final String IMPORTDATABACK = "importdataback";
    private static final String action_version = "btn_version";
    TemplateCopyUpdateDomain copyUpdateDomain;

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Long modelId = IDUtils.toLong((Object)this.getView().getFormShowParameter().getCustomParam("KEY_MODEL_ID"));
        if (modelId == null || modelId == 0L) {
            modelId = UserSelectUtil.getModelIdAfterCreateNewData((IFormView)this.getView(), (String)"modelbd", (boolean)false);
        } else {
            UserSelectUtil.saveUserSelectWhenModelChange((IFormView)this.getView(), (Long)modelId);
        }
        if (modelId == null || modelId == 0L) {
            BillList billList = (BillList)this.getView().getControl("billlistap");
            billList.setFilter(new QFilter("1", "!=", (Object)1));
            this.getView().showTipNotification(MessageConstant.getMODEL_NOTEXISTS());
            return;
        }
        this.getModel().setValue("modelbd", (Object)modelId);
        this.modelChange(modelId);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{action_version});
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        if (!this.validator()) {
            return;
        }
        switch (key = e.getProperty().getName()) {
            case "modelbd": {
                Long modelId = UserSelectUtil.getF7SelectId((IFormView)this.getView(), (String)"modelbd");
                if (modelId == null || modelId == 0L) {
                    this.getModel().setValue("modelbd", (Object)this.getPageCache().get("KEY_MODEL_ID"));
                    break;
                }
                if (modelId.equals(IDUtils.toLong((Object)this.getPageCache().get("KEY_MODEL_ID")))) {
                    return;
                }
                UserSelectUtil.saveUserSelectWhenModelChange((IFormView)this.getView(), (Long)modelId);
                this.modelChange(modelId);
                break;
            }
        }
    }

    private void modelChange(Long modelId) {
        this.getPageCache().put("KEY_MODEL_ID", modelId.toString());
        FilterParameter fp = new FilterParameter();
        QFilter filter = new QFilter("model", "=", (Object)modelId);
        fp.setFilter(filter);
        BillList billList = (BillList)this.getControl("billlistap");
        billList.setFilterParameter(fp);
        this.refrushTree();
        this.refrushBillList();
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "btn_addcustomtemplate": {
                this.openFormPage("eb_templateentity_bg", false);
                break;
            }
            case "btn_deltemplate": {
                this.deleteTemplate();
                break;
            }
            case "btn_refrush": {
                this.refrushBillList();
                this.refrushTree();
                break;
            }
            case "btn_export": {
                this.barexport();
                break;
            }
            case "btn_import": {
                this.importTemplate();
                break;
            }
            case "btn_distribution": {
                this.showDistributionView();
                break;
            }
            case "baritemup": 
            case "baritemdown": {
                this.downAndUpRptTemplate(key);
                break;
            }
            case "barcopy": {
                this.copyTemplate(false);
                break;
            }
            case "barcopyupdate": {
                this.copyUpdateTemplate();
                break;
            }
            case "btn_reset": {
                this.deleteRoport();
                break;
            }
            case "btn_version": {
                this.versionReportTpl();
                break;
            }
            case "btn_enable": 
            case "btn_disable": {
                BillList billList = (BillList)this.getControl("billlistap");
                ListSelectedRowCollection dys = billList.getSelectedRows();
                if (dys == null || dys.size() == 0) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5177\u4f53\u884c\u3002", (String)"TemplateListPlugin_0", (String)"epm-eb-budget", (Object[])new Object[0]));
                }
                if (StringUtil.equals((String)"btn_enable", (String)key)) {
                    Set<String> unEffectiveDate = TemplateUtil.updateReportStatus("1", dys.getPrimaryKeyValues(), true);
                    if (unEffectiveDate.size() > 0) {
                        this.getView().showMessage(ResManager.loadKDString((String)"\u90e8\u5206\u6a21\u677f\u56e0\u751f\u6548\u65e5\u671f\u4e3a\u7a7a\u542f\u7528\u5931\u8d25\uff0c\u8bf7\u5728\u7248\u672c\u5316\u4e2d\u7ef4\u62a4\u751f\u6548\u65e5\u671f\u3002", (String)"TemplateListPlugin_1", (String)"epm-eb-budget", (Object[])new Object[0]), unEffectiveDate.toString(), MessageTypes.Default);
                    } else {
                        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u542f\u7528", "TemplateListPlugin_47", "epm-eb-budget");
                        MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u542f\u7528\u6a21\u677f\uff1a%1$s", "TemplateListPlugin_48", "epm-eb-budget");
                        this.writeLog(null, "enable", opName, opDesc, new String[]{Arrays.toString(dys.getPrimaryKeyValues())});
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"TemplateListPlugin_32", (String)"epm-eb-budget", (Object[])new Object[0]));
                    }
                } else if (StringUtil.equals((String)"btn_disable", (String)key)) {
                    TemplateUtil.updateReportStatus("0", dys.getPrimaryKeyValues(), false);
                    MultiLangEnumBridge opName = new MultiLangEnumBridge("\u7981\u7528", "TemplateListPlugin_49", "epm-eb-budget");
                    MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u7981\u7528\u6a21\u677f\uff1a%1$s", "TemplateListPlugin_50", "epm-eb-budget");
                    this.writeLog(null, "disable", opName, opDesc, new String[]{Arrays.toString(dys.getPrimaryKeyValues())});
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"TemplateListPlugin_33", (String)"epm-eb-budget", (Object[])new Object[0]));
                }
                this.refrushBillList();
                break;
            }
        }
    }

    protected void downAndUpRptTemplate(String key) {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows == null || selectedRows.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u4e2a\u6a21\u677f\u3002", (String)"TemplateListPlugin_3", (String)"epm-eb-budget", (Object[])new Object[0]));
            return;
        }
        if (selectedRows.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u4e2a\u6a21\u677f\u8fdb\u884c\u79fb\u52a8\u3002", (String)"TemplateListPlugin_4", (String)"epm-eb-budget", (Object[])new Object[0]));
            return;
        }
        String modelID = this.getPageCache().get("KEY_MODEL_ID");
        this.initHistoryData(modelID);
        DynamicObject dyTemplate = BusinessDataServiceHelper.loadSingle((Object)selectedRows.get(0).getPrimaryKeyValue(), (String)"id,number,sequence", (String)"eb_templateentity_bg");
        if ("baritemup".equals(key)) {
            this.moveRptTemplateUp(dyTemplate, modelID);
        } else if ("baritemdown".equals(key)) {
            this.moveRptTemplateDown(dyTemplate, modelID);
        }
        this.writeLog(dyTemplate.getString("number"), "move", new MultiLangEnumBridge("\u79fb\u52a8", "BgTemplateListPlugin_45", "epm-eb-formplugin"), new MultiLangEnumBridge("\u6a21\u677f\u76ee\u5f55\u79fb\u52a8\u6210\u529f", "TemplateListPlugin_38", "epm-eb-budget"), null);
        billList.setOrderBy("sequence");
        billList.refresh();
    }

    public void initHistoryData(String modelId) {
        QFilter modelFilter = new QFilter("model", "=", (Object)IDUtils.toLong((Object)modelId));
        QFilter[] filters = new QFilter[]{modelFilter};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)this.getClass().getName(), (String)"eb_templateentity_bg", (String)"id,sequence", (QFilter[])filters, (String)"number");
        if (dcs != null && dcs.size() > 0) {
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (DynamicObject dy : dcs) {
                String id = dy.getString("id");
                arrayList.add(id);
                map.put(id, Integer.valueOf(dy.getString("sequence")));
            }
            if (map.values().contains(0)) {
                DynamicObject dyTemplateEntity = BusinessDataServiceHelper.newDynamicObject((String)"eb_templateentity_bg");
                Object[] dyObjSeqs = (DynamicObject[])BusinessDataReader.load((Object[])arrayList.toArray(), (IDataEntityType)EntityMetadataCache.getDataEntityType((String)dyTemplateEntity.getDynamicObjectType().getName()));
                for (int i = 0; i < dyObjSeqs.length; ++i) {
                    dyObjSeqs[i].set("sequence", (Object)(i + 1));
                }
                SaveServiceHelper.save((IDataEntityType)EntityMetadataCache.getDataEntityType((String)dyTemplateEntity.getDynamicObjectType().getName()), (Object[])dyObjSeqs);
            }
        }
    }

    private void moveRptTemplateUp(DynamicObject dyTemplate, String modelID) {
        int seq = dyTemplate.getInt("sequence");
        if (seq == 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6a21\u677f\u5df2\u662f\u5f53\u524d\u8282\u70b9\u7684\u6700\u9876\u5c42\uff0c\u4e0d\u80fd\u4e0a\u79fb\u3002", (String)"TemplateListPlugin_5", (String)"epm-eb-budget", (Object[])new Object[0]));
            return;
        }
        QFilter qf1 = new QFilter("sequence", "=", (Object)(seq - 1));
        QFilter qf2 = new QFilter("model", "=", (Object)IDUtils.toLong((Object)modelID));
        QFilter[] filters = new QFilter[]{qf1, qf2};
        DynamicObject dyTemplate2 = BusinessDataServiceHelper.loadSingle((String)"eb_templateentity_bg", (String)"id", (QFilter[])filters);
        dyTemplate2 = BusinessDataServiceHelper.loadSingle((Object)dyTemplate2.getPkValue(), (DynamicObjectType)dyTemplate.getDynamicObjectType());
        int seq2 = dyTemplate2.getInt("sequence");
        dyTemplate2.set("sequence", (Object)seq);
        dyTemplate.set("sequence", (Object)seq2);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dyTemplate, dyTemplate2});
    }

    private void moveRptTemplateDown(DynamicObject dyTemplate, String modelID) {
        int seq = dyTemplate.getInt("sequence");
        QFilter qf1 = new QFilter("sequence", "=", (Object)(seq + 1));
        QFilter qf2 = new QFilter("model", "=", (Object)IDUtils.toLong((Object)modelID));
        QFilter[] filters = new QFilter[]{qf1, qf2};
        DynamicObject dyTemplate2 = BusinessDataServiceHelper.loadSingle((String)"eb_templateentity_bg", (String)"id,sequence", (QFilter[])filters);
        if (dyTemplate2 == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u6a21\u677f\u5df2\u662f\u5f53\u524d\u8282\u70b9\u7684\u6700\u5e95\u5c42\uff0c\u4e0d\u80fd\u4e0b\u79fb\u3002", (String)"TemplateListPlugin_6", (String)"epm-eb-budget", (Object[])new Object[0]));
            return;
        }
        dyTemplate2 = BusinessDataServiceHelper.loadSingle((Object)dyTemplate2.getPkValue(), (DynamicObjectType)dyTemplate.getDynamicObjectType());
        int seq2 = dyTemplate2.getInt("sequence");
        dyTemplate2.set("sequence", (Object)seq);
        dyTemplate.set("sequence", (Object)seq2);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dyTemplate, dyTemplate2});
    }

    private void copyUpdateTemplate() {
        BillList list = (BillList)this.getControl("billlistap");
        if (list.getSelectedRows().size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6a21\u677f\u3002", (String)"BgTemplateListPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        if (list.getSelectedRows().size() == 1) {
            DynamicObject dyna = BusinessDataReader.loadSingle((Object)list.getFocusRowPkId(), (DynamicObjectType)list.getEntityType());
            TemplateModel template = this.constructTemplateModel(dyna);
            String dataUnit = "0";
            template.setDataUnit(dataUnit);
            this.getPageCache().put("template_model", ObjectSerialUtil.toByteSerialized((Object)template));
            this.openFormPage("eb_templateentity_bg", true);
        } else if (list.getSelectedRows().size() > 1) {
            this.openFormPage("eb_copyupdatetemplate", false);
        }
    }

    private void copyTemplate(boolean needOpen) {
        BillList list = (BillList)this.getControl("billlistap");
        if (list.getSelectedRows().size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6a21\u677f\u3002", (String)"BgTemplateListPlugin_4", (String)"epm-eb-formplugin", (Object[])new Object[0]));
            return;
        }
        HashSet<String> numberSet = new HashSet<String>(16);
        HashSet<String> nameSet = new HashSet<String>(16);
        QFilter modelqfilter = new QFilter("model", "=", (Object)this.getModelId());
        try (DataSet alldata = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"eb_templateentity_bg", (String)"name, number", (QFilter[])new QFilter[]{modelqfilter}, null);){
            while (alldata.hasNext()) {
                Row row = alldata.next();
                numberSet.add(row.getString("number"));
                nameSet.add(row.getString("name"));
            }
        }
        Map dynas = list.getModel().loadReferenceDataBatch((DynamicObjectType)list.getEntityType(), list.getSelectedRows().getPrimaryKeyValues());
        HashSet<DynamicObject> tempObjs = new HashSet<DynamicObject>(dynas.values());
        DynamicObject pkId = this.copyTemplate(tempObjs, nameSet, numberSet);
        this.refrushBillList();
        if (pkId != null) {
            DynamicObject dyna = BusinessDataReader.loadSingle((Object)pkId.getLong("id"), (DynamicObjectType)list.getEntityType());
            if (needOpen) {
                this.handleOpenProcess(dyna);
            }
        }
        this.writeLog(null, "coppy", new MultiLangEnumBridge("\u590d\u5236", "BgTemplateListPlugin_5", "epm-eb-formplugin"), new MultiLangEnumBridge("\u590d\u5236\u6a21\u677f\u201c%1$s\u201d\u6210\u529f\u3002", "BgTemplateListPlugin_6", "epm-eb-formplugin"), new String[]{StringUtils.join((Collection)tempObjs.stream().map(e -> e.getString("name")).collect(Collectors.toSet()), (String)",")});
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u590d\u5236\u6210\u529f\u3002", (String)"TemplateListPlugin_10", (String)"epm-eb-budget", (Object[])new Object[0]));
    }

    private DynamicObject copyTemplate(Set<DynamicObject> tempObjs, Set<String> nameSet, Set<String> numberSet) {
        if (tempObjs != null && tempObjs.size() > 0) {
            ArrayList saveObj = Lists.newArrayListWithExpectedSize((int)tempObjs.size());
            for (DynamicObject obj : tempObjs) {
                String number;
                String name;
                TemplateModel templateModel = new TemplateModel();
                templateModel.loadDynaObj2Model(obj);
                String string = name = templateModel.getName().length() > 56 ? templateModel.getName().substring(0, 55) + "copy" : templateModel.getName() + "copy";
                if (name.length() > 50) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u677f\u540d\u79f0\u8d85\u957f\u3002", (String)"TemplateListPlugin_35", (String)"epm-eb-budget", (Object[])new Object[0]));
                }
                templateModel.setName(this.getCopyName(name, nameSet, 1));
                String string2 = number = templateModel.getNumber().length() > 56 ? templateModel.getNumber().substring(0, 55) + "copy" : templateModel.getNumber() + "copy";
                if (name.length() > 50) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u677f\u7f16\u7801\u8d85\u957f\u3002", (String)"TemplateListPlugin_36", (String)"epm-eb-budget", (Object[])new Object[0]));
                }
                templateModel.setNumber(this.getCopyName(number, numberSet, 1));
                this.setSpreadJsonCopyName(templateModel);
                templateModel.setId(GlobalIdUtil.genGlobalLongId());
                templateModel.getAreaRangeEntries().forEach(p -> p.setId(GlobalIdUtil.genGlobalLongId()));
                templateModel.getPageDimensionEntries().forEach(p -> p.setId(GlobalIdUtil.genGlobalLongId()));
                templateModel.getViewPointDimensionEntries().forEach(p -> p.setId(GlobalIdUtil.genGlobalLongId()));
                templateModel.getPagePropEntries().forEach(p -> p.setId(GlobalIdUtil.genGlobalLongId()));
                Date time = new Date();
                templateModel.setCreatorId(UserUtils.getUserId().longValue());
                templateModel.setCreateTime(time);
                templateModel.setModifierId(UserUtils.getUserId().longValue());
                templateModel.setModifyTime(time);
                if (this.copyUpdateDomain != null) {
                    String beginTime = this.copyUpdateDomain.getBeginTime();
                    String endTime = this.copyUpdateDomain.getEndTime();
                    TemplateCatalog templateCatalog = this.copyUpdateDomain.getTemplateCatalog();
                    if (kd.bos.util.StringUtils.isNotEmpty((String)beginTime)) {
                        templateModel.setBeginTime(beginTime);
                    }
                    if (kd.bos.util.StringUtils.isNotEmpty((String)endTime)) {
                        templateModel.setEndTime(endTime);
                    }
                    if (templateCatalog != null) {
                        templateModel.setTemplateCatalog(templateCatalog);
                    }
                }
                DynamicObject t = templateModel.genDynamicObject();
                t.set("status", (Object)"0");
                t.set("versionnumber", (Object)"1.0");
                t.set("versionstatus", (Object)"1");
                t.set("group", (Object)GlobalIdUtil.genGlobalLongId());
                saveObj.add(t);
            }
            Object[] objs = BusinessDataWriter.save((IDataEntityType)((DynamicObject)saveObj.get(0)).getDataEntityType(), (Object[])saveObj.toArray());
            this.copyIntergrationByTemp(tempObjs, objs);
            return (DynamicObject)objs[0];
        }
        return null;
    }

    private String getCopyName(String name, Set<String> nameset, int i) {
        if (nameset.contains(name)) {
            if (name.length() > 56) {
                name = name.substring(0, 39);
                name = name + "copy" + i;
            } else {
                char ss = name.charAt(name.length() - 1);
                try {
                    Integer.parseInt(String.valueOf(ss));
                    name = name.substring(0, name.length() - 1) + i;
                }
                catch (NumberFormatException e) {
                    name = name + i;
                }
            }
            return this.getCopyName(name, nameset, i + 1);
        }
        return name;
    }

    private void setSpreadJsonCopyName(TemplateModel model) {
        String ssjson = new String(GZIPUtils.uncompress((byte[])Base64.getDecoder().decode(model.getSpreadJson().substring(6))));
        JSONObject object = JSONObject.parseObject((String)ssjson, (Feature[])new Feature[]{Feature.OrderedField});
        JSONObject sheets = (JSONObject)object.get((Object)"sheets");
        String temName = model.getName();
        for (Map.Entry entry : sheets.entrySet()) {
            sheets.put(temName, ObjectUtils.clone(entry.getValue()));
            JSONObject name = (JSONObject)sheets.get((Object)temName);
            name.put("name", (Object)temName);
            sheets.remove(entry.getKey());
        }
        byte[] bb = Base64.getEncoder().encode(GZIPUtils.compress((String)object.toJSONString()));
        String bbs = new String(bb);
        model.setSpreadJson("base64" + bbs);
    }

    private void copyIntergrationByTemp(Set<DynamicObject> temObjs, Object[] objs) {
        BillList list = (BillList)this.getControl("billlistap");
        Object[] ids = list.getSelectedRows().getPrimaryKeyValues();
        QFilter filter = new QFilter("template", "in", (Object)ids);
        filter.and(new QFilter("org", "=", (Object)0L));
        Object[] dys = BusinessDataServiceHelper.load((String)"eb_intergration_entity", (String)"template,template.number", (QFilter[])new QFilter[]{filter});
        if (dys.length == 0) {
            return;
        }
        DynamicObject o = BusinessDataServiceHelper.loadSingle((Object)dys[0].getLong("id"), (String)"eb_intergration_entity");
        dys = BusinessDataServiceHelper.load((Object[])DynamicObjectCollectionUtil.getPKArray((Object[])dys), (DynamicObjectType)o.getDynamicObjectType());
        HashMap tempId2CopyIds = Maps.newHashMap();
        for (DynamicObject temp : temObjs) {
            long id = temp.getLong("id");
            String number = temp.getString("number");
            for (Object obj : objs) {
                if (!(number + "copy").equals(((DynamicObject)obj).getString("number"))) continue;
                tempId2CopyIds.put(id, (DynamicObject)obj);
            }
        }
        DynamicObject[] newDys = new DynamicObject[dys.length];
        for (int i = 0; i < dys.length; ++i) {
            Object newDy = OrmUtils.clone((Object)dys[i], (IDataEntityType)dys[i].getDataEntityType(), (boolean)false, (boolean)true);
            ((DynamicObject)newDy).set("template", tempId2CopyIds.get(dys[i].getLong("template.id")));
            newDys[i] = (DynamicObject)newDy;
        }
        SaveServiceHelper.save((DynamicObject[])newDys);
    }

    private void versionReportTpl() {
        String loadKDString = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6a21\u677f\u3002", (String)"TemplateListPlugin_11", (String)"epm-eb-budget", (Object[])new Object[0]);
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.size() == 0) {
            this.getView().showTipNotification(loadKDString);
            return;
        }
        if (selectedRows.size() == 1) {
            Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
            DynamicObject tempSimple = QueryServiceHelper.queryOne((String)"eb_templateentity_bg", (String)"number, name, group", (QFilter[])QFilter.of((String)"id = ?", (Object[])new Object[]{primaryKeyValues[0]}).toArray());
            if (tempSimple != null) {
                ListShowParameter formShowParameter = new ListShowParameter();
                formShowParameter.setFormId("eb_tplversionlist");
                formShowParameter.setCustomParam("group", (Object)tempSimple.getLong("group"));
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                String strVersion = ResManager.loadKDString((String)"\u7248\u672c\u5316", (String)"TemplateListPlugin_12", (String)"epm-eb-budget", (Object[])new Object[0]);
                formShowParameter.setCaption(String.format(strVersion + "-%s %s ", tempSimple.getString("number"), tempSimple.getString("name")));
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, action_version));
                this.getView().showForm((FormShowParameter)formShowParameter);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6a21\u677f\u4e0d\u5b58\u5728\uff0c\u5237\u65b0\u540e\u91cd\u8bd5", (String)"TemplateListPlugin_13", (String)"epm-eb-budget", (Object[])new Object[0]));
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u9009\u62e9\u4e00\u4e2a\u6a21\u677f\u8fdb\u884c\u7248\u672c\u5316\u64cd\u4f5c", (String)"TemplateListPlugin_14", (String)"epm-eb-budget", (Object[])new Object[0]));
        }
    }

    private void deleteRoport() {
        String loadKDString = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6a21\u677f\u3002", (String)"TemplateListPlugin_11", (String)"epm-eb-budget", (Object[])new Object[0]);
        BillList billList = (BillList)this.getView().getControl("billlistap");
        if (billList.getSelectedRows().size() == 0) {
            this.getView().showTipNotification(loadKDString);
            return;
        }
        Object[] primaryKeyValues = billList.getSelectedRows().getPrimaryKeyValues();
        String modelkey = this.getPageCache().get("KEY_MODEL_ID");
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("eb_reportentry_delete");
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "eb_reportentry_delete"));
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCustomParam("KEY_MODEL_ID", (Object)modelkey);
        this.getView().showForm(fsp);
    }

    private void barexport() {
        if (this.getSelectTemplate() == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u5bfc\u51fa\u7684\u62a5\u8868\u6a21\u677f", (String)"TemplateListPlugin_15", (String)"epm-eb-budget", (Object[])new Object[0]));
            return;
        }
        this.exportTemplate(this.getSelectTemplate());
    }

    private void exportTemplate(Object[] selectTemplateIds) {
        long modelId = this.getModelId();
        try {
            TemplateExportPlugin exportor = new TemplateExportPlugin();
            String url = exportor.export("eb_templateentity_bg", modelId, selectTemplateIds, ResManager.loadKDString((String)"\u62a5\u8868\u6a21\u677f\u5bfc\u5165\u5bfc\u51fa_", (String)"TemplateListPlugin_16", (String)"epm-eb-budget", (Object[])new Object[0]));
            if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)url)) {
                ImportAndExportUtil.addTempFileCheck((String)url, (String)"eb_templatelist_bg", (String)ApplicationTypeEnum.EB.getAppnum(), (int)10000);
                this.getClientViewProxy().addAction("download", (Object)url);
            }
            MultiLangEnumBridge opName = new MultiLangEnumBridge("\u6a21\u677f\u5bfc\u51fa", "TemplateListPlugin_44", "epm-eb-budget");
            MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u5bfc\u51fa\u6a21\u677fid:%1$s", "TemplateListPlugin_43", "epm-eb-budget");
            this.writeLog(null, "export", opName, opDesc, new String[]{JSONObject.toJSONString((Object)selectTemplateIds)});
        }
        catch (IOException e) {
            log.error((Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"IO\u5f02\u5e38", (String)"TemplateListPlugin_17", (String)"epm-eb-budget", (Object[])new Object[0]));
        }
    }

    private void importTemplate() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("eb_templateimport");
        showParameter.setCustomParam("modelid", (Object)this.getModelId());
        showParameter.setCustomParam("templatecatalog", (Object)this.getPageCache().get("focusnodeid"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, IMPORTDATABACK));
        this.getView().showForm(showParameter);
    }

    private void deleteTemplate() {
        DynamicObject[] tempObjs = this.getSelectedTempDynaObjs(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u6a21\u677f\u8bb0\u5f55\u3002", (String)"TemplateListPlugin_18", (String)"epm-eb-budget", (Object[])new Object[0]));
        if (tempObjs != null) {
            String modelId = this.getPageCache().get("KEY_MODEL_ID");
            StringBuilder distributedNames = new StringBuilder();
            for (DynamicObject tempObj : tempObjs) {
                Set orgIds = QueryMemberDetailsHelper.getOrgIdsByTemplate((Long)tempObj.getLong("id"), (Object)modelId);
                if (orgIds.isEmpty()) continue;
                distributedNames.append(tempObj.getString("name")).append("\uff0c ");
            }
            if (ApplicationUtils.hasBudget(this.getView())) {
                BillList billList = (BillList)this.getView().getControl("billlistap");
                QFilter filter = new QFilter("entryentity.templateid", "in", (Object)billList.getSelectedRows().getPrimaryKeyValues());
                if (QueryServiceHelper.exists((String)"eb_task", (QFilter[])new QFilter[]{filter})) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6a21\u677f\u5df2\u88ab\u4efb\u52a1\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"TemplateListPlugin_19", (String)"epm-eb-budget", (Object[])new Object[0]));
                    return;
                }
            }
            if (kd.bos.util.StringUtils.isNotEmpty((String)distributedNames.toString())) {
                this.getView().showConfirm(ResManager.loadResFormat((String)"%1\u5df2\u7ecf\u5206\u914d\uff0c\u662f\u5426\u7ee7\u7eed\u5220\u9664\uff1f", (String)"TemplateListPlugin_20", (String)"epm-eb-budget", (Object[])new Object[]{distributedNames.toString()}), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("deletetemplate_comfirm", (IFormPlugin)this));
                return;
            }
            if (kd.bos.util.StringUtils.isEmpty((String)distributedNames.toString())) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u5220\u9664\uff1f", (String)"TemplateListPlugin_21", (String)"epm-eb-budget", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("deletetemplate_comfirm", (IFormPlugin)this));
            }
        }
    }

    private void verifyTemp(DynamicObject tempObj, OperationResult operationResult, List<Object> successIds) {
        QFilter filter1 = new QFilter("model", "=", (Object)tempObj.getLong("model.id"));
        QFilter filter2 = new QFilter("template", "=", (Object)tempObj.getLong("id"));
        QFilter[] filters = new QFilter[]{filter1, filter2};
        boolean flag = QueryServiceHelper.exists((String)"eb_reportentity", (QFilter[])filters);
        if (flag) {
            OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
            operateErrorInfo.setLevel(ErrorLevel.Error);
            operateErrorInfo.setMessage(ResManager.loadResFormat((String)"%1\u5df2\u7ecf\u751f\u6210\u62a5\u8868\u3002", (String)"TemplateListPlugin_22", (String)"epm-eb-budget", (Object[])new Object[]{tempObj.getString("name")}));
            operationResult.addErrorInfo(operateErrorInfo);
            return;
        }
        successIds.add(tempObj.get("id"));
        operationResult.addSuccessPkId(tempObj.get("id"));
        operationResult.setMessage(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"TemplateListPlugin_23", (String)"epm-eb-budget", (Object[])new Object[0]));
    }

    private void comfirmDeleteTemplate(String modelId) {
        DynamicObject[] tempObjs = this.getSelectedTempDynaObjs();
        if (tempObjs == null) {
            return;
        }
        OperationResult operationResult = new OperationResult();
        operationResult.setBillCount(tempObjs.length);
        ArrayList<Object> successIds = new ArrayList<Object>();
        for (DynamicObject tempObj : tempObjs) {
            this.verifyTemp(tempObj, operationResult, successIds);
        }
        List templateIds = IDUtils.toLongs(successIds);
        QFilter filter = new QFilter("id", "in", (Object)templateIds);
        DynamicObjectCollection tempCollection = QueryServiceHelper.query((String)"eb_templateentity_bg", (String)"id, number", (QFilter[])new QFilter[]{filter});
        for (DynamicObject object : tempCollection) {
            this.writeLog(object.getString("number"), "delete", new MultiLangEnumBridge("\u5220\u9664", "TemplateListPlugin_24", "epm-eb-budget"), null, null);
        }
        this.deleteBizRuleByTemplate(successIds);
        DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"eb_templateentity_bg"), (Object[])successIds.toArray());
        ArrayList<String> recordIds = new ArrayList<String>();
        QFilter filter1 = new QFilter("model", "=", (Object)IDUtils.toLong((Object)modelId));
        QFilter filter2 = new QFilter("template", "in", (Object)templateIds);
        QFilter[] filters = new QFilter[]{filter1, filter2};
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"eb_distributionentity", (String)"id", (QFilter[])filters);
        if (collection != null && !collection.isEmpty()) {
            for (DynamicObject obj : collection) {
                recordIds.add(obj.get("id").toString());
            }
        }
        TemplateServiceHelper.removeTemplateModelCacheByIds((Object)modelId, (Object[])successIds.toArray());
        DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"eb_distributionentity"), (Object[])recordIds.toArray());
        DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"MemberQuoteService", (String)"delete", (Object[])new Object[]{MemberQuoteResourceEnum.Template.getType(), templateIds});
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u5220\u9664", "BgTemplateListPlugin_25", "epm-eb-formplugin");
        MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u6a21\u677f\u5206\u7c7b\u5220\u9664\u6210\u529f\u3002", "BgTemplateListPlugin_26", "epm-eb-formplugin");
        this.writeLog(null, "delete", opName, opDesc, null);
        this.refrushBillList();
        this.getView().showOperationResult(operationResult);
    }

    @Override
    public String getBizEntityNumber() {
        return "eb_templateentity_bg";
    }

    private void deleteBizRuleByTemplate(List<Object> templateId) {
        QFilter filter = new QFilter("template", "in", (Object)IDUtils.toLongs(templateId));
        BusinessDataWriter.delete((String)"eb_brallocateentity", (QFilter[])new QFilter[]{filter});
    }

    private void showDistributionView() {
        FormShowParameter param = new FormShowParameter();
        param.setFormId("eb_template_distribution");
        if (this.getView().getParentView() != null) {
            param.setRootPageId(this.getView().getParentView().getPageId());
        }
        param.setStatus(OperationStatus.ADDNEW);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.getOpenStyle().setTargetKey("_submaintab_");
        param.setCustomParam("KEY_MODEL_ID", (Object)this.getPageCache().get("KEY_MODEL_ID"));
        Set<String> rows = this.getSelectTemplateNumber();
        if (rows != null && rows.size() > 0) {
            param.setCustomParam("rows", (Object)rows.toArray(new String[rows.size()]));
        }
        param.setCaption(ResManager.loadKDString((String)"\u6a21\u677f\u5206\u914d", (String)"TemplateListPlugin_25", (String)"epm-eb-budget", (Object[])new Object[0]));
        this.getView().showForm(param);
    }

    private Object[] getSelectTemplate() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection rows = billList.getSelectedRows();
        this.getModel().getDataEntity();
        if (rows.size() > 0) {
            return rows.getPrimaryKeyValues();
        }
        return null;
    }

    private Set<String> getSelectTemplateNumber() {
        HashSet<String> templateNumber = new HashSet<String>();
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection rows = billList.getSelectedRows();
        rows.stream().forEach(p -> templateNumber.add(p.getNumber()));
        return templateNumber;
    }

    private void openFormPage(String formId, boolean isEdit) {
        if (this.getModelId() == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f53\u7cfb\u3002", (String)"TemplateListPlugin_26", (String)"epm-eb-budget", (Object[])new Object[0]));
        }
        String catelogId = this.getPageCache().get("focusnodeid");
        if (catelogId == null) {
            catelogId = "0";
        }
        JSONObject catalog = new JSONObject();
        catalog.put("id", (Object)catelogId);
        catalog.put("name", (Object)"");
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(formId);
        formShowParameter.setCustomParam("modelId", (Object)this.getPageCache().get("KEY_MODEL_ID"));
        formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getPageCache().get("KEY_MODEL_ID"));
        formShowParameter.setCustomParam("catalog", (Object)catalog.toJSONString());
        formShowParameter.setParentPageId(this.getView().getPageId());
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = null;
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f", (String)"TemplateListPlugin_28", (String)"epm-eb-budget", (Object[])new Object[0]));
        if (isEdit) {
            formShowParameter.setStatus(OperationStatus.EDIT);
            formShowParameter.setCustomParam("iscopy", (Object)true);
            formShowParameter.setCustomParam("template_model", (Object)this.getPageCache().get("template_model"));
            closeCallBack = new CloseCallBack((IFormPlugin)this, formId + "edit");
        } else {
            closeCallBack = new CloseCallBack((IFormPlugin)this, formId);
        }
        if ("eb_copyupdatetemplate".equals(formId)) {
            BillList list = (BillList)this.getControl("billlistap");
            Object[] primaryKeyValues = list.getSelectedRows().getPrimaryKeyValues();
            formShowParameter.setCustomParam("templateIds", (Object)primaryKeyValues);
        }
        formShowParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(formShowParameter);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId;
        super.closedCallBack(evt);
        switch (actionId = evt.getActionId()) {
            case "eb_templateentity_bg": 
            case "eb_templateentity_bgedit": {
                if (evt.getReturnData() == null) break;
                String tempser = (String)evt.getReturnData();
                TemplateModel template = (TemplateModel)ObjectSerialUtil.deSerializedBytes((String)tempser);
                DynamicObject modelObje = this.getModel().getDataEntity().getDynamicObject("modelbd");
                if (modelObje == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"TemplateListPlugin_34", (String)"epm-eb-budget", (Object[])new Object[0]));
                }
                PeriodUtils.getLastPeriod((String)modelObje.getString("shownumber"), (String)"M_M01", (boolean)true);
                this.openTemplateProcessPage(template);
                MultiLangEnumBridge opName = new MultiLangEnumBridge("\u65b0\u589e\u6a21\u677f", "BgTemplateListPlugin_49", "epm-eb-formplugin");
                MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u65b0\u589e\u6a21\u677f\u6210\u529f\uff0c\u7f16\u7801\u4e3a\uff1a%1$s", "BgTemplateListPlugin_50", "epm-eb-formplugin");
                this.writeLog(template.getNumber(), "addnew", opName, opDesc, new String[]{template.getNumber()});
                break;
            }
            case "nofinancialClose": {
                if (evt.getReturnData() == null) break;
                this.saveData(evt);
                break;
            }
            case "importdataback": 
            case "processClosedCallBack": {
                this.refrushBillList();
                break;
            }
            case "eb_reportentry_delete": {
                if (evt.getReturnData() == null) break;
                this.deleteReportData(evt);
                break;
            }
            case "eb_copyupdatetemplate": {
                this.copyUpdateTemplates(evt);
                break;
            }
        }
    }

    private void copyUpdateTemplates(ClosedCallBackEvent evt) {
        this.copyUpdateDomain = (TemplateCopyUpdateDomain)evt.getReturnData();
        if (this.copyUpdateDomain == null) {
            return;
        }
        this.copyTemplate(true);
    }

    private void deleteReportData(ClosedCallBackEvent evt) {
        Map returnData = (Map)evt.getReturnData();
        List yearColl = (List)returnData.get("year");
        List periodColl = (List)returnData.get("period");
        BillList billList = (BillList)this.getView().getControl("billlistap");
        Object[] primaryKeyValues = billList.getSelectedRows().getPrimaryKeyValues();
        String modelkey = this.getPageCache().get("KEY_MODEL_ID");
        QFilter qf = new QFilter("model", "=", (Object)IDUtils.toLong((Object)modelkey));
        QFilter qf2 = new QFilter("template", "in", (Object)primaryKeyValues);
        QFilter qf3 = new QFilter("fyear", "in", (Object)IDUtils.toLongs((List)yearColl));
        QFilter qf4 = new QFilter("period", "in", (Object)IDUtils.toLongs((List)periodColl));
        QFilter qf5 = new QFilter("reportstatus", "in", (Object)new Object[]{"B", "E"});
        QFilter[] qfs = new QFilter[]{qf, qf2, qf3, qf4, qf5};
        int delete = DeleteServiceHelper.delete((String)"eb_reportentity", (QFilter[])qfs);
        MultiLangEnumBridge opName = new MultiLangEnumBridge("\u91cd\u7f6e\u62a5\u8868\u72b6\u6001", "TemplateListPlugin_45", "epm-eb-budget");
        MultiLangEnumBridge opDesc = new MultiLangEnumBridge("\u91cd\u7f6e\u6a21\u677f:%1$s,\u8d22\u5e74:%2$s,\u671f\u95f4:%3$s,\u4f53\u7cfb:%4$s", "TemplateListPlugin_46", "epm-eb-budget");
        String[] opDescArgs = new String[]{Arrays.toString(primaryKeyValues), JSONObject.toJSONString((Object)yearColl), JSONObject.toJSONString((Object)periodColl), modelkey};
        this.writeLog(null, "deleteData", opName, opDesc, opDescArgs);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u72b6\u6001\u91cd\u7f6e\u6210\u529f\u3002", (String)"TemplateListPlugin_30", (String)"epm-eb-budget", (Object[])new Object[0]));
    }

    private void saveData(ClosedCallBackEvent evt) {
        TemplateModel template = (TemplateModel)evt.getReturnData();
        template.setModifierId(UserUtils.getUserId().longValue());
        template.setModifyTime(TimeServiceHelper.now());
        DynamicObject t = template.genDynamicObject();
        t.set("isfintemplate", (Object)"0");
        t.set("versionnumber", (Object)" ");
        try (TXHandle tx = TX.required();){
            try {
                BusinessDataWriter.delete((IDataEntityType)t.getDataEntityType(), (Object[])new Object[]{t.getPkValue()});
                BusinessDataWriter.save((IDataEntityType)t.getDataEntityType(), (Object[])new Object[]{t});
            }
            catch (Throwable e) {
                tx.markRollback();
                throw e;
            }
        }
        this.refrushBillList();
    }

    private void openTemplateProcessPage(TemplateModel template) {
        IFormView mainPageView = this.getView().getMainView();
        String pageId = this.getView().getPageId() + template.getId();
        IFormView parentView = this.getView().getParentView();
        if (mainPageView == null || mainPageView.getView(pageId) == null) {
            FormShowParameter formShowParameter = new FormShowParameter();
            boolean isNewPage = !template.isOldTemplate();
            formShowParameter.setFormId(isNewPage ? "eb_multiviewtemplate" : "eb_template_process");
            formShowParameter.setPageId(pageId);
            formShowParameter.setCustomParam("KEY_MODEL_ID", (Object)this.getPageCache().get("KEY_MODEL_ID"));
            formShowParameter.setCustomParam("listPageID", (Object)this.getView().getPageId());
            BigDecimal versionNumber = (BigDecimal)template.get("versionnumber");
            String version = String.format("V%.1f", Float.valueOf(versionNumber.floatValue()));
            formShowParameter.setCaption(ResManager.loadResFormat((String)"\u7f16\u8f91\u6a21\u677f-%1 %2", (String)"TemplateListPlugin_31", (String)"epm-eb-budget", (Object[])new Object[]{template.getName(), version}));
            formShowParameter.setCustomParam("template_model", (Object)ObjectSerialUtil.toByteSerialized((Object)template));
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            formShowParameter.getOpenStyle().setTargetKey("_submaintab_");
            formShowParameter.setCustomParam("List_entry", (Object)Boolean.TRUE);
            formShowParameter.setCustomParam("rank", (Object)this.getPageCache().get("rank"));
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "processClosedCallBack");
            formShowParameter.setCloseCallBack(closeCallBack);
            if (parentView == null) {
                this.getView().showForm(formShowParameter);
                return;
            }
            formShowParameter.setParentPageId(parentView.getPageId());
            formShowParameter.setParentFormId(parentView.getEntityId());
            parentView.showForm(formShowParameter);
            this.getView().sendFormAction(parentView);
        } else {
            IFormView childFormView = mainPageView.getView(pageId);
            childFormView.activate();
            this.getView().sendFormAction(childFormView);
        }
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent mbce) {
        super.confirmCallBack(mbce);
        String modelId = this.getPageCache().get("KEY_MODEL_ID");
        String callBackId = mbce.getCallBackId();
        if ("deletetemplate_comfirm".equals(callBackId) && mbce.getResult() == MessageBoxResult.Yes) {
            this.comfirmDeleteTemplate(modelId);
        }
    }

    @Override
    public void listRowDoubleClick(ListRowClickEvent evt) {
        BillList list = (BillList)evt.getSource();
        if (list.getSelectedRows().size() > 0) {
            DynamicObject dyna = BusinessDataReader.loadSingle((Object)list.getFocusRowPkId(), (DynamicObjectType)list.getEntityType());
            this.handleOpenProcess(dyna);
        }
        evt.setCancel(true);
    }

    @Override
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        DynamicObject dyna1;
        super.billListHyperLinkClick(args);
        BillList list = (BillList)args.getHyperLinkClickEvent().getSource();
        DynamicObject dyna = BusinessDataReader.loadSingle((Object)list.getFocusRowPkId(), (DynamicObjectType)list.getEntityType());
        String noScenarioMemberTreeId = EBOldTemplateDataResolveUtil.ebAddNoScenario(dyna.getString("model.id"), this.getView());
        if (kd.bos.util.StringUtils.isNotEmpty((String)noScenarioMemberTreeId) && Objects.nonNull(dyna1 = EBOldTemplateDataResolveUtil.saveTemplateEntityDynamicObject(dyna, noScenarioMemberTreeId))) {
            dyna = dyna1;
        }
        this.handleOpenProcess(dyna);
        args.setCancel(true);
    }

    private void handleOpenProcess(DynamicObject dyna) {
        TemplateModel template = this.constructTemplateModel(dyna);
        this.openTemplateProcessPage(template);
    }

    private TemplateModel constructTemplateModel(DynamicObject dyna) {
        TemplateModel template = new TemplateModel();
        template.loadDynaObj2Model(dyna);
        return template;
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
    }

    @Override
    protected String getOrderBy() {
        return "number,createtime,versionnumber asc";
    }

    @Override
    protected QFilter getTemplateIdsQFilter(QFilter qFilter1) {
        qFilter1.and("templatetype", "not in", (Object)TemplateTypeEnum.getWPTypes());
        Map templates = BusinessDataServiceHelper.loadFromCache((String)"eb_templateentity_bg", (String)"id, number, versionnumber", (QFilter[])qFilter1.toArray());
        if (this.getPageCache().get("isHideHistory") != null) {
            Collection<DynamicObject> values = templates.values();
            TemplateUtil.filterVersionTemplateTree(values);
            ArrayList ids = new ArrayList(16);
            values.forEach(t -> ids.add(t.getLong("id")));
            return new QFilter("id", "in", ids);
        }
        return new QFilter("id", "in", templates.keySet());
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection allRows = super.getData(start, limit);
                long modelId = TemplateListPlugin.this.getModelId();
                if (modelId == 0L) {
                    return allRows;
                }
                IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
                String defaultPeriodName = TemplateCopyUpdateUtils.getDefaultPeriod(modelCache);
                if (CollectionUtils.isNotEmpty((Collection)allRows)) {
                    for (DynamicObject allRow : allRows) {
                        String endtime;
                        String begintime = allRow.getString("begintime");
                        if (kd.bos.util.StringUtils.isEmpty((String)begintime)) {
                            allRow.set("begintime", (Object)defaultPeriodName);
                        } else {
                            String realTime = TemplateCopyUpdateUtils.getRealTime(modelCache, begintime);
                            allRow.set("begintime", (Object)realTime);
                        }
                        if (!kd.bos.util.StringUtils.isNotEmpty((String)(endtime = allRow.getString("endtime")))) continue;
                        String realTime = TemplateCopyUpdateUtils.getRealTime(modelCache, endtime);
                        allRow.set("endtime", (Object)realTime);
                    }
                }
                return allRows;
            }
        });
    }
}

