/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.budget.formplugin.template;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.container.TabAp;
import kd.bos.metadata.form.container.TabPageAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.budget.formplugin.database.BasedataEditSingleMemberF7;
import kd.epm.eb.budget.formplugin.template.AbstractTemplateBasePlugin;
import kd.epm.eb.budget.formplugin.template.util.TemplateFloatUtil;
import kd.epm.eb.budget.formplugin.util.SingleMemberF7Util;
import kd.epm.eb.business.dataperm.EbMembPerm;
import kd.epm.eb.common.ebcommon.common.enums.DimEntityNumEnum;
import kd.epm.eb.common.ebcommon.common.enums.PositionTypeEnum;
import kd.epm.eb.common.ebcommon.common.enums.dimension.SysDimensionEnum;
import kd.epm.eb.common.ebcommon.common.json.JSONObject;
import kd.epm.eb.common.ebcommon.common.util.DataEntityUtils;
import kd.epm.eb.common.ebcommon.common.util.ObjectSerialUtil;
import kd.epm.eb.ebBusiness.serviceHelper.MemberServiceHelper;
import kd.epm.eb.ebBusiness.template.model.AreaRangeEntry;
import kd.epm.eb.ebBusiness.template.model.ColDimensionEntry;
import kd.epm.eb.ebBusiness.template.model.MembSettingBaseDetail;
import kd.epm.eb.ebBusiness.template.model.RowDimensionEntry;
import kd.epm.eb.ebSpread.domain.view.builder.dynamic.BasePointInnerLineInfo;

public class TemplateMembSetting4SpreadF7Plugin
extends AbstractTemplateBasePlugin
implements EbMembPerm {
    private static final Log log = LogFactory.getLog(TemplateMembSetting4SpreadF7Plugin.class);

    @Override
    public void initialize() {
        super.initialize();
        this.bindCtrlMapping();
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.bindCtrlMapping();
        this.buildPageViewPanel();
        this.initPageviewPanelValues();
        this.checkLock();
        SingleMemberF7Util.cacheModelPrem(this.getPageCache(), this.getTemplateModel().getModelId(), this.getApplicationType());
    }

    private void checkLock() {
        List<?> ls;
        String lock = (String)this.getFormCustomParam("lock");
        String lockDim = (String)this.getFormCustomParam("lockDim");
        if (StringUtils.isNotEmpty((String)lock)) {
            RowDimensionEntry c;
            ls = this.getDimMemberDetail();
            Object object = c = "row".equals(lock) ? new RowDimensionEntry(null) : new ColDimensionEntry(null);
            if (ls != null) {
                for (MembSettingBaseDetail m : ls) {
                    if (!m.getClass().isInstance(c)) continue;
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{this.sugarF7Key(m.getDimension().getMemberEntityNumber(), m.getDimension().getNumber())});
                }
            }
        }
        if (StringUtils.isNotEmpty((String)lockDim)) {
            ls = this.getDimMemberDetail();
            for (MembSettingBaseDetail m : ls) {
                if (!m.getDimension().getNumber().equals(lockDim)) continue;
                this.getView().setEnable(Boolean.valueOf(false), new String[]{this.sugarF7Key(m.getDimension().getMemberEntityNumber(), m.getDimension().getNumber())});
            }
        }
    }

    private void bindCtrlMapping() {
        List<?> ls = this.getDimMemberDetail();
        if (ls != null) {
            MainEntityType mainEntityType = this.getModel().getDataEntityType();
            DataEntityPropertyCollection props = mainEntityType.getProperties();
            ls.forEach(e -> {
                String membEntityNum = e.getDimension().getMemberEntityNumber();
                String f7Key = this.sugarF7Key(membEntityNum, e.getDimension().getNumber());
                if (!props.containsKey((Object)f7Key)) {
                    DataEntityUtils.addBasedataF7ToMainEntity((Container)((Container)this.getControl("flexpanelap")), (MainEntityType)mainEntityType, (String)f7Key.toLowerCase(), (String)membEntityNum, (IDataModel)this.getModel(), (IFormView)this.getView());
                }
                this.setF7LookUpFilter(membEntityNum, f7Key, e.getDimension().getNumber());
            });
        }
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        super.beforeF7Select(beforeF7SelectEvent);
        if (this.getView().getFormShowParameter().getCustomParams().containsKey("switch_eb_f7")) {
            this.switchDimNewF7(beforeF7SelectEvent);
        }
    }

    public String getCurrentDimNumber(String controlKey) {
        SysDimensionEnum dimensionEnum = SysDimensionEnum.getEnumByTreeNumber((String)controlKey);
        if (dimensionEnum != null) {
            return dimensionEnum.getNumber();
        }
        String dimNumLowcase = controlKey.substring(controlKey.lastIndexOf(95) + 1);
        String dimNumStr = (String)this.getView().getFormShowParameter().getCustomParam("numbers");
        if (dimNumStr != null) {
            for (String dimNum : (String[])SerializationUtils.fromJsonString((String)dimNumStr, String[].class)) {
                if (!dimNum.toLowerCase(Locale.getDefault()).equals(dimNumLowcase)) continue;
                return dimNum;
            }
        }
        return null;
    }

    private void setF7LookUpFilter(String membEntityNum, String f7Key, String dimNumber) {
        BasedataEdit f7 = (BasedataEdit)this.getControl(f7Key);
        DynamicObjectCollection members = MemberServiceHelper.getAllBaseMember((String)membEntityNum, (String)"id,dimension.number", (Object)this.getTemplateModel().getModelId());
        ArrayList ids = new ArrayList();
        members.forEach(member -> {
            if (membEntityNum.equals("epm_userdefinedmembertree")) {
                if (dimNumber.equals(member.getString("dimension.number"))) {
                    ids.add(member.getLong("id"));
                }
            } else {
                ids.add(member.getLong("id"));
            }
        });
        QFilter filter = new QFilter("id", "in", (Object)ids.toArray());
        f7.getQFilters().add(filter);
    }

    @Override
    public void getEntityType(GetEntityTypeEventArgs e) {
        try {
            e.setNewEntityType((MainEntityType)e.getOriginalEntityType().clone());
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void initPageviewPanelValues() {
        List<?> ls = this.getDimMemberDetail();
        String ids = (String)this.getFormCustomParam("ids");
        if (ls != null && StringUtils.isNotEmpty((String)ids)) {
            String[] idstr = ids.split(";");
            block0: for (MembSettingBaseDetail m : ls) {
                String membEntityNum = m.getDimension().getMemberEntityNumber();
                for (int index = 0; index < idstr.length; ++index) {
                    DynamicObject dynaObj = QueryServiceHelper.queryOne((String)membEntityNum, (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(idstr[index])), new QFilter("dimension.number", "=", (Object)m.getDimension().getNumber())});
                    if (dynaObj == null) continue;
                    DynamicObject o = ORM.create().newDynamicObject(membEntityNum);
                    o.set("id", (Object)dynaObj.getLong("id"));
                    o.set("name", dynaObj.get("name"));
                    o.set("number", dynaObj.get("number"));
                    this.getModel().setValue(this.sugarF7Key(m.getDimension().getMemberEntityNumber(), m.getDimension().getNumber()), (Object)o);
                    continue block0;
                }
            }
        }
    }

    private void buildPageViewPanel() {
        int positionType = (Integer)this.getFormCustomParam("positionType");
        PositionTypeEnum type = PositionTypeEnum.getPositionTypeByVal((int)positionType);
        FlexPanelAp flex = new FlexPanelAp();
        flex.setKey("flexpanelap");
        List<MembSettingBaseDetail> ls = this.getDimMemberDetail();
        switch (type) {
            case ONROW: {
                FlexPanelAp rowDimFieldPanel = this.createTabAp(flex, "rowtab", "rowtab", true, false);
                this.fillDimItemField(rowDimFieldPanel, null, ls);
                break;
            }
            case ONCOL: {
                FlexPanelAp colDimFieldPanel = this.createTabAp(flex, "coltab", "coltab", false, false);
                this.fillDimItemField(null, colDimFieldPanel, ls);
                break;
            }
            case ONCROSS: {
                FlexPanelAp rowDimFieldPanel = this.createTabAp(flex, "rowtab", "rowtab", true, true);
                FlexPanelAp colDimFieldPanel = this.createTabAp(flex, "coltab", "coltab", false, true);
                this.fillDimItemField(rowDimFieldPanel, colDimFieldPanel, ls);
            }
        }
        this.getView().updateControlMetadata("flexpanelap", flex.createControl());
    }

    private void fillDimItemField(FlexPanelAp rowFieldPanel, FlexPanelAp colFieldPanel, List<MembSettingBaseDetail> ls) {
        if (ls != null) {
            Style style = new Style();
            Margin margin = new Margin();
            margin.setTop("10px");
            margin.setLeft("50px");
            style.setMargin(margin);
            if (rowFieldPanel != null) {
                rowFieldPanel.setStyle(style);
                rowFieldPanel.setAlignItems("right");
            }
            if (colFieldPanel != null) {
                colFieldPanel.setStyle(style);
                colFieldPanel.setAlignItems("right");
            }
            ls.forEach(e -> {
                EntryFieldAp f7Field = new EntryFieldAp();
                BasedataField basedata = new BasedataField();
                f7Field.setName(new LocaleString(e.getDimension().getName()));
                f7Field.setKey(this.sugarF7Key(e.getDimension().getMemberEntityNumber(), e.getDimension().getNumber()));
                f7Field.setFieldTextAlign("center");
                f7Field.setTextAlign("left");
                f7Field.setAlignSelf("center");
                f7Field.setQuickAddNew(false);
                basedata.setViewDetail(false);
                basedata.setKey(e.getDimension().getMemberEntityNumber());
                basedata.setBaseEntityId(e.getDimension().getMemberEntityNumber());
                f7Field.setField((Field)basedata);
                if (e instanceof RowDimensionEntry && rowFieldPanel != null && rowFieldPanel.getItems() != null) {
                    rowFieldPanel.getItems().add(f7Field);
                } else if (e instanceof ColDimensionEntry && colFieldPanel != null && colFieldPanel.getItems() != null) {
                    colFieldPanel.getItems().add(f7Field);
                }
            });
        }
    }

    private FlexPanelAp createTabAp(FlexPanelAp flex, String key, String name, boolean isRowDim, boolean setHeight) {
        TabAp tabap = new TabAp();
        tabap.setKey(key);
        tabap.setName(new LocaleString(name));
        if (setHeight) {
            tabap.setHeight(new LocaleString("50%"));
        }
        TabPageAp page = new TabPageAp();
        page.setKey(isRowDim ? "rowpage" : "colpage");
        page.setName(new LocaleString(isRowDim ? ResManager.loadKDString((String)"\u884c\u7ef4", (String)"TemplateMembSetting4SpreadF7Plugin_0", (String)"epm-eb-budget", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5217\u7ef4", (String)"TemplateMembSetting4SpreadF7Plugin_1", (String)"epm-eb-budget", (Object[])new Object[0])));
        FlexPanelAp fieldsetpanelap = new FlexPanelAp();
        fieldsetpanelap.setJustifyContent("space-between");
        fieldsetpanelap.setWidth(new LocaleString("90%"));
        fieldsetpanelap.setKey(isRowDim ? "rowdimflexpanel" : "coldimflexpanel");
        page.getItems().add(fieldsetpanelap);
        tabap.getItems().add(page);
        flex.getItems().add(tabap);
        return fieldsetpanelap;
    }

    private List<?> getDimMemberDetail() {
        int positionType = (Integer)this.getFormCustomParam("positionType");
        String isFloat = (String)this.getFormCustomParam("isFloat");
        String areaRange = (String)this.getFormCustomParam("areaRange");
        if (Boolean.parseBoolean(isFloat)) {
            String[] numbers = (String[])SerializationUtils.fromJsonString((String)((String)this.getFormCustomParam("numbers")), String[].class);
            log.info("float numbers:{}", (Object)JSONObject.toJSONString(Arrays.asList(numbers)));
            ArrayList<MembSettingBaseDetail> ls = new ArrayList<MembSettingBaseDetail>();
            AreaRangeEntry areaRangeEntry = (AreaRangeEntry)this.getTemplateModel().getAreaRangeEntries().get(0);
            if (areaRange != null) {
                for (AreaRangeEntry ar : this.getTemplateModel().getAreaRangeEntries()) {
                    if (!ar.getAreaRange().equals(areaRange)) continue;
                    areaRangeEntry = ar;
                    break;
                }
            }
            for (String string : numbers) {
                for (MembSettingBaseDetail memb : areaRangeEntry.getColDimEntries()) {
                    if (!string.equals(memb.getDimension().getNumber())) continue;
                    ls.add(memb);
                }
            }
            for (String string : numbers) {
                for (MembSettingBaseDetail memb : areaRangeEntry.getRowDimEntries()) {
                    if (!string.equals(memb.getDimension().getNumber())) continue;
                    ls.add(memb);
                }
            }
            return ls;
        }
        PositionTypeEnum type = PositionTypeEnum.getPositionTypeByVal((int)positionType);
        for (AreaRangeEntry ar : this.getTemplateModel().getAreaRangeEntries()) {
            if (!ar.getAreaRange().equals(areaRange)) continue;
            switch (type) {
                case ONROW: {
                    return ar.getRowDimEntries();
                }
                case ONCOL: {
                    return ar.getColDimEntries();
                }
                case ONCROSS: {
                    ArrayList ls = new ArrayList();
                    ls.addAll(ar.getRowDimEntries());
                    ls.addAll(ar.getColDimEntries());
                    return ls;
                }
            }
        }
        return null;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String oprtId = args.getOperateKey();
        ListSelectedRowCollection coll = new ListSelectedRowCollection();
        int rowdimSize = 0;
        int coldimSize = 0;
        int notSelectRowdimCount = 0;
        int notSelectColdimCount = 0;
        boolean checkAllFill = this.getFormCustomParam("checkAllFill", false);
        if ("confirm".equals(oprtId)) {
            List<?> ls = this.getDimMemberDetail();
            boolean isRow = false;
            if (ls != null) {
                for (MembSettingBaseDetail m : ls) {
                    if (m instanceof RowDimensionEntry) {
                        ++rowdimSize;
                        isRow = true;
                    } else {
                        ++coldimSize;
                        isRow = false;
                    }
                    String f7Key = this.sugarF7Key(m.getDimension().getMemberEntityNumber(), m.getDimension().getNumber());
                    if (this.getModel().getValue(f7Key) == null) {
                        if (isRow) {
                            ++notSelectRowdimCount;
                            continue;
                        }
                        ++notSelectColdimCount;
                        continue;
                    }
                    ListSelectedRow row = new ListSelectedRow(this.getModel().getDataEntity().getDynamicObject(f7Key).get("id"));
                    coll.add((Object)row);
                }
                if (rowdimSize != notSelectRowdimCount && notSelectRowdimCount > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u884c\u7ef4\u5b58\u5728\u672a\u9009\u62e9\u7684\u6210\u5458\u3002", (String)"TemplateMembSetting4SpreadF7Plugin_2", (String)"epm-eb-budget", (Object[])new Object[0]));
                    return;
                }
                if (coldimSize != notSelectColdimCount && notSelectColdimCount > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5217\u7ef4\u5b58\u5728\u672a\u9009\u62e9\u7684\u6210\u5458\u3002", (String)"TemplateMembSetting4SpreadF7Plugin_3", (String)"epm-eb-budget", (Object[])new Object[0]));
                    return;
                }
                if (checkAllFill && notSelectRowdimCount + notSelectColdimCount > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u9009\u62e9\u7684\u6210\u5458\u3002", (String)"TemplateMembSetting4SpreadF7Plugin_4", (String)"epm-eb-budget", (Object[])new Object[0]));
                    return;
                }
            }
        }
        if (coll.size() > 0) {
            int positionType = (Integer)this.getFormCustomParam("positionType");
            if (PositionTypeEnum.ONCROSS.getValue() == positionType) {
                HashMap<String, Integer> result = new HashMap<String, Integer>();
                result.put("positionType", notSelectColdimCount + notSelectRowdimCount == 0 ? PositionTypeEnum.ONCROSS.getValue() : (notSelectRowdimCount == 0 ? PositionTypeEnum.ONROW.getValue() : PositionTypeEnum.ONCOL.getValue()));
                result.put("result", (Integer)coll);
                this.getView().returnDataToParent(result);
            } else {
                this.getView().returnDataToParent((Object)coll);
            }
        }
        this.getView().close();
    }

    @Override
    public void onGetControl(OnGetControlArgs e) {
        String ctrlKey = e.getKey();
        if (this.checkControlKeyPrefix(this.getView(), ctrlKey) && !ctrlKey.endsWith("_id")) {
            String isFloat = (String)this.getFormCustomParam("isFloat");
            if (Boolean.parseBoolean(isFloat)) {
                BasePointInnerLineInfo[] innerInfos = (BasePointInnerLineInfo[])ObjectSerialUtil.deSerializedBytes((String)((String)this.getFormCustomParam("innerInfo")));
                BasePointInnerLineInfo info = null;
                String dimNum = this.splitUserDefineDimNumByF7key(ctrlKey);
                if (dimNum == null) {
                    dimNum = DimEntityNumEnum.getNumberByEntieyNum((String)ctrlKey);
                }
                for (BasePointInnerLineInfo basePointInnerLineInfo : innerInfos) {
                    if (!dimNum.equalsIgnoreCase(basePointInnerLineInfo.getDimension().getNumber())) continue;
                    info = basePointInnerLineInfo;
                    break;
                }
                if (info == null) {
                    return;
                }
                QFilter numberFilter = new QFilter("number", "=", (Object)info.getDimension().getNumber());
                DynamicObject dimObj = BusinessDataServiceHelper.loadSingle((String)"epm_dimension", (String)"id,number,name,dseq,membermodel", (QFilter[])new QFilter[]{this.getQFilterByModelID(), numberFilter});
                QFilter filter = TemplateFloatUtil.getFilterByInnerInfo(info, this.getTemplateModel().getModelId(), dimObj.getLong("id"));
                if (filter == null) {
                    filter = new QFilter("dimension", "=", (Object)dimObj.getLong("id"));
                }
                BasedataEdit basedataEdit = DataEntityUtils.createF7Component((String)ctrlKey, (IDataModel)this.getModel(), (IFormView)this.getView(), (QFilter)filter, null);
                if (this.isEPM()) {
                    basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
                }
                e.setControl((Control)basedataEdit);
            } else {
                String entityNum = this.getEntityNumByF7key(ctrlKey);
                String dimNum = this.splitUserDefineDimNumByF7key(ctrlKey);
                long dimId = 0L;
                List<?> ls = this.getDimMemberDetail();
                for (MembSettingBaseDetail p : ls) {
                    if (!p.getDimension().getMemberEntityNumber().equals(entityNum) || (dimNum == null || !dimNum.equalsIgnoreCase(p.getDimension().getNumber())) && dimNum != null) continue;
                    dimId = p.getDimension().getId();
                    break;
                }
                if (dimId == 0L) {
                    throw new KDBizException("not found dimension number ->" + dimNum);
                }
                BasedataEditSingleMemberF7 basedataSingleF7 = SingleMemberF7Util.createBasedataEditSingleMemberF7(this.getView(), this.getModel(), this.getTemplateModel().getModelId(), dimId, ctrlKey, null, false);
                basedataSingleF7.setDisplayAllFyOrPeriodMemb(true);
                basedataSingleF7.setVerifyPermission(false);
                HashMap<String, Object> customData = new HashMap<String, Object>();
                customData.put("f7Click", "true");
                basedataSingleF7.setCustomData(customData);
                e.setControl((Control)basedataSingleF7);
            }
        }
    }
}

