/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.budget.formplugin.template;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.RedisModelCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.TextProp;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.util.StringUtils;
import kd.epm.eb.budget.formplugin.template.AbstractTemplateBasePlugin;
import kd.epm.eb.common.ebcommon.common.enums.DimTypesEnum;
import kd.epm.eb.ebBusiness.serviceHelper.QueryDimensionServiceHelper;
import kd.epm.eb.ebBusiness.template.model.AreaRangeEntry;
import kd.epm.eb.ebBusiness.template.model.ColDimensionEntry;
import kd.epm.eb.ebBusiness.template.model.Dimension;
import kd.epm.eb.ebBusiness.template.model.PageDimensionEntry;
import kd.epm.eb.ebBusiness.template.model.RowDimensionEntry;
import kd.epm.eb.ebBusiness.template.model.TemplateModel;
import kd.epm.eb.ebBusiness.template.model.ViewPointDimensionEntry;

public class TemplateRankSettingPlugin
extends AbstractTemplateBasePlugin {
    private static final String row = "row";
    private static final String col = "col";
    private static final String rowpanel = "rowpanel";
    private static final String colpanel = "colpanel";
    private static final String allname = "map";
    private static final String allseq = "seq";

    @Override
    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{"btn_confirm", "btn_cancel"});
        this.bindCtrlMapping();
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.loadColEntry(this.template);
        this.loadRowEntry(this.template);
        this.bindCtrlMapping();
        this.getControl(rowpanel).setDroppable(true);
        this.getControl(colpanel).setDroppable(true);
    }

    private void bindCtrlMapping(String item) {
        String f7MapFields = this.getPageCache().get(item + "Fields");
        if (StringUtils.isEmpty((String)f7MapFields)) {
            return;
        }
        String[] fields = f7MapFields.split(";");
        MainEntityType mainEntityType = this.getModel().getDataEntityType();
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)mainEntityType.getName(), (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        EntityMetadata entityMeta = (EntityMetadata)MetadataDao.readRuntimeMeta((String)formMeta.getEntityId(), (MetaCategory)MetaCategory.Entity);
        for (String sign : fields) {
            this.addTextFieldToMainEntity((Container)this.getControl(item + "panel"), mainEntityType, entityMeta, sign, this.getModel(), this.getView());
            this.getModel().setValue(sign, (Object)this.getNameMap().get(sign));
            this.getControl(sign).setDraggable(true);
            this.getControl(sign).setDroppable(true);
        }
    }

    private void bindCtrlMapping() {
        this.bindCtrlMapping(row);
        this.bindCtrlMapping(col);
    }

    @Override
    public void getEntityType(GetEntityTypeEventArgs e) {
        try {
            e.setNewEntityType((MainEntityType)e.getOriginalEntityType().clone());
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void onGetControl(OnGetControlArgs e) {
        String ctrlKey = e.getKey();
        if (ctrlKey.startsWith("epm_")) {
            TextEdit edit = new TextEdit();
            edit.setKey(ctrlKey);
            edit.setModel(this.getModel());
            edit.setView(this.getView());
            edit.setDraggable(true);
            edit.setDroppable(true);
            e.setControl((Control)edit);
        }
    }

    private void loadRowEntry(TemplateModel template) {
        List<String> row = this.getRowEntry();
        FlexPanelAp rowpanel = new FlexPanelAp();
        rowpanel.setKey(rowpanel);
        if (row.size() > 0) {
            this.addItems(rowpanel, row);
        }
        this.updateControlMetadata(rowpanel, rowpanel.createControl());
        StringBuilder sb = new StringBuilder();
        for (String string : row) {
            sb.append(string).append(';');
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        this.getPageCache().put("rowFields", sb.toString());
    }

    private void loadColEntry(TemplateModel template) {
        List<String> col = this.getColEntry();
        FlexPanelAp colpanel = new FlexPanelAp();
        colpanel.setKey(colpanel);
        if (col.size() > 0) {
            this.addItems(colpanel, col);
        }
        this.updateControlMetadata(colpanel, colpanel.createControl());
        StringBuilder sb = new StringBuilder();
        for (String string : col) {
            sb.append(string).append(';');
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        this.getPageCache().put("colFields", sb.toString());
    }

    private List<String> getRowEntry() {
        if (this.getPageCache().get(row) == null) {
            Map<String, String> map = this.getNameMap();
            Map<String, String> seq = this.getSeqMap();
            ArrayList<String> list = new ArrayList<String>();
            AreaRangeEntry ae = null;
            List<DynamicObject> rank = this.getRankDim();
            for (AreaRangeEntry area : this.getTemplateModel().getAreaRangeEntries()) {
                if (!area.getAreaRange().equals(this.getArea()) || area.getRowDimEntries().size() <= 0 && area.getColDimEntries().size() <= 0) continue;
                ae = area;
                break;
            }
            if (ae == null) {
                DynamicObject obj = rank.get(0);
                list.add("epm_" + obj.getString("number").toLowerCase());
                map.put("epm_" + obj.getString("number").toLowerCase(), obj.getString("name"));
                seq.put("epm_" + obj.getString("number").toLowerCase(), QueryDimensionServiceHelper.getMsgByNumber((long)this.getTemplateModel().getModelId(), (String)obj.getString("number")).getString("dseq"));
            } else {
                for (RowDimensionEntry re : ae.getRowDimEntries()) {
                    list.add("epm_" + re.getDimension().getNumber().toLowerCase());
                    map.put("epm_" + re.getDimension().getNumber().toLowerCase(), re.getDimension().getName());
                    seq.put("epm_" + re.getDimension().getNumber().toLowerCase(), QueryDimensionServiceHelper.getMsgByNumber((long)this.getTemplateModel().getModelId(), (String)re.getDimension().getNumber()).getString("dseq"));
                }
            }
            this.getPageCache().put(row, SerializationUtils.toJsonString(list));
            this.getPageCache().put(allname, SerializationUtils.toJsonString(map));
            this.getPageCache().put(allseq, SerializationUtils.toJsonString(seq));
        }
        List rp = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(row), List.class);
        return rp;
    }

    private List<String> getColEntry() {
        if (this.getPageCache().get(col) == null) {
            Map<String, String> map = this.getNameMap();
            Map<String, String> seq = this.getSeqMap();
            ArrayList<String> list = new ArrayList<String>();
            AreaRangeEntry ae = null;
            List<DynamicObject> rank = this.getRankDim();
            for (AreaRangeEntry area : this.getTemplateModel().getAreaRangeEntries()) {
                if (!area.getAreaRange().equals(this.getArea()) || area.getRowDimEntries().size() <= 0 && area.getColDimEntries().size() <= 0) continue;
                ae = area;
                break;
            }
            if (ae == null) {
                rank.remove(0);
                for (DynamicObject obj : rank) {
                    list.add("epm_" + obj.getString("number").toLowerCase());
                    map.put("epm_" + obj.getString("number").toLowerCase(), obj.getString("name"));
                    seq.put("epm_" + obj.getString("number").toLowerCase(), QueryDimensionServiceHelper.getMsgByNumber((long)this.getTemplateModel().getModelId(), (String)obj.getString("number")).getString("dseq"));
                }
            } else {
                for (ColDimensionEntry re : ae.getColDimEntries()) {
                    list.add("epm_" + re.getDimension().getNumber().toLowerCase());
                    map.put("epm_" + re.getDimension().getNumber().toLowerCase(), re.getDimension().getName());
                    seq.put("epm_" + re.getDimension().getNumber().toLowerCase(), QueryDimensionServiceHelper.getMsgByNumber((long)this.getTemplateModel().getModelId(), (String)re.getDimension().getNumber()).getString("dseq"));
                }
            }
            this.getPageCache().put(col, SerializationUtils.toJsonString(list));
            this.getPageCache().put(allname, SerializationUtils.toJsonString(map));
            this.getPageCache().put(allseq, SerializationUtils.toJsonString(seq));
        }
        List cp = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get(col), List.class);
        return cp;
    }

    private Map<String, String> getNameMap() {
        HashMap<String, String> map;
        if (this.getPageCache().get(allname) == null) {
            map = new HashMap();
            this.getPageCache().put(allname, SerializationUtils.toJsonString(map));
        }
        map = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(allname), Map.class);
        return map;
    }

    private Map<String, String> getSeqMap() {
        HashMap<String, String> map;
        if (this.getPageCache().get(allseq) == null) {
            map = new HashMap();
            this.getPageCache().put(allseq, SerializationUtils.toJsonString(map));
        }
        map = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get(allseq), Map.class);
        return map;
    }

    private void addItems(FlexPanelAp pageviewpanel, List<String> list) {
        for (String e : list) {
            EntryFieldAp lb = new EntryFieldAp();
            lb.setName(new LocaleString(e));
            lb.setKey(e);
            TextField asd = new TextField();
            lb.setField((Field)asd);
            lb.setShowTitle(false);
            lb.setTextAlign("center");
            lb.setFieldTextAlign("center");
            lb.setLock("new,edit,view");
            pageviewpanel.getItems().add(lb);
        }
    }

    private void addTextFieldToMainEntity(Container targContainer, MainEntityType targetEntity, EntityMetadata entityMeta, String fieldKey, IDataModel model, IFormView view) {
        TextProp fieldprop = new TextProp();
        fieldprop.setName(fieldKey);
        targetEntity.addProperty((DynamicProperty)fieldprop);
        if (targContainer instanceof EntryGrid) {
            ((EntryProp)targetEntity.getProperties().get((Object)targContainer.getKey()))._collectionItemPropertyType.addProperty((DynamicProperty)fieldprop);
        }
        FieldAp field = new FieldAp();
        field.setName(new LocaleString(fieldKey));
        field.setKey(fieldKey);
        TextField textFiled = new TextField();
        textFiled.setKey(fieldKey);
        textFiled.setEntityMetadata(entityMeta);
        entityMeta.getItems().add(textFiled);
        field.setField((Field)textFiled);
        FieldEdit control = field.buildRuntimeControl();
        control.setModel(model);
        control.setView(view);
        targContainer.getItems().add(control);
    }

    public void customEvent(CustomEventArgs e) {
        String name = e.getEventName();
        if ("drop".equals(name)) {
            String eventArgs = e.getEventArgs();
            String[] msg = this.translateMessage(eventArgs);
            String target = msg[0];
            String source = msg[1];
            if (source.startsWith("epm_")) {
                this.interChange(target, source);
                FlexPanelAp colpanel = new FlexPanelAp();
                colpanel.setKey(colpanel);
                FlexPanelAp rowpanel = new FlexPanelAp();
                rowpanel.setKey(rowpanel);
                this.updateControlMetadata(colpanel, colpanel.createControl());
                this.updateControlMetadata(rowpanel, rowpanel.createControl());
                this.loadColEntry(this.template);
                this.loadRowEntry(this.template);
                this.bindCtrlMapping();
                RedisModelCache cache = new RedisModelCache((IRefrencedataProvider)this.getView().getService(IDataModel.class), this.getModel().getDataEntityType(), this.getView().getPageId());
                cache.storeAll(this.getModel().getDataEntity());
                this.getModel().setDataChanged(true);
            }
        }
    }

    private String[] translateMessage(String text) {
        text = text.substring(1, text.length() - 1);
        String[] msg = text.split(",");
        for (int i = 0; i < msg.length; ++i) {
            msg[i] = msg[i].substring(1, msg[i].length() - 1);
        }
        return msg;
    }

    private void interChange(String target, String source) {
        List<String> rowlist = this.getRowEntry();
        List<String> collist = this.getColEntry();
        String sourcePanel = rowlist.contains(source) ? rowpanel : colpanel;
        String targetPanel = "";
        if (target.startsWith("epm_")) {
            targetPanel = rowlist.contains(target) ? rowpanel : colpanel;
            List<String> tarlist = targetPanel.equals(rowpanel) ? rowlist : collist;
            List<String> sorlist = sourcePanel.equals(rowpanel) ? rowlist : collist;
            int tarnum = tarlist.indexOf(target);
            int sornum = sorlist.indexOf(source);
            sorlist.remove(sornum);
            tarlist.add(tarnum, source);
        } else if (rowpanel.equals(target) || colpanel.equals(target)) {
            targetPanel = target;
            List<String> tarlist = targetPanel.equals(rowpanel) ? rowlist : collist;
            List<String> sorlist = sourcePanel.equals(rowpanel) ? rowlist : collist;
            int sornum = sorlist.indexOf(source);
            sorlist.remove(sornum);
            tarlist.add(source);
        }
        this.getPageCache().put(col, SerializationUtils.toJsonString(collist));
        this.getPageCache().put(row, SerializationUtils.toJsonString(rowlist));
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        String objectId;
        super.afterDoOperation(eventArgs);
        switch (objectId = eventArgs.getOperateKey()) {
            case "confirm": {
                if (eventArgs.getOperationResult().isSuccess()) {
                    if (this.getColEntry().size() > 0 && this.getRowEntry().size() > 0) {
                        this.handleAreaRangAndClose(true);
                        break;
                    }
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u884c\u7ef4\u6216\u5217\u7ef4\u81f3\u5c11\u4fdd\u75591\u4e2a\u7ef4\u5ea6\u3002", (String)"TemplateRankSettingPlugin_0", (String)"epm-eb-budget", (Object[])new Object[0]));
                    break;
                }
                List errorInfos = eventArgs.getOperationResult().getAllErrorOrValidateInfo();
                this.getView().showErrorNotification(((IOperateInfo)errorInfos.get(0)).getMessage());
            }
        }
    }

    private void handleAreaRangAndClose(boolean b) {
        boolean isFromChangeArea;
        String after;
        Dimension dim;
        TemplateModel model = this.getTemplateModel();
        DynamicObject temp = null;
        AreaRangeEntry areaentry = null;
        String before = this.collectRowAndColDimNum();
        boolean is = false;
        for (AreaRangeEntry area : model.getAreaRangeEntries()) {
            if (!area.getAreaRange().equals(this.getArea())) continue;
            areaentry = area;
            area.setStartPosition(this.getStartPoint());
            break;
        }
        if (areaentry == null) {
            areaentry = new AreaRangeEntry(model);
            areaentry.setAreaRange(this.getArea());
            areaentry.setStartPosition(this.getStartPoint());
            is = true;
        }
        areaentry.getRowDimEntries().clear();
        areaentry.getColDimEntries().clear();
        for (String row : this.getRowEntry()) {
            temp = QueryDimensionServiceHelper.getDimByDseq((int)Integer.parseInt(this.getSeqMap().get(row)), (Long)model.getModelId());
            dim = this.convertDynaObj2Dimension(temp);
            RowDimensionEntry rowDimEntry = new RowDimensionEntry(areaentry);
            rowDimEntry.setDimension(dim);
            rowDimEntry.setSeq(Integer.parseInt(this.getSeqMap().get(row)));
            areaentry.addRowDimEntry(rowDimEntry);
        }
        for (String col : this.getColEntry()) {
            temp = QueryDimensionServiceHelper.getDimByDseq((int)Integer.parseInt(this.getSeqMap().get(col)), (Long)model.getModelId());
            dim = this.convertDynaObj2Dimension(temp);
            ColDimensionEntry colDimEntry = new ColDimensionEntry(areaentry);
            colDimEntry.setDimension(dim);
            colDimEntry.setSeq(Integer.parseInt(this.getSeqMap().get(col)));
            areaentry.addColDimEntry(colDimEntry);
        }
        if (is) {
            model.getAreaRangeEntries().add(areaentry);
        }
        model.put("isChange", (Object)(!before.equals(after = this.collectRowAndColDimNum()) ? 1 : 0));
        boolean bl = isFromChangeArea = this.getFormCustomParam("isFromChangeArea") == null ? false : (Boolean)this.getFormCustomParam("isFromChangeArea");
        if (isFromChangeArea) {
            this.returnDataToParent(this.getTemplateModel());
            this.getView().close();
        } else if (before.equals(after)) {
            this.getView().close();
        } else if (StringUtils.isNotEmpty((String)before) && !"|".equals(before)) {
            this.cacheTemplateModel();
            this.getView().showConfirm(ResManager.loadKDString((String)"\u884c\u5217\u7ef4\u5df2\u53d1\u751f\u53d8\u52a8\uff0c\u8bf7\u786e\u8ba4\u6e05\u7a7a\u7ef4\u5ea6\u6210\u5458\u8bbe\u7f6e\u4fe1\u606f\uff1f", (String)"TemplateRankSettingPlugin_1", (String)"epm-eb-budget", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("change_confirm", (IFormPlugin)this));
        } else {
            this.returnDataToParent(this.getTemplateModel());
            this.getView().close();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackId = e.getCallBackId();
        if ("change_confirm".equals(callBackId)) {
            if (e.getResult().equals((Object)MessageBoxResult.Yes)) {
                this.getTemplateModel().put("isChange", (Object)true);
                this.returnDataToParent(this.getTemplateModel());
            }
            this.getView().close();
        }
    }

    private String collectRowAndColDimNum() {
        StringBuilder sb = new StringBuilder();
        String area = this.getArea();
        this.getTemplateModel().getAreaRangeEntries().forEach(e -> {
            if (area.equals(e.getAreaRange())) {
                e.getRowDimEntries().forEach(r -> sb.append(r.getDimension().getMemberEntityNumber()));
                sb.append('|');
                e.getColDimEntries().forEach(c -> sb.append(c.getDimension().getMemberEntityNumber()));
            }
        });
        return sb.toString();
    }

    private String getArea() {
        String area = (String)this.getView().getFormShowParameter().getCustomParam("areaRange");
        return area;
    }

    private String getStartPoint() {
        String start = (String)this.getView().getFormShowParameter().getCustomParam("startPosition");
        return start;
    }

    private List<DynamicObject> getRankDim() {
        ArrayList<String> numbers = new ArrayList<String>(10);
        for (PageDimensionEntry pe : this.getTemplateModel().getPageDimensionEntries()) {
            numbers.add(pe.getDimension().getNumber());
        }
        for (PageDimensionEntry pe : this.getTemplateModel().getPagePropEntries()) {
            numbers.add(pe.getDimension().getNumber());
        }
        for (ViewPointDimensionEntry ve : this.getTemplateModel().getViewPointDimensionEntries()) {
            numbers.add(ve.getDimension().getNumber());
        }
        List rank = QueryDimensionServiceHelper.getOthersDim(numbers, (Long)this.getTemplateModel().getModelId());
        for (DynamicObject obj : rank) {
            if (!DimTypesEnum.INTERCOMPANY.getNumber().equals(obj.getString("number")) || QueryDimensionServiceHelper.checkIcEnt((long)this.getTemplateModel().getModelId())) continue;
            rank.remove(obj);
            break;
        }
        return rank;
    }

    private void updateControlMetadata(String key, Map<String, Object> ctl) {
        ArrayList<Object> paras = new ArrayList<Object>(2);
        paras.add(key);
        if (ctl.get("items") == null) {
            ctl.put("items", new Object[0]);
        }
        paras.add(ctl);
        ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("updateControlMetadata", paras);
    }
}

