/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.budget.formplugin.template;

import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.budget.formplugin.template.AbstractTemplateBasePlugin;
import kd.epm.eb.common.ebcommon.common.enums.DimTypesEnum;
import kd.epm.eb.common.ebcommon.common.util.ObjectSerialUtil;
import kd.epm.eb.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.ebSpread.domain.Cell;
import kd.epm.eb.ebSpread.domain.Domain;
import kd.epm.eb.ebSpread.domain.view.Sheet;
import kd.epm.eb.ebSpread.model.IDimMember;
import kd.epm.eb.ebSpread.model.dao.Tuple;
import kd.epm.eb.ebSpread.util.GZIPUtils;

public class TemplateSetBaseVarForEB {
    private static final String CON_EBSYS = "eb";
    private static final String CON_BGSYS = "bg";
    private static final String CON_YEAR_FY = "FY";
    private static final String CON_CELLVALUE_SPLITKEY = ";";
    private static final String DIMTYPE_YEAR = DimTypesEnum.YEAR.getNumber();
    private static final String DIMTYPE_TYPE = DimTypesEnum.DATATYPE.getNumber();
    private static final String DIMTYPE_VERSION = DimTypesEnum.VERSION.getNumber();
    private static final String BASEYEARVAR = "varbaseforeb";
    private static final String CON_HEADJSON = "varjsonforeb";
    private static final String CON_YEARVARPREFIX = "@Y";
    private static final String CON_TYPEVARPREFIX = "@D";
    private static final String CON_VERSTIONVARPREFIX = "@V";

    private static String getCON_YEARC_HEAD_FINDKEY() {
        return ResManager.loadKDString((String)"\u5e74", (String)"TemplateSetBaseVarForEB_0", (String)"epm-eb-budget", (Object[])new Object[0]);
    }

    private static String getCON_YEARC_DATARANGE_FINDKEY() {
        return ResManager.loadKDString((String)"\u8d22\u5e74!", (String)"TemplateSetBaseVarForEB_1", (String)"epm-eb-budget", (Object[])new Object[0]);
    }

    private static String getCON_YEAR_PY() {
        return ResManager.loadKDString((String)"\u57fa\u51c6\u8d22\u5e74\u504f\u79fb", (String)"TemplateSetBaseVarForEB_2", (String)"epm-eb-budget", (Object[])new Object[0]);
    }

    private static String getCON_TYPE_FINDKEY() {
        return ResManager.loadKDString((String)"\u6570\u636e\u7c7b\u578b!", (String)"TemplateSetBaseVarForEB_3", (String)"epm-eb-budget", (Object[])new Object[0]);
    }

    private static String getCON_VERSTION_FINDKEY() {
        return ResManager.loadKDString((String)"\u7248\u672c!", (String)"TemplateSetBaseVarForEB_4", (String)"epm-eb-budget", (Object[])new Object[0]);
    }

    public static Boolean isSetBaseYearVar(AbstractTemplateBasePlugin plugin) {
        return plugin.getTemplateModel().getVarBase() != null && plugin.getTemplateModel().getVarBase().length() > 0;
    }

    public static Boolean isBudgetApp(AbstractTemplateBasePlugin plugin) {
        return plugin.getBizAppId() != null && (plugin.getBizAppId().contains(CON_BGSYS) || CON_EBSYS.equals(plugin.getBizAppId()) || ApplicationTypeEnum.WF.getAppnum().equals(plugin.getBizAppId()) || ApplicationTypeEnum.WF2.getAppnum().equals(plugin.getBizAppId()));
    }

    public static Map<String, String[]> loopRecordHeadPos(AbstractTemplateBasePlugin plugin) {
        HashMap<String, String[]> mapPos = new HashMap<String, String[]>();
        if (TemplateSetBaseVarForEB.isBudgetApp(plugin).booleanValue() && plugin.getTemplateModel().getSpreadJson() != null && plugin.getTemplateModel().getVarJson() != null) {
            Sheet sheet = plugin.getEffectiveSheet();
            sheet.iteratorCells(cell -> {
                String cellValue;
                String strYearPreFix;
                if (TemplateSetBaseVarForEB.cellIsNotNull(cell) && !"".equals(strYearPreFix = TemplateSetBaseVarForEB.doYearValue(cellValue = cell.getValue().toString()))) {
                    mapPos.put(TemplateSetBaseVarForEB.getMapKey(cell, DIMTYPE_YEAR), new String[]{String.valueOf(cell.getRow()), String.valueOf(cell.getCol()), cellValue, strYearPreFix});
                }
            });
        }
        return mapPos;
    }

    private static boolean cellIsNotNull(Cell cell) {
        return cell != null && cell.getValue() != null && cell.getValue().toString().length() > 0;
    }

    private static String getMapKey(Cell cell, String dimKey) {
        return dimKey + '|' + cell.getRow() + ':' + cell.getCol();
    }

    public static void cellChangeRecordHeadPos(AbstractTemplateBasePlugin plugin, Map<String, String[]> mapPos, Cell cell) {
        if (TemplateSetBaseVarForEB.isBudgetApp(plugin).booleanValue() && TemplateSetBaseVarForEB.cellIsNotNull(cell)) {
            String cellValue;
            String strYearPreFix;
            if (mapPos == null) {
                mapPos = new HashMap<String, String[]>();
            }
            if ((strYearPreFix = TemplateSetBaseVarForEB.doYearValue(cellValue = cell.getValue().toString())).length() > 0 && !mapPos.containsKey(TemplateSetBaseVarForEB.getMapKey(cell, DIMTYPE_YEAR))) {
                mapPos.put(TemplateSetBaseVarForEB.getMapKey(cell, DIMTYPE_YEAR), new String[]{String.valueOf(cell.getRow()), String.valueOf(cell.getCol()), cellValue, strYearPreFix});
            } else if (strYearPreFix.length() > 0 && mapPos.containsKey(TemplateSetBaseVarForEB.getMapKey(cell, DIMTYPE_YEAR))) {
                if (cellValue != mapPos.get(TemplateSetBaseVarForEB.getMapKey(cell, DIMTYPE_YEAR))[3]) {
                    mapPos.remove(TemplateSetBaseVarForEB.getMapKey(cell, DIMTYPE_YEAR));
                    mapPos.put(TemplateSetBaseVarForEB.getMapKey(cell, DIMTYPE_YEAR), new String[]{String.valueOf(cell.getRow()), String.valueOf(cell.getCol()), cellValue, strYearPreFix});
                }
            } else if (strYearPreFix.length() == 0 && mapPos.containsKey(TemplateSetBaseVarForEB.getMapKey(cell, DIMTYPE_YEAR))) {
                mapPos.remove(TemplateSetBaseVarForEB.getMapKey(cell, DIMTYPE_YEAR));
            }
        }
    }

    public static String replease2BaseVar(AbstractTemplateBasePlugin plugin, Cell cell) {
        String sDisplayValue = cell.displayDimMsg();
        if (TemplateSetBaseVarForEB.isBudgetApp(plugin).booleanValue() && TemplateSetBaseVarForEB.isSetBaseYearVar(plugin).booleanValue()) {
            boolean fyIsRowDim = TemplateSetBaseVarForEB.isOnRowDim(DIMTYPE_YEAR, plugin);
            boolean typeIsRowDim = TemplateSetBaseVarForEB.isOnRowDim(DIMTYPE_TYPE, plugin);
            boolean verIsRowDim = TemplateSetBaseVarForEB.isOnRowDim(DIMTYPE_VERSION, plugin);
            Map cellDimMap = cell.getMemberFromUserObjectDimNumbers();
            if (!fyIsRowDim) {
                sDisplayValue = TemplateSetBaseVarForEB.transVar2SpecificFY(plugin.getTemplateModel().getVarBase(), cellDimMap, DIMTYPE_YEAR, sDisplayValue, TemplateSetBaseVarForEB.getCON_YEARC_DATARANGE_FINDKEY(), CON_YEARVARPREFIX);
            }
            if (!typeIsRowDim) {
                sDisplayValue = TemplateSetBaseVarForEB.transVar2SpecificTypeAndVerstion(plugin.getTemplateModel().getVarBase(), cellDimMap, DIMTYPE_TYPE, sDisplayValue, TemplateSetBaseVarForEB.getCON_TYPE_FINDKEY(), CON_TYPEVARPREFIX);
            }
            if (!verIsRowDim) {
                sDisplayValue = TemplateSetBaseVarForEB.transVar2SpecificTypeAndVerstion(plugin.getTemplateModel().getVarBase(), cellDimMap, DIMTYPE_VERSION, sDisplayValue, TemplateSetBaseVarForEB.getCON_VERSTION_FINDKEY(), CON_VERSTIONVARPREFIX);
            }
        }
        return sDisplayValue;
    }

    private static String[] getCellOldValue(String cellValue, String strFindKey) {
        String[] strCellValueSplit;
        String[] strReturn = new String[]{};
        for (String strSubSplit : strCellValueSplit = cellValue.split(CON_CELLVALUE_SPLITKEY)) {
            if (!strSubSplit.contains(strFindKey) && (!strFindKey.equalsIgnoreCase(TemplateSetBaseVarForEB.getCON_YEARC_DATARANGE_FINDKEY()) || !cellValue.contains(CON_YEAR_FY) || cellValue.length() != 6)) continue;
            String subStr = strSubSplit.indexOf(strFindKey) >= 0 ? strSubSplit.substring(strSubSplit.indexOf(strFindKey) + strFindKey.length()) : strSubSplit;
            String[] strSplit = (subStr = subStr.replace("[", "").replace("]", "")).split("\\|");
            if (strSplit.length > 1) {
                strReturn = new String[]{strSplit[0], strSplit[1], subStr};
                break;
            }
            if (strSplit.length != 1) break;
            strReturn = new String[]{strSplit[0], strSplit[0], subStr};
            break;
        }
        return strReturn;
    }

    public static String doYearValue(String s) {
        if (s != null && s.contains(TemplateSetBaseVarForEB.getCON_YEARC_HEAD_FINDKEY()) && s.length() > 4 && StringUtils.isNumeric((String)s.substring(0, 4))) {
            return s.substring(0, 4);
        }
        return "";
    }

    private static String doYearValueForFY(String s) {
        if (s != null && s.contains(DimTypesEnum.YEAR.getShortNumber()) && s.length() > 4 && StringUtils.isNumeric((String)s.substring(DimTypesEnum.YEAR.getShortNumber().length(), DimTypesEnum.YEAR.getShortNumber().length() + 4))) {
            return s.substring(DimTypesEnum.YEAR.getShortNumber().length(), DimTypesEnum.YEAR.getShortNumber().length() + 4);
        }
        return "";
    }

    private static boolean isAlreadyTrans(Sheet sheet, String transKey) {
        return sheet.getUserObject(transKey) == null ? false : (Boolean)sheet.getUserObject(transKey);
    }

    public static boolean needTransFyVar(boolean hasFyDim, Sheet sheet, AbstractTemplateBasePlugin plugin) {
        boolean bolReturn = false;
        if (TemplateSetBaseVarForEB.isBudgetApp(plugin).booleanValue() && TemplateSetBaseVarForEB.isSetBaseYearVar(plugin).booleanValue()) {
            return !bolReturn;
        }
        return bolReturn;
    }

    public static String getInvaliadDimInfo(List<String> strLst) {
        if (strLst == null) {
            return "";
        }
        StringBuilder strReturn = new StringBuilder();
        HashSet<String> existStrSet = new HashSet<String>(16);
        for (String str : strLst) {
            if (!StringUtils.isNotEmpty((String)str) || existStrSet.contains(str)) continue;
            strReturn.append(str).append(',');
            existStrSet.add(str);
        }
        if (strReturn.length() > 0) {
            return strReturn.substring(0, strReturn.length() - 1);
        }
        return strReturn.toString();
    }

    private static int getPianYi(int baseYearVar, int cellYear) {
        return cellYear - baseYearVar;
    }

    private static String getPianYiString(int iPanYi) {
        String postFix = "";
        if (iPanYi != 0) {
            postFix = iPanYi > 0 ? "+" + iPanYi : "" + iPanYi;
        }
        return postFix;
    }

    public static String transFyVar2SpecificVal(AbstractTemplateBasePlugin plugin, IDimMember dom, Map<DimTypesEnum, Object> params, Map<String, Map<String, String>> sysDimMap) {
        String strReturn = null;
        ArrayList<String> strLst = new ArrayList<String>();
        if (TemplateSetBaseVarForEB.isAlreadyTrans(plugin.getEffectiveSheet(), "hasTransFyVar2SpecificVal")) {
            return null;
        }
        if (TemplateSetBaseVarForEB.isOnRowDim(DIMTYPE_YEAR, plugin)) {
            return null;
        }
        Map<String, String> dimVarMap = TemplateSetBaseVarForEB.getVarBaseMapFromString(plugin.getTemplateModel().getVarBase());
        if (!dimVarMap.containsKey(DIMTYPE_YEAR)) {
            return null;
        }
        Optional<String> temp = TemplateSetBaseVarForEB.transVar2SpecificFYOptional(plugin.getTemplateModel().getVarBase(), sysDimMap.get(DIMTYPE_YEAR), DIMTYPE_YEAR, dom.getNumber(), TemplateSetBaseVarForEB.getCON_YEARC_DATARANGE_FINDKEY(), (String)params.get(DimTypesEnum.YEAR));
        temp.ifPresent(v -> {
            if (!((Map)sysDimMap.get(DIMTYPE_YEAR)).containsKey(v)) {
                if (!strLst.contains(v)) {
                    strLst.add((String)v);
                }
            } else {
                dom.setNumber(v);
            }
        });
        strReturn = TemplateSetBaseVarForEB.getInvaliadDimInfo(strLst);
        return strReturn;
    }

    private static Optional<String> transVar2SpecificTypeAndVerstionOptional(String strGetVarBase, Map<String, String> sysDimMap, String cellDimKey, String cellValue, String strFindKey, String currentRuntimeFy) {
        return Optional.ofNullable(TemplateSetBaseVarForEB.transVar2SpecificTypeAndVerstion(strGetVarBase, sysDimMap, cellDimKey, cellValue, strFindKey, currentRuntimeFy));
    }

    private static String transVar2SpecificTypeAndVerstion(String strGetVarBase, Map<String, String> sysDimMap, String cellDimKey, String cellValue, String strFindKey, String currentRuntimeFy) {
        String replaceFY = cellValue;
        Map<String, String> dimVarMap = TemplateSetBaseVarForEB.getVarBaseMapFromString(strGetVarBase);
        String baseVerstionandType = TemplateSetBaseVarForEB.getVarBaseValueFromString(cellDimKey, strGetVarBase);
        if (dimVarMap.containsKey(cellDimKey) && baseVerstionandType != null && baseVerstionandType.length() > 0) {
            String[] strOldValueArray;
            String[] stringArray = strOldValueArray = cellValue.contains("!") ? TemplateSetBaseVarForEB.getCellOldValue(cellValue, strFindKey) : TemplateSetBaseVarForEB.assemCellOldValue(cellValue);
            if (strOldValueArray.length > 0 && (strOldValueArray[1].equalsIgnoreCase(baseVerstionandType) || strOldValueArray[1].equalsIgnoreCase(sysDimMap.get(baseVerstionandType)))) {
                if (currentRuntimeFy.contains("@")) {
                    replaceFY = cellValue.replace(strOldValueArray[2], currentRuntimeFy);
                } else {
                    if (cellValue.equals(currentRuntimeFy)) {
                        return replaceFY;
                    }
                    if (sysDimMap.containsKey(strOldValueArray[0])) {
                        String strReplaceNewValue = strOldValueArray[2].replace(strOldValueArray[1], currentRuntimeFy);
                        strReplaceNewValue = strReplaceNewValue.replace(strOldValueArray[0], sysDimMap.get(currentRuntimeFy));
                        replaceFY = cellValue.replace(strOldValueArray[2], strReplaceNewValue);
                    } else {
                        String strReplaceNewValue = strOldValueArray[2].replace(strOldValueArray[0], sysDimMap.get(currentRuntimeFy));
                        replaceFY = cellValue.replace(strOldValueArray[2], strReplaceNewValue);
                    }
                }
            }
        }
        return replaceFY;
    }

    private static Optional<String> transVar2SpecificFYOptional(String strGetVarBase, Map<String, String> sysDimMap, String cellDimKey, String cellValue, String strFindKey, String currentRuntimeFy) {
        return Optional.ofNullable(TemplateSetBaseVarForEB.transVar2SpecificFY(strGetVarBase, sysDimMap, cellDimKey, cellValue, strFindKey, currentRuntimeFy));
    }

    private static String transVar2SpecificFY(String strGetVarBase, Map<String, String> sysDimMap, String cellDimKey, String cellValue, String strFindKey, String currentRuntimeFy) {
        int baseYearVar;
        String replaceFY = cellValue;
        Map<String, String> dimVarMap = TemplateSetBaseVarForEB.getVarBaseMapFromString(strGetVarBase);
        if (dimVarMap.containsKey(cellDimKey) && (baseYearVar = TemplateSetBaseVarForEB.getVarBaseYear(strGetVarBase)) > 0) {
            String[] strOldValueArray = TemplateSetBaseVarForEB.getCellOldValue(cellValue, strFindKey);
            replaceFY = TemplateSetBaseVarForEB.getNewShowValueForYear(strOldValueArray, baseYearVar, currentRuntimeFy, cellValue);
        }
        return replaceFY;
    }

    private static String getNewShowValueForYear(String[] strOldValueArray, int baseYearVar, String currentRuntimeFy, String cellValue) {
        String replaceFY = cellValue;
        int iCellYear = 0;
        int iPanYi = 0;
        int iNewValue = 0;
        if (strOldValueArray.length > 0) {
            iCellYear = Integer.parseInt(TemplateSetBaseVarForEB.doYearValue(strOldValueArray[0]).length() > 0 ? TemplateSetBaseVarForEB.doYearValue(strOldValueArray[0]) : "0");
            if (iCellYear == 0) {
                iCellYear = Integer.parseInt(TemplateSetBaseVarForEB.doYearValueForFY(strOldValueArray[0]).length() > 0 ? TemplateSetBaseVarForEB.doYearValueForFY(strOldValueArray[0]) : "0");
            }
            if (iCellYear == 0) {
                return replaceFY;
            }
            iPanYi = TemplateSetBaseVarForEB.getPianYi(baseYearVar, iCellYear);
            String postFix = TemplateSetBaseVarForEB.getPianYiString(iPanYi);
            if (currentRuntimeFy.contains("@")) {
                String strReplaceNewValue = strOldValueArray[2].replace(strOldValueArray[0], currentRuntimeFy + postFix);
                strReplaceNewValue = strReplaceNewValue.replace(strOldValueArray[1], currentRuntimeFy + postFix);
                replaceFY = cellValue.replace(strOldValueArray[2], strReplaceNewValue);
            } else {
                iNewValue = Integer.parseInt(currentRuntimeFy.substring(CON_YEAR_FY.length())) + iPanYi;
                String strReplaceNewValue = strOldValueArray[2].replace(String.valueOf(iCellYear), String.valueOf(iNewValue));
                replaceFY = cellValue.replace(strOldValueArray[2], strReplaceNewValue);
            }
        }
        return replaceFY;
    }

    private static HashMap<String, String> getSingleDimMap(String sFormID, long modelID) {
        HashMap<String, String> fymap = new HashMap<String, String>();
        QFilter qFilter = new QFilter("model", "=", (Object)modelID);
        try (DataSet result = QueryServiceHelper.queryDataSet((String)sFormID, (String)sFormID, (String)"id,number,name ", (QFilter[])new QFilter[]{qFilter}, null);){
            for (Row memberRow : result) {
                fymap.put(memberRow.getString("number"), memberRow.getString("name"));
            }
        }
        return fymap;
    }

    public static Map<String, Map<String, String>> getVarBaseDimMap(long modelID) {
        HashMap<String, Map<String, String>> dimMap = new HashMap<String, Map<String, String>>();
        HashMap<String, String> fymap = TemplateSetBaseVarForEB.getSingleDimMap("epm_yearmembertree", modelID);
        HashMap<String, String> typemap = TemplateSetBaseVarForEB.getSingleDimMap("eb_datetypemembertree", modelID);
        HashMap<String, String> versionmap = TemplateSetBaseVarForEB.getSingleDimMap("epm_versionmembertree", modelID);
        dimMap.put(DIMTYPE_YEAR, fymap);
        dimMap.put(DIMTYPE_TYPE, typemap);
        dimMap.put(DIMTYPE_VERSION, versionmap);
        return dimMap;
    }

    private static boolean isBaseEqualCurrentRuntime(int baseYearVar, int currentRuntimeValue) {
        return baseYearVar == currentRuntimeValue;
    }

    public static String transHeadVar2Value(String spreadJson, AbstractTemplateBasePlugin plugin, Map<DimTypesEnum, Object> params) {
        String ssjson = null;
        String uncompressJson = null;
        if (TemplateSetBaseVarForEB.isBudgetApp(plugin).booleanValue()) {
            boolean hasTransHeadPeriodOrFy2SpecificVal = TemplateSetBaseVarForEB.isAlreadyTrans(plugin.getEffectiveSheet(), "hasTransHeadPeriodOrFy2SpecificVal");
            if (hasTransHeadPeriodOrFy2SpecificVal) {
                return ssjson;
            }
            String strVerJson = plugin.getTemplateModel().getVarJson();
            if (strVerJson == null || strVerJson.length() == 0) {
                return ssjson;
            }
            int baseYearVar = TemplateSetBaseVarForEB.getVarBaseYear(plugin.getTemplateModel().getVarBase());
            String currentRuntimeValue = (String)params.get(DimTypesEnum.YEAR);
            if (currentRuntimeValue == null || TemplateSetBaseVarForEB.isBaseEqualCurrentRuntime(baseYearVar, Integer.parseInt(currentRuntimeValue.substring(CON_YEAR_FY.length())))) {
                return null;
            }
            if (baseYearVar > 0) {
                String json = spreadJson.substring(6);
                uncompressJson = new String(GZIPUtils.uncompress((byte[])Base64.getDecoder().decode(json)));
                Map mapPos = (Map)ObjectSerialUtil.deSerializedBytes((String)strVerJson);
                if (mapPos == null) {
                    return ssjson;
                }
                for (Map.Entry<String, String[]> entry : mapPos.entrySet()) {
                    String[] sDisplayValue = TemplateSetBaseVarForEB.getHeadVar(entry, baseYearVar, currentRuntimeValue, TemplateSetBaseVarForEB.getCON_YEARC_HEAD_FINDKEY(), false);
                    if (sDisplayValue.length <= 1) continue;
                    String strNewValue = TemplateSetBaseVarForEB.doYearValue(sDisplayValue[1]) + CON_YEARVARPREFIX + TemplateSetBaseVarForEB.getCON_YEARC_HEAD_FINDKEY();
                    uncompressJson = uncompressJson.replace(sDisplayValue[0], strNewValue);
                }
                uncompressJson = uncompressJson.replace(CON_YEARVARPREFIX, "");
                byte[] textByte = GZIPUtils.compress((String)uncompressJson);
                ssjson = "base64" + Base64.getEncoder().encodeToString(textByte);
                plugin.getEffectiveSheet().putUserObject("hasTransHeadPeriodOrFy2SpecificVal", (Object)true);
            }
        }
        return ssjson;
    }

    public static String[] getHeadVar(Map.Entry<String, String[]> map, int baseYearVar, String currentRuntimeValue, String sFIX, boolean toVar) {
        if (baseYearVar > 0) {
            String[] cell = map.getValue();
            String cellValue = cell[2];
            String[] cellValueArrage = TemplateSetBaseVarForEB.assemCellOldValue(cellValue);
            String sDisplayValue = TemplateSetBaseVarForEB.getNewShowValueForYear(cellValueArrage, baseYearVar, currentRuntimeValue, cellValue);
            return new String[]{cellValue, sDisplayValue};
        }
        return new String[0];
    }

    private static String[] assemCellOldValue(String cellValue) {
        return new String[]{cellValue, cellValue, cellValue};
    }

    private static Map<String, String> getVarBaseMapFromString(Object strVarString) {
        String str;
        HashMap<String, String> map = new HashMap<String, String>();
        if (strVarString != null && (str = strVarString.toString().trim()).length() > 0) {
            String[] values = str.split(CON_CELLVALUE_SPLITKEY);
            for (int i = 0; i < values.length; ++i) {
                String value = values[i].trim();
                if (value.indexOf(58) <= 0 || value.indexOf(58) >= value.length() || value.substring(value.indexOf(58) + 1) == null || value.substring(value.indexOf(58) + 1).length() <= 0) continue;
                map.put(value.substring(0, value.indexOf(":")), value.substring(value.indexOf(58) + 1));
            }
        }
        return map;
    }

    public static String getVarBaseValueFromString(String saveMapkey, Object strVarString) {
        if (strVarString != null && strVarString.toString().length() > 0) {
            Map<String, String> map = TemplateSetBaseVarForEB.getVarBaseMapFromString(strVarString);
            return map.get(saveMapkey);
        }
        return "";
    }

    public static int getVarBaseYear(Object strVarString) {
        int strReturn = 0;
        String StrBaseYear = TemplateSetBaseVarForEB.getVarBaseValueFromString(DIMTYPE_YEAR, strVarString);
        if (StrBaseYear != null && StrBaseYear.length() > 0) {
            return Integer.parseInt(StrBaseYear);
        }
        return strReturn;
    }

    private static void doTypeVerstion2SpecificVal(AbstractTemplateBasePlugin plugin, Domain dom, Map<DimTypesEnum, Object> params, Map<String, Map<String, String>> sysDimMap, HashMap<String, String> taskmap, boolean hasTypeDim, boolean hasVerstionDim) {
        boolean typeIsRowDim = TemplateSetBaseVarForEB.isOnRowDim(DIMTYPE_TYPE, plugin);
        boolean verIsRowDim = TemplateSetBaseVarForEB.isOnRowDim(DIMTYPE_TYPE, plugin);
        dom.getAllMembers().forEach(m -> {
            Optional<String> temp;
            String currentRunValue;
            if (hasTypeDim && !typeIsRowDim) {
                currentRunValue = (String)params.get(DimTypesEnum.DATATYPE.getNumber()) == null ? (String)taskmap.get(DimTypesEnum.DATATYPE.getNumber()) : (String)params.get(DimTypesEnum.DATATYPE.getNumber());
                temp = TemplateSetBaseVarForEB.transVar2SpecificTypeAndVerstionOptional(plugin.getTemplateModel().getVarBase(), (Map)sysDimMap.get(DIMTYPE_TYPE), DIMTYPE_TYPE, m.getNumber(), TemplateSetBaseVarForEB.getCON_TYPE_FINDKEY(), currentRunValue);
                temp.ifPresent(v -> m.setNumber(v));
            }
            if (hasVerstionDim && !verIsRowDim) {
                currentRunValue = (String)params.get(DimTypesEnum.VERSION.getNumber()) == null ? (String)taskmap.get(DimTypesEnum.VERSION.getNumber()) : (String)params.get(DimTypesEnum.VERSION.getNumber());
                temp = TemplateSetBaseVarForEB.transVar2SpecificTypeAndVerstionOptional(plugin.getTemplateModel().getVarBase(), (Map)sysDimMap.get(DIMTYPE_VERSION), DIMTYPE_VERSION, m.getNumber(), TemplateSetBaseVarForEB.getCON_VERSTION_FINDKEY(), currentRunValue);
                temp.ifPresent(v -> m.setNumber(v));
            }
        });
    }

    public static void transTypeVerstion2SpecificValue(AbstractTemplateBasePlugin plugin, Map<DimTypesEnum, Object> params, Map<String, Map<String, String>> sysDimMap, String taskID, HashMap<String, String> taskDim) {
        if (TemplateSetBaseVarForEB.isSetBaseYearVar(plugin).booleanValue() && taskID != null) {
            boolean hasVerstionDim;
            Map<String, String> map = TemplateSetBaseVarForEB.getVarBaseMapFromString(plugin.getTemplateModel().getVarBase());
            if (!map.containsKey(DIMTYPE_TYPE) && !map.containsKey(DIMTYPE_VERSION)) {
                return;
            }
            boolean hasTransTypeVar2SpecificVal = TemplateSetBaseVarForEB.isAlreadyTrans(plugin.getEffectiveSheet(), "hasTransTypeVar2SpecificVal");
            if (hasTransTypeVar2SpecificVal) {
                return;
            }
            boolean hasTypeDim = plugin.getTemplateModel().getViewPointDimensionEntries().stream().anyMatch(v -> v.getDimension().getNumber().equals(DIMTYPE_TYPE)) || plugin.getTemplateModel().getPageDimensionEntries().stream().anyMatch(v -> v.getDimension().getNumber().equals(DIMTYPE_TYPE));
            boolean bl = hasVerstionDim = plugin.getTemplateModel().getViewPointDimensionEntries().stream().anyMatch(v -> v.getDimension().getNumber().equals(DIMTYPE_VERSION)) || plugin.getTemplateModel().getPageDimensionEntries().stream().anyMatch(v -> v.getDimension().getNumber().equals(DIMTYPE_VERSION));
            if (!hasTypeDim || !hasVerstionDim) {
                HashMap<String, String> taskmap = taskDim == null ? TemplateSetBaseVarForEB.getTaskDimInfo(taskID) : taskDim;
                plugin.getSpreadModel().getAreaManager().forEach(e -> {
                    TemplateSetBaseVarForEB.doTypeVerstion2SpecificVal(plugin, (Domain)((Tuple)e.getValue()).k, params, sysDimMap, taskmap, !hasTypeDim, !hasVerstionDim);
                    TemplateSetBaseVarForEB.doTypeVerstion2SpecificVal(plugin, (Domain)((Tuple)e.getValue()).v, params, sysDimMap, taskmap, !hasTypeDim, !hasVerstionDim);
                });
            }
            plugin.getEffectiveSheet().putUserObject("hasTransTypeVar2SpecificVal", (Object)true);
        }
    }

    public static HashMap<String, String> getTaskDimInfo(String taskID) {
        if (taskID == null || taskID.length() == 0) {
            return null;
        }
        HashMap<String, String> taskmap = new HashMap<String, String>();
        QFilter qFilter = new QFilter("id", "=", (Object)IDUtils.toLong((Object)taskID));
        DynamicObject dyTaskProcess = QueryServiceHelper.queryOne((String)"eb_taskprocess", (String)"id,task.tasklist ", (QFilter[])new QFilter[]{qFilter});
        if (dyTaskProcess == null) {
            return taskmap;
        }
        String strTaskListID = dyTaskProcess.getString("task.tasklist");
        qFilter = new QFilter("id", "=", (Object)IDUtils.toLong((Object)strTaskListID));
        dyTaskProcess = QueryServiceHelper.queryOne((String)"eb_tasklist", (String)"id,year.number FYNumber,version.number VerNumber,datatype.number DTNumber ", (QFilter[])new QFilter[]{qFilter});
        try (DataSet result = QueryServiceHelper.queryDataSet((String)"eb_tasklist", (String)"eb_tasklist", (String)"id,year.number FYNumber,version.number VerNumber,datatype.number DTNumber ", (QFilter[])new QFilter[]{qFilter}, null);){
            for (Row memberRow : result) {
                taskmap.put(DIMTYPE_YEAR, memberRow.getString("FYNumber"));
                taskmap.put(DIMTYPE_TYPE, memberRow.getString("DTNumber"));
                taskmap.put(DIMTYPE_VERSION, memberRow.getString("VerNumber"));
            }
        }
        return taskmap;
    }

    private static boolean isOnRowDim(String dimKey, AbstractTemplateBasePlugin plugin) {
        if (plugin == null || plugin.getTemplateModel() == null) {
            return false;
        }
        String strTemplateType = String.valueOf(plugin.getTemplateModel().getTemplateType());
        if (strTemplateType == null || strTemplateType.equalsIgnoreCase("null") || !strTemplateType.equals("1")) {
            return false;
        }
        return plugin.getTemplateModel().getAreaRangeEntries().stream().anyMatch(p -> p.getRowDimEntries().stream().anyMatch(r -> r.getDimension().getNumber().equals(dimKey)));
    }
}

