/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.budget.formplugin.template.model;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.ebcommon.common.util.ObjectSerialUtil;

public interface IPageCacheProxy {
    public IPageCache getPageCache();

    public static class PageCacheMonitor {
        private Map<String, Integer> monitor = new HashMap<String, Integer>();

        protected void addMonitor(String cachKey, String cacheVal, String methodName) {
            this.monitor.compute(String.format("[%s]-%s", methodName, cachKey), (k, oldVal) -> oldVal == null ? 1 : oldVal + 1);
        }
    }

    public static class PageCacheProxy
    implements InvocationHandler {
        private final IPageCache pageCache;
        private PageCacheMonitor monitor;
        private Map<String, String> bigDataCache;
        private Map<String, String> smallDataCache;
        private Set<String> bigDataCacheKeys;
        private static final String BCM_BIGDATA_KEY = "eb_bigData_Key_";
        private static final String BCM_SMALLDATA_KEY = "eb_smallData_Key_";
        private static final int threshold = 10000;

        public PageCacheProxy(IPageCache pageCache) {
            this.pageCache = pageCache;
            this.monitor = new PageCacheMonitor();
            this.bigDataCache = new HashMap<String, String>();
            String dataKeys = this.pageCache.get(BCM_BIGDATA_KEY);
            this.bigDataCacheKeys = StringUtils.isEmpty((String)dataKeys) ? new HashSet() : (Set)ObjectSerialUtil.parseObject((String)dataKeys, Set.class);
            String smallDataKeys = this.pageCache.get(BCM_SMALLDATA_KEY);
            this.smallDataCache = StringUtils.isEmpty((String)smallDataKeys) ? new HashMap() : (Map)ObjectSerialUtil.parseObject((String)smallDataKeys, Map.class);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (args == null || args.length == 1 && !(args[0] instanceof String)) {
                return method.invoke((Object)this.pageCache, args);
            }
            Object result = null;
            String val = null;
            String key = (String)args[0];
            if ("put".equals(method.getName())) {
                if (FormShowParameter.class.getSimpleName().equals(key) && args[1] instanceof String) {
                    this.pageCache.put(key, (String)args[1]);
                }
                if (args[1] instanceof String) {
                    val = (String)args[1];
                    if (val.length() >= 10000) {
                        this.bigDataCache.put(key, val);
                        this.bigDataCacheKeys.add(key);
                        if (this.smallDataCache.containsKey(key)) {
                            this.smallDataCache.remove(key);
                        }
                    } else if (!this.smallDataCache.containsKey(key) && this.pageCache.get(key) != null) {
                        this.pageCache.put(key, val);
                        this.monitor(args, method.getName());
                    } else {
                        this.smallDataCache.put(key, val);
                        if (this.bigDataCacheKeys.remove(key)) {
                            this.bigDataCache.remove(key);
                        }
                    }
                } else if (args[1] == null && this.smallDataCache.containsKey(key)) {
                    this.smallDataCache.put(key, null);
                } else {
                    this.pageCache.put(key, val);
                }
            } else if ("get".equals(method.getName())) {
                String tempValue;
                String value = this.bigDataCache.get(key);
                result = value != null ? value : (this.bigDataCacheKeys.contains(key) ? this.pageCache.getBigObject((String)args[0]) : ((tempValue = this.smallDataCache.get(key)) != null ? tempValue : this.pageCache.get(key)));
            } else if ("remove".equals(method.getName())) {
                if (this.bigDataCache.containsKey(key)) {
                    this.bigDataCache.remove(key);
                    this.bigDataCacheKeys.remove(key);
                    this.pageCache.removeBigObject((String)args[0]);
                } else if (!this.smallDataCache.containsKey(key)) {
                    this.pageCache.remove(key);
                    this.monitor(args, method.getName());
                } else {
                    this.smallDataCache.put(key, null);
                }
            } else {
                result = method.invoke((Object)this.pageCache, args);
            }
            return result;
        }

        private void monitor(Object[] args, String method) {
            this.monitor.addMonitor((String)args[0], args.length > 1 ? (String)args[1] : "", method);
        }

        public IPageCache getProxy() {
            return (IPageCache)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), this.pageCache.getClass().getInterfaces(), (InvocationHandler)this);
        }
    }
}

