/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.budget.formplugin.template.model;

import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.spread.LookUpDataArgs;
import kd.bos.form.spread.Spread;
import kd.bos.form.spread.SpreadActionAdapter;
import kd.bos.form.spread.SpreadPostDataInfo;
import kd.bos.form.spread.event.SpreadEvent;
import kd.bos.util.StringUtils;
import kd.epm.eb.budget.formplugin.report.AbstractMultiReportPlugin;
import kd.epm.eb.budget.formplugin.template.model.AskExcuteInfo;
import kd.epm.eb.budget.formplugin.template.model.ISpreadModelSupplier;
import kd.epm.eb.common.ebcommon.common.util.ObjectSerialUtil;
import kd.epm.eb.common.ebcommon.common.util.ThrowableHelper;
import kd.epm.eb.ebSpread.domain.Cell;
import kd.epm.eb.ebSpread.domain.view.JsonSerializerUtil;
import kd.epm.eb.ebSpread.domain.view.Sheet;
import kd.epm.eb.ebSpread.domain.view.SpreadManager;
import kd.epm.eb.ebSpread.domain.view.SpreadSelector;
import kd.epm.eb.ebSpread.domain.view.event.EventConstant;
import kd.epm.eb.ebSpread.domain.view.event.IAfterEventHandle;
import kd.epm.eb.ebSpread.domain.view.event.ISpreadListener;
import kd.epm.eb.ebSpread.domain.view.event.NotifyEvent;
import kd.epm.eb.ebSpread.domain.view.js.SpreadProperties;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.MethodUtils;

public class SpreadDataModel
extends SpreadActionAdapter {
    private static String AMOUNT_PATTERN = "^\\(?((-?([0-9]+|[0-9]{1,3}(,[0-9]{3})*))(\\.[0-9]{1,})?)\\)?$";

    public SpreadDataModel(AbstractFormPlugin plugin) {
        super(plugin);
    }

    public void deleteRows(SpreadEvent event) {
    }

    public void deleteColumns(SpreadEvent event) {
    }

    public void addRows(SpreadEvent event) {
    }

    public void addColumns(SpreadEvent event) {
    }

    public void askExecute(SpreadEvent event) {
        Spread spread;
        SpreadPostDataInfo data;
        super.askExecute(event);
        SpreadManager sm = this.getSpreadManager(event);
        if (sm != null && (data = (spread = (Spread)event.getSource()).getPostDataInfo()).getInvokeParams() != null && data.getInvokeParams().size() > 0) {
            this.adjustExcuteInfo(data.getInvokeParams());
            AskExcuteInfo askExcuteInfo = new AskExcuteInfo(data);
            NotifyEvent notifyEvent = new NotifyEvent((Object)askExcuteInfo, askExcuteInfo.getActionname(), null);
            this.doBeforeNotify(notifyEvent);
            if (!notifyEvent.isCancel()) {
                SpreadDataModel.adjustSheet(askExcuteInfo, sm);
                this.doAfterNotify(askExcuteInfo, askExcuteInfo.getActionname());
                this.cacheSpreadModel(sm);
            }
        }
    }

    private void adjustExcuteInfo(LinkedHashMap<String, Object> param) {
        String method = (String)param.get("method");
        if (SpreadProperties.InsertMethod.INSERTCOL.k().equals(method) || SpreadProperties.InsertMethod.INSERTROW.k().equals(method)) {
            if (param.get("data") instanceof List) {
                List val = (List)param.get("data");
                if (val.size() > 1) {
                    boolean isContinute = true;
                    for (int i = 1; i < val.size(); ++i) {
                        if ((Integer)val.get(i) == (Integer)val.get(i - 1) + 1) continue;
                        isContinute = false;
                        break;
                    }
                    if (isContinute) {
                        ArrayList<Integer> newval = new ArrayList<Integer>(val.size());
                        int insert = (Integer)val.get(0);
                        for (int i = 0; i < val.size(); ++i) {
                            newval.add(insert);
                        }
                        param.put("data", newval);
                    }
                }
            } else if (param.get("data") instanceof Map) {
                Map data = (Map)param.get("data");
                int selectIndex = (Integer)data.get("selectIndex");
                int oprtCount = (Integer)data.get("count");
                ArrayList<Integer> newval = new ArrayList<Integer>(oprtCount);
                for (int i = 0; i < oprtCount; ++i) {
                    newval.add(selectIndex);
                }
                param.put("data", newval);
            }
        }
    }

    public void selectedSpread(SpreadEvent event) {
        SpreadPostDataInfo data = event.getPostData();
        if (data.getSelRows() != null && data.getSelRows().size() > 0 && data.getSelCols() != null && data.getSelCols().size() > 0) {
            this.sortSelectData(data);
            SpreadSelector selector = new SpreadSelector(((Integer)data.getSelRows().get(0)).intValue(), ((Integer)data.getSelCols().get(0)).intValue(), ((Integer)data.getSelRows().get(data.getSelRows().size() - 1)).intValue(), ((Integer)data.getSelCols().get(data.getSelCols().size() - 1)).intValue());
            this.cacheIt(event, "spread_selector", ObjectSerialUtil.toByteSerialized((Object)selector));
            NotifyEvent evtdelcol = new NotifyEvent((Object)data, EventConstant.ActionName.CELL_SELECT, null);
            this.doBeforeNotify(evtdelcol);
            if (!evtdelcol.isCancel()) {
                this.doAfterNotify(data, EventConstant.ActionName.CELL_SELECT);
            }
        }
    }

    private void sortSelectData(SpreadPostDataInfo data) {
        data.getSelRows().sort(this.sortSmallTobig());
        data.getSelCols().sort(this.sortSmallTobig());
        int rowindex = data.getSelRows().indexOf(-1);
        int colindex = data.getSelCols().indexOf(-1);
        if (rowindex != -1) {
            data.getSelRows().remove(rowindex);
        }
        if (colindex != -1) {
            data.getSelCols().remove(colindex);
        }
    }

    public void updateCellValue(SpreadEvent event) {
        SpreadManager sm = null;
        try {
            sm = this.getSpreadManager(event);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (sm != null) {
            Spread spread = (Spread)event.getSource();
            SpreadPostDataInfo data = spread.getPostDataInfo();
            if (data == null) {
                data = event.getPostData();
            }
            if (data.getValues() != null) {
                data.getValues().forEach(v -> {
                    if (v.get("v") instanceof String) {
                        v.put("v", v.get("v").toString().trim());
                    }
                });
                Sheet sheet = sm.getBook().getSheet(0);
                NotifyEvent mulevt = new NotifyEvent((Object)sm, EventConstant.ActionName.UPDATE_MULVALUE, (Object)data);
                if (data.getValues().size() > 0) {
                    this.doBeforeNotify(mulevt);
                }
                if (!mulevt.isCancel()) {
                    for (LinkedHashMap e : data.getValues()) {
                        Object val = e.get("v");
                        if (!(val instanceof Number) && !(val instanceof String) && !(val instanceof Character) && val != null) continue;
                        Cell cell = sheet.getCell(((Integer)e.get("r")).intValue(), ((Integer)e.get("c")).intValue());
                        if (val instanceof String && val != null && this.isNotSupportExcelFormat(val.toString()) && !StringUtils.isNumeric((String)val.toString())) {
                            String vdata = this.removeAmountSign(val.toString().trim()).trim();
                            boolean isNegative = vdata.startsWith("(");
                            String validateData = vdata.replaceAll("\\(", "").replaceAll("\\)", "").replaceAll(",", "");
                            if (!validateData.startsWith("-") && isNegative) {
                                validateData = "-" + validateData;
                            }
                            val = new BigDecimal(validateData);
                        }
                        NotifyEvent evt = new NotifyEvent((Object)cell, EventConstant.ActionName.UPDATE_VALUE, val);
                        this.doBeforeNotify(evt);
                        if (evt.isCancel() || !cell.setValue(val)) continue;
                        this.doAfterNotify(cell, EventConstant.ActionName.UPDATE_VALUE);
                    }
                    if (this.plugin instanceof AbstractMultiReportPlugin) {
                        ((AbstractMultiReportPlugin)this.plugin).clearTipCount();
                    }
                    this.doAfterNotify(data, EventConstant.ActionName.UPDATE_MULVALUE);
                }
                this.doAfterEventHandle(EventConstant.ActionName.UPDATE_VALUE);
                this.cacheSpreadModel(sm);
            }
        }
    }

    protected boolean isNotSupportExcelFormat(String data) {
        String vdata = this.removeAmountSign(data);
        return StringUtils.isNotEmpty((String)vdata) && Pattern.matches(AMOUNT_PATTERN, vdata.trim());
    }

    private String removeAmountSign(String data) {
        return data.replaceAll("[\\\\$,US\\\\$,\u00a3,\u00a5]", "");
    }

    private void doBeforeNotify(NotifyEvent evt) {
        if (ISpreadListener.class.isAssignableFrom(this.plugin.getClass())) {
            ((ISpreadListener)ISpreadListener.class.cast(this.plugin)).doBeforeNotify(evt);
        }
    }

    private void doAfterNotify(Object source, EventConstant.ActionName actionName) {
        if (ISpreadListener.class.isAssignableFrom(this.plugin.getClass())) {
            ((ISpreadListener)ISpreadListener.class.cast(this.plugin)).doAfterNotify(new NotifyEvent(source, actionName));
        }
    }

    private void doAfterEventHandle(EventConstant.ActionName actionName) {
        if (IAfterEventHandle.class.isAssignableFrom(this.plugin.getClass())) {
            ((IAfterEventHandle)IAfterEventHandle.class.cast(this.plugin)).afterSpreadEventHandle(actionName);
        }
    }

    public void updateFormula(SpreadEvent event) {
        Spread spread;
        SpreadPostDataInfo data;
        SpreadManager sm = this.getSpreadManager(event);
        if (sm != null && (data = (spread = (Spread)event.getSource()).getPostDataInfo()).getInvokeParams() != null && data.getInvokeParams().get("formulas") != null) {
            ((List)data.getInvokeParams().get("formulas")).forEach(e -> {
                LinkedHashMap item = (LinkedHashMap)e;
                Cell cell = sm.getBook().getSheet(0).getCell(((Integer)item.get("r")).intValue(), ((Integer)item.get("c")).intValue());
                String val = (String)item.get("f");
                NotifyEvent evt = new NotifyEvent((Object)cell, EventConstant.ActionName.UPDATE_FORMULA, (Object)val);
                this.doBeforeNotify(evt);
                if (!evt.isCancel()) {
                    cell.setFormula(val);
                    this.doAfterNotify(cell, EventConstant.ActionName.UPDATE_FORMULA);
                }
            });
            this.cacheSpreadModel(sm);
        }
    }

    public void showCellDimInfo(SpreadEvent event) {
    }

    public void insertRangeRow(SpreadEvent event) {
        SpreadManager sm = this.getSpreadManager(event);
        if (sm != null) {
            Spread spread = (Spread)event.getSource();
            SpreadPostDataInfo data = spread.getPostDataInfo();
            SpreadDataModel.insertRangeRows(sm.getBook().getSheet(0), data.getStartCol(), data.getEndCol(), data.getSelcIndex(), data.getOprtCount());
            this.cacheSpreadModel(sm);
        }
    }

    public void insertRangeCols(SpreadEvent event) {
        SpreadManager sm = this.getSpreadManager(event);
        if (sm != null) {
            Spread spread = (Spread)event.getSource();
            SpreadPostDataInfo data = spread.getPostDataInfo();
            SpreadDataModel.insertRangeCols(sm.getBook().getSheet(0), data.getStartRow(), data.getEndRow(), data.getSelcIndex(), data.getOprtCount());
            this.cacheSpreadModel(sm);
        }
    }

    public void delRangeRow(SpreadEvent event) {
        SpreadManager sm = this.getSpreadManager(event);
        if (sm != null) {
            Spread spread = (Spread)event.getSource();
            SpreadPostDataInfo data = spread.getPostDataInfo();
            SpreadDataModel.delRangeRows(sm.getBook().getSheet(0), data.getStartCol(), data.getEndCol(), data.getSelcIndex(), data.getOprtCount());
            this.cacheSpreadModel(sm);
        }
    }

    public void delRangeCols(SpreadEvent event) {
        SpreadManager sm = this.getSpreadManager(event);
        if (sm != null) {
            Spread spread = (Spread)event.getSource();
            SpreadPostDataInfo data = spread.getPostDataInfo();
            SpreadDataModel.delRangeCols(sm.getBook().getSheet(0), data.getStartRow(), data.getEndRow(), data.getSelcIndex(), data.getOprtCount());
            this.cacheSpreadModel(sm);
        }
    }

    public static void insertRangeRows(Sheet sheet, int fromColIdx, int toColIdx, int selcRowindex, int rowCount) {
        sheet.insertRangeRows(fromColIdx, toColIdx, selcRowindex, rowCount);
    }

    public static void insertRangeCols(Sheet sheet, int fromRowIdx, int toRowIdx, int selcColindex, int colCount) {
        sheet.insertRangeCols(fromRowIdx, toRowIdx, selcColindex, colCount);
    }

    public static void delRangeRows(Sheet sheet, int fromColIdx, int toColIdx, int selcRowindex, int rowCount) {
        sheet.delRangeRows(fromColIdx, toColIdx, selcRowindex, rowCount);
    }

    public static void delRangeCols(Sheet sheet, int fromRowIdx, int toRowIdx, int selcColindex, int colCount) {
        sheet.delRangeCols(fromRowIdx, toRowIdx, selcColindex, colCount);
    }

    private SpreadManager getSpreadManager(SpreadEvent event) {
        SpreadManager sm = null;
        if (ISpreadModelSupplier.class.isAssignableFrom(this.plugin.getClass())) {
            sm = ((ISpreadModelSupplier)ISpreadModelSupplier.class.cast(this.plugin)).getSpreadModel();
        }
        if (sm != null) {
            return sm;
        }
        IPageCache pageCache = this.plugin.getPageCache();
        String serial = pageCache.get("KEY_SPREAD_MODEL");
        if (serial != null) {
            sm = JsonSerializerUtil.toSpreadManager((String)serial);
        }
        if (sm == null) {
            throw new RuntimeException(ResManager.loadKDString((String)"\u627e\u4e0d\u5230spread\u6a21\u578b\u5e8f\u5217", (String)"SpreadDataModel_0", (String)"epm-eb-budget", (Object[])new Object[0]));
        }
        return sm;
    }

    private void cacheIt(SpreadEvent event, String cacheKey, String serial) {
        IPageCache pageCache = this.plugin.getPageCache();
        pageCache.put(cacheKey, serial);
    }

    private void cacheSpreadModel(SpreadManager sm) {
        if (!ISpreadModelSupplier.class.isAssignableFrom(this.plugin.getClass())) {
            throw new KDBizException("not implement interface's method[cacheSpreadModel] ");
        }
        ((ISpreadModelSupplier)ISpreadModelSupplier.class.cast(this.plugin)).cacheSpreadModel(sm);
    }

    private Comparator<Integer> sortSmallTobig() {
        return new Comparator<Integer>(){

            @Override
            public int compare(Integer x, Integer y) {
                return Integer.compare(x, y);
            }
        };
    }

    public static void adjustSheet(AskExcuteInfo excuteinfo, SpreadManager sm) {
        Sheet sheet = sm.getBook().getSheet(0);
        switch (excuteinfo.getMethod().getMethod()) {
            case "deleteCol": {
                excuteinfo.getOperationdata().forEach(e -> sheet.delColumn(e.intValue()));
                excuteinfo.getBatchOperationData().forEach(e -> {
                    for (int i = 0; i < e.getSize(); ++i) {
                        sheet.delColumn(e.getOprtPosition());
                    }
                });
                break;
            }
            case "insertCol": {
                excuteinfo.getOperationdata().forEach(e -> sheet.insertColumn(e.intValue()));
                excuteinfo.getBatchOperationData().forEach(e -> {
                    for (int i = 0; i < e.getSize(); ++i) {
                        sheet.insertColumn(e.getOprtPosition());
                    }
                });
                break;
            }
            case "deleteRow": {
                excuteinfo.getOperationdata().forEach(e -> sheet.delRow(e.intValue()));
                excuteinfo.getBatchOperationData().forEach(e -> {
                    for (int i = 0; i < e.getSize(); ++i) {
                        sheet.delRow(e.getOprtPosition());
                    }
                });
                break;
            }
            case "insertRow": {
                excuteinfo.getOperationdata().forEach(e -> sheet.insertRow(e.intValue()));
                excuteinfo.getBatchOperationData().forEach(e -> {
                    for (int i = 0; i < e.getSize(); ++i) {
                        sheet.insertRow(e.getOprtPosition());
                    }
                });
                break;
            }
        }
    }

    public void getLookupData(SpreadEvent event) {
        if (event.getPostData().getInvokeParams() != null) {
            int r = (Integer)event.getPostData().getInvokeParams().get("r");
            int c = (Integer)event.getPostData().getInvokeParams().get("c");
            Map lookupDataInfo = (Map)event.getPostData().getInvokeParams().get("lookupInfo");
            LookUpDataArgs bean = new LookUpDataArgs();
            this.populate(bean, lookupDataInfo);
            bean.setR(r);
            bean.setC(c);
            this.invokePluginMethod("spreadF7LookUpData", bean);
        }
    }

    private void populate(Object populateBean, Map<String, ? extends Object> values) {
        try {
            BeanUtils.populate((Object)populateBean, values);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new KDBizException("convert exception:" + e);
        }
    }

    private void invokePluginMethod(String methodName, Object params) {
        try {
            MethodUtils.invokeMethod((Object)this.plugin, (String)methodName, (Object)params);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new KDBizException(ThrowableHelper.toString((Exception)e));
        }
    }

    public void invokePluginMethod(SpreadEvent event) {
        String methodName = (String)event.getPostData().getInvokeParams().get("invokemethod");
        Object data = event.getPostData().getInvokeParams().get("data");
        try {
            MethodUtils.invokeMethod((Object)this.plugin, (String)methodName, data);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException var5) {
            throw new KDBizException(ThrowableHelper.toString((Exception)var5));
        }
    }
}

