/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.budget.formplugin.template.multiview;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import kd.epm.eb.budget.formplugin.template.multiview.PraseModel;
import kd.epm.eb.common.ebcommon.common.json.JSONObjectUtil;
import kd.epm.eb.ebSpread.domain.Cell;
import kd.epm.eb.ebSpread.domain.view.SpreadManager;
import kd.epm.eb.ebSpread.domain.view.js.SpreadProperties;
import kd.epm.eb.ebSpread.util.DataAndJsonTranslator;
import kd.epm.eb.ebSpread.util.GZIPUtils;

public class TempFormulaUtil {
    public static String removeFormula(SpreadManager sm, String json) {
        ArrayList cells = new ArrayList();
        sm.getBook().getSheet(0).iteratorCells(cell -> {
            if (cell.hasFormula() && (TempFormulaUtil.checkFormulaExits(cell.getFormula()) || cell.getFormula().toLowerCase().contains("abs("))) {
                cells.add(cell);
                cell.setChangeVal(false);
            }
        });
        if (cells.size() > 0) {
            String sheetname = sm.getBook().getSheet(0).getSheetName();
            JSONObject object = JSONObjectUtil.parseObjectOrder((String)json);
            JSONObject dataTable = TempFormulaUtil.getDataTable(object, sheetname);
            for (Cell c : cells) {
                JSONObject cell2 = (JSONObject)((JSONObject)dataTable.get((Object)(c.getRow() + ""))).get((Object)(c.getCol() + ""));
                cell2.remove((Object)"value");
                cell2.remove((Object)"formula");
            }
            return object.toJSONString();
        }
        return json;
    }

    private static JSONObject getDataTable(JSONObject object, String sheetname) {
        return DataAndJsonTranslator.getDataTable((JSONObject)object, (String)sheetname);
    }

    public static String removeAllFormula(SpreadManager sm, String json) {
        ArrayList cells = new ArrayList();
        sm.getBook().getSheet(0).iteratorCells(cell -> {
            if (!(!cell.hasFormula() || cell.getFormula().startsWith("unit") || cell.getFormula().startsWith("date") || cell.getFormula().startsWith("currency") || cell.getFormula().isEmpty())) {
                cells.add(cell);
                cell.setChangeVal(false);
            }
        });
        if (cells.size() > 0) {
            String sheetname = sm.getBook().getSheet(0).getSheetName();
            JSONObject object = JSONObjectUtil.parseObjectOrder((String)json);
            JSONObject dataTable = TempFormulaUtil.getDataTable(object, sheetname);
            for (Cell c : cells) {
                JSONObject cell2 = (JSONObject)((JSONObject)dataTable.get((Object)(c.getRow() + ""))).get((Object)(c.getCol() + ""));
                cell2.remove((Object)"value");
                cell2.remove((Object)"formula");
            }
            return object.toJSONString();
        }
        return json;
    }

    public static String removeFormula(SpreadManager sm, JSONObject object) {
        ArrayList cells = new ArrayList();
        sm.getBook().getSheet(0).iteratorCells(cell -> {
            if (cell.hasFormula() && (TempFormulaUtil.checkFormulaExits(cell.getFormula()) || cell.getFormula().toLowerCase().contains("abs("))) {
                cells.add(cell);
                cell.setChangeVal(false);
            }
        });
        if (cells.size() > 0) {
            String sheetname = sm.getBook().getSheet(0).getSheetName();
            Object sheetsObj = object.get((Object)"sheets");
            if (sheetsObj == null) {
                return object.toJSONString();
            }
            JSONObject sheets = (JSONObject)sheetsObj;
            Object sheetObj = sheets.get((Object)sheetname);
            if (sheetObj == null) {
                return object.toJSONString();
            }
            JSONObject sheet = (JSONObject)sheetObj;
            Object dataObj = sheet.get((Object)"data");
            if (dataObj == null) {
                return object.toJSONString();
            }
            JSONObject data = (JSONObject)dataObj;
            Object dataTableObj = data.get((Object)"dataTable");
            if (dataTableObj == null) {
                return object.toJSONString();
            }
            JSONObject dataTable = (JSONObject)dataTableObj;
            for (Cell c : cells) {
                Object row = dataTable.get((Object)(c.getRow() + ""));
                if (row == null) continue;
                JSONObject cell2 = (JSONObject)((JSONObject)row).get((Object)(c.getCol() + ""));
                cell2.remove((Object)"value");
                cell2.remove((Object)"formula");
            }
            return object.toJSONString();
        }
        return object.toJSONString();
    }

    public static String removeUnUsedFormula(SpreadManager spread, SpreadManager sm, JSONObject object, List<Map<String, Object>> cellValues) {
        if (!cellValues.isEmpty()) {
            String sheetname = sm.getBook().getSheet(0).getSheetName();
            JSONObject dataTable = TempFormulaUtil.getDataTable(object, sheetname);
            for (Map<String, Object> c : cellValues) {
                JSONObject cell = (JSONObject)((JSONObject)dataTable.get((Object)(c.get(SpreadProperties.SetFormulaMethod.R.k()) + ""))).get((Object)(c.get(SpreadProperties.SetFormulaMethod.C.k()) + ""));
                cell.remove((Object)"value");
                cell.remove((Object)"formula");
                int cRow = Integer.parseInt(c.get(SpreadProperties.SetFormulaMethod.R.k()).toString() + "");
                int cCell = Integer.parseInt(c.get(SpreadProperties.SetFormulaMethod.C.k()).toString() + "");
                spread.getBook().getSheet(0).getCell(cRow, cCell).setValue(null);
                spread.getBook().getSheet(0).getCell(cRow, cCell).setFormula(null);
                sm.getBook().getSheet(0).getCell(cRow, cCell).setValue(null);
                sm.getBook().getSheet(0).getCell(cRow, cCell).setFormula(null);
            }
            return object.toJSONString();
        }
        return object.toJSONString();
    }

    public static String removeAccFormula(SpreadManager sm, String spreadJson) {
        if (spreadJson == null) {
            return null;
        }
        spreadJson = TempFormulaUtil.dealBase64Str(spreadJson);
        String ssjson = new String(GZIPUtils.uncompress((byte[])Base64.getDecoder().decode(spreadJson)));
        String sb = TempFormulaUtil.removeFormula(sm, ssjson);
        byte[] bb = Base64.getEncoder().encode(GZIPUtils.compress((String)sb));
        String bbs = new String(bb);
        return "base64" + bbs;
    }

    public static String dealBase64Str(String spreadJson) {
        return DataAndJsonTranslator.dealBase64Str((String)spreadJson);
    }

    public static String removeAccFormula(SpreadManager sm, JSONObject object) {
        if (object == null) {
            return null;
        }
        String sb = TempFormulaUtil.removeFormula(sm, object);
        byte[] bb = Base64.getEncoder().encode(GZIPUtils.compress((String)sb));
        String bbs = new String(bb);
        return "base64" + bbs;
    }

    public static boolean checkFormulaExits(String formula) {
        return new PraseModel(formula).isPass();
    }
}

