/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.budget.formplugin.template.multiview;

import com.google.common.collect.Lists;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.util.StringUtils;
import kd.epm.eb.budget.formplugin.template.AbstractTemplateBasePlugin;
import kd.epm.eb.budget.formplugin.template.ICommunicateBtwForm;
import kd.epm.eb.ebBusiness.template.model.AreaRangeEntry;
import kd.epm.eb.ebBusiness.template.model.TemplateModel;

public class TemplateDataAreaSettingPlugin
extends AbstractTemplateBasePlugin {
    private static final String PAGEID = "pageId";

    @Override
    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String area = (String)this.getFormCustomParam("area");
        if (StringUtils.isNotEmpty((String)area)) {
            this.getModel().setValue("area", (Object)area);
        }
    }

    @Override
    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "btn_confirm": {
                String area = (String)this.getModel().getValue("area");
                this.checkValidata(area);
                if (this.willBePredicate(area)) break;
                this.doHandleAreaSetting();
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String key;
        switch (key = e.getCallBackId()) {
            case "deletearea_comfirm": {
                if (e.getResult().equals((Object)MessageBoxResult.Yes)) {
                    this.doHandleAreaSetting();
                    break;
                }
                this.getView().close();
            }
        }
    }

    private void doHandleAreaSetting() {
        this.sendMsg2Parent();
        IPageCache pageCache = (IPageCache)this.getView().getParentView().getService(IPageCache.class);
        String success = pageCache.get("areasetting");
        if (success != null && "true".equals(success)) {
            this.getView().close();
        }
    }

    private boolean willBePredicate(String area) {
        TemplateModel template = this.getTemplateModel();
        List entries = template.findOverlapAreaByAreas(area);
        if (entries.isEmpty()) {
            return false;
        }
        if (entries.size() == 1) {
            this.getView().showConfirm(ResManager.loadResFormat((String)"\u5df2\u5b58\u5728\u6570\u636e\u533a\u57df\uff0c\u662f\u5426\u786e\u5b9a\u5c06\u539f\u6570\u636e\u533a\u57df%1\u4fee\u6539\u4e3a\u65b0\u6570\u636e\u533a\u57df%2\uff1f", (String)"TemplateDataAreaSettingPlugin_0", (String)"epm-eb-budget", (Object[])new Object[]{((AreaRangeEntry)entries.get(0)).getAreaRange(), area}), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("changearea_comfirm", (IFormPlugin)this));
        } else {
            this.getView().showConfirm(ResManager.loadResFormat((String)"\u662f\u5426\u6e05\u9664\u539f\u6570\u636e\u533a\u57df%1\u7684\u6240\u6709\u8bbe\u7f6e\uff0c\u65b0\u589e\u6570\u636e\u533a\u57df%2\uff1f", (String)"TemplateDataAreaSettingPlugin_1", (String)"epm-eb-budget", (Object[])new Object[]{String.join((CharSequence)",", Lists.transform((List)entries, e -> e.getAreaRange())), area}), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("changearea_comfirm", (IFormPlugin)this));
        }
        return true;
    }

    private void checkValidata(String area) {
        String msg = "";
        if (StringUtils.isEmpty((String)area)) {
            msg = ResManager.loadKDString((String)"\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TemplateDataAreaSettingPlugin_2", (String)"epm-eb-budget", (Object[])new Object[0]);
        } else if (area.indexOf(58) == -1) {
            msg = ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u5355\u5143\u683c\u8303\u56f4\u3002", (String)"TemplateDataAreaSettingPlugin_3", (String)"epm-eb-budget", (Object[])new Object[0]);
        }
        if (StringUtils.isNotEmpty((String)msg)) {
            throw new KDBizException(msg);
        }
    }

    private void sendMsg2Parent() {
        IFormView pv = this.getView().getParentView();
        String area = (String)this.getModel().getValue("area");
        pv.getFormShowParameter().setCustomParam("area", (Object)area);
        FormViewPluginProxy proxy = (FormViewPluginProxy)pv.getService(FormViewPluginProxy.class);
        proxy.getPlugIns().forEach(e -> {
            if (ICommunicateBtwForm.class.isAssignableFrom(e.getClass())) {
                ((ICommunicateBtwForm)ICommunicateBtwForm.class.cast(e)).communicateMsg();
            }
        });
        this.getView().sendFormAction(pv);
    }
}

