/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.budget.formplugin.template.multiview.handle;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.epm.eb.budget.formplugin.report.dynamic.DynamicUtils;
import kd.epm.eb.budget.formplugin.spread.SpreadClientInvoker;
import kd.epm.eb.budget.formplugin.template.AbstractTemplateBasePlugin;
import kd.epm.eb.budget.formplugin.template.multiview.handle.IViewHandle;
import kd.epm.eb.common.ebcommon.common.util.ExcelUtils;
import kd.epm.eb.common.ebcommon.common.util.MapInitHelper;
import kd.epm.eb.ebSpread.domain.view.Sheet;
import kd.epm.eb.ebSpread.domain.view.builder.PositionInfo;
import kd.epm.eb.ebSpread.domain.view.js.SpreadProperties;

public abstract class AbstractViewHandle
implements IViewHandle {
    protected AbstractTemplateBasePlugin plugin;
    protected String spreadKey;

    @Override
    public void handleView(AbstractTemplateBasePlugin plugin, String spreadKey) {
        this.plugin = plugin;
        this.spreadKey = spreadKey;
        this.doHandleView();
        this.handleButtonDisplayStrategy();
        this.hideWholeContextMenuItem(true);
    }

    protected void handleButtonDisplayStrategy() {
        this.setVisible(this.getAllHideCtrlKeys(), false);
        this.setVisible(this.getVisibleCtrlKeys(), true);
    }

    protected void lockSheet() {
        boolean isDynaTemplate = DynamicUtils.isDynamicReport(this.plugin.getSpreadModel());
        Sheet sheet = this.getEffectiveSheet();
        int maxRow = isDynaTemplate ? Math.min(100, sheet.getMaxRowCount()) : sheet.getMaxRowCount();
        ArrayList cells = new ArrayList();
        HashMap<String, Integer> cell = new HashMap<String, Integer>();
        cell.put(SpreadProperties.LockCellMethod.R.k(), 0);
        cell.put(SpreadProperties.LockCellMethod.C.k(), 0);
        cell.put(SpreadProperties.LockCellMethod.RC.k(), maxRow);
        cell.put(SpreadProperties.LockCellMethod.CC.k(), sheet.getMaxColumnCount());
        cells.add(cell);
        SpreadClientInvoker.invokeLockCellMethod(this.plugin.getClientViewProxy(), this.spreadKey, cells);
    }

    protected void controlWholeToolBarItems(boolean isLock) {
        SpreadClientInvoker.invokeLockOrUnlockWholeToolbar(this.plugin.getClientViewProxy(), this.spreadKey, isLock);
    }

    protected void hideWholeContextMenuItem(boolean isHide) {
        SpreadClientInvoker.invokeHideContextMenuItems(this.plugin.getClientViewProxy(), this.spreadKey, MapInitHelper.ofMap((Object)"isHide", (Object)true));
    }

    protected void setAutoExtendColWidth() {
        HashMap featureMap;
        ArrayList cols = new ArrayList();
        ArrayList rows = new ArrayList();
        this.plugin.getSpreadModel().getAreaManager().forEach(area -> {
            String[] areaRange = ((PositionInfo)area.getKey()).getAreaRange().split(":");
            int[] startXY = ExcelUtils.pos2XY((String)areaRange[0]);
            int[] endXY = ExcelUtils.pos2XY((String)areaRange[1]);
            cols.addAll(IntStream.range(startXY[0], endXY[0] + 1).boxed().collect(Collectors.toList()));
            rows.addAll(IntStream.range(startXY[1], endXY[1] + 1).boxed().collect(Collectors.toList()));
        });
        if (!cols.isEmpty()) {
            featureMap = new HashMap();
            featureMap.put(SpreadProperties.AutoFitColumns.C.k(), cols);
            SpreadClientInvoker.invokeAutoFitColumns(this.plugin.getClientViewProxy(), this.spreadKey, featureMap);
        }
        if (!rows.isEmpty()) {
            featureMap = new HashMap();
            featureMap.put(SpreadProperties.AutoFitRows.R.k(), rows);
            SpreadClientInvoker.invokeAutoFitRows(this.plugin.getClientViewProxy(), this.spreadKey, featureMap);
        }
    }

    private String[] getAllHideCtrlKeys() {
        return new String[]{"btn_baseinfo", "btn_weaveexplain", "btn_weaveinfo", "btn_dimsetting", "btn_areasetting", "btn_membsetting", "btn_floatsetting", "btn_circularsetting", "btn_clearcross", "btn_restorecross", "btn_modifycross", "btn_clearformula", "btn_restoreformula", "btn_modifyformula", "bar_formulaview", "btn_rptparam"};
    }

    private void setVisible(String[] ctrlKeys, boolean v) {
        this.plugin.getView().setVisible(Boolean.valueOf(v), ctrlKeys);
    }

    protected void displayStyle() {
        String json = this.plugin.getTemplateModel().getSpreadJson() != null ? this.plugin.getTemplateModel().getSpreadJson() : this.plugin.getSpreadModel().getBook().toJSon();
        SpreadClientInvoker.invokeSetSpreadJsonMethod(this.plugin.getClientViewProxy(), this.spreadKey, json);
    }

    protected boolean isSameWithPrevTabKey(String tabKey) {
        return tabKey.equals(this.plugin.getPageCache().get("tab_current_key"));
    }

    protected void lockOrUnlockSpreadMenuItem(boolean isLocked) {
        if (isLocked) {
            SpreadClientInvoker.invokeLockOrHideSpreadMenuItems(this.plugin.getClientViewProxy(), this.spreadKey);
        } else {
            SpreadClientInvoker.invokeUnLockOrShowSpreadMenuItems(this.plugin.getClientViewProxy(), this.spreadKey);
        }
    }

    protected Sheet getEffectiveSheet() {
        return this.plugin.getSpreadModel().getBook().getSheet(0);
    }

    protected abstract String getViewTabKey();

    protected abstract void doHandleView();

    protected abstract String[] getVisibleCtrlKeys();
}

