/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.budget.formplugin.template.multiview.handle;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.util.StringUtils;
import kd.epm.eb.budget.formplugin.spread.SpreadClientInvoker;
import kd.epm.eb.budget.formplugin.template.multiview.handle.AbstractViewHandle;
import kd.epm.eb.budget.formplugin.template.util.TemplateFloatUtil;
import kd.epm.eb.budget.formplugin.util.MarkSpecialCell;
import kd.epm.eb.common.ebcommon.common.Recorder;
import kd.epm.eb.common.ebcommon.common.util.ExcelUtils;
import kd.epm.eb.ebBusiness.template.model.AreaRangeEntry;
import kd.epm.eb.ebSpread.domain.view.Sheet;
import kd.epm.eb.ebSpread.domain.view.SpreadManager;
import kd.epm.eb.ebSpread.domain.view.builder.PositionInfo;
import kd.epm.eb.ebSpread.domain.view.js.SpreadProperties;

public class MemberViewHandle
extends AbstractViewHandle {
    @Override
    public void doHandleView() {
        this.displayStyle();
        this.controlWholeToolBarItems(true);
        this.drawDimMemAreaColor();
        this.displayMemberInfo();
        this.setF7TypeCellOnSpreadJS();
        this.lockSheet();
        this.unlockDimCell();
        this.lockFloatColOrRow();
        this.lockOrUnlockSpreadMenuItem(true);
        MarkSpecialCell.drawMarkPoint(this.plugin.getPageCache(), this.plugin.getView(), this.plugin.getSpreadModel(), this.spreadKey, false);
    }

    private void unlockDimCell() {
        SpreadManager sm = this.plugin.getSpreadModel();
        ArrayList cells = new ArrayList();
        sm.getAreaManager().forEach(area -> {
            String[] areaRange = ((PositionInfo)area.getKey()).getAreaRange().split(":");
            int[] startXY = ExcelUtils.pos2XY((String)areaRange[0]);
            int[] endXY = ExcelUtils.pos2XY((String)areaRange[1]);
            cells.add(this.constructUnlockCellParam(startXY, endXY, true));
            cells.add(this.constructUnlockCellParam(startXY, endXY, false));
        });
        if (!cells.isEmpty()) {
            SpreadClientInvoker.invokeUnLockCellMethod(this.plugin.getClientViewProxy(), this.spreadKey, cells);
        }
    }

    private Map<String, Object> constructUnlockCellParam(int[] startXY, int[] endXY, boolean isRow) {
        HashMap<String, Object> cell = new HashMap<String, Object>();
        cell.put(SpreadProperties.LockCellMethod.R.k(), startXY[1]);
        cell.put(SpreadProperties.LockCellMethod.C.k(), startXY[0]);
        cell.put(SpreadProperties.LockCellMethod.RC.k(), isRow ? 1 : endXY[1] - startXY[1] + 1);
        cell.put(SpreadProperties.LockCellMethod.CC.k(), isRow ? endXY[0] - startXY[0] + 1 : 1);
        return cell;
    }

    private void drawDimMemAreaColor() {
        SpreadManager sm = this.plugin.getSpreadModel();
        ArrayList rangeList = new ArrayList();
        sm.getAreaManager().forEach(area -> {
            String[] areaRange = ((PositionInfo)area.getKey()).getAreaRange().split(":");
            int[] startXY = ExcelUtils.pos2XY((String)areaRange[0]);
            int[] endXY = ExcelUtils.pos2XY((String)areaRange[1]);
            rangeList.add(this.constructRangeFeature(startXY, endXY, true));
            rangeList.add(this.constructRangeFeature(startXY, endXY, false));
        });
        if (!rangeList.isEmpty()) {
            HashMap<String, Cloneable> features = new HashMap<String, Cloneable>();
            HashMap<String, String> styleMap = new HashMap<String, String>();
            styleMap.put(SpreadProperties.SetCellStyleMethod.BACKCOLOR.k(), "#66CDAA");
            features.put(SpreadProperties.SetCellStyleMethod.RANGE.k(), rangeList);
            features.put(SpreadProperties.SetCellStyleMethod.STYLE.k(), styleMap);
            SpreadClientInvoker.invokeSetCellStyleMethod(this.plugin.getClientViewProxy(), this.spreadKey, Lists.newArrayList((Object[])new Map[]{features}));
        }
    }

    private Map<String, Object> constructRangeFeature(int[] startXY, int[] endXY, boolean isDrawRow) {
        HashMap<String, Object> rangeMap = new HashMap<String, Object>();
        rangeMap.put(SpreadProperties.SetCellStyleMethod.R.k(), startXY[1]);
        rangeMap.put(SpreadProperties.SetCellStyleMethod.C.k(), startXY[0]);
        rangeMap.put(SpreadProperties.SetCellStyleMethod.RC.k(), isDrawRow ? 1 : endXY[1] - startXY[1] + 1);
        rangeMap.put(SpreadProperties.SetCellStyleMethod.CC.k(), isDrawRow ? endXY[0] - startXY[0] + 1 : 1);
        return rangeMap;
    }

    private void displayMemberInfo() {
        SpreadManager sm = this.plugin.getSpreadModel();
        Sheet sheet = sm.getBook().getSheet(0);
        ArrayList cellValues = new ArrayList();
        ArrayList formulas = new ArrayList();
        Recorder hasFormula = new Recorder((Object)false);
        sm.getAreaManager().forEach(area -> {
            String[] areaRange = ((PositionInfo)area.getKey()).getAreaRange().split(":");
            int[] startXY = ExcelUtils.pos2XY((String)areaRange[0]);
            int[] endXY = ExcelUtils.pos2XY((String)areaRange[1]);
            sheet.iteratorRangeCells(startXY[1], endXY[1], startXY[0], endXY[0], cell -> {
                if (cell.getMemberFromUserObject() != null && !cell.getMemberFromUserObject().isEmpty()) {
                    if (cell.getRow() == startXY[1] || cell.getCol() == startXY[0]) {
                        cellValues.add(this.plugin.packedUpdateCellMap(cell.getRow(), cell.getCol(), cell.displayDimMsg()));
                    } else {
                        cellValues.add(this.plugin.packedUpdateCellMap(cell.getRow(), cell.getCol(), null));
                    }
                } else if (cell.getVariant() != null && !cell.getVariant().isEmpty()) {
                    cellValues.add(this.plugin.packedUpdateCellMap(cell.getRow(), cell.getCol(), null));
                }
                if (StringUtils.isNotEmpty((String)cell.getFormula())) {
                    HashMap<String, Object> formula = new HashMap<String, Object>(3);
                    formula.put(SpreadProperties.SetFormulaMethod.R.k(), cell.getRow());
                    formula.put(SpreadProperties.SetFormulaMethod.C.k(), cell.getCol());
                    formula.put(SpreadProperties.SetFormulaMethod.F.k(), "");
                    formulas.add(formula);
                    hasFormula.setRecord((Object)true);
                }
            });
        });
        if (!formulas.isEmpty()) {
            SpreadClientInvoker.invokeSetFormulaMethod(this.plugin.getClientViewProxy(), this.spreadKey, formulas);
        }
        if (!cellValues.isEmpty()) {
            SpreadClientInvoker.invokeUpdataValueMethod(this.plugin.getClientViewProxy(), this.spreadKey, cellValues);
        }
        if (((Boolean)hasFormula.getRecord()).booleanValue()) {
            this.plugin.cacheSpreadModel();
        }
    }

    private void setF7TypeCellOnSpreadJS() {
        SpreadManager sm = this.plugin.getSpreadModel();
        sm.getAreaManager().forEach(area -> {
            String[] areaRange = ((PositionInfo)area.getKey()).getAreaRange().split(":");
            int[] startXY = ExcelUtils.pos2XY((String)areaRange[0]);
            int[] endXY = ExcelUtils.pos2XY((String)areaRange[1]);
            AreaRangeEntry entry = this.getOverlapAreaRange(((PositionInfo)area.getKey()).getAreaRange());
            if (entry != null) {
                this.constructF7TypeFeature(entry.getColDimEntries().size() == 1 ? 0 : 1, startXY, endXY, true);
                this.constructF7TypeFeature(entry.getRowDimEntries().size() == 1 ? 0 : 1, startXY, endXY, false);
                this.constructF7TypeFeature(1, startXY, startXY, false);
            }
        });
    }

    private AreaRangeEntry getOverlapAreaRange(String tarArea) {
        for (AreaRangeEntry e : this.plugin.getTemplateModel().getAreaRangeEntries()) {
            if (!tarArea.equals(e.getAreaRange())) continue;
            return e;
        }
        return null;
    }

    private void constructF7TypeFeature(int selectType, int[] startXY, int[] endXY, boolean isRow) {
        HashMap<String, Serializable> features = new HashMap<String, Serializable>();
        ArrayList items = new ArrayList();
        if (isRow) {
            for (int c = startXY[0]; c <= endXY[0]; ++c) {
                HashMap<String, Integer> feature = new HashMap<String, Integer>();
                feature.put(SpreadProperties.SetF7TypeCellMethod.R.k(), startXY[1]);
                feature.put(SpreadProperties.SetF7TypeCellMethod.C.k(), c);
                items.add(feature);
            }
        } else {
            for (int r = startXY[1]; r <= endXY[1]; ++r) {
                HashMap<String, Integer> feature = new HashMap<String, Integer>();
                feature.put(SpreadProperties.SetF7TypeCellMethod.R.k(), r);
                feature.put(SpreadProperties.SetF7TypeCellMethod.C.k(), startXY[0]);
                items.add(feature);
            }
        }
        features.put(SpreadProperties.SetF7TypeCellMethod.CELL.k(), items);
        features.put(SpreadProperties.SetF7TypeCellMethod.SELECTTYPE.k(), Integer.valueOf(selectType));
        SpreadClientInvoker.invokeSetF7TypeCellMethod(this.plugin.getClientViewProxy(), this.spreadKey, features);
    }

    @Override
    protected String getViewTabKey() {
        return "tab_memb";
    }

    @Override
    protected String[] getVisibleCtrlKeys() {
        return new String[]{"btn_dimsetting", "btn_areasetting", "btn_membsetting", "btn_floatsetting"};
    }

    private void lockFloatColOrRow() {
        for (PositionInfo ps : this.plugin.getSpreadModel().getAreaManager().getPostionInfoSet()) {
            TemplateFloatUtil.setFloatAreaCellLock(this.plugin.getView(), this.spreadKey, ps, null);
        }
    }
}

