/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.budget.formplugin.template.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.time.LocalDate;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.ebcommon.common.util.ObjectSerialUtil;
import kd.epm.eb.ebBusiness.template.model.TemplateModel;

public class TemplateExportPlugin {
    private static Log log = LogFactory.getLog(TemplateExportPlugin.class);

    public String export(String formId, long modelId, Object[] pkids, String filename) throws IOException {
        DynamicObjectType type = BusinessDataServiceHelper.newDynamicObject((String)formId).getDynamicObjectType();
        TemplateModel[] tempalteModels = this.loadTemplatesById(pkids, type);
        String jsonString = ObjectSerialUtil.toByteSerialized((Object)tempalteModels);
        String fileName = this.getFileName(filename);
        return this.createJsonFile(jsonString, fileName);
    }

    private TemplateModel[] loadTemplatesById(Object[] templateIds, DynamicObjectType type) {
        DynamicObject[] templates = BusinessDataServiceHelper.load((Object[])templateIds, (DynamicObjectType)type);
        TemplateModel[] tempalteModels = new TemplateModel[templateIds.length];
        for (int i = 0; i < templates.length; ++i) {
            TemplateModel template = new TemplateModel();
            template.loadDynaObj2Model(templates[i]);
            tempalteModels[i] = template;
        }
        return tempalteModels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createJsonFile(String jsonString, String fileName) throws IOException {
        ByteArrayInputStream inStream = null;
        try {
            inStream = new ByteArrayInputStream(jsonString.getBytes(Charset.forName("UTF-8")));
            String string = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)inStream, 10000);
            return string;
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    log.error((Throwable)e);
                }
            }
        }
    }

    private String getFileName(String filename) {
        String fileName = filename;
        LocalDate now = LocalDate.now();
        fileName = fileName + String.format("_%02d%02d", now.getMonthValue(), now.getDayOfMonth()) + ".json";
        return fileName;
    }
}

