/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.budget.formplugin.template.util;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.budget.formplugin.AbstractBaseFormPlugin;
import kd.epm.eb.budget.formplugin.template.util.TemplateScanMemberService;
import kd.epm.eb.common.ebcommon.common.PresetConstant;
import kd.epm.eb.common.ebcommon.common.Recorder;
import kd.epm.eb.common.ebcommon.common.enums.DimTypesEnum;
import kd.epm.eb.common.ebcommon.common.log.BcmLogFactory;
import kd.epm.eb.common.ebcommon.common.log.WatchLogger;
import kd.epm.eb.common.ebcommon.common.util.ExcelUtils;
import kd.epm.eb.common.ebcommon.common.util.ObjectSerialUtil;
import kd.epm.eb.common.ebcommon.common.util.Point;
import kd.epm.eb.common.ebcommon.common.util.ThrowableHelper;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.ebBusiness.serviceHelper.DimensionServiceHelper;
import kd.epm.eb.ebBusiness.template.model.AreaRangeEntry;
import kd.epm.eb.ebBusiness.template.model.ColDimensionEntry;
import kd.epm.eb.ebBusiness.template.model.Dimension;
import kd.epm.eb.ebBusiness.template.model.Member;
import kd.epm.eb.ebBusiness.template.model.PageDimPropEntry;
import kd.epm.eb.ebBusiness.template.model.PageDimensionEntry;
import kd.epm.eb.ebBusiness.template.model.RowDimensionEntry;
import kd.epm.eb.ebBusiness.template.model.TemplateCatalog;
import kd.epm.eb.ebBusiness.template.model.TemplateModel;
import kd.epm.eb.ebBusiness.template.model.ViewPointDimensionEntry;
import kd.epm.eb.ebBusiness.util.EntityVersioningUtil;
import kd.epm.eb.ebSpread.domain.Cell;
import kd.epm.eb.ebSpread.domain.view.JsonSerializerUtil;
import kd.epm.eb.ebSpread.domain.view.Sheet;
import kd.epm.eb.ebSpread.domain.view.SpreadManager;
import kd.epm.eb.ebSpread.domain.view.builder.FreeStyleTemplateFinalBuilder;
import kd.epm.eb.ebSpread.domain.view.builder.PositionInfo;
import kd.epm.eb.ebSpread.domain.view.builder.dynamic.BasePointInfo;
import kd.epm.eb.ebSpread.domain.view.builder.dynamic.BasePointInnerLineInfo;
import kd.epm.eb.ebSpread.domain.view.builder.dynamic.DynaMembScopeInfo;
import kd.epm.eb.ebSpread.model.DimMember;
import kd.epm.eb.ebSpread.model.IDimMember;
import kd.epm.eb.ebSpread.model.IDimension;
import org.apache.commons.io.IOUtils;

public class TemplateImportPlugin
extends AbstractBaseFormPlugin
implements UploadListener {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance(TemplateImportPlugin.class);

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", "btndownload"});
        AttachmentPanel attach = (AttachmentPanel)this.getControl("attachmentpanelap");
        attach.addUploadListener((UploadListener)this);
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        if ("btnok".equals(((Button)evt.getSource()).getKey())) {
            TempFileCacheDownloadable fileCache = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
            try {
                String file_url = this.getPageCache().get("file_url");
                if (file_url == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u4e0a\u4f20\u5bfc\u5165\u6570\u636e", (String)"TemplateImportPlugin_0", (String)"epm-eb-budget", (Object[])new Object[0]));
                }
                String[] reqParams = new URL(file_url).getQuery().split("&");
                HashMap<String, String> map = new HashMap<String, String>(reqParams.length);
                for (String param : reqParams) {
                    String[] p = param.split("=");
                    map.put(p[0], p[1]);
                }
                TempFileCacheDownloadable.Content content = fileCache.get((String)map.get("configKey"), (String)map.get("id"));
                InputStream inputStream = content.getInputStream();
                String jsonString = this.getStringFromInputStream(inputStream);
                this.handleInputStream(jsonString);
                this.getView().close();
            }
            catch (KDBizException e) {
                throw e;
            }
            catch (Exception e) {
                log.error("error", (Throwable)e);
                throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\u6216\u5df2\u635f\u574f\uff0c\u8bf7\u68c0\u67e5", (String)"TemplateImportPlugin_2", (String)"epm-eb-budget", (Object[])new Object[0]));
            }
        }
    }

    private String getStringFromInputStream(InputStream inputStream) {
        StringWriter writer = new StringWriter();
        try {
            IOUtils.copy((InputStream)inputStream, (Writer)writer, (String)StandardCharsets.UTF_8.name());
        }
        catch (IOException e) {
            log.error("io error", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"IO\u5f02\u5e38", (String)"TemplateImportPlugin_1", (String)"epm-eb-budget", (Object[])new Object[0]));
        }
        return writer.toString();
    }

    private void handleInputStream(String str) {
        TemplateModel[] templateModels;
        try {
            templateModels = (TemplateModel[])ObjectSerialUtil.deSerializedBytes((String)str);
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u6b63\u786e\u6216\u5df2\u635f\u574f\uff0c\u8bf7\u68c0\u67e5", (String)"TemplateImportPlugin_2", (String)"epm-eb-budget", (Object[])new Object[0]));
        }
        Long modelid = (Long)this.getFormCustomParam("modelid");
        Map<String, String> realdimNumbers = this.getDimensions(modelid);
        Map<String, Set<String>> membersmap = this.getMembersNumber(modelid, realdimNumbers);
        Map<Long, String> propertyMap = this.getDPropertyMap(modelid);
        Map<String, Set<String>> propertyValues = this.getPropertyValues(modelid);
        ArrayList<TemplateModel> passedTemplates = new ArrayList<TemplateModel>();
        HashMap<String, String> nopassedTemplates = new HashMap<String, String>();
        for (TemplateModel tmplModel : templateModels) {
            if (!this.checkDimensionAndMemberNumber(modelid, tmplModel, realdimNumbers, membersmap, propertyMap, propertyValues, nopassedTemplates)) continue;
            passedTemplates.add(tmplModel);
        }
        HashSet<String> adjustEffectivedateTmpl = new HashSet<String>();
        if (passedTemplates.size() > 0) {
            Map<String, Map<String, Object>> tmplNeedFields = this.getNeedExchangeFields(modelid, passedTemplates.toArray(new TemplateModel[0]));
            HashSet<String> numberSet = new HashSet<String>(16);
            HashSet<String> nameSet = new HashSet<String>(16);
            QFilter modelqfilter = new QFilter("model", "=", (Object)modelid);
            try (DataSet alldata = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"eb_templateentity_bg", (String)"name, number", (QFilter[])new QFilter[]{modelqfilter}, null);){
                while (alldata.hasNext()) {
                    Row row = alldata.next();
                    numberSet.add(row.getString("number"));
                    nameSet.add(row.getString("name"));
                }
            }
            ArrayList<TemplateModel> newtemplateModels = new ArrayList<TemplateModel>(10);
            HashMap<String, BigDecimal> templateMaxVersion = new HashMap<String, BigDecimal>(16);
            HashMap<String, Long> newGroupId = new HashMap<String, Long>();
            Map<String, DynamicObject> sysdimension = this.getSysDimension(modelid);
            Map<String, Map<String, String>> sysdimmember = this.getSysDimensionMember(modelid, realdimNumbers);
            Map<String, DynamicObject> propertymap = this.getSysProperty(modelid);
            Map<String, DynamicObject> propertyValueDynamicObj = this.getPropertyValueDynamicObj(modelid);
            for (TemplateModel templatemodel : passedTemplates) {
                Map<String, Object> currentlist = tmplNeedFields.get(templatemodel.getNumber());
                newtemplateModels.add(this.buildModels(templatemodel, numberSet, nameSet, currentlist, templateMaxVersion, adjustEffectivedateTmpl, sysdimension, sysdimmember, propertymap, propertyValueDynamicObj, newGroupId));
            }
            ArrayList successTemplates = new ArrayList();
            newtemplateModels.forEach(model -> {
                DynamicObject t = model.genDynamicObject();
                successTemplates.add(t);
            });
            try (TXHandle tx = TX.required((String)"template_import_save");){
                try {
                    if (successTemplates.size() > 0) {
                        SaveServiceHelper.save((DynamicObject[])successTemplates.toArray(new DynamicObject[0]));
                        this.setImportTemplatesDistribution(newtemplateModels, tmplNeedFields);
                        this.saveUserdefcvtformula(newtemplateModels);
                        this.setRules(newtemplateModels);
                    }
                }
                catch (Throwable e) {
                    tx.markRollback();
                    log.error("--templateImportSave--:\n" + ThrowableHelper.toString((Throwable)e));
                    throw e;
                }
            }
        }
        String needChangeMessage = "";
        if (adjustEffectivedateTmpl.size() > 0) {
            needChangeMessage = ResManager.loadKDString((String)"\u5168\u90e8\u6a21\u677f\u5bfc\u5165\u6210\u529f\u3002", (String)"TemplateImportPlugin_7", (String)"epm-eb-budget", (Object[])new Object[0]);
        }
        StringBuilder message = new StringBuilder(ResManager.loadKDString((String)"\u5931\u8d25\u539f\u56e0\u5982\u4e0b:\n", (String)"TemplateImportPlugin_5", (String)"epm-eb-budget", (Object[])new Object[0]));
        for (Map.Entry entry : nopassedTemplates.entrySet()) {
            String key = (String)entry.getKey();
            message.append(ResManager.loadKDString((String)"\u62a5\u8868\u6a21\u677f", (String)"TemplateImportPlugin_6", (String)"epm-eb-budget", (Object[])new Object[0])).append(key).append(':').append((String)entry.getValue()).append(";\n");
        }
        if (nopassedTemplates.size() == 0 && passedTemplates.size() > 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5168\u90e8\u6a21\u677f\u5bfc\u5165\u6210\u529f\u3002", (String)"TemplateImportPlugin_7", (String)"epm-eb-budget", (Object[])new Object[0]), needChangeMessage, null);
        } else if (nopassedTemplates.size() > 0 && passedTemplates.size() > 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u90e8\u5206\u6a21\u677f\u5bfc\u5165\u6210\u529f\u3002", (String)"TemplateImportPlugin_8", (String)"epm-eb-budget", (Object[])new Object[0]), ResManager.loadResFormat((String)"\u6210\u529f\u4e2a\u6570\uff1a%1 \u5931\u8d25\u4e2a\u6570\uff1a%2", (String)"TemplateImportPlugin_9", (String)"epm-eb-budget", (Object[])new Object[]{passedTemplates.size(), nopassedTemplates.size()}) + "\n" + needChangeMessage + "\n" + message, null);
        } else {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6a21\u677f\u5bfc\u5165\u5931\u8d25\u3002", (String)"TemplateImportPlugin_11", (String)"epm-eb-budget", (Object[])new Object[0]), message.toString(), null);
        }
    }

    private void saveUserdefcvtformula(List<TemplateModel> templates) {
        ArrayList list = new ArrayList();
        for (TemplateModel template : templates) {
            long modelId = template.getModelId();
            long templateId = template.getId();
            String scenarioIdStr = this.getPageCache().get("convert2scenarioid" + Long.toString(templateId));
            String scenarioNum = this.getPageCache().get("convert2scenarionumber" + Long.toString(templateId));
            if (scenarioIdStr == null) {
                return;
            }
            HashMap viewPointMember = new HashMap();
            template.getViewPointDimensionEntries().forEach(v -> viewPointMember.put(v.getDimension().getNumber(), v.getMember().getNumber()));
            SpreadManager spreadModel = JsonSerializerUtil.toSpreadManager((String)template.getData());
            Sheet sheet = spreadModel.getBook().getSheet(0);
            spreadModel.getAreaManager().forEach(area -> {
                PositionInfo positionInfo = (PositionInfo)area.getKey();
                String[] areaRange = positionInfo.getAreaRange().split(":");
                int[] startXY = ExcelUtils.pos2XY((String)areaRange[0]);
                int[] endXY = ExcelUtils.pos2XY((String)areaRange[1]);
                if (positionInfo.isFloatPosition()) {
                    List basePoints = positionInfo.getBasePoints();
                    for (BasePointInfo basePoint : basePoints) {
                        List members;
                        Cell cell;
                        int i;
                        List lineInfos = basePoint.getBasePointInnerLineInfo();
                        boolean isAccountOrChangeTypeFloat = false;
                        for (BasePointInnerLineInfo lineInfo : lineInfos) {
                            String dimNumber = lineInfo.getDimension().getNumber();
                            if (!lineInfo.isFloated() || !PresetConstant.ACCOUNT_DIM.equals(dimNumber) && !PresetConstant.CHANGETYPE_DIM.equals(dimNumber)) continue;
                            isAccountOrChangeTypeFloat = true;
                            break;
                        }
                        if (isAccountOrChangeTypeFloat) continue;
                        int[] pos2xy = ExcelUtils.pos2XY((String)basePoint.getDynaRange().split(":")[0]);
                        if (basePoint.isDirectHoriz()) {
                            for (i = startXY[1]; i <= endXY[1]; ++i) {
                                cell = sheet.getCell(i, startXY[0]);
                                if (cell != null && (members = cell.getMemberFromUserObject()) != null && !members.isEmpty() && (cell = sheet.getCell(i, pos2xy[0])) != null) continue;
                            }
                            continue;
                        }
                        for (i = startXY[0]; i <= endXY[0]; ++i) {
                            cell = sheet.getCell(startXY[1], i);
                            if (cell != null && (members = cell.getMemberFromUserObject()) != null && !members.isEmpty() && (cell = sheet.getCell(pos2xy[1], i)) != null) continue;
                        }
                    }
                }
            });
        }
        SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
    }

    private void setRules(List<TemplateModel> newtemplateModels) {
        for (TemplateModel tm : newtemplateModels) {
            SpreadManager spread = JsonSerializerUtil.toSpreadManager((String)tm.getData());
            FreeStyleTemplateFinalBuilder builder = new FreeStyleTemplateFinalBuilder(spread, tm);
            builder.doBuildReport(true, false);
            this.correctAcctCellLeaf(spread, tm);
            TemplateScanMemberService service = new TemplateScanMemberService(spread, tm);
            service.scan();
            service.updaterule(spread);
        }
    }

    private void correctAcctCellLeaf(SpreadManager spread, TemplateModel tm) {
        Set infos = spread.getAreaManager().getPostionInfoSet();
        if (infos.isEmpty()) {
            return;
        }
        Map<String, Set<String>> map = this.getViewPointRowColNotLeafDimMem(tm);
        HashSet firstfloatCells = Sets.newHashSet();
        int pSize = tm.getPageDimensionEntries().size();
        int vSize = tm.getViewPointDimensionEntries().size();
        int dimSize = DimensionServiceHelper.getDimensionNumListByModel((Object)tm.getModelId()).size();
        Recorder rowColSize = new Recorder((Object)(dimSize - pSize - vSize));
        ArrayList<String> areas = new ArrayList<String>(infos.size());
        for (PositionInfo info : infos) {
            areas.add(info.getAreaRange());
            String[] parea = info.getAreaRange().split(":");
            int[] pstartXY = ExcelUtils.pos2XY((String)parea[0]);
            int[] pendXY = ExcelUtils.pos2XY((String)parea[1]);
            for (BasePointInfo baseInfo : info.getBasePoints()) {
                String memNum;
                String dimNum;
                boolean isClear;
                int i;
                Map rcMems = baseInfo.getFixMemberPosition();
                String[] area = baseInfo.getDynaRange().split(":");
                int[] startXY = ExcelUtils.pos2XY((String)area[0]);
                if (baseInfo.getDirect() == 1) {
                    for (i = pstartXY[1]; i <= pendXY[1]; ++i) {
                        isClear = false;
                        if (rcMems.size() == 0) {
                            isClear = true;
                        }
                        if (rcMems.get(i - pstartXY[1]) != null) {
                            for (IDimMember iDimMember : (List)rcMems.get(i - pstartXY[1])) {
                                dimNum = iDimMember.getDimension().getNumber();
                                memNum = iDimMember.getNumber();
                                if (!map.get(dimNum).contains(memNum)) continue;
                                isClear = true;
                                break;
                            }
                        }
                        if (isClear) continue;
                        firstfloatCells.add(new Point(startXY[0], i));
                    }
                    continue;
                }
                for (i = pstartXY[0]; i <= pendXY[0]; ++i) {
                    isClear = false;
                    if (rcMems.size() == 0) {
                        isClear = true;
                    }
                    if (rcMems.get(i - pstartXY[0]) != null) {
                        for (IDimMember iDimMember : (List)rcMems.get(i - pstartXY[0])) {
                            dimNum = iDimMember.getDimension().getNumber();
                            memNum = iDimMember.getNumber();
                            if (!map.get(dimNum).contains(memNum)) continue;
                            isClear = true;
                            break;
                        }
                    }
                    if (isClear) continue;
                    firstfloatCells.add(new Point(i, startXY[1]));
                }
            }
        }
        spread.getBook().getSheet(0).iteratorCells(cell -> {
            if (!StringUtils.isEmpty((String)cell.getFormula())) {
                for (String a : areas) {
                    if (ExcelUtils.isOverlap((String)a, (String)ExcelUtils.xy2Pos((int)cell.getCol(), (int)cell.getRow()))) continue;
                    return;
                }
                Point p = new Point(cell.getCol(), cell.getRow());
                if (firstfloatCells.contains(p)) {
                    return;
                }
                if (cell.getMemberFromUserObject() != null && cell.getMemberFromUserObject().size() == ((Integer)rowColSize.getRecord()).intValue()) {
                    for (IDimMember member : cell.getMemberFromUserObject()) {
                        if (!((Set)map.get(member.getDimension().getNumber())).contains(member.getNumber())) continue;
                        cell.setFormula(null);
                        cell.setValue(null);
                        break;
                    }
                } else {
                    cell.setFormula(null);
                    cell.setValue(null);
                }
            }
        });
    }

    private Map<String, Set<String>> getViewPointRowColNotLeafDimMem(TemplateModel tm) {
        DynamicObjectCollection doc;
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>(16);
        QFBuilder qf = new QFBuilder("model", "=", (Object)this.getModelId());
        qf.add("isleaf", "=", (Object)false);
        for (ViewPointDimensionEntry views : tm.getViewPointDimensionEntries()) {
            Dimension dimension = views.getDimension();
            doc = QueryServiceHelper.query((String)dimension.getMemberEntityNumber(), (String)"number", (QFilter[])qf.toArray());
            HashSet numbers = Sets.newHashSet();
            for (DynamicObject dy : doc) {
                numbers.add(dy.getString("number"));
            }
            map.put(dimension.getNumber(), numbers);
        }
        for (AreaRangeEntry area : tm.getAreaRangeEntries()) {
            HashSet numbers;
            Dimension dimension;
            for (ColDimensionEntry colDimEntry : area.getColDimEntries()) {
                dimension = colDimEntry.getDimension();
                doc = QueryServiceHelper.query((String)dimension.getMemberEntityNumber(), (String)"number", (QFilter[])qf.toArray());
                numbers = Sets.newHashSet();
                for (DynamicObject dy : doc) {
                    numbers.add(dy.getString("number"));
                }
                map.put(dimension.getNumber(), numbers);
            }
            for (RowDimensionEntry rowDimEntry : area.getRowDimEntries()) {
                dimension = rowDimEntry.getDimension();
                doc = QueryServiceHelper.query((String)dimension.getMemberEntityNumber(), (String)"number", (QFilter[])qf.toArray());
                numbers = Sets.newHashSet();
                for (DynamicObject dy : doc) {
                    numbers.add(dy.getString("number"));
                }
                map.put(dimension.getNumber(), numbers);
            }
        }
        return map;
    }

    private Map<String, Map<String, String>> getSysDimensionMember(Long modelid, Map<String, String> dimNumbers) {
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>(16);
        for (Map.Entry<String, String> entry : dimNumbers.entrySet()) {
            QFilter qf = new QFilter("model", "=", (Object)modelid);
            qf.and(new QFilter("longNumber", "like", (Object)(entry.getKey() + "%")));
            QFilter[] qfs = new QFilter[]{qf};
            DynamicObjectCollection dcs = QueryServiceHelper.query((String)entry.getValue(), (String)"id, number", (QFilter[])qfs);
            HashMap numbers = new HashMap();
            dcs.forEach(p -> numbers.put(p.getString("number"), p.getString("id")));
            map.put(entry.getKey(), numbers);
        }
        return map;
    }

    private Map<String, DynamicObject> getSysDimension(Long modelid) {
        QFilter qf = new QFilter("model", "=", (Object)modelid);
        QFilter[] qfs = new QFilter[]{qf};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"epm_dimension", (String)"id, number, name, membermodel, fieldmapped", (QFilter[])qfs);
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>();
        dcs.forEach(p -> map.put(p.getString("number"), (DynamicObject)p));
        return map;
    }

    private void setImportTemplatesDistribution(List<TemplateModel> newtemplateModels, Map<String, Map<String, Object>> tmplNeedFields) {
        ArrayList<DynamicObject> toSaveList = new ArrayList<DynamicObject>();
        for (TemplateModel newtemplate : newtemplateModels) {
            DynamicObject[] dyns;
            if (!tmplNeedFields.containsKey(newtemplate.getNumber())) continue;
            QFBuilder qf = new QFBuilder("model", "=", (Object)newtemplate.getModelId());
            qf.add("template.number", "=", (Object)newtemplate.getNumber());
            qf.add("template.id", "=", tmplNeedFields.get(newtemplate.getNumber()).get("id"));
            for (DynamicObject dyn : dyns = BusinessDataServiceHelper.load((String)"eb_distributionentity", (String)"id, model, entity, template, memrangdecombo, definedproperty, definedpropertyvalue, textname", (QFilter[])qf.toArray())) {
                DynamicObject newDy = (DynamicObject)OrmUtils.clone((IDataEntityBase)dyn, (boolean)true, (boolean)true);
                long id = GlobalIdUtil.genGlobalLongId();
                newDy.set("id", (Object)id);
                newDy.set("template", newtemplate.get("id"));
                newDy.set("template_id", newtemplate.get("id"));
                toSaveList.add(newDy);
            }
        }
        SaveServiceHelper.save((DynamicObject[])toSaveList.toArray(new DynamicObject[0]));
    }

    private boolean checkDimensionAndMemberNumber(Long modelid, TemplateModel template, Map<String, String> realdimNumbers, Map<String, Set<String>> membersmap, Map<Long, String> propertyMap, Map<String, Set<String>> propertyValues, Map<String, String> nopassedTemplates) {
        Set value;
        String k2;
        boolean pass = true;
        HashMap<String, Set> dimensionAndMembers = new HashMap<String, Set>();
        HashMap propertys = new HashMap();
        HashMap propertyvalue = new HashMap();
        template.getViewPointDimensionEntries().forEach(v -> {
            HashSet<String> dimMembers = dimensionAndMembers.get(v.getDimension().getNumber()) == null ? new HashSet<String>() : (Set)dimensionAndMembers.get(v.getDimension().getNumber());
            dimMembers.add(v.getMember().getNumber());
            dimensionAndMembers.put(v.getDimension().getNumber(), dimMembers);
        });
        template.getPageDimensionEntries().forEach(p -> {
            HashSet dimMembers = dimensionAndMembers.get(p.getDimension().getNumber()) == null ? new HashSet() : (Set)dimensionAndMembers.get(p.getDimension().getNumber());
            p.getMembers().forEach(member -> dimMembers.add(member.getNumber()));
            dimensionAndMembers.put(p.getDimension().getNumber(), dimMembers);
        });
        template.getPagePropEntries().forEach(p -> {
            HashSet propertyset = propertys.get(p.getDimension().getNumber()) == null ? new HashSet() : (Set)propertys.get(p.getDimension().getNumber());
            p.getCustomProperties().forEach(custom -> propertyset.add(custom.getNumber()));
            propertys.put(p.getDimension().getNumber(), propertyset);
            HashSet propertyvalueset = propertyvalue.get(p.getDimension().getNumber()) == null ? new HashSet() : (Set)propertyvalue.get(p.getDimension().getNumber());
            p.getAllMembProperties().forEach(membproperty -> propertyvalueset.add(membproperty.getNumber()));
            propertyvalue.put(p.getDimension().getNumber(), propertyvalueset);
        });
        template.getAreaRangeEntries().forEach(area -> {
            area.getColDimEntries().forEach(c -> {
                HashSet dimMembers;
                Set set = dimMembers = dimensionAndMembers.get(c.getDimension().getNumber()) == null ? new HashSet() : (Set)dimensionAndMembers.get(c.getDimension().getNumber());
                if (c.getMembers() != null) {
                    c.getMembers().forEach(member -> dimMembers.add(member.getNumber()));
                }
                dimensionAndMembers.put(c.getDimension().getNumber(), dimMembers);
            });
            area.getRowDimEntries().forEach(c -> {
                HashSet dimMembers;
                Set set = dimMembers = dimensionAndMembers.get(c.getDimension().getNumber()) == null ? new HashSet() : (Set)dimensionAndMembers.get(c.getDimension().getNumber());
                if (c.getMembers() != null) {
                    c.getMembers().forEach(member -> dimMembers.add(member.getNumber()));
                }
                dimensionAndMembers.put(c.getDimension().getNumber(), dimMembers);
            });
        });
        StringBuilder nopassedMessage = new StringBuilder();
        ArrayList dimensions = new ArrayList();
        dimensionAndMembers.forEach((k, v) -> dimensions.add(k));
        if (!dimensions.containsAll(realdimNumbers.keySet())) {
            HashSet<String> realdims = new HashSet<String>(realdimNumbers.keySet());
            realdims.removeAll(dimensions);
            if (template.isSaveByDim() && realdims.size() > 0) {
                nopassedMessage.append(ResManager.loadKDString((String)"\u5bfc\u5165\u6a21\u677f\u7f3a\u5c11\u7ef4\u5ea6\u7f16\u7801\uff1a", (String)"TemplateImportPlugin_12", (String)"epm-eb-budget", (Object[])new Object[0])).append(String.join((CharSequence)",", realdims));
                nopassedTemplates.put(template.getNumber(), nopassedMessage.toString());
                return false;
            }
        }
        dimensions.removeAll(realdimNumbers.keySet());
        if (dimensions.size() > 0) {
            nopassedMessage.append(ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u4e0d\u5b58\u5728\u7ef4\u5ea6\u7f16\u7801\uff1a", (String)"TemplateImportPlugin_13", (String)"epm-eb-budget", (Object[])new Object[0])).append(String.join((CharSequence)",", dimensions));
            nopassedTemplates.put(template.getNumber(), nopassedMessage.toString());
            return false;
        }
        for (Map.Entry entry : dimensionAndMembers.entrySet()) {
            k2 = (String)entry.getKey();
            ((Set)entry.getValue()).removeAll((Collection)membersmap.get(k2));
            if (((Set)dimensionAndMembers.get(k2)).size() <= 0) continue;
            nopassedMessage.append(ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u7ef4\u5ea6\uff1a", (String)"TemplateImportPlugin_14", (String)"epm-eb-budget", (Object[])new Object[0])).append(k2).append(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u7ef4\u5ea6\u6210\u5458\uff1a", (String)"TemplateImportPlugin_15", (String)"epm-eb-budget", (Object[])new Object[0])).append(String.join((CharSequence)",", (Iterable)dimensionAndMembers.get(k2)));
            nopassedTemplates.put(template.getNumber(), nopassedMessage.toString());
            return false;
        }
        if (propertys.size() > 0 && propertyMap.size() > 0) {
            for (Map.Entry entry : propertys.entrySet()) {
                k2 = (String)entry.getKey();
                value = (Set)entry.getValue();
                value.removeAll(propertyMap.values());
                if (value.size() <= 0) continue;
                nopassedMessage.append(ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u7ef4\u5ea6\uff1a", (String)"TemplateImportPlugin_14", (String)"epm-eb-budget", (Object[])new Object[0])).append(k2).append(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u81ea\u5b9a\u4e49\u5c5e\u6027\uff1a", (String)"TemplateImportPlugin_16", (String)"epm-eb-budget", (Object[])new Object[0])).append(String.join((CharSequence)",", value));
                nopassedTemplates.put(template.getNumber(), nopassedMessage.toString());
                return false;
            }
        } else if (propertys.size() > 0 && propertyMap.size() == 0) {
            nopassedMessage.append(ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u4e0d\u5b58\u5728\u81ea\u5b9a\u4e49\u5c5e\u6027", (String)"TemplateImportPlugin_17", (String)"epm-eb-budget", (Object[])new Object[0]));
            nopassedTemplates.put(template.getNumber(), nopassedMessage.toString());
            return false;
        }
        if (propertyvalue.size() > 0 && propertyValues.size() > 0) {
            for (Map.Entry entry : propertyvalue.entrySet()) {
                k2 = (String)entry.getKey();
                value = (Set)entry.getValue();
                if (propertyValues.get(k2) != null) {
                    value.removeAll((Collection)propertyValues.get(k2));
                }
                if (value.size() <= 0) continue;
                nopassedMessage.append(ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u7ef4\u5ea6\uff1a", (String)"TemplateImportPlugin_14", (String)"epm-eb-budget", (Object[])new Object[0])).append(k2).append(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u81ea\u5b9a\u4e49\u5c5e\u6027\u503c\uff1a", (String)"TemplateImportPlugin_18", (String)"epm-eb-budget", (Object[])new Object[0])).append(String.join((CharSequence)",", value));
                nopassedTemplates.put(template.getNumber(), nopassedMessage.toString());
                return false;
            }
        } else if (propertyvalue.size() > 0 && propertyValues.size() == 0) {
            nopassedMessage.append(ResManager.loadKDString((String)"\u5f53\u524d\u4f53\u7cfb\u4e0d\u5b58\u5728\u81ea\u5b9a\u4e49\u5c5e\u6027\u503c", (String)"TemplateImportPlugin_19", (String)"epm-eb-budget", (Object[])new Object[0]));
            nopassedTemplates.put(template.getNumber(), nopassedMessage.toString());
            return false;
        }
        return pass;
    }

    private TemplateModel buildModels(TemplateModel templateModel, Set<String> numberSet, Set<String> nameSet, Map<String, Object> currentlist, Map<String, BigDecimal> maxversion, Set<String> adjustEffectivedateTmpl, Map<String, DynamicObject> sysdimension, Map<String, Map<String, String>> sysdimmember, Map<String, DynamicObject> propertymap, Map<String, DynamicObject> propertyValueDynamicObj, Map<String, Long> newGroupId) {
        TemplateModel newTemplateModel = new TemplateModel();
        boolean nohistryTemplate = currentlist == null;
        newTemplateModel.setId(GlobalIdUtil.genGlobalLongId());
        newTemplateModel.setModelId(((Long)this.getFormCustomParam("modelid")).longValue());
        String name = templateModel.getName().length() > 56 ? templateModel.getName().substring(0, 55) + "copy" : templateModel.getName() + "copy";
        String number = templateModel.getNumber().length() > 56 ? templateModel.getNumber().substring(0, 55) + "copy" : templateModel.getNumber() + "copy";
        newTemplateModel.setNumber(this.getCopyName(number, numberSet, 1));
        newTemplateModel.setName(this.getCopyName(name, nameSet, 1));
        newTemplateModel.setSpreadJson(templateModel.getSpreadJson());
        newTemplateModel.setData(this.getData(templateModel.getData(), sysdimension, sysdimmember));
        newTemplateModel.setRptData(this.getData(templateModel.getRptData(), sysdimension, sysdimmember));
        newTemplateModel.setRptSpreadJson(templateModel.getRptSpreadJson());
        newTemplateModel.setCreateOrgId(this.getOrgId());
        newTemplateModel.setUsage(templateModel.getUsage());
        newTemplateModel.setDataUnit(templateModel.getDataUnit());
        newTemplateModel.setIsOnlyRead(templateModel.getIsOnlyRead());
        newTemplateModel.setTemplateType(templateModel.getTemplateType().intValue());
        newTemplateModel.setVarBase(templateModel.getVarBase());
        newTemplateModel.setVarJson(templateModel.getVarJson());
        newTemplateModel.setIsOldTemplate(templateModel.isOldTemplate());
        newTemplateModel.setIsFinTemplate(templateModel.isFinTemplate());
        newTemplateModel.setCreateTime(TimeServiceHelper.now());
        newTemplateModel.setCreatorId(this.getUserId());
        newTemplateModel.setModifierId(this.getUserId());
        newTemplateModel.setModifyTime(TimeServiceHelper.now());
        newTemplateModel.setVersionStatus(templateModel.getVersionStatus());
        newTemplateModel.setDescription(templateModel.getDescription());
        newTemplateModel.setBeginTime(templateModel.getBeginTime());
        newTemplateModel.setEndTime(templateModel.getEndTime());
        newTemplateModel.setSaveByDim(templateModel.isSaveByDim());
        newTemplateModel.setTemplateCatalog(nohistryTemplate ? this.getTmplCatalog(Long.valueOf((String)this.getFormCustomParam("templatecatalog"))) : this.getTmplCatalog((Long)currentlist.get("templatecatalog")));
        newTemplateModel.setEffectiveDate(nohistryTemplate ? EntityVersioningUtil.getModelBeginDate((Object)((Long)this.getFormCustomParam("modelid"))) : null);
        if (!nohistryTemplate) {
            adjustEffectivedateTmpl.add(templateModel.getNumber());
        }
        BigDecimal max = maxversion.get(templateModel.getNumber());
        BigDecimal versionnumber = nohistryTemplate ? new BigDecimal(1) : (max == null ? ((BigDecimal)currentlist.get("versionnumber")).add(new BigDecimal(1)) : max.add(new BigDecimal(1)));
        maxversion.put(templateModel.getNumber(), versionnumber);
        newTemplateModel.setVersionNumber(versionnumber);
        if (newGroupId.get(templateModel.getNumber()) == null) {
            newGroupId.put(templateModel.getNumber(), nohistryTemplate ? Long.valueOf(GlobalIdUtil.genGlobalLongId()) : (Long)currentlist.get("group"));
        }
        newTemplateModel.setGroup(newGroupId.get(templateModel.getNumber()).longValue());
        newTemplateModel.setStatus("0");
        newTemplateModel.setVersionDescription(ResManager.loadResFormat((String)"\u5bfc\u5165\u751f\u6210\u3002%1", (String)"TemplateImportPlugin_20", (String)"epm-eb-budget", (Object[])new Object[]{templateModel.get("versiondescription") == null ? "" : templateModel.get("versiondescription")}));
        newTemplateModel.setExpiringDate(null);
        List viewpointMembEntryList = templateModel.getViewPointDimensionEntries();
        DynamicObjectCollection viewPointDimensionEntry = new DynamicObjectCollection();
        for (ViewPointDimensionEntry entry : viewpointMembEntryList) {
            DynamicObject dyn = entry.genDynamicObject();
            DynamicObject entryRow = new DynamicObject(dyn.getDynamicObjectType());
            entryRow.set("viewmembid", (Object)sysdimmember.get(entry.getDimension().getNumber()).get(entry.getMember().getNumber()));
            entryRow.set("viewdimension", (Object)sysdimension.get(entry.getDimension().getNumber()));
            entryRow.set("seq", dyn.get("seq"));
            viewPointDimensionEntry.add((Object)entryRow);
            if (!DimTypesEnum.SCENARIO.getNumber().equals(entry.getDimension().getNumber())) continue;
            this.getPageCache().put("convert2scenarioid" + Long.toString(newTemplateModel.getId()), sysdimmember.get(entry.getDimension().getNumber()).get(entry.getMember().getNumber()));
            this.getPageCache().put("convert2scenarionumber" + Long.toString(newTemplateModel.getId()), entry.getMember().getNumber());
        }
        newTemplateModel.getViewPointDimensionEntries().addAll(new ViewPointDimensionEntry(newTemplateModel).loadDynaObject(viewPointDimensionEntry, () -> newTemplateModel));
        List pageMembEntryList = templateModel.getPageDimensionEntries();
        DynamicObjectCollection pageMembEntry = new DynamicObjectCollection();
        for (PageDimensionEntry entry : pageMembEntryList) {
            List members = entry.getMembers();
            DynamicObject dyn = entry.genDynamicObject();
            if (members.size() > 0) {
                Iterator iterator = members.iterator();
                while (iterator.hasNext()) {
                    Member member = (Member)iterator.next();
                    DynamicObject entryRow = new DynamicObject(dyn.getDynamicObjectType());
                    entryRow.set("pagemembid", (Object)sysdimmember.get(entry.getDimension().getNumber()).get(member.getNumber()));
                    entryRow.set("pagedimension", (Object)sysdimension.get(entry.getDimension().getNumber()));
                    entryRow.set("seq", dyn.get("seq"));
                    entryRow.set("membbound", member.get("scope"));
                    pageMembEntry.add((Object)entryRow);
                }
                if (!DimTypesEnum.SCENARIO.getNumber().equals(entry.getDimension().getNumber())) continue;
                this.getPageCache().put("convert2scenarioid" + Long.toString(newTemplateModel.getId()), sysdimmember.get(entry.getDimension().getNumber()).get(((Member)members.get(0)).getNumber()));
                this.getPageCache().put("convert2scenarionumber" + Long.toString(newTemplateModel.getId()), ((Member)members.get(0)).getNumber());
                continue;
            }
            DynamicObject entryRow = new DynamicObject(dyn.getDynamicObjectType());
            entryRow.set("pagemembid", (Object)"");
            entryRow.set("pagedimension", (Object)sysdimension.get(entry.getDimension().getNumber()));
            entryRow.set("seq", dyn.get("seq"));
            entryRow.set("membbound", dyn.get("membbound"));
            pageMembEntry.add((Object)entryRow);
        }
        newTemplateModel.getPageDimensionEntries().addAll(new PageDimensionEntry(newTemplateModel).loadDynaObject(pageMembEntry, () -> newTemplateModel));
        List pageDimPropEntryList = templateModel.getPagePropEntries();
        DynamicObjectCollection pageProEntry = new DynamicObjectCollection();
        for (PageDimPropEntry entry : pageDimPropEntryList) {
            DynamicObject dyn = entry.genDynamicObject();
            AtomicInteger incrementer = new AtomicInteger(1);
            List membproperties = entry.getAllMembProperties();
            if (membproperties.size() <= 0) continue;
            for (Object membproperty : membproperties) {
                DynamicObject entryRow = new DynamicObject(dyn.getDynamicObjectType());
                entryRow.set("pagepropdim", (Object)sysdimension.get(entry.getDimension().getNumber()));
                entryRow.set("property", (Object)propertymap.get(membproperty.getCustomProperty().getNumber()));
                entryRow.set("seq", (Object)incrementer.getAndIncrement());
                entryRow.set("membprop", (Object)propertyValueDynamicObj.get(membproperty.getNumber()));
                entryRow.set("propbound", (Object)membproperty.getScope());
                pageProEntry.add((Object)entryRow);
            }
        }
        if (pageProEntry.size() > 0) {
            newTemplateModel.getPagePropEntries().addAll(new PageDimPropEntry(newTemplateModel).loadDynaObject(pageProEntry, () -> newTemplateModel));
        }
        List areaRangeEntryList = templateModel.getAreaRangeEntries();
        for (AreaRangeEntry area : areaRangeEntryList) {
            DynamicObject entryrow;
            AreaRangeEntry newAreaRangeEntry = new AreaRangeEntry(newTemplateModel);
            newAreaRangeEntry.setAreaRange(area.getAreaRange());
            newAreaRangeEntry.setStartPosition(area.getStartPosition());
            newAreaRangeEntry.setSeq(area.getSeq());
            List colDimensionEntryList = area.getColDimEntries();
            DynamicObjectCollection colsEntry = new DynamicObjectCollection();
            for (ColDimensionEntry colEntry : colDimensionEntryList) {
                List members = colEntry.getMembers();
                AtomicInteger incrementer = new AtomicInteger(1);
                DynamicObject col = colEntry.genDynamicObject();
                if (members.size() == 0) {
                    DynamicObject entryrow2 = new DynamicObject(col.getDynamicObjectType());
                    entryrow2.set("colmembid", (Object)"");
                    entryrow2.set("coldimension", (Object)sysdimension.get(colEntry.getDimension().getNumber()));
                    entryrow2.set("seq", (Object)incrementer.getAndIncrement());
                    entryrow2.set("colgroup", col.get("colgroup"));
                    entryrow2.set("header", col.get("header"));
                    entryrow2.set("colindex", col.get("colindex"));
                    entryrow2.set("displaychild", col.get("displaychild"));
                    colsEntry.add((Object)entryrow2);
                    continue;
                }
                for (Member member : members) {
                    entryrow = new DynamicObject(col.getDynamicObjectType());
                    entryrow.set("colmembid", (Object)sysdimmember.get(colEntry.getDimension().getNumber()).get(member.getNumber()));
                    entryrow.set("coldimension", (Object)sysdimension.get(colEntry.getDimension().getNumber()));
                    entryrow.set("seq", (Object)incrementer.getAndIncrement());
                    entryrow.set("colgroup", col.get("colgroup"));
                    entryrow.set("header", col.get("header"));
                    entryrow.set("colindex", col.get("colindex"));
                    entryrow.set("displaychild", col.get("displaychild"));
                    colsEntry.add((Object)entryrow);
                }
            }
            newAreaRangeEntry.getColDimEntries().addAll(new ColDimensionEntry(newAreaRangeEntry).loadDynaObject(colsEntry, () -> newAreaRangeEntry));
            List rowDimensionEntryList = area.getRowDimEntries();
            DynamicObjectCollection rowsEntry = new DynamicObjectCollection();
            for (RowDimensionEntry rowEntry : rowDimensionEntryList) {
                List members = rowEntry.getMembers();
                AtomicInteger incrementer = new AtomicInteger(1);
                DynamicObject row = rowEntry.genDynamicObject();
                if (members.size() == 0) {
                    entryrow = new DynamicObject(row.getDynamicObjectType());
                    entryrow.set("rowmembid", (Object)"");
                    entryrow.set("rowdimension", (Object)sysdimension.get(rowEntry.getDimension().getNumber()));
                    entryrow.set("seq", (Object)incrementer.getAndIncrement());
                    entryrow.set("rowmembscope", row.get("rowmembscope"));
                    rowsEntry.add((Object)entryrow);
                    continue;
                }
                for (Member member : members) {
                    DynamicObject entryrow3 = new DynamicObject(row.getDynamicObjectType());
                    entryrow3.set("rowmembid", (Object)sysdimmember.get(rowEntry.getDimension().getNumber()).get(member.getNumber()));
                    entryrow3.set("rowdimension", (Object)sysdimension.get(rowEntry.getDimension().getNumber()));
                    entryrow3.set("seq", (Object)incrementer.getAndIncrement());
                    entryrow3.set("rowmembscope", member.get("scope"));
                    rowsEntry.add((Object)entryrow3);
                }
            }
            newAreaRangeEntry.getRowDimEntries().addAll(new RowDimensionEntry(newAreaRangeEntry).loadDynaObject(rowsEntry, () -> newAreaRangeEntry));
            newTemplateModel.getAreaRangeEntries().add(newAreaRangeEntry);
        }
        return newTemplateModel;
    }

    private String getCopyName(String name, Set<String> nameset, int i) {
        if (nameset.contains(name)) {
            if (name.length() > 56) {
                name = name.substring(0, 39);
                name = name + "copy" + i;
            } else {
                char ss = name.charAt(name.length() - 1);
                try {
                    Integer.parseInt(String.valueOf(ss));
                    name = name.substring(0, name.length() - 1) + i;
                }
                catch (NumberFormatException e) {
                    name = name + i;
                }
            }
            return this.getCopyName(name, nameset, i + 1);
        }
        nameset.add(name);
        return name;
    }

    private String getData(String data, Map<String, DynamicObject> sysdimension, Map<String, Map<String, String>> sysdimmember) {
        SpreadManager sm = JsonSerializerUtil.toSpreadManager((String)data);
        for (PositionInfo e : sm.getAreaManager().getPostionInfoSet()) {
            List basepoints = e.getBasePoints();
            for (BasePointInfo basepoint : basepoints) {
                List lines = basepoint.getBasePointInnerLineInfo();
                lines.forEach(line -> {
                    List scopes = line.getDynaMembScopes();
                    ArrayList newscopes = new ArrayList();
                    scopes.forEach(scope -> {
                        String dimensionNumer = scope.getMember().getDimension().getNumber();
                        String memberNumber = scope.getMember().getNumber();
                        kd.epm.eb.ebSpread.model.Dimension dimension = new kd.epm.eb.ebSpread.model.Dimension(((DynamicObject)sysdimension.get(dimensionNumer)).getString("name"), dimensionNumer, ((DynamicObject)sysdimension.get(dimensionNumer)).getString("membermodel"));
                        DimMember member = new DimMember(scope.getMember().getName(), scope.getMember().getNumber(), null, (IDimension)dimension);
                        String memberId = (String)((Map)sysdimmember.get(dimensionNumer)).get(memberNumber);
                        if (memberId != null) {
                            member.setId(Long.parseLong(memberId));
                        }
                        newscopes.add(new DynaMembScopeInfo((IDimMember)member, scope.getRange(), scope.isCustom()));
                    });
                    line.setDynaMembScopes(newscopes);
                    if (line.getMemberAddOf() != null) {
                        DimMember member = new DimMember(line.getMemberAddOf().getName(), line.getMemberAddOf().getNumber(), null, line.getMemberAddOf().getDimension());
                        String memberId = (String)((Map)sysdimmember.get(line.getMemberAddOf().getDimension().getNumber())).get(line.getMemberAddOf().getNumber());
                        if (memberId != null) {
                            member.setId(Long.parseLong(memberId));
                        }
                        line.setMemberAddOf((IDimMember)member);
                    }
                });
            }
        }
        return JsonSerializerUtil.toJson((SpreadManager)sm);
    }

    private Map<String, String> getDimensions(Long modelid) {
        QFilter qf = new QFilter("model", "=", (Object)modelid);
        QFilter[] qfs = new QFilter[]{qf};
        DynamicObjectCollection dcs = QueryServiceHelper.query((String)"epm_dimension", (String)"number, membermodel", (QFilter[])qfs);
        HashMap<String, String> map = new HashMap<String, String>();
        dcs.forEach(p -> map.put(p.getString("number"), p.getString("membermodel")));
        return map;
    }

    private Map<String, DynamicObject> getSysProperty(Long modelid) {
        QFilter qf = new QFilter("model", "=", (Object)modelid);
        QFilter[] qfs = new QFilter[]{qf};
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>();
        return map;
    }

    private Map<String, Set<String>> getMembersNumber(Long modelid, Map<String, String> dimNumbers) {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>(16);
        QFilter qf = new QFilter("model", "=", (Object)modelid);
        QFilter[] qfs = new QFilter[]{qf};
        for (Map.Entry<String, String> entry : dimNumbers.entrySet()) {
            DynamicObjectCollection dcs = QueryServiceHelper.query((String)entry.getValue(), (String)"number", (QFilter[])qfs);
            HashSet numbers = new HashSet();
            dcs.forEach(p -> numbers.add(p.getString("number")));
            map.put(entry.getKey(), numbers);
        }
        return map;
    }

    private Map<String, Set<String>> getPropertyValues(Long modelid) {
        HashMap<String, Set<String>> propertyValues = new HashMap<String, Set<String>>();
        return propertyValues;
    }

    private Map<String, DynamicObject> getPropertyValueDynamicObj(Long modelid) {
        HashMap<String, DynamicObject> propertyValues = new HashMap<String, DynamicObject>();
        return propertyValues;
    }

    private TemplateCatalog getTmplCatalog(Long templatecatalogid) {
        TemplateCatalog catalog = new TemplateCatalog();
        DynamicObject dyna = BusinessDataServiceHelper.loadSingle((Object)templatecatalogid, (String)"eb_templatecatalog_bg");
        catalog.setId(dyna.getLong("id"));
        catalog.setName(dyna.getString("name"));
        return catalog;
    }

    private Map<String, Map<String, Object>> getNeedExchangeFields(long modelid, TemplateModel[] templateModels) {
        String[] templatesNumber = new String[templateModels.length];
        for (int i = 0; i < templateModels.length; ++i) {
            templatesNumber[i] = templateModels[i].getNumber();
        }
        QFilter qfnumber = new QFilter("number", "in", (Object)templatesNumber);
        QFilter modelFilter = new QFilter("model", "=", (Object)modelid);
        DynamicObjectCollection numberCol = QueryServiceHelper.query((String)"eb_templateentity_bg", (String)"id, number, versionnumber, group, templatecatalog", (QFilter[])new QFilter[]{qfnumber, modelFilter});
        HashMap<String, Map<String, Object>> needExchangeFields = new HashMap<String, Map<String, Object>>();
        numberCol.forEach(e -> {
            if (needExchangeFields.get(e.getString("number")) == null) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("versionnumber", e.get("versionnumber"));
                map.put("group", e.get("group"));
                map.put("templatecatalog", e.get("templatecatalog"));
                map.put("id", e.get("id"));
                needExchangeFields.put(e.getString("number"), map);
            } else if (e.getBigDecimal("versionnumber").compareTo((BigDecimal)((Map)needExchangeFields.get(e.getString("number"))).get("versionnumber")) > 0) {
                ((Map)needExchangeFields.get(e.getString("number"))).put("versionnumber", e.get("versionnumber"));
                ((Map)needExchangeFields.get(e.getString("number"))).put("id", e.get("id"));
            }
        });
        return needExchangeFields;
    }

    private Map<Long, String> getDPropertyMap(long modelid) {
        QFilter modelFilter = new QFilter("model", "=", (Object)modelid);
        HashMap<Long, String> propertyMap = new HashMap<Long, String>();
        return propertyMap;
    }

    public void upload(UploadEvent evt) {
        for (Object url : evt.getUrls()) {
            this.getPageCache().put("file_url", (String)((Map)url).get("url"));
        }
    }
}

