/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.budget.formplugin.template.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.budget.formplugin.batch.BatchQueryHelper;
import kd.epm.eb.budget.formplugin.batch.IQuery;
import kd.epm.eb.budget.formplugin.spread.SpreadEasyInvoker;
import kd.epm.eb.budget.formplugin.template.multiview.TempFormulaUtil;
import kd.epm.eb.budget.formplugin.template.util.TemplateFloatUtil;
import kd.epm.eb.budget.formplugin.util.ObjectConvertUtils;
import kd.epm.eb.budget.formplugin.util.RegexUtils;
import kd.epm.eb.common.ebcommon.common.Pair;
import kd.epm.eb.common.ebcommon.common.enums.DimEntityNumEnum;
import kd.epm.eb.common.ebcommon.common.enums.StorageTypeEnum;
import kd.epm.eb.common.ebcommon.common.util.ExcelUtils;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.ebBusiness.serviceHelper.QueryDimensionServiceHelper;
import kd.epm.eb.ebBusiness.template.model.AreaRangeEntry;
import kd.epm.eb.ebBusiness.template.model.MembSettingBaseDetail;
import kd.epm.eb.ebBusiness.template.model.TemplateModel;
import kd.epm.eb.ebBusiness.template.model.ViewPointDimensionEntry;
import kd.epm.eb.ebBusiness.util.SerialSpliter;
import kd.epm.eb.ebSpread.domain.view.Sheet;
import kd.epm.eb.ebSpread.domain.view.SpreadManager;
import kd.epm.eb.ebSpread.model.IDimMember;

public class TemplateScanMemberService {
    private SpreadManager sm;
    private TemplateModel template;
    private List<Map<String, Object>> cellValues;
    private HashMap<String, Pair<Long, Object>> dimAndMem = new HashMap();

    public HashMap<String, Pair<Long, Object>> getDimAndMem() {
        return this.dimAndMem;
    }

    public TemplateScanMemberService(SpreadManager sm, TemplateModel template) {
        this.sm = sm;
        this.template = template;
    }

    public List<Map<String, Object>> getCellValues() {
        if (this.cellValues == null) {
            this.cellValues = new ArrayList<Map<String, Object>>();
        }
        return this.cellValues;
    }

    public void scan() {
        this.sm.getAreaManager().getPostionInfoSet().forEach(e -> {
            int[] dataxy = ExcelUtils.pos2XY((String)e.getStartPosition());
            int[] endxy = ExcelUtils.pos2XY((String)e.getAreaRange().split(":")[1]);
            int srow = this.template.isOldTemplate() ? dataxy[1] - 1 : dataxy[1];
            int scol = this.template.isOldTemplate() ? dataxy[0] - 1 : dataxy[0];
            int erow = endxy[1];
            int ecol = endxy[0];
            AreaRangeEntry ar = this.getOverlapAreaRange(e.getStartPosition() + ":" + e.getStartPosition());
            if (ar == null) {
                return;
            }
            List<List<String>> members = this.scanDimMemberInfo(srow, scol, erow, ecol, true, ar);
            this.handleQuery(members, ar, true);
            members = this.scanDimMemberInfo(srow, scol, erow, ecol, false, ar);
            this.handleQuery(members, ar, false);
        });
    }

    private AreaRangeEntry getOverlapAreaRange(String tarArea) {
        for (AreaRangeEntry e : this.template.getAreaRangeEntries()) {
            if (!ExcelUtils.isOverlap((String)e.getAreaRange(), (String)tarArea)) continue;
            return e;
        }
        return null;
    }

    private List<List<String>> scanDimMemberInfo(int srow, int scol, int erow, int ecol, boolean isScanRow, AreaRangeEntry ar) {
        ArrayList<List<String>> items = new ArrayList<List<String>>();
        int from = isScanRow ? srow : scol;
        int end = isScanRow ? erow : ecol;
        List membDetail = isScanRow ? ar.getRowDimEntries() : ar.getColDimEntries();
        for (int c = from; c <= end; ++c) {
            List members = this.getEffectiveSheet().getCell(isScanRow ? c : srow, isScanRow ? scol : c).getMemberFromUserObject();
            if (members == null || members.isEmpty()) continue;
            ArrayList<String> item = new ArrayList<String>(members.size());
            for (IDimMember m : members) {
                boolean isInclude = membDetail.stream().anyMatch(p -> m.getDimension().getNumber().equals(p.getDimension().getNumber()));
                if (!isInclude) continue;
                item.add(m.getNumber());
            }
            if (item.isEmpty()) continue;
            items.add(item);
        }
        if (!this.template.isOldTemplate()) {
            this.getEffectiveSheet().iteratorRangeCells(srow, erow, scol, ecol, cell -> {
                String serial;
                if (cell.isMdDataDomain() && ((Boolean)cell.getUserObject("not_cross", (Object)false)).booleanValue() && StringUtils.isNotEmpty((String)(serial = (String)cell.getUserObject("cross_nums", (Object)"")))) {
                    SerialSpliter spliter = new SerialSpliter(serial);
                    ArrayList item2 = new ArrayList(membDetail.size());
                    spliter.getPairs().forEach(p -> {
                        boolean isInclude = membDetail.stream().anyMatch(d -> ((String)p.p1).equals(d.getDimension().getNumber()));
                        if (isInclude) {
                            item2.add(p.p2);
                        }
                    });
                    if (!item2.isEmpty()) {
                        items.add(item2);
                    }
                }
            });
        }
        return items;
    }

    private Sheet getEffectiveSheet() {
        return this.sm.getBook().getSheet(0);
    }

    private void handleQuery(List<List<String>> members, AreaRangeEntry ar, boolean isRowDim) {
        BatchQueryHelper<String, String, DynamicObject[]> query = new BatchQueryHelper<String, String, DynamicObject[]>();
        if (!members.isEmpty()) {
            String[] entityNums = new String[isRowDim ? ar.getRowDimEntries().size() : ar.getColDimEntries().size()];
            int index = 0;
            for (MembSettingBaseDetail cd : isRowDim ? ar.getRowDimEntries() : ar.getColDimEntries()) {
                entityNums[index++] = cd.getDimension().getMemberEntityNumber();
            }
            members.forEach(l -> {
                if (l.size() == entityNums.length) {
                    int idx = 0;
                    for (String n : entityNums) {
                        query.addQueryItem(n, (String)l.get(idx++));
                    }
                }
            });
            query.doQuery(new IQuery<String, String, DynamicObject[]>(){

                @Override
                public DynamicObject[] query(String k, Set<String> v) {
                    QFilter filtNum = new QFilter("number", "in", v);
                    QFilter filtshare = new QFilter("storagetype", "!=", (Object)StorageTypeEnum.SHARE.index);
                    QFilter filtModel = TemplateScanMemberService.this.getQFilterByModelID();
                    return BusinessDataServiceHelper.load((String)k, (String)"id,name,number,member,dimension.id,dimension.number,dimension.membermodel,dimension.dseq", (QFilter[])new QFilter[]{filtNum.and(filtModel).and(filtshare)}, null);
                }
            }, (coll, k) -> {
                for (MembSettingBaseDetail cd : isRowDim ? ar.getRowDimEntries() : ar.getColDimEntries()) {
                    if (!cd.getDimension().getMemberEntityNumber().equals(k)) continue;
                    cd.getMembers().clear();
                    for (DynamicObject m : coll) {
                        cd.getMembers().add(ObjectConvertUtils.toMember(m));
                        this.dimAndMem.put(m.getString("dimension.number") + "_" + m.getString("number"), (Pair<Long, Object>)Pair.onePair((Object)m.getLong("id"), (Object)m.getDynamicObject("dimension")));
                    }
                }
            });
        }
    }

    private QFilter getQFilterByModelID() {
        return new QFilter("model", "=", (Object)this.template.getModelId());
    }

    public void updaterule(SpreadManager spreadCopy) {
        QFilter filter = new QFilter("template", "=", (Object)this.template.getId());
        QFilter filter2 = new QFilter("org", "=", (Object)0);
        BusinessDataWriter.delete((String)"eb_intergration_entity", (QFilter[])new QFilter[]{filter, filter2});
        if (spreadCopy.getAreaManager().getPostionInfoSet().size() <= 0) {
            return;
        }
        List<DynamicObject> ruleList = this.getRulelist(spreadCopy);
        if (ruleList.size() != 0) {
            Object[] ruleListColls = new Object[ruleList.size()];
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"eb_intergration_entity");
            BusinessDataWriter.save((IDataEntityType)dynamicObject.getDynamicObjectType(), (Object[])ruleList.toArray(ruleListColls));
        }
    }

    private List<DynamicObject> getRulelist(SpreadManager spreadCopy) {
        int dimnum = 0;
        if (this.template.getAreaRangeEntries().size() > 0) {
            dimnum = ((AreaRangeEntry)this.template.getAreaRangeEntries().get(0)).getColDimEntries().size() + ((AreaRangeEntry)this.template.getAreaRangeEntries().get(0)).getRowDimEntries().size();
        }
        int num = this.getFirstUserdefinedDimDseq(this.template.getModelId());
        List<Pair<String, Long>> viewpairs = this.doViewPrepare(num);
        ArrayList<DynamicObject> ruleList = new ArrayList<DynamicObject>();
        int finalDimnum = dimnum;
        spreadCopy.getBook().getSheet(0).iteratorCells(cell -> {
            String errormsg;
            String formula;
            Map<String, String> floatmsg = TemplateFloatUtil.getFloatAreaforAcct(cell.getRow(), cell.getCol(), spreadCopy);
            String area = "";
            if (floatmsg != null) {
                area = floatmsg.get("area");
            }
            if ((cell.isMdDataDomain() || StringUtils.isNotEmpty((String)area)) && cell.hasFormula() && TempFormulaUtil.checkFormulaExits(formula = cell.getFormula()) && ((errormsg = this.doCheckAcct(formula)) == null || errormsg.equals(""))) {
                DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"eb_intergration_entity");
                dynamicObject.set("template", (Object)this.template.getId());
                dynamicObject.set("modifyid", (Object)UserUtils.getUserId());
                dynamicObject.set("modifytime", (Object)TimeServiceHelper.now());
                dynamicObject.set("datafrom", (Object)("=" + formula));
                StringBuilder dimKey = new StringBuilder();
                StringBuilder membKey = new StringBuilder();
                for (Pair pair : viewpairs) {
                    dynamicObject.set((String)pair.p1, pair.p2);
                }
                int count = 0;
                if (cell.getMemberFromUserObject() != null && cell.getMemberFromUserObject().size() == finalDimnum) {
                    if (formula.contains("@")) {
                        this.getCellValues().add(SpreadEasyInvoker.packedFormulaCellMap(cell.getRow(), cell.getCol(), ""));
                        return;
                    }
                    cell.getMemberFromUserObject().forEach(m -> {
                        Pair<Long, Object> rowPair = this.dimAndMem.get(m.getDimension().getNumber() + "_" + m.getNumber());
                        this.fillMember(dynamicObject, rowPair, num);
                        membKey.append(m.getNumber()).append('|');
                        dimKey.append(m.getDimension().getNumber()).append('|');
                    });
                } else if (floatmsg != null) {
                    for (Map.Entry<String, String> entry : floatmsg.entrySet()) {
                        String key = entry.getKey();
                        String value = entry.getValue();
                        if ("area".equals(key)) {
                            dynamicObject.set("floatarea", (Object)value);
                            continue;
                        }
                        if ("floatindex".equals(key)) {
                            dynamicObject.set("floatindex", (Object)value);
                            continue;
                        }
                        if (!"@".equals(value)) {
                            Pair rowPair = this.dimAndMem.get(key + "_" + value);
                            if (rowPair == null) {
                                String entitynumber = DimEntityNumEnum.getEntieyNumByNumber((String)key);
                                if (StringUtils.isEmpty((String)entitynumber)) {
                                    entitynumber = "epm_userdefinedmembertree";
                                }
                                DynamicObject m2 = QueryDimensionServiceHelper.getMemberMsgByNumber((long)this.template.getModelId(), (String)value, (String)entitynumber);
                                m2 = BusinessDataServiceHelper.loadSingle((Object)m2.getLong("id"), (String)entitynumber, (String)"id,dimension");
                                rowPair = Pair.onePair((Object)m2.getLong("id"), (Object)m2.getDynamicObject("dimension"));
                            }
                            this.fillMember(dynamicObject, rowPair, num);
                        } else {
                            ++count;
                        }
                        membKey.append(value).append('|');
                        dimKey.append(key).append('|');
                    }
                }
                dynamicObject.set("dimKey", (Object)dimKey);
                dynamicObject.set("membKey", (Object)membKey);
                ruleList.add(dynamicObject);
            }
        });
        return ruleList;
    }

    private String doCheckAcct(String formulaStr) {
        List<String> formulaList = RegexUtils.regexMatch(formulaStr, "ACCT\\(.*?\\)");
        for (String formula : formulaList) {
            int index1 = formula.indexOf(40);
            int index2 = formula.indexOf(41);
            formulaStr = formula.substring(index1 + 1, index2);
            String[] params = formula.split(",");
            if (params.length == 8 && params[2].contains("[") && params[3].contains("]")) {
                return null;
            }
            if (params.length == 7) continue;
            return ResManager.loadKDString((String)"\u516c\u5f0f\u5b57\u7b26\u4e32\u53c2\u6570\u5e94\u8be5\u4e3a7\u4e2a\u3002", (String)"TemplateScanMemberService_0", (String)"epm-eb-budget", (Object[])new Object[0]);
        }
        return null;
    }

    private int getFirstUserdefinedDimDseq(Long modelid) {
        QFilter modelfilter = new QFilter("model", "=", (Object)modelid);
        QFilter sysdimfilter = new QFilter("issysdimension", "=", (Object)false);
        DynamicObjectCollection colls = QueryServiceHelper.query((String)"epm_dimension", (String)"id,model,issysdimension,dseq", (QFilter[])new QFilter[]{modelfilter, sysdimfilter}, (String)"dseq");
        if (colls.size() > 0) {
            return ((DynamicObject)colls.get(0)).getInt("dseq");
        }
        return 0;
    }

    private List<Pair<String, Long>> doViewPrepare(int num) {
        List viewmembers = this.template.getViewPointDimensionEntries();
        ArrayList<Pair<String, Long>> viewpairs = new ArrayList<Pair<String, Long>>();
        ArrayList<Long> userdefinedid = new ArrayList<Long>();
        for (ViewPointDimensionEntry viewPoint : viewmembers) {
            String memberentity = viewPoint.getMember().getDimension().getMemberEntityNumber();
            if ("epm_userdefinedmembertree".equals(memberentity)) {
                userdefinedid.add(viewPoint.getMember().getId());
                continue;
            }
            viewpairs.add((Pair<String, Long>)Pair.onePair((Object)viewPoint.getMember().getDimension().getNumber(), (Object)viewPoint.getMember().getId()));
        }
        if (userdefinedid.size() != 0) {
            QFilter filter = new QFilter("id", "in", userdefinedid);
            DynamicObjectCollection userdefineds = QueryServiceHelper.query((String)"epm_userdefinedmembertree", (String)"id,dimension.id,dimension.fieldmapped", (QFilter[])new QFilter[]{filter}, null);
            for (DynamicObject userdefined : userdefineds) {
                viewpairs.add((Pair<String, Long>)Pair.onePair((Object)userdefined.getString("dimension.fieldmapped"), (Object)userdefined.getLong("id")));
            }
        }
        return viewpairs;
    }

    private void fillMember(DynamicObject dynamicObject, Pair<Long, Object> pair, int num) {
        if (pair == null) {
            return;
        }
        DynamicObject dim = (DynamicObject)pair.p2;
        if ("epm_userdefinedmembertree".equals(dim.getString("membermodel"))) {
            dynamicObject.set("dim" + (dim.getInt("dseq") - num + 1), pair.p1);
        } else {
            dynamicObject.set(dim.getString("number").toLowerCase(), pair.p1);
        }
    }
}

