/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.budget.formplugin.tree;

import java.util.ArrayList;
import java.util.List;
import kd.epm.eb.budget.formplugin.tree.ITreeNode;

public abstract class AbstractTreeNode<T>
implements ITreeNode<T> {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected String name;
    protected ITreeNode<T> parent;
    protected List<ITreeNode<T>> children = new ArrayList<ITreeNode<T>>();
    private T userData;
    private boolean isOpened = false;

    public AbstractTreeNode(String id, String name) {
        this(id, name, null);
    }

    public AbstractTreeNode(String id, String name, ITreeNode<T> parent) {
        this.id = id;
        this.name = name;
        this.parent = parent;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public T getData() {
        return this.userData;
    }

    public void setData(T userData) {
        this.userData = userData;
    }

    @Override
    public ITreeNode<T> getParent() {
        return this.parent;
    }

    @Override
    public void setParent(ITreeNode<T> parent) {
        this.parent = parent;
    }

    @Override
    public List<ITreeNode<T>> getChildren() {
        return this.children;
    }

    @Override
    public void addChild(ITreeNode<T> child) {
        this.children.add(child);
        child.setParent(this);
    }

    @Override
    public boolean removeChild(ITreeNode<T> child) {
        return this.children.removeIf(p -> child.getId().equals(p.getId()));
    }

    @Override
    public boolean isOpened() {
        return this.isOpened;
    }

    public void SetIsOpened(boolean isOpened) {
        this.isOpened = isOpened;
    }

    @Override
    public boolean removeAll() {
        this.children = new ArrayList<ITreeNode<T>>();
        return true;
    }

    @Override
    public boolean addAllChild(List<ITreeNode<T>> children) {
        return this.children.addAll(children);
    }
}

