/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.budget.formplugin.tree;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.bos.util.StringUtils;
import kd.epm.eb.budget.formplugin.tree.ITreeNode;
import kd.epm.eb.budget.formplugin.tree.report.OrgTreeNode;
import kd.epm.eb.budget.formplugin.tree.report.TreeBuilder;
import kd.epm.eb.common.ebcommon.common.Recorder;
import kd.epm.eb.common.ebcommon.common.util.ObjectSerialUtil;

public class TreeModel<E extends ITreeNode<?>>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private E root;
    private Map<String, ITreeNode<?>> dict = new HashMap();
    private boolean isBuiltDict = false;

    public TreeModel(E root) {
        Objects.requireNonNull(root);
        this.root = root;
    }

    public E getRoot() {
        return this.root;
    }

    public E searchByNodeId(String nodeId) {
        if (!this.isBuiltDict) {
            this.buildNodeDictionary();
        }
        return (E)this.dict.get(nodeId);
    }

    private void buildNodeDictionary() {
        this.cycleIterateNode((ITreeNode<?>)this.root);
        this.isBuiltDict = true;
    }

    private void cycleIterateNode(ITreeNode<?> node) {
        this.dict.put(node.getId(), node);
        for (ITreeNode<?> n : node.getChildren()) {
            this.cycleIterateNode(n);
        }
    }

    public List<E> seekAllChildrenIf(String pNodeId, Predicate<E> p) {
        E node = this.searchByNodeId(pNodeId);
        this.checkNode((ITreeNode<?>)node, pNodeId);
        Recorder r = new Recorder(new ArrayList());
        if (p.test(this.root)) {
            ((List)r.getRecord()).add(this.root);
        }
        this.cycleSeekAllNodes((ITreeNode<?>)node, p, (Recorder<List<E>>)r);
        return (List)r.getRecord();
    }

    private void cycleSeekAllNodes(ITreeNode<?> node, Predicate<E> p, Recorder<List<E>> r) {
        node.getChildren().forEach(t -> {
            if (p.test(t)) {
                ((List)r.getRecord()).add(t);
            }
            this.cycleSeekAllNodes((ITreeNode<?>)t, p, r);
        });
    }

    private void checkNode(ITreeNode<?> node, String nodeId) {
        if (node == null) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u8282\u70b9ID\u201c%1\u201d\u5728\u6811\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"TreeModel_0", (String)"epm-eb-budget", (Object[])new Object[]{nodeId}));
        }
    }

    public TreeNode buildEntryTree(TreeView tree) {
        if (!this.isBuiltDict) {
            this.buildNodeDictionary();
        }
        tree.deleteAllNodes();
        TreeNode troot = new TreeNode();
        this.cloneTreeNode(true, troot, (ITreeNode<?>)this.root);
        tree.addNode(troot);
        return troot;
    }

    private void cloneTreeNode(boolean isRoot, TreeNode parentNode, ITreeNode<?> currNode) {
        TreeNode pNode = parentNode;
        if (isRoot) {
            parentNode.setId(currNode.getId());
            parentNode.setText(currNode.getName());
            if (currNode instanceof OrgTreeNode) {
                parentNode.setType(((OrgTreeNode)currNode).getStoragetype());
            }
            parentNode.setIsOpened(currNode.isOpened());
            if (!currNode.isLeaf()) {
                parentNode.setChildren(new ArrayList());
            }
        } else {
            TreeNode child = new TreeNode(parentNode.getId(), currNode.getId(), currNode.getName(), !currNode.isLeaf());
            if (child.getId().contains(TreeBuilder.LOADMORE)) {
                child.setColor("#2E2EFE");
            }
            if (currNode instanceof OrgTreeNode) {
                child.setType(((OrgTreeNode)currNode).getStoragetype());
            }
            child.setIsOpened(currNode.isOpened());
            parentNode.addChild(child);
            pNode = child;
        }
        for (ITreeNode<?> c : currNode.getChildren()) {
            this.cloneTreeNode(false, pNode, c);
        }
    }

    public void ache2page(IPageCache cache, String pagecachekey) {
        cache.put(pagecachekey, ObjectSerialUtil.toByteSerialized((Object)this));
    }

    public static TreeModel<?> toTreeModel(IPageCache cache, String pagecachekey) {
        return (TreeModel)ThreadCache.get((Object)pagecachekey, () -> {
            String serial = cache.get(pagecachekey);
            if (StringUtils.isNotEmpty((String)serial)) {
                return (TreeModel)ObjectSerialUtil.deSerializedBytes((String)serial);
            }
            return null;
        });
    }

    public Map<String, ITreeNode<?>> getDict() {
        return this.dict;
    }
}

