/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.budget.formplugin.tree.report;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.budget.formplugin.report.ReportListPlugin;
import kd.epm.eb.budget.formplugin.tree.AbstractTreeNode;
import kd.epm.eb.budget.formplugin.tree.ITreeNode;
import kd.epm.eb.budget.formplugin.tree.report.OrgTreeNode;
import kd.epm.eb.budget.formplugin.tree.report.TemplateTreeNode;
import kd.epm.eb.budget.formplugin.util.TemplateUtil;

public class TreeBuilder {
    public static String LOADMORE = "_loadmore";

    public static OrgTreeNode getOrgTree(DynamicObjectCollection rootNodeList, OrgTreeNode root, String showType) {
        return TreeBuilder.getOrgTreeRoot(rootNodeList, showType, false);
    }

    public static OrgTreeNode getOrgCslTree(DynamicObjectCollection rootNodeList, String showType, boolean isCsl) {
        return TreeBuilder.getOrgTreeRoot(rootNodeList, showType, isCsl);
    }

    private static OrgTreeNode getOrgTreeRoot(DynamicObjectCollection rootNodeList, String showType, boolean isCsl) {
        HashMap<String, List<DynamicObject>> nodeMap = new HashMap<String, List<DynamicObject>>();
        for (int i = 0; i < rootNodeList.size(); ++i) {
            DynamicObject node = (DynamicObject)rootNodeList.get(i);
            String parentId = node.getString("parent.id");
            ArrayList<DynamicObject> list = (ArrayList<DynamicObject>)nodeMap.get(parentId);
            if (list == null) {
                list = new ArrayList<DynamicObject>();
                nodeMap.put(parentId, list);
            }
            list.add(node);
        }
        DynamicObject rootNode = null;
        if (nodeMap.get("0") != null) {
            rootNode = (DynamicObject)((List)nodeMap.get("0")).get(0);
        }
        if (rootNode == null && nodeMap.get(null) != null) {
            rootNode = (DynamicObject)((List)nodeMap.get(null)).get(0);
        }
        if (rootNode == null) {
            return null;
        }
        return TreeBuilder.createNode(rootNode, null, nodeMap, showType, isCsl);
    }

    private static OrgTreeNode createNode(DynamicObject map, OrgTreeNode parentNode, Map<String, List<DynamicObject>> nodeMap, String showType, boolean isCsl) {
        String id = map.getString("id");
        String name = map.getString("name");
        String number = map.getString("number");
        String storageType = map.getString("storagetype");
        String orgcode = map.getString("orgcode");
        String formatName = TreeBuilder.formatDisplayName(showType, name, number, orgcode);
        OrgTreeNode curNode = new OrgTreeNode(id, formatName, number, storageType, formatName);
        List<DynamicObject> list = nodeMap.get(id);
        curNode.SetIsOpened(true);
        if (parentNode != null) {
            curNode.setParent(parentNode);
            parentNode.addChild(curNode);
        }
        if (list != null) {
            for (DynamicObject dnm : list) {
                if (isCsl && dnm.getBoolean("isLeaf")) continue;
                TreeBuilder.createNode(dnm, curNode, nodeMap, showType, isCsl);
            }
            curNode.setName(curNode.getFinalname() + "(" + curNode.getChildSize() + ")");
        }
        return curNode;
    }

    public static String formatDisplayName(String showType, String name, String number, String currencyName) {
        String formatName = name;
        switch (showType = StringUtils.isEmpty((String)showType) ? "3" : showType) {
            case "2": {
                formatName = StringUtils.isNotEmpty((String)currencyName) ? name + " " + currencyName : name;
                break;
            }
            case "3": {
                formatName = number + " " + name;
                break;
            }
            case "4": {
                formatName = StringUtils.isNotEmpty((String)currencyName) ? number + " " + name + " " + currencyName : name;
            }
        }
        return formatName;
    }

    public static TemplateTreeNode getTemplateTreeNew(DynamicObjectCollection templatecatalogList, TemplateTreeNode root, ITemplateQuery query, String showType, ITemplateCollectionFilter tmplFilter) {
        Optional optional;
        Collection result = BusinessDataServiceHelper.loadFromCache((String)"eb_templateentity_bg", (String)query.getSelector(), (QFilter[])query.getFilter(), (String)query.getOrder()).values();
        DynamicObject any = null;
        if (!result.isEmpty() && (optional = result.stream().findAny()).isPresent()) {
            any = (DynamicObject)optional.get();
        }
        DynamicObjectCollection templateColls = any != null ? new DynamicObjectCollection(any.getDynamicObjectType(), any) : new DynamicObjectCollection();
        templateColls.addAll(result);
        TemplateUtil.filterVersionTemplateTree((Collection<DynamicObject>)templateColls);
        if (tmplFilter != null) {
            tmplFilter.filter(templateColls);
        }
        return TreeBuilder.getTemplateCatalogTreeRoot(false, templatecatalogList, root, templateColls, showType);
    }

    private static TemplateTreeNode getTemplateCatalogTreeRoot(boolean ishaveroot, DynamicObjectCollection templatecatalogList, TemplateTreeNode parent, DynamicObjectCollection templateColls, String showType) {
        for (DynamicObject map : templatecatalogList) {
            if (!ishaveroot) {
                if (!map.getString("parent").equals("0")) continue;
                parent = new TemplateTreeNode(map.getString("id"), map.getString("name"), map.getString("number"), false);
                parent.SetIsOpened(true);
                TreeBuilder.getTemplateTree(parent, templateColls, showType);
                TreeBuilder.getTemplateCatalogTreeRoot(true, templatecatalogList, parent, templateColls, showType);
                continue;
            }
            if (!map.getString("parent").equals(parent.getId())) continue;
            TemplateTreeNode child = new TemplateTreeNode(map.getString("id"), map.getString("name"), map.getString("number"), false);
            TreeBuilder.getTemplateTree(child, templateColls, showType);
            TreeBuilder.getTemplateCatalogTreeRoot(true, templatecatalogList, child, templateColls, showType);
            if (child.isLeaf()) continue;
            child.setParent(parent);
            parent.SetIsOpened(true);
            parent.addChild(child);
        }
        return parent;
    }

    private static void getTemplateTree(TemplateTreeNode templatecatalog, DynamicObjectCollection templateColls, String showType) {
        for (DynamicObject dot : templateColls) {
            boolean isDyna = dot.get("templatecatalog") instanceof DynamicObject;
            if (!templatecatalog.getId().equals(isDyna ? dot.getString("templatecatalog.id") : dot.getString("templatecatalog"))) continue;
            TemplateTreeNode template = null;
            String id = dot.getString("id");
            String name = dot.getString("name");
            String number = dot.getString("number");
            template = "1".equals(showType) ? new TemplateTreeNode(id, name, number, true) : ("2".equals(showType) ? new TemplateTreeNode(id, number + " " + name, number, true) : new TemplateTreeNode(id, name, number, true));
            template.setParent(templatecatalog);
            template.setUsage(dot.getString("usage"));
            templatecatalog.addChild(template);
            templatecatalog.SetIsOpened(true);
        }
    }

    public static ITreeNode<Object> setOpen(ITreeNode<Object> root) {
        LinkedList queue = new LinkedList();
        queue.addAll(root.getChildren());
        while (!queue.isEmpty()) {
            AbstractTreeNode node = (AbstractTreeNode)queue.poll();
            node.SetIsOpened(false);
            List children = node.getChildren();
            if (children == null) continue;
            queue.addAll(children);
        }
        return root;
    }

    public static TreeNode getAddPageOrgCslTree(DynamicObjectCollection addNodes, TreeNode parent, String showType) {
        if (addNodes != null) {
            int i = 0;
            for (DynamicObject object : addNodes) {
                TreeNode child = null;
                if (i == ReportListPlugin.TREE_LOAD_SIZE) {
                    child = new TreeNode(parent.getId(), parent.getId() + LOADMORE, ResManager.loadKDString((String)"...\u52a0\u8f7d\u66f4\u591a...", (String)"TreeBuilder_0", (String)"epm-eb-budget", (Object[])new Object[0]));
                    child.setColor("#2E2EFE");
                    parent.addChild(child);
                    break;
                }
                String id = object.getString("id");
                String name = object.getString("name");
                String number = object.getString("number");
                String orgcode = object.getString("orgcode");
                boolean isleaf = object.getBoolean("isleaf");
                String parentId = object.getString("parent");
                String formatName = TreeBuilder.formatDisplayName(showType, name, number, orgcode);
                child = new TreeNode(parentId, id, formatName, !isleaf);
                child.setIsOpened(true);
                parent.addChild(child);
                ++i;
            }
        }
        return parent;
    }

    public static interface ITemplateCollectionFilter {
        public void filter(DynamicObjectCollection var1);
    }

    public static interface ITemplateQuery {
        default public String getSelector() {
            return "id,number,name,templatecatalog.id,usage,versionnumber,group";
        }

        public QFilter[] getFilter();

        default public String getOrder() {
            return "number";
        }
    }
}

