/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.budget.formplugin.util;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IPageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.budget.formplugin.report.cache.DataTypeAcctCacheInfo;
import kd.epm.eb.budget.formplugin.report.style.StyleContext;
import kd.epm.eb.budget.formplugin.spread.SpreadClientInvoker;
import kd.epm.eb.budget.formplugin.util.DimensionUtil;
import kd.epm.eb.common.ebcommon.common.enums.DataTypeEnum;
import kd.epm.eb.common.ebcommon.common.util.ObjectSerialUtil;
import kd.epm.eb.common.ebcommon.common.util.RangeModel;
import kd.epm.eb.ebBusiness.dimension.enumvalue.EnumAndMembModel;
import kd.epm.eb.ebSpread.domain.Cell;
import kd.epm.eb.ebSpread.domain.view.SpreadManager;
import kd.epm.eb.ebSpread.domain.view.js.SpreadProperties;
import kd.epm.eb.ebSpread.model.IDimMember;

public class CellDataTypeUtil {
    private static final String dimDataTypeCache = "dimCacheInfo";
    private static final List<String> preSetDimensions = Collections.unmodifiableList(Arrays.asList("Scenario", "Account", "ChangeType"));
    public static final String USER_DEFINED_DIM = "userdefineddim";

    public static List<String> getUserDefined(long modelId, IPageCache pageCache) {
        return (List)ThreadCache.get((Object)(USER_DEFINED_DIM + modelId), () -> {
            ArrayList<String> userDefined = null;
            boolean realodFromDb = false;
            String jsonStr = pageCache.get(USER_DEFINED_DIM + modelId);
            try {
                if (StringUtils.isNotEmpty((String)jsonStr)) {
                    userDefined = SerializationUtils.fromJsonStringToList((String)jsonStr, String.class);
                } else {
                    realodFromDb = true;
                }
            }
            catch (Exception ex) {
                realodFromDb = true;
            }
            if (realodFromDb) {
                userDefined = new ArrayList<String>();
                QFilter qFilter = new QFilter("model", "=", (Object)modelId);
                Collection col = BusinessDataServiceHelper.loadFromCache((String)"epm_dimension", (String)"number", (QFilter[])new QFilter[]{qFilter}, (String)"dseq").values();
                for (DynamicObject dot : col) {
                    if (!DimensionUtil.isUserDefinedDim(dot.getString("number"))) continue;
                    userDefined.add(dot.getString("number"));
                }
                pageCache.put(USER_DEFINED_DIM + modelId, SerializationUtils.toJsonString(userDefined));
            }
            return userDefined;
        });
    }

    public static DataTypeEnum getCellDataType(long modelId, Cell cell, IPageCache pageCache, SpreadManager spreadManager, HashMap<String, DataTypeAcctCacheInfo> cachemap) {
        DataTypeEnum defaultDataType = DataTypeEnum.DEFAULT;
        if (cell.isMdDataDomain()) {
            Map<String, String> allFilterDimNumbers = CellDataTypeUtil.getSpreadModelAllFilterDimNumbers(spreadManager);
            DataTypeEnum returnDataType = CellDataTypeUtil.getDataTypeEnum(modelId, preSetDimensions, cell, pageCache, allFilterDimNumbers, cachemap);
            if (returnDataType != defaultDataType) {
                return returnDataType;
            }
            List<String> userDefined = CellDataTypeUtil.getUserDefined(modelId, pageCache);
            return CellDataTypeUtil.getDataTypeEnum(modelId, userDefined, cell, pageCache, allFilterDimNumbers, cachemap);
        }
        return defaultDataType;
    }

    public static EnumAndMembModel getCellDataType4EnumStyle(long modelId, Cell cell, IPageCache pageCache, Map<String, String> allFilterDimNumbers, HashMap<String, DataTypeAcctCacheInfo> cachemap) {
        DataTypeEnum defaultDataType = DataTypeEnum.DEFAULT;
        if (cell.isMdDataDomain()) {
            EnumAndMembModel returnDataType = CellDataTypeUtil.getDataTypeEnum4Enumvalue(modelId, preSetDimensions, cell, pageCache, allFilterDimNumbers, cachemap);
            if (!returnDataType.getDataTypeEnum().index.equals(defaultDataType.index)) {
                return returnDataType;
            }
            List<String> userDefined = CellDataTypeUtil.getUserDefined(modelId, pageCache);
            return CellDataTypeUtil.getDataTypeEnum4Enumvalue(modelId, userDefined, cell, pageCache, allFilterDimNumbers, cachemap);
        }
        return new EnumAndMembModel(defaultDataType);
    }

    public static EnumAndMembModel getCellDataType4EnumStyle(long modelId, Cell cell, IPageCache pageCache, SpreadManager spreadManager, HashMap<String, DataTypeAcctCacheInfo> cachemap) {
        Map<String, String> allFilterDimNumbers = CellDataTypeUtil.getSpreadModelAllFilterDimNumbers(spreadManager);
        return CellDataTypeUtil.getCellDataType4EnumStyle(modelId, cell, pageCache, allFilterDimNumbers, cachemap);
    }

    private static DataTypeEnum getDataTypeEnum(long modelId, List<String> dims, Cell cell, IPageCache pageCache, Map<String, String> allFilterDimNumbers, HashMap<String, DataTypeAcctCacheInfo> cachemap) {
        DataTypeEnum defaultType = DataTypeEnum.DEFAULT;
        boolean isCache = false;
        if (cachemap == null || cachemap.size() == 0) {
            isCache = true;
            cachemap = CellDataTypeUtil.getDataTypeCache(pageCache);
        }
        Map.Entry<String, String>[] currencyMap = CellDataTypeUtil.getCurrencyMemberName(cell, dims, allFilterDimNumbers);
        DataTypeEnum dataTypeEnum = null;
        for (int i = 0; i < currencyMap.length; ++i) {
            String memberNumber;
            String dim = currencyMap[i].getKey();
            dataTypeEnum = CellDataTypeUtil.getDimensionDataType(modelId, dim, memberNumber = currencyMap[i].getValue(), cachemap);
            if (dataTypeEnum == defaultType) continue;
            return dataTypeEnum;
        }
        if (isCache) {
            CellDataTypeUtil.cacheDataTypeInfo(pageCache, cachemap);
        }
        return defaultType;
    }

    public static void cacheDataTypeInfo(IPageCache pageCache, HashMap<String, DataTypeAcctCacheInfo> cachemap) {
        pageCache.put(dimDataTypeCache, ObjectSerialUtil.toByteSerialized(cachemap));
    }

    public static HashMap<String, DataTypeAcctCacheInfo> getDataTypeCache(IPageCache pageCache) {
        String dimCacheInfo = pageCache.get(dimDataTypeCache);
        HashMap cachemap = new HashMap();
        if (dimCacheInfo != null) {
            cachemap = (HashMap)ObjectSerialUtil.deSerializedBytes((String)dimCacheInfo);
        }
        return cachemap;
    }

    private static EnumAndMembModel getDataTypeEnum4Enumvalue(long modelId, List<String> dims, Cell cell, IPageCache pageCache, Map<String, String> allFilterDimNumbers, HashMap<String, DataTypeAcctCacheInfo> cachemap) {
        DataTypeEnum defaultType = DataTypeEnum.DEFAULT;
        Map.Entry<String, String>[] currencyMap = CellDataTypeUtil.getCurrencyMemberName(cell, dims, allFilterDimNumbers);
        DataTypeEnum dataTypeEnum = null;
        for (int i = 0; i < currencyMap.length; ++i) {
            String memberNumber;
            String dim = currencyMap[i].getKey();
            dataTypeEnum = CellDataTypeUtil.getDimensionDataType(modelId, dim, memberNumber = currencyMap[i].getValue(), cachemap);
            if (dataTypeEnum == defaultType) continue;
            return new EnumAndMembModel(dim, memberNumber, dataTypeEnum);
        }
        return new EnumAndMembModel(defaultType);
    }

    private static Map.Entry<String, String>[] getCurrencyMemberName(Cell cell, Collection<String> dimNumbers, Map<String, String> allFilterDimNumbers) {
        Map checkDimNumbers = cell.getMemberFromUserObjectDimNumbers();
        Map.Entry[] resultMap = new Map.Entry[dimNumbers.size()];
        int i = 0;
        for (String dimNumber : dimNumbers) {
            String number = (String)checkDimNumbers.get(dimNumber);
            if (number == null && (number = allFilterDimNumbers.get(dimNumber)) == null) {
                throw new KDBizException(ResManager.loadResFormat((String)"\u83b7\u53d6\u5355\u5143\u683c\u5185\u67d0\u4e00\u7ef4\u5ea6\u5bf9\u5e94\u7684\u7ef4\u5ea6\u6210\u5458\u5931\u8d25:%1", (String)"CellDataTypeUtil_0", (String)"epm-eb-budget", (Object[])new Object[]{dimNumber}));
            }
            resultMap[i++] = new AbstractMap.SimpleEntry<String, String>(dimNumber, number);
        }
        return resultMap;
    }

    public static Map<String, String> getSpreadModelAllFilterDimNumbers(SpreadManager spreadModel) {
        return (Map)ThreadCache.get((Object)"getSpreadModelAllFilterDimNumbers", () -> {
            HashMap<String, String> resultMap = new HashMap<String, String>();
            if (spreadModel != null && spreadModel.getFilter() != null) {
                List listMemmber;
                if (spreadModel.getFilter().getPageDomain() != null && (listMemmber = spreadModel.getFilter().getPageDomain().getAllMembers()) != null) {
                    for (IDimMember member : listMemmber) {
                        resultMap.put(member.getDimension().getNumber(), member.getNumber());
                    }
                }
                if (spreadModel.getFilter().getViewPointDomain() != null && (listMemmber = spreadModel.getFilter().getViewPointDomain().getAllMembers()) != null) {
                    for (IDimMember member : listMemmber) {
                        resultMap.put(member.getDimension().getNumber(), member.getNumber());
                    }
                }
            }
            return resultMap;
        });
    }

    public static DataTypeEnum getDimensionDataType(long modelId, String dimNumber, String memberNumber, HashMap<String, DataTypeAcctCacheInfo> cachemap) {
        if (cachemap.get(dimNumber) == null) {
            DataTypeAcctCacheInfo acctCacheInfo = new DataTypeAcctCacheInfo(modelId, DimensionUtil.getDimMembEntityNumByDimNum(dimNumber), dimNumber);
            cachemap.put(dimNumber, acctCacheInfo);
        }
        return cachemap.get(dimNumber).getMemberDataTypeEnum(dimNumber, memberNumber);
    }

    public static void setEnumStyleCell(StyleContext ctx, IClientViewProxy view, IPageCache pageCache, List<Integer> rs, List<Integer> cs, String range) {
        int endRow;
        int endCol;
        int startRow;
        int startCol;
        ArrayList items = new ArrayList();
        ArrayList resetItems = new ArrayList();
        HashMap<String, Serializable> features = new HashMap<String, Serializable>();
        HashMap resetFeatures = new HashMap();
        HashMap<String, DataTypeAcctCacheInfo> cachemap = CellDataTypeUtil.getDataTypeCache(pageCache);
        if (range != null && !range.isEmpty()) {
            RangeModel poss = new RangeModel(range);
            startCol = poss.getX_start();
            startRow = poss.getY_start();
            endCol = poss.getX_end();
            endRow = poss.getY_end();
        } else {
            endRow = 0;
            endCol = 0;
            startRow = 0;
            startCol = 0;
        }
        Map<String, String> allFilterDimNumbers = CellDataTypeUtil.getSpreadModelAllFilterDimNumbers(ctx.getSpreadManager());
        ctx.getSpreadManager().getBook().getSheet(0).iteratorCells(c -> {
            if (rs == null && cs == null) {
                if (c.isMdDataDomain()) {
                    EnumAndMembModel dataTypeEnum = CellDataTypeUtil.getCellDataType4EnumStyle(ctx.getTemplate().getModelId(), c, pageCache, allFilterDimNumbers, cachemap);
                    if (dataTypeEnum.getDataTypeEnum().index.equals(DataTypeEnum.ENUMTP.index)) {
                        HashMap<String, Integer> cell = new HashMap<String, Integer>();
                        cell.put(SpreadProperties.LockCellMethod.R.k(), c.getRow());
                        cell.put(SpreadProperties.LockCellMethod.C.k(), c.getCol());
                        cell.put(SpreadProperties.LockCellMethod.RC.k(), 1);
                        cell.put(SpreadProperties.LockCellMethod.CC.k(), 1);
                        items.add(cell);
                    }
                }
            } else if (rs != null && rs.contains(c.getRow()) || cs != null && cs.contains(c.getCol())) {
                if (c.isMdDataDomain()) {
                    EnumAndMembModel dataTypeEnum = CellDataTypeUtil.getCellDataType4EnumStyle(ctx.getTemplate().getModelId(), c, pageCache, allFilterDimNumbers, cachemap);
                    if (dataTypeEnum.getDataTypeEnum().index.equals(DataTypeEnum.ENUMTP.index)) {
                        HashMap<String, Integer> cell = new HashMap<String, Integer>();
                        cell.put(SpreadProperties.LockCellMethod.R.k(), c.getRow());
                        cell.put(SpreadProperties.LockCellMethod.C.k(), c.getCol());
                        cell.put(SpreadProperties.LockCellMethod.RC.k(), 1);
                        cell.put(SpreadProperties.LockCellMethod.CC.k(), 1);
                        items.add(cell);
                    }
                } else if (c.getRow() >= startRow && c.getRow() <= endRow && c.getCol() >= startCol && c.getCol() <= endCol) {
                    HashMap<String, Integer> cellAxis = new HashMap<String, Integer>();
                    cellAxis.put(SpreadProperties.ResetCellMethod.R.k(), c.getRow());
                    cellAxis.put(SpreadProperties.ResetCellMethod.C.k(), c.getCol());
                    cellAxis.put(SpreadProperties.ResetCellMethod.RC.k(), 1);
                    cellAxis.put(SpreadProperties.ResetCellMethod.CC.k(), 1);
                    resetItems.add(cellAxis);
                }
            }
        });
        if (items.size() > 0) {
            features.put(SpreadProperties.SetF7TypeCellMethod.CELL.k(), items);
            features.put(SpreadProperties.SetF7TypeCellMethod.DISPLAYSTYLE.k(), Integer.valueOf(1));
            features.put(SpreadProperties.SetF7TypeCellMethod.SELECTTYPE.k(), Integer.valueOf(0));
            SpreadClientInvoker.invokeSetF7TypeCellMethod(view, ctx.getSpreadKey(), features);
        }
        CellDataTypeUtil.cacheDataTypeInfo(pageCache, cachemap);
        if (resetItems.size() > 0) {
            resetFeatures.put(SpreadProperties.ResetCellMethod.RANGE.k(), resetItems);
            SpreadClientInvoker.invokeResetCellMethod(view, ctx.getSpreadKey(), resetFeatures);
        }
    }
}

