/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.budget.formplugin.util;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class DimensionUtil {
    public static final int rootLevel = 1;

    public static boolean isExpand2SecondLevel4MultiMemberF7(String membermodel) {
        boolean is = false;
        if (membermodel.equals("epm_entitymembertree") || membermodel.equals("epm_accountmembertree") || membermodel.equals("epm_changetypemembertree") || membermodel.equals("epm_icmembertree") || membermodel.equals("epm_userdefinedmembertree")) {
            is = true;
        }
        return is;
    }

    public static String getDimMembEntityNumByDimNum(String dimNum) {
        switch (dimNum.toLowerCase(Locale.getDefault())) {
            case "entity": {
                return "epm_entitymembertree";
            }
            case "account": {
                return "epm_accountmembertree";
            }
            case "year": {
                return "epm_yearmembertree";
            }
            case "period": {
                return "epm_periodmembertree";
            }
            case "scenario": {
                return "epm_scenemembertree";
            }
            case "process": {
                return "epm_processmembertree";
            }
            case "currency": {
                return "epm_currencymembertree";
            }
            case "audittrail": {
                return "epm_audittrialmembertree";
            }
            case "changetype": {
                return "epm_changetypemembertree";
            }
            case "internalcompany": {
                return "epm_icmembertree";
            }
            case "multigaap": {
                return "eb_rulemembertree";
            }
            case "version": {
                return "epm_versionmembertree";
            }
            case "datatype": {
                return "epm_datatypemembertree";
            }
            case "datasort": {
                return "eb_datasortmembertree";
            }
            case "mycompany": {
                return "eb_mycompanymembertree";
            }
            case "metric": {
                return "epm_metricmembertree";
            }
        }
        return "epm_userdefinedmembertree";
    }

    public static boolean isUserDefinedDim(String dimNum) {
        return DimensionUtil.getDimMembEntityNumByDimNum(dimNum).equals("epm_userdefinedmembertree");
    }

    public static Map<Object, Object> getDimMap(String entity, String key, String value, long modelid) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelid);
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        try (DataSet col = QueryServiceHelper.queryDataSet((String)"queryDimension", (String)entity, (String)(key + "," + value), (QFilter[])new QFilter[]{qFilter}, null);){
            while (col.hasNext()) {
                Row row = col.next();
                map.put(row.get(key), row.get(value));
            }
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
        return map;
    }
}

