/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.budget.formplugin.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.ebcommon.common.util.ExcelUtils;
import kd.epm.eb.common.ebcommon.common.util.ObjectSerialUtil;
import kd.epm.eb.ebSpread.domain.view.SpreadManager;
import kd.epm.eb.ebSpread.domain.view.builder.PositionInfo;
import kd.epm.eb.ebSpread.domain.view.builder.dynamic.BasePointInfo;

public class MarkSpecialCell {
    public static final String OLDSPREAD = "oldspread";

    public static void markSpecialCells(Object pif, boolean mark, IFormView view, String spreadkey) {
        List<BasePointInfo> baseinfo = null;
        if (pif instanceof PositionInfo) {
            baseinfo = ((PositionInfo)pif).getBasePoints();
        } else if (pif instanceof BasePointInfo) {
            baseinfo = Collections.singletonList((BasePointInfo)pif);
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4f20\u5165PositionInfo\u6216\u8005BasePointInfo\u7c7b\u578b\uff0c\u5982\u9700\u652f\u6301\u5176\u4ed6\u7c7b\u578b\u8bf7\u81ea\u884c\u6dfb\u52a0", (String)"MarkSpecialCell_0", (String)"epm-eb-budget", (Object[])new Object[0]));
        }
        for (BasePointInfo base : baseinfo) {
            String range = base.getDynaRange();
            int y_end = -1;
            if (!StringUtils.isNotEmpty((String)range)) continue;
            String[] array = range.split(":");
            int[] start = ExcelUtils.pos2XY((String)array[0]);
            int[] end = ExcelUtils.pos2XY((String)array[1]);
            int x_start = start[0];
            int y_start = start[1];
            int x_end = end[0];
            y_end = end[1];
            HashMap<String, Object> features = new HashMap<String, Object>();
            features.put("r", y_start);
            features.put("c", x_start);
            features.put("st", mark);
            features.put("pos", Lists.newArrayList((Object[])new Integer[]{0}));
            ((IClientViewProxy)view.getService(IClientViewProxy.class)).invokeControlMethod(spreadkey, "setCellTag", new Object[]{Lists.newArrayList((Object[])new Map[]{features})});
            HashMap<String, Object> features0 = new HashMap<String, Object>();
            features0.put("r", y_end);
            features0.put("c", x_end);
            features0.put("st", mark);
            features0.put("pos", Lists.newArrayList((Object[])new Integer[]{2}));
            ((IClientViewProxy)view.getService(IClientViewProxy.class)).invokeControlMethod(spreadkey, "setCellTag", new Object[]{Lists.newArrayList((Object[])new Map[]{features0})});
        }
    }

    public static void cacheOldFloat(IPageCache pageCache, SpreadManager spread) {
        pageCache.put(OLDSPREAD, ObjectSerialUtil.toByteSerialized((Object)spread));
    }

    public static void drawMarkPoint(IPageCache pageCache, IFormView view, SpreadManager newspread, String spreadkey, boolean isclean) {
        String serial = pageCache.get(OLDSPREAD);
        if (StringUtils.isNotEmpty((String)serial)) {
            SpreadManager lastsm = (SpreadManager)ObjectSerialUtil.deSerializedBytes((String)serial);
            for (PositionInfo pif : lastsm.getAreaManager().getPostionInfoSet()) {
                MarkSpecialCell.markSpecialCells(pif, false, view, spreadkey);
            }
        }
        for (PositionInfo pif : newspread.getAreaManager().getPostionInfoSet()) {
            MarkSpecialCell.markSpecialCells(pif, true, view, spreadkey);
        }
        if (isclean) {
            pageCache.remove(OLDSPREAD);
        }
    }

    public static void drawMarkPoint(IPageCache pageCache, IFormView view, SpreadManager newspread, String spreadkey) {
        MarkSpecialCell.drawMarkPoint(pageCache, view, newspread, spreadkey, true);
    }

    public static void clearAreaMarkPoint(Object pif, IFormView view, String spreadkey) {
        List<Object> baseinfo = new ArrayList();
        if (pif instanceof PositionInfo) {
            baseinfo = ((PositionInfo)pif).getBasePoints();
        } else if (pif instanceof BasePointInfo) {
            baseinfo = Collections.singletonList((BasePointInfo)pif);
        } else if (pif instanceof SpreadManager) {
            for (PositionInfo positionInfo : ((SpreadManager)pif).getAreaManager().getPostionInfoSet()) {
                baseinfo.addAll(positionInfo.getBasePoints());
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4f20\u5165PositionInfo\u6216\u8005BasePointInfo\u7c7b\u578b\uff0c\u5982\u9700\u652f\u6301\u5176\u4ed6\u7c7b\u578b\u8bf7\u81ea\u884c\u6dfb\u52a0", (String)"MarkSpecialCell_0", (String)"epm-eb-budget", (Object[])new Object[0]));
        }
        for (BasePointInfo basePointInfo : baseinfo) {
            HashMap<String, Object> features;
            int j;
            int i;
            String range = basePointInfo.getDynaRange();
            int y_end = -1;
            if (!StringUtils.isNotEmpty((String)range)) continue;
            String[] array = range.split(":");
            int[] start = ExcelUtils.pos2XY((String)array[0]);
            int[] end = ExcelUtils.pos2XY((String)array[1]);
            int x_start = start[0];
            int y_start = start[1];
            int x_end = end[0];
            y_end = end[1];
            for (i = x_start; i <= x_start + 2; ++i) {
                for (j = y_start; j <= y_start + 2; ++j) {
                    features = new HashMap<String, Object>();
                    features.put("r", j);
                    features.put("c", i);
                    features.put("st", false);
                    features.put("pos", Lists.newArrayList((Object[])new Integer[]{0}));
                    ((IClientViewProxy)view.getService(IClientViewProxy.class)).invokeControlMethod(spreadkey, "setCellTag", new Object[]{Lists.newArrayList((Object[])new Map[]{features})});
                }
            }
            for (i = x_end - 2; i <= x_end; ++i) {
                for (j = y_end - 2; j <= y_end; ++j) {
                    features = new HashMap();
                    features.put("r", j);
                    features.put("c", i);
                    features.put("st", false);
                    features.put("pos", Lists.newArrayList((Object[])new Integer[]{0}));
                    ((IClientViewProxy)view.getService(IClientViewProxy.class)).invokeControlMethod(spreadkey, "setCellTag", new Object[]{Lists.newArrayList((Object[])new Map[]{features})});
                }
            }
        }
    }
}

