/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.budget.formplugin.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.ebcommon.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.ebBusiness.serviceHelper.BcmFunPermissionHelper;
import kd.epm.eb.ebBusiness.serviceHelper.MemberPermHelper;

public class ModelUtil {
    public static ApplicationTypeEnum queryApp(IFormView view) {
        ApplicationTypeEnum application = ApplicationTypeEnum.EB;
        String appnumber = view.getFormShowParameter().getAppId();
        if (StringUtils.isEmpty((String)appnumber)) {
            return application;
        }
        return ApplicationTypeEnum.getEnumByNumber((String)appnumber, (IFormView)view);
    }

    public static List<QFilter> getModelFilter(IFormView view) {
        String sign = ModelUtil.queryApp(view).getAppnum();
        QFilter qf = ModelUtil.getModelQfilterByApp(view);
        ArrayList<QFilter> modelQFilters = new ArrayList<QFilter>();
        modelQFilters.add(qf);
        if (view.getParentView() != null) {
            if ("eb_user_assignperm".equals(view.getParentView().getEntityId())) {
                Set ids = MemberPermHelper.getLimitedModelListByUser();
                modelQFilters.add(new QFilter("id", "in", (Object)ids));
            } else {
                QFilter superid = new QFilter("id", "in", (Object)MemberPermHelper.getLimitedModelListByUser());
                QFilter haspermid = new QFilter("id", "in", (Object)BcmFunPermissionHelper.getEffectiveByPermModel((String)view.getEntityId(), (ApplicationTypeEnum)ModelUtil.queryApp(view)));
                QFilter perRoleids = new QFilter("id", "in", (Object)BcmFunPermissionHelper.getRoleModel((long)UserUtils.getUserId(), (String)"epm_model", (ApplicationTypeEnum)ModelUtil.queryApp(view), (String)view.getEntityId(), (String)"47150e89000000ac"));
                modelQFilters.add(superid.or(haspermid).or(perRoleids));
            }
        }
        return modelQFilters;
    }

    public static QFilter getModelQfilterByApp(IFormView view) {
        ApplicationTypeEnum application = ModelUtil.queryApp(view);
        QFilter qcf = new QFilter("ReportType", "=", (Object)application.getOIndex());
        switch (application) {
            case RPT: {
                qcf = BcmFunPermissionHelper.getRptAdminModelQFilter();
                break;
            }
            case IEP: {
                qcf = new QFilter("ReportType", "=", (Object)ApplicationTypeEnum.CM.getOIndex());
                break;
            }
            case BGM: {
                qcf = new QFilter("ReportType", "=", (Object)ApplicationTypeEnum.BGMD.getOIndex());
                break;
            }
            case EB: {
                qcf = new QFilter("ReportType", "=", (Object)ApplicationTypeEnum.EB.getOIndex());
                break;
            }
            case BGC: {
                qcf = new QFilter("ReportType", "=", (Object)ApplicationTypeEnum.EB.getOIndex()).or("ReportType", "=", (Object)ApplicationTypeEnum.BGMD.getOIndex());
                break;
            }
            case BGBD: {
                qcf = new QFilter("ReportType", "=", (Object)ApplicationTypeEnum.EB.getOIndex()).or("ReportType", "=", (Object)ApplicationTypeEnum.BGMD.getOIndex());
                break;
            }
        }
        return qcf;
    }
}

