/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.budget.formplugin.util;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.io.IOUtils;

public class ResourcesLoaderUtil {
    private static final Log log = LogFactory.getLog(ResourcesLoaderUtil.class);

    public static String getStringFromResources(String path) {
        InputStream in = null;
        try {
            in = ResourcesLoaderUtil.class.getClassLoader().getResourceAsStream(path);
            String string = IOUtils.toString((InputStream)in, (String)"UTF-8");
            return string;
        }
        catch (IOException e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8d44\u6e90\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25\u3002", (String)"ResourcesLoaderUtil_0", (String)"epm-eb-budget", (Object[])new Object[0]));
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage());
                }
            }
        }
    }

    public static List<Map> getMapListFromResources(String path) {
        String str = ResourcesLoaderUtil.getStringFromResources(path);
        return JSON.parseArray((String)str, Map.class);
    }
}

