/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.budget.formplugin.util;

import java.lang.reflect.Field;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.budget.formplugin.adjust.report.BasedataEditSingleMemberF74NoLeaf;
import kd.epm.eb.budget.formplugin.adjust.report.BasedataEditSingleMemberF74Root;
import kd.epm.eb.budget.formplugin.adjust.report.BasedataEditSingleMemberF7Custom;
import kd.epm.eb.budget.formplugin.database.BasedataEditSingleMemberF7;
import kd.epm.eb.budget.formplugin.database.LTreeRListEdit;
import kd.epm.eb.budget.formplugin.exchangeRate.BasedataEditSingleMemberF7Ext;
import kd.epm.eb.common.ebcommon.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.ebcommon.common.enums.SingleF7TypeEnum;
import kd.epm.eb.ebBusiness.exchangeRate.ExchageRateServiceHelper;
import kd.epm.eb.ebBusiness.serviceHelper.MemberPermHelper;

public class SingleMemberF7Util {
    public static Field getClassField(Class<?> clazz, String fieldName) {
        Field[] fields;
        Field field = null;
        for (Field f : fields = clazz.getDeclaredFields()) {
            if (!fieldName.equals(f.getName())) continue;
            field = f;
            break;
        }
        if (field == null && clazz != Object.class) {
            field = SingleMemberF7Util.getClassField(clazz.getSuperclass(), fieldName);
        }
        return field;
    }

    public static BasedataEditSingleMemberF7 getBasedataEditSingleMemberF7(IFormView view, IDataModel iDataModel, Long modelId, String dimNumber, String f7Key, BeforeF7SelectListener beforeF7SelectListener, boolean isOnlyReturnId, SingleF7TypeEnum type) {
        IDataEntityType parentProperty;
        BasedataEditSingleMemberF7 bdEdit = SingleMemberF7Util.getBdEdit(type);
        bdEdit.setKey(f7Key);
        bdEdit.setFieldKey(f7Key);
        bdEdit.setF7Name(f7Key);
        bdEdit.setView(view);
        bdEdit.setModel(iDataModel);
        bdEdit.setOnlyReturnId(isOnlyReturnId);
        bdEdit.setDisplayProp("name");
        bdEdit.setDimNumber(dimNumber);
        bdEdit.setType(type);
        if (bdEdit.getProperty() != null && (parentProperty = bdEdit.getProperty().getParent()) instanceof EntryType) {
            bdEdit.setEntryKey(parentProperty.getName());
        }
        if (modelId != null) {
            bdEdit.setModelId(modelId);
        }
        if (beforeF7SelectListener != null) {
            bdEdit.addBeforeF7SelectListener(beforeF7SelectListener);
        }
        return bdEdit;
    }

    public static QFilter getPermissonFilter(String entityName, long dimensionId, Object modelid) {
        return null;
    }

    public static Boolean cacheModelPrem(IPageCache iPageCache, Long modelId, ApplicationTypeEnum application) {
        Boolean isModelPerm = false;
        if (MemberPermHelper.getLimitedModelListByUser((ApplicationTypeEnum)application).contains(modelId)) {
            isModelPerm = true;
        }
        iPageCache.put("modelPrem", String.valueOf(isModelPerm));
        return isModelPerm;
    }

    public static BasedataEditSingleMemberF7 createBasedataEditSingleMemberF7(IFormView view, IDataModel iDataModel, Long modelId, Long dimId, String f7Key, BeforeF7SelectListener beforeF7SelectListener, boolean isOnlyReturnId, SingleF7TypeEnum type) {
        DynamicObject dimObj = BusinessDataServiceHelper.loadSingleFromCache((String)"epm_dimension", (String)"id,number,name,dseq,membermodel", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)dimId)});
        if (dimObj == null) {
            throw new KDBizException("not found dimension:{dimId:" + dimId + ";modelId:" + modelId + ";f7Key:" + f7Key + "}");
        }
        BasedataEditSingleMemberF7 bdEdit = "epm_icmembertree".equals(dimObj.getString("membermodel")) ? new LTreeRListEdit() : SingleMemberF7Util.getBdEdit(type);
        bdEdit.setKey(f7Key);
        bdEdit.setFieldKey(f7Key);
        bdEdit.setModelId(modelId);
        bdEdit.setDimId(dimId);
        bdEdit.setF7Name(f7Key);
        bdEdit.setF7Value(dimObj.getInt("dseq"));
        bdEdit.setEntity(dimObj.getString("membermodel"));
        bdEdit.setView(view);
        bdEdit.setOnlyReturnId(isOnlyReturnId);
        bdEdit.setModel(iDataModel);
        bdEdit.setDisplayProp("name");
        bdEdit.setDimName(dimObj.getString("name"));
        QFilter modelFilter = new QFilter("model", "=", (Object)modelId);
        QFilter permissonFilter = SingleMemberF7Util.getPermissonFilter(dimObj.getString("membermodel"), dimId, modelId);
        ExchageRateServiceHelper.delExchangeRatePlanFilter((QFilter)modelFilter, (String)dimObj.getString("membermodel"));
        switch (type) {
            case LEAF: {
                modelFilter.and(new QFilter("isleaf", "=", (Object)true));
                break;
            }
            case NOLEAF: {
                modelFilter.and(new QFilter("isleaf", "=", (Object)false));
                break;
            }
        }
        bdEdit.setQFilter(modelFilter.and(permissonFilter));
        if (beforeF7SelectListener != null) {
            bdEdit.addBeforeF7SelectListener(beforeF7SelectListener);
        }
        return bdEdit;
    }

    public static BasedataEditSingleMemberF7 createBasedataEditSingleMemberF7(IFormView view, IDataModel iDataModel, Long modelId, Long dimId, String f7Key, BeforeF7SelectListener beforeF7SelectListener, boolean isOnlyReturnId) {
        return SingleMemberF7Util.createBasedataEditSingleMemberF7(view, iDataModel, modelId, dimId, f7Key, beforeF7SelectListener, isOnlyReturnId, SingleF7TypeEnum.COMMON);
    }

    public static BasedataEditSingleMemberF7 getBdEdit(SingleF7TypeEnum type) {
        switch (type) {
            case LEAF: {
                return new BasedataEditSingleMemberF7Ext();
            }
            case NOLEAF: {
                return new BasedataEditSingleMemberF74NoLeaf();
            }
            case ROOT: {
                return new BasedataEditSingleMemberF74Root();
            }
            case CUSTOM: {
                return new BasedataEditSingleMemberF7Custom();
            }
        }
        return new BasedataEditSingleMemberF7();
    }

    public static interface ISingleMemberF7Handle {
        public void beforeSingleMemberF7Select(BeforeF7SelectEvent var1);
    }
}

