/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.budget.formplugin.util;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.budget.formplugin.report.dynamic.DynamicUtils;
import kd.epm.eb.common.ebcommon.common.Pair;
import kd.epm.eb.common.ebcommon.common.enums.DetailTypeEnum;
import kd.epm.eb.ebBusiness.serviceHelper.QueryMemberDetailsHelper;
import kd.epm.eb.ebBusiness.template.model.PageDimensionEntry;
import kd.epm.eb.ebBusiness.template.model.TemplateModel;
import kd.epm.eb.ebBusiness.template.model.ViewPointDimensionEntry;
import kd.epm.eb.ebSpread.domain.ColumnDimDomain;
import kd.epm.eb.ebSpread.domain.RowDimDomain;
import kd.epm.eb.ebSpread.domain.view.JsonSerializerUtil;
import kd.epm.eb.ebSpread.domain.view.SpreadManager;
import kd.epm.eb.ebSpread.domain.view.builder.PositionInfo;
import kd.epm.eb.ebSpread.domain.view.builder.dynamic.BasePointInfo;
import kd.epm.eb.ebSpread.domain.view.builder.dynamic.BasePointInnerLineInfo;
import kd.epm.eb.ebSpread.domain.view.builder.dynamic.DynaMembScopeInfo;
import kd.epm.eb.ebSpread.model.DimMember;
import kd.epm.eb.ebSpread.model.IDimMember;
import kd.epm.eb.ebSpread.model.IDimension;
import kd.epm.eb.ebSpread.model.dao.Tuple;

public class SpreadMemUtil {
    public static List<Map<String, Set<String>>> analysisMemberFromSheet(SpreadManager sm, TemplateModel model, String ... selectDim) {
        if (DynamicUtils.isDynamicReport(sm)) {
            return SpreadMemUtil.analysisDynamicReport(sm, model, selectDim);
        }
        return SpreadMemUtil.analysisFixReport(sm, model, selectDim);
    }

    private static List<Map<String, Set<String>>> analysisFixReport(SpreadManager sm, TemplateModel model, String ... selectDim) {
        ArrayList<Map<String, Set<String>>> list = new ArrayList<Map<String, Set<String>>>(10);
        for (PositionInfo ps : sm.getAreaManager().getPostionInfoSet()) {
            Map<String, Set<String>> map = SpreadMemUtil.getNormalMap(sm, ps, model, selectDim);
            list.add(map);
        }
        return list;
    }

    private static Map<String, Set<String>> getNormalMap(SpreadManager sm, PositionInfo ps, TemplateModel model, String ... selectDim) {
        HashSet<String> numbers;
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>(16);
        Tuple t = sm.getAreaManager().getRowAndColDomainByPosition(ps);
        List<String> select = Arrays.asList(selectDim);
        for (IDimension r : ((RowDimDomain)t.k).getDimensions()) {
            if (select.size() > 0 && !select.contains(r.getNumber())) continue;
            numbers = new HashSet<String>(16);
            for (IDimMember m : r.getMembers()) {
                numbers.add(m.getNumber());
            }
            map.put(r.getNumber(), numbers);
        }
        for (IDimension r : ((ColumnDimDomain)t.v).getDimensions()) {
            if (select.size() > 0 && !select.contains(r.getNumber())) continue;
            numbers = new HashSet(16);
            for (IDimMember m : r.getMembers()) {
                numbers.add(m.getNumber());
            }
            map.put(r.getNumber(), numbers);
        }
        for (ViewPointDimensionEntry v : model.getViewPointDimensionEntries()) {
            if (select.size() > 0 && !select.contains(v.getDimension().getNumber())) continue;
            map.put(v.getDimension().getNumber(), Sets.newHashSet((Object[])new String[]{v.getMember().getNumber()}));
        }
        for (PageDimensionEntry p : model.getPageDimensionEntries()) {
            if (select.size() > 0 && !select.contains(p.getDimension().getNumber())) continue;
            numbers = new HashSet(16);
            for (IDimMember m : p.getMembers()) {
                numbers.addAll(QueryMemberDetailsHelper.queryMemberNumbersByRange((String)p.getDimension().getMemberEntityNumber(), (Long)m.getId(), (String)m.getNumber(), (int)m.getScope(), (String)String.valueOf(model.getModelId()), (DetailTypeEnum)DetailTypeEnum.OTHERS));
            }
            map.put(p.getDimension().getNumber(), numbers);
        }
        for (PageDimensionEntry p : model.getPagePropEntries()) {
            if (select.size() > 0 && !select.contains(p.getDimension().getNumber())) continue;
            numbers = new HashSet(16);
            for (IDimMember m : p.getAllMembProperties()) {
                numbers.addAll(QueryMemberDetailsHelper.getMemberIdsByDefinedRange4Number((String)p.getDimension().getMemberEntityNumber(), (Long)m.getId(), (String)m.getNumber(), (int)m.getScope(), (String)String.valueOf(model.getModelId()), (DetailTypeEnum)DetailTypeEnum.OTHERS));
            }
            map.put(p.getDimension().getNumber(), numbers);
        }
        return map;
    }

    private static List<Map<String, Set<String>>> analysisDynamicReport(SpreadManager sm, TemplateModel model, String ... selectDim) {
        ArrayList<Map<String, Set<String>>> list = new ArrayList<Map<String, Set<String>>>(10);
        List<String> select = Arrays.asList(selectDim);
        ArrayList<String> unScope = new ArrayList<String>();
        for (PositionInfo ps : sm.getAreaManager().getPostionInfoSet()) {
            unScope.clear();
            Map<String, Set<String>> map = SpreadMemUtil.getNormalMap(sm, ps, model, selectDim);
            for (BasePointInfo bp : ps.getBasePoints()) {
                for (BasePointInnerLineInfo info : bp.getBasePointInnerLineInfo()) {
                    if (select.size() > 0 && !select.contains(info.getDimension().getNumber())) continue;
                    List scope = info.getDynaMembScopes();
                    if (scope.size() == 0) {
                        unScope.add(info.getDimension().getNumber());
                        continue;
                    }
                    ArrayList numbers = new ArrayList();
                    for (DynaMembScopeInfo scinfo : scope) {
                        if (scinfo.isCustom()) {
                            numbers.addAll(QueryMemberDetailsHelper.getMemberIdsByDefinedRange4Number((String)scinfo.getMember().getDimension().getUqCode(), (Long)((DimMember)scinfo.getMember()).getId(), (String)scinfo.getMember().getNumber(), (int)scinfo.getRange().getValue(), (String)String.valueOf(model.getModelId()), (DetailTypeEnum)DetailTypeEnum.OTHERS));
                            continue;
                        }
                        numbers.addAll(QueryMemberDetailsHelper.queryMemberNumbersByRange((String)scinfo.getMember().getDimension().getUqCode(), (Long)((DimMember)scinfo.getMember()).getId(), (String)((DimMember)scinfo.getMember()).getNumber(), (int)scinfo.getRange().getValue(), (String)String.valueOf(model.getModelId()), (DetailTypeEnum)DetailTypeEnum.OTHERS));
                    }
                    Set<String> li = map.get(info.getDimension().getNumber());
                    if (li == null) {
                        li = new HashSet<String>();
                    }
                    li.addAll(numbers);
                    map.put(info.getDimension().getNumber(), li);
                }
            }
            for (String s : unScope) {
                map.remove(s);
            }
            list.add(map);
        }
        return list;
    }

    public static String getMemFromFilter(SpreadManager spread, String dimnum) {
        ArrayList pageAndViewDim = new ArrayList(spread.getFilter().getPageDomain().getDimensions());
        pageAndViewDim.addAll(spread.getFilter().getViewPointDomain().getDimensions());
        for (IDimension dim : pageAndViewDim) {
            if (!dim.getNumber().equals(dimnum)) continue;
            return ((IDimMember)dim.getMembers().get(0)).getNumber();
        }
        return null;
    }

    public static SpreadManager querySpreadManager(Long templateid) {
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"", (String)"eb_templateentity_bg", (String)"rptdata", (QFilter[])new QFilter("id", "=", (Object)templateid).toArray(), null);){
            if (ds.hasNext()) {
                SpreadManager spreadManager = JsonSerializerUtil.toSpreadManager((String)ds.next().getString("rptdata"));
                return spreadManager;
            }
        }
        return null;
    }

    public static Pair<Set<String>, Set<String>> getFixAndFloatDimByPositionInfo(PositionInfo pos) {
        if (pos.getBasePoints().isEmpty()) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u8be5\u533a\u57df\u201c%s\u201d\u4e3a\u975e\u6d6e\u52a8\u533a\u57df\u3002", (String)"SpreadMemUtil_0", (String)"epm-eb-budget", (Object[])new Object[]{pos.getAreaRange()}));
        }
        Set floatDims = ((BasePointInfo)pos.getBasePoints().get(0)).getBasePointInnerLineInfo().stream().map(line -> line.getDimension().getNumber()).collect(Collectors.toSet());
        Set fixDims = ((List)((BasePointInfo)pos.getBasePoints().get(0)).getFixMemberPosition().values().stream().findFirst().get()).stream().map(m -> m.getDimension().getNumber()).collect(Collectors.toSet());
        return Pair.onePair(fixDims, floatDims);
    }
}

