/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.budget.formplugin.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.budget.formplugin.template.AbstractTemplateBasePlugin;
import kd.epm.eb.budget.formplugin.template.util.EBOldTemplateDataResolveUtil;
import kd.epm.eb.budget.formplugin.util.ModelUtil;
import kd.epm.eb.common.ebcommon.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.ebcommon.common.enums.DimEntityNumEnum;
import kd.epm.eb.common.ebcommon.common.enums.DimTypesEnum;
import kd.epm.eb.common.ebcommon.common.enums.RangeEnum;
import kd.epm.eb.common.ebcommon.common.enums.template.DefaultDimAreaEnum;
import kd.epm.eb.common.ebcommon.common.enums.template.DefaultDimSettingEnum;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.ebBusiness.serviceHelper.DimensionServiceHelper;
import kd.epm.eb.ebBusiness.serviceHelper.QueryDimensionServiceHelper;
import kd.epm.eb.ebBusiness.template.model.AreaRangeEntry;
import kd.epm.eb.ebBusiness.template.model.CustomProperty;
import kd.epm.eb.ebBusiness.template.model.Dimension;
import kd.epm.eb.ebBusiness.template.model.MembProperty;
import kd.epm.eb.ebBusiness.template.model.Member;
import kd.epm.eb.ebBusiness.template.model.PageDimPropEntry;
import kd.epm.eb.ebBusiness.template.model.PageDimensionEntry;
import kd.epm.eb.ebBusiness.template.model.TemplateModel;
import kd.epm.eb.ebBusiness.template.model.ViewPointDimensionEntry;

public class TemplateDimSettingUtil {
    private static String ALL = "allPoint";
    private static String VIEWPANEL = "panel1";
    private static String PAGEPANEL = "panel2";
    private static String RANKPANEL = "panel3";
    private static String ISEDIT = "edit";

    public static List<Map<String, String>> getPointEntry(AbstractTemplateBasePlugin page, TemplateModel tem, boolean isWorkPaper) {
        if (page.getPageCache().get(ALL) == null) {
            ArrayList allPoint = new ArrayList();
            int maxSeq = QueryDimensionServiceHelper.getMaxDseq((Long)tem.getModelId());
            ApplicationTypeEnum app = ModelUtil.queryApp(page.getView());
            DefaultDimAreaEnum pageenum = DefaultDimAreaEnum.getDefaultDimAreaEnumByArea((String)"page", (String)app.appnum, (boolean)isWorkPaper);
            DefaultDimAreaEnum rankenum = DefaultDimAreaEnum.getDefaultDimAreaEnumByArea((String)"rank", (String)app.appnum, (boolean)isWorkPaper);
            List<String> pagenumbers = Arrays.asList(pageenum.getNumbers());
            List<String> ranknumbers = Arrays.asList(rankenum.getNumbers());
            for (int i = 1; i <= maxSeq; ++i) {
                DynamicObject obj = QueryDimensionServiceHelper.getDimByDseq((int)i, (Long)tem.getModelId());
                if (obj == null) continue;
                HashMap<String, String> map = new HashMap<String, String>();
                if (DimTypesEnum.INTERCOMPANY.getNumber().equals(obj.getString("number")) && !QueryDimensionServiceHelper.checkIcEnt((long)tem.getModelId())) continue;
                map.put("name", obj.getString("name"));
                map.put("entity", obj.getString("membermodel"));
                map.put("sign", obj.getString("membermodel") + i);
                map.put("seq", String.valueOf(i));
                map.put("number", obj.getString("number"));
                String number = obj.getString("number");
                if (pagenumbers.contains(number)) {
                    map.put("panel", PAGEPANEL);
                } else if (ranknumbers.contains(number)) {
                    map.put("sign", obj.getString("membermodel") + i + "t");
                    map.put("panel", RANKPANEL);
                } else {
                    map.put("sign", obj.getString("membermodel") + i + "s");
                    map.put("panel", VIEWPANEL);
                }
                allPoint.add(map);
            }
            page.getPageCache().put(ALL, SerializationUtils.toJsonString(allPoint));
        }
        List ap = (List)SerializationUtils.fromJsonString((String)page.getPageCache().get(ALL), List.class);
        return ap;
    }

    public static void setDefaultValue(AbstractTemplateBasePlugin page, TemplateModel tem, IFormView formView, boolean isWorkPaper) {
        List<Map<String, String>> list = TemplateDimSettingUtil.getPointEntry(page, tem, isWorkPaper);
        for (Map<String, String> map : list) {
            DefaultDimSettingEnum dimSetting = DefaultDimSettingEnum.getDefaultDimSettingEnumByEntity((String)map.get("entity"), (String)page.getBizAppId());
            if (VIEWPANEL.equals(map.get("panel"))) {
                if (dimSetting != null) {
                    DynamicObject memberMsgByNumber;
                    String id = null;
                    String number = dimSetting.getNumber();
                    if (isWorkPaper && dimSetting == DefaultDimSettingEnum.BCM_CURRENCY) {
                        number = "EC";
                    }
                    if (Objects.isNull(memberMsgByNumber = QueryDimensionServiceHelper.getMemberMsgByNumber((long)tem.getModelId(), (String)number, (String)dimSetting.getEntity()))) {
                        if (map.get("number").equals("Scenario") && Objects.isNull(memberMsgByNumber = QueryDimensionServiceHelper.getMemberMsgByNumber((long)tem.getModelId(), (String)DefaultDimSettingEnum.RPT_SCENARIO.getNumber(), (String)dimSetting.getEntity()))) {
                            memberMsgByNumber = QueryDimensionServiceHelper.getMemberMsgByNumber((long)tem.getModelId(), (String)"Actual", (String)dimSetting.getEntity());
                            id = memberMsgByNumber.getString("id");
                        }
                        if ("NoScenario".equals(dimSetting.getNumber())) {
                            id = EBOldTemplateDataResolveUtil.ebAddNoScenario(String.valueOf(tem.getModelId()), formView);
                        }
                    } else {
                        id = memberMsgByNumber.getString("id");
                    }
                    if (StringUtils.isNotEmpty((String)id)) {
                        page.getPageCache().put(map.get("sign"), id);
                        continue;
                    }
                    formView.showErrorNotification(ResManager.loadResFormat((String)"\u7ef4\u5ea6\u6210\u5458%1\u4e0d\u5b58\u5728", (String)"TemplateDimSettingUtil_0", (String)"epm-eb-budget", (Object[])new Object[]{dimSetting.getNumber()}));
                    continue;
                }
                try {
                    long id;
                    if (isWorkPaper && map.get("entity").equals("epm_processmembertree")) {
                        DynamicObject member = QueryDimensionServiceHelper.getMemberMsgByNumber((long)tem.getModelId(), (String)"BPNone", (String)"epm_processmembertree");
                        id = member.getLong("id");
                    } else {
                        long dimid = Long.parseLong(QueryDimensionServiceHelper.getDimIdByNumber((String)map.get("number"), (String)String.valueOf(tem.getModelId())));
                        id = QueryDimensionServiceHelper.getDefautDimMemId((long)dimid, (String)map.get("entity"));
                    }
                    page.getPageCache().put(map.get("sign"), String.valueOf(id));
                }
                catch (Exception e) {
                    formView.showErrorNotification(ResManager.loadResFormat((String)"\u7ef4\u5ea6\u6210\u5458%1\u7684\u9ed8\u8ba4\u6210\u5458\u4e0d\u5b58\u5728", (String)"TemplateDimSettingUtil_2", (String)"epm-eb-budget", (Object[])new Object[]{map.get("number")}));
                }
                continue;
            }
            if (!PAGEPANEL.equals(map.get("panel"))) continue;
            if (dimSetting != null) {
                String number = dimSetting.getNumber();
                if ("epm_scenemembertree".equals(map.get("entity"))) {
                    number = DimensionServiceHelper.getDefaultScenarioNumber((long)tem.getModelId(), (long)0L);
                }
                if (tem.isSaveByDim()) {
                    TemplateDimSettingUtil.initDefaultValue(map.get("sign"), map.get("entity"), number, dimSetting.getRange(), page, tem);
                } else {
                    TemplateDimSettingUtil.initDefaultValue(map.get("sign"), map.get("entity"), DimEntityNumEnum.getNumberByEntieyNum((String)map.get("entity")), RangeEnum.VALUE_40.getValue(), page, tem);
                }
            }
            if ("eb_rulemembertree".equals(map.get("entity"))) {
                if (QueryServiceHelper.exists((String)map.get("entity"), (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)tem.getModelId()), new QFilter("number", "=", (Object)"PRCGAAP")})) {
                    TemplateDimSettingUtil.initDefaultValue(map.get("sign"), map.get("entity"), "PRCGAAP", RangeEnum.VALUE_10.getValue(), page, tem);
                } else {
                    TemplateDimSettingUtil.initDefaultValue(map.get("sign"), map.get("entity"), DimTypesEnum.MULTIGAAP.getNumber(), RangeEnum.VALUE_40.getValue(), page, tem);
                }
            }
            if ("epm_processmembertree".equals(map.get("entity"))) {
                TemplateDimSettingUtil.initDefaultValue(map.get("sign"), map.get("entity"), "Process", RangeEnum.VALUE_50.getValue(), page, tem);
            }
            if (!"epm_audittrialmembertree".equals(map.get("entity"))) continue;
            TemplateDimSettingUtil.initDefaultValue(map.get("sign"), map.get("entity"), "AuditTrail", RangeEnum.VALUE_50.getValue(), page, tem);
        }
    }

    public static void initDefaultValue(String sign, String entity, String number, int scope, AbstractTemplateBasePlugin page, TemplateModel tem) {
        DynamicObject obj = QueryDimensionServiceHelper.getMemberMsgByNumber((long)tem.getModelId(), (String)number, (String)entity);
        if (obj == null && "MRpt".equals(number)) {
            number = "Scenario";
            obj = QueryDimensionServiceHelper.getMemberMsgByNumber((long)tem.getModelId(), (String)number, (String)entity);
        }
        if (obj == null && "M_YearTotal".equals(number)) {
            number = "Period";
            obj = QueryDimensionServiceHelper.getMemberMsgByNumber((long)tem.getModelId(), (String)number, (String)entity);
        }
        if (obj != null) {
            long id = obj.getLong("id");
            ArrayList li = new ArrayList();
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("id", String.valueOf(id));
            m.put("scope", String.valueOf(scope));
            m.put("number", obj.getString("number"));
            m.put("name", obj.getString("name"));
            li.add(m);
            page.getPageCache().put(sign, SerializationUtils.toJsonString(li));
        }
    }

    public static boolean fillBack2TemplateModel(AbstractTemplateBasePlugin pageview, TemplateModel tem, boolean isWorkPaper) {
        TemplateModel template = tem;
        ArrayList<Map<String, String>> view = new ArrayList<Map<String, String>>();
        ArrayList<Map<String, String>> page = new ArrayList<Map<String, String>>();
        ArrayList<Map<String, String>> rank = new ArrayList<Map<String, String>>();
        for (Map<String, String> map : TemplateDimSettingUtil.getPointEntry(pageview, tem, isWorkPaper)) {
            if (VIEWPANEL.equals(map.get("panel"))) {
                if (pageview.getPageCache().get(map.get("sign")) == null) {
                    pageview.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9690\u85cf\u7ef4\u6210\u5458\u3002", (String)"TemplateDimSettingUtil_3", (String)"epm-eb-budget", (Object[])new Object[0]));
                    return false;
                }
                String memberId = pageview.getPageCache().get(map.get("sign"));
                map.put("viewmemb_Id", memberId);
                view.add(map);
                continue;
            }
            if (PAGEPANEL.equals(map.get("panel"))) {
                if (!("epm_entitymembertree".equals(map.get("entity")) || pageview.getPageCache().get(map.get("sign")) != null && ((List)SerializationUtils.fromJsonString((String)pageview.getPageCache().get(map.get("sign")), List.class)).size() != 0)) {
                    pageview.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9875\u9762\u7ef4\u6210\u5458\u3002", (String)"TemplateDimSettingUtil_4", (String)"epm-eb-budget", (Object[])new Object[0]));
                    return false;
                }
                page.add(map);
                continue;
            }
            if (!RANKPANEL.equals(map.get("panel"))) continue;
            rank.add(map);
        }
        if (rank.size() < 2) {
            pageview.getView().showTipNotification(ResManager.loadKDString((String)"\u884c\u7ef4\u5217\u7ef4\u81f3\u5c11\u4fdd\u75592\u4e2a\u7ef4\u5ea6\u3002", (String)"TemplateDimSettingUtil_5", (String)"epm-eb-budget", (Object[])new Object[0]));
            return false;
        }
        if (!QueryDimensionServiceHelper.checkIcEnt((long)tem.getModelId()) && QueryDimensionServiceHelper.isExitDimension((long)tem.getModelId(), (String)DimTypesEnum.INTERCOMPANY.getNumber())) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("entity", "epm_icmembertree");
            map.put("seq", QueryDimensionServiceHelper.getMsgByNumber((long)tem.getModelId(), (String)DimTypesEnum.INTERCOMPANY.getNumber()).getString("dseq"));
            String selectFields = "id";
            QFilter fmodelid = new QFilter("model", "=", (Object)tem.getModelId());
            QFilter fmodelid2 = new QFilter("number", "=", (Object)"ICNone");
            QFilter[] filters = new QFilter[]{fmodelid, fmodelid2};
            DynamicObject member = QueryServiceHelper.queryOne((String)"epm_icmembertree", (String)selectFields, (QFilter[])filters);
            String memberId = String.valueOf(member.get("id"));
            map.put("viewmemb_Id", memberId);
            view.add(map);
        }
        TemplateDimSettingUtil.handleViewEntryFilltoTemplateModel2(template, view, pageview);
        TemplateDimSettingUtil.handlePageEntryFilltoTemplateModel(template, page, pageview);
        TemplateDimSettingUtil.handleRankEntryFilltoCache(template, rank, pageview);
        IPageCache pageCache = (IPageCache)pageview.getView().getParentView().getService(IPageCache.class);
        pageCache.put(ISEDIT, "1");
        return true;
    }

    private static void handleRankEntryFilltoCache(TemplateModel template, List<Map<String, String>> rank, AbstractTemplateBasePlugin pageview) {
        IPageCache pageCache = (IPageCache)pageview.getView().getParentView().getService(IPageCache.class);
        pageCache.put("rank", SerializationUtils.toJsonString(rank));
        pageview.getPageCache().put("rank", SerializationUtils.toJsonString(rank));
    }

    public static void handleViewEntryFilltoTemplateModel2(TemplateModel model, List<Map<String, String>> entries, AbstractTemplateBasePlugin pageview) {
        model.getViewPointDimensionEntries().clear();
        DynamicObject temp = null;
        for (Map<String, String> entry : entries) {
            ViewPointDimensionEntry viewentry = new ViewPointDimensionEntry(model);
            viewentry.setSeq(Integer.parseInt(entry.get("seq")));
            String selectFields = "id,number,name,membermodel,dseq";
            QFilter fmodelid = new QFilter("membermodel", "=", (Object)entry.get("entity"));
            QFilter fmodelid2 = new QFilter("model", "=", (Object)model.getModelId());
            QFilter[] filters = new QFilter[]{fmodelid, fmodelid2};
            DynamicObjectCollection dcs = QueryServiceHelper.query((String)"DimMetaUtil", (String)"epm_dimension", (String)selectFields, (QFilter[])filters, null);
            if (dcs != null && dcs.size() > 0) {
                for (DynamicObject dynamicObject : dcs) {
                    if (!dynamicObject.getString("dseq").equals(entry.get("seq"))) continue;
                    temp = dynamicObject;
                    break;
                }
            }
            if (temp == null) continue;
            Dimension dim = TemplateDimSettingUtil.convertDynaObj2Dimension(temp);
            viewentry.setDimension(dim);
            temp = TemplateDimSettingUtil.loadMemberObject(dim.getMemberEntityNumber(), entry.get("viewmemb_Id"));
            Member member = TemplateDimSettingUtil.convertDynaObj2Member(temp);
            member.setDimension(dim);
            dim.setDataEntityNumber(temp.getDataEntityType().getName());
            viewentry.setMember(member);
            model.getViewPointDimensionEntries().add(viewentry);
        }
    }

    public static void handlePageEntryFilltoTemplateModel(TemplateModel model, List<Map<String, String>> entries, AbstractTemplateBasePlugin pageview) {
        model.getPageDimensionEntries().clear();
        model.getPagePropEntries().clear();
        Dimension dim = null;
        DynamicObject temp = null;
        List membColl = null;
        for (Map<String, String> entry : entries) {
            PageDimensionEntry pageentry;
            QFilter fmodelid2;
            QFilter[] filters;
            DynamicObjectCollection dcs;
            String selectFields = "id,number,name,membermodel,dseq";
            QFilter fmodelid = new QFilter("membermodel", "=", (Object)entry.get("entity"));
            if (entry.get("sign").endsWith("p") && !"MultiGAAP".equalsIgnoreCase(entry.get("sign"))) {
                String membermodel = entry.get("sign").substring(0, entry.get("sign").length() - 1);
                membermodel = membermodel.replaceAll("\\d+", "");
                if (StringUtils.isNotEmpty((String)entry.get("entity"))) {
                    membermodel = entry.get("entity");
                }
                fmodelid = new QFilter("membermodel", "=", (Object)membermodel);
            }
            if ((dcs = QueryServiceHelper.query((String)"DimMetaUtil", (String)"epm_dimension", (String)selectFields, (QFilter[])(filters = new QFilter[]{fmodelid, fmodelid2 = new QFilter("model", "=", (Object)model.getModelId())}), null)) != null && dcs.size() > 0) {
                for (Object dynamicObject : dcs) {
                    if (!dynamicObject.getString("dseq").equals(entry.get("seq"))) continue;
                    temp = dynamicObject;
                    break;
                }
            }
            if (temp != null) {
                dim = TemplateDimSettingUtil.convertDynaObj2Dimension(temp);
                dim.setDataEntityNumber(temp.get("membermodel").toString());
            }
            if (pageview.getPageCache().get(entry.get("sign")) == null) {
                pageentry = new PageDimensionEntry(model);
                pageentry.setDimension(dim);
                pageentry.setSeq(Integer.parseInt(entry.get("seq")));
                pageentry.getMembers().clear();
                model.getPageDimensionEntries().add(pageentry);
                continue;
            }
            membColl = (List)SerializationUtils.fromJsonString((String)pageview.getPageCache().get(entry.get("sign")), List.class);
            if (membColl.size() == 0) {
                pageentry = new PageDimensionEntry(model);
                pageentry.setDimension(dim);
                pageentry.setSeq(Integer.parseInt(entry.get("seq")));
                pageentry.getMembers().clear();
                model.getPageDimensionEntries().add(pageentry);
                continue;
            }
            if (((Map)membColl.get(0)).get("type") != null && "C".equals(((Map)membColl.get(0)).get("type"))) {
                Object dynamicObject;
                PageDimPropEntry pageproentry = new PageDimPropEntry(model);
                pageproentry.setDimension(dim);
                pageproentry.setSeq(Integer.parseInt(entry.get("seq")));
                pageproentry.getAllMembProperties().clear();
                pageproentry.getCustomProperties().clear();
                CustomProperty cp = null;
                dynamicObject = membColl.iterator();
                while (dynamicObject.hasNext()) {
                    Map tempMemb = (Map)dynamicObject.next();
                    MembProperty membpro = new MembProperty();
                    membpro.setId(IDUtils.toLong(tempMemb.get("id")).longValue());
                    membpro.setNumber((String)tempMemb.get("number"));
                    membpro.setName((String)tempMemb.get("name"));
                    cp = new CustomProperty();
                    cp.setId(IDUtils.toLong(tempMemb.get("propid")).longValue());
                    cp.setNumber((String)tempMemb.get("propnumber"));
                    cp.setName((String)tempMemb.get("propname"));
                    membpro.setCustomProperty(cp);
                    membpro.setScope(Integer.parseInt((String)tempMemb.get("scope")));
                    pageproentry.getAllMembProperties().add(membpro);
                    pageproentry.addCustomProperty(cp);
                }
                model.getPagePropEntries().add(pageproentry);
                continue;
            }
            if (dim == null) continue;
            pageentry = new PageDimensionEntry(model);
            pageentry.setDimension(dim);
            pageentry.setSeq(Integer.parseInt(entry.get("seq")));
            pageentry.getMembers().clear();
            for (Map tempMemb : membColl) {
                Member member = TemplateDimSettingUtil.convertDynaObj2Member(TemplateDimSettingUtil.loadMemberObject(dim.getMemberEntityNumber(), tempMemb.get("id")));
                member.setDimension(dim);
                member.setScope(Integer.parseInt((String)tempMemb.get("scope")));
                pageentry.getMembers().add(member);
            }
            model.getPageDimensionEntries().add(pageentry);
        }
    }

    public static Dimension convertDynaObj2Dimension(DynamicObject dynaObj) {
        Dimension dim = new Dimension();
        dim.setId(dynaObj.getLong("id"));
        dim.setNumber(dynaObj.getString("number"));
        dim.setName(dynaObj.getString("name"));
        dim.setDataEntityNumber(dynaObj.getDataEntityType().getName());
        dim.setMemberEntityNumber(dynaObj.getString("membermodel"));
        if (dynaObj.getDataEntityType().getProperties().containsKey((Object)"fieldmapped")) {
            dim.setFieldmapped(dynaObj.getString("fieldmapped"));
        }
        return dim;
    }

    public static DynamicObject loadMemberObject(String entityNum, Object pk) {
        return BusinessDataServiceHelper.loadSingle((Object)pk, (String)entityNum);
    }

    public static Member convertDynaObj2Member(DynamicObject dynaObj) {
        Member member = new Member();
        member.setId(dynaObj.getLong("id"));
        member.setNumber(dynaObj.getString("number"));
        member.setName(dynaObj.getString("name"));
        member.setDataEntityNumber(dynaObj.getDataEntityType().getName());
        return member;
    }

    public static boolean checkDimension(AbstractTemplateBasePlugin pageview, TemplateModel template) {
        boolean is = true;
        ArrayList dimIds = new ArrayList();
        template.getViewPointDimensionEntries().forEach(v -> dimIds.add(v.getDimension().getId()));
        template.getPageDimensionEntries().forEach(p -> dimIds.add(p.getDimension().getId()));
        template.getPagePropEntries().forEach(p -> dimIds.add(p.getDimension().getId()));
        if (template.getAreaRangeEntries().size() != 0 && ((AreaRangeEntry)template.getAreaRangeEntries().get(0)).getColDimEntries().size() != 0) {
            ((AreaRangeEntry)template.getAreaRangeEntries().get(0)).getColDimEntries().forEach(c -> dimIds.add(c.getDimension().getId()));
            ((AreaRangeEntry)template.getAreaRangeEntries().get(0)).getRowDimEntries().forEach(c -> dimIds.add(c.getDimension().getId()));
        } else {
            if (pageview.getPageCache().get("rank") == null) {
                return true;
            }
            List list = (List)SerializationUtils.fromJsonString((String)pageview.getPageCache().get("rank"), List.class);
            list.forEach(p -> dimIds.add(Long.valueOf(QueryDimensionServiceHelper.getDimIdByNumber((String)((String)p.get("number")), (String)String.valueOf(template.getModelId())))));
        }
        List realdimIds = QueryDimensionServiceHelper.getdimensionIds((Long)template.getModelId());
        dimIds.retainAll(realdimIds);
        if (dimIds.size() != realdimIds.size()) {
            is = false;
        }
        return is;
    }
}

