/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.budget.formplugin.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.budget.formplugin.util.ApplicationUtils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.ebcommon.common.enums.dimension.SysDimensionEnum;
import kd.epm.eb.common.ebcommon.common.util.ObjectSerialUtil;
import kd.epm.eb.common.ebcommon.common.util.QFBuilder;
import kd.epm.eb.ebBusiness.serviceHelper.AppCacheServiceHelper;
import kd.epm.eb.ebBusiness.template.model.TemplateModel;

public class TemplateUtil {
    public static Set<String> updateReportStatus(String isEnable, Object[] primaryKeyValues, boolean isCheckEffectiveDate) {
        HashSet<String> unEffectiveDate = new HashSet<String>();
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add("id", "in", (Object)primaryKeyValues);
        qfBuilder.add("status", "!=", (Object)isEnable);
        DynamicObject[] dos = BusinessDataServiceHelper.load((String)"eb_templateentity_bg", (String)TemplateUtil.getSelectParams(isCheckEffectiveDate), (QFilter[])qfBuilder.toArray());
        Arrays.stream(dos).forEach(p -> p.set("status", (Object)isEnable));
        SaveServiceHelper.save((DynamicObject[])dos);
        return unEffectiveDate;
    }

    private static String getSelectParams(boolean isCheckEffectiveDate) {
        if (isCheckEffectiveDate) {
            return "number,name,versionnumber,status,effectivedate";
        }
        return "status";
    }

    public static TemplateModel getTempModel(Object id) {
        TemplateModel template = new TemplateModel();
        String templateSerial = (String)AppCacheServiceHelper.get((String)String.valueOf(id), String.class);
        if (StringUtils.isEmpty((String)templateSerial)) {
            DynamicObject templateDy = BusinessDataServiceHelper.loadSingle((Object)id, (String)"eb_templateentity_bg");
            template.loadDynaObj2Model(templateDy);
            AppCacheServiceHelper.put((String)String.valueOf(id), (Object)ObjectSerialUtil.toByteSerialized((Object)template));
        } else {
            template = (TemplateModel)ObjectSerialUtil.deSerializedBytes((String)templateSerial);
        }
        return template;
    }

    public static boolean isCtrl(IFormView view, String ctrlName) {
        boolean re = false;
        if (ctrlName == null) {
            return re;
        }
        re = view != null ? (ApplicationUtils.hasBudget(view) ? ctrlName.startsWith("epm_") || ctrlName.startsWith("eb_") : ctrlName.startsWith("epm_")) : ctrlName.startsWith("epm_") || ctrlName.startsWith("eb_");
        return re;
    }

    public static void filterVersionTemplateTree(Collection<DynamicObject> templateColls) {
        HashSet passes = new HashSet();
        Map<String, List<DynamicObject>> templateGroups = templateColls.stream().collect(Collectors.groupingBy(e -> e.getString("number")));
        templateGroups.forEach((number, tmpList) -> {
            if (tmpList.size() == 1) {
                passes.add(((DynamicObject)tmpList.get(0)).getLong("id"));
            } else {
                tmpList.sort(new Comparator<DynamicObject>(){

                    @Override
                    public int compare(DynamicObject o1, DynamicObject o2) {
                        return -1 * o1.getBigDecimal("versionnumber").compareTo(o2.getBigDecimal("versionnumber"));
                    }
                });
                passes.add(((DynamicObject)tmpList.get(0)).getLong("id"));
            }
        });
        templateColls.removeIf(t -> !passes.contains(t.getLong("id")));
    }

    public static Map<String, Long> getTemplateNumbersByIds(Set<Long> templateIds) {
        HashMap<String, Long> number2Id = new HashMap<String, Long>();
        BusinessDataServiceHelper.loadFromCache((String)"eb_templateentity_bg", (String)"number", (QFilter[])new QFBuilder("id", "in", templateIds).toArray()).forEach((id, dy) -> number2Id.put(dy.getString("number"), (Long)id));
        return number2Id;
    }

    public static Set<Long> getExistReportIds(DynamicObjectCollection reportColls, Set<Long> templateIds, Map<String, Long> number2Id) {
        HashSet<Long> existReport = new HashSet<Long>();
        reportColls.forEach(rpt -> {
            String number = rpt.getString("template.number");
            Long id = (Long)number2Id.get(number);
            if (id != null) {
                existReport.add(rpt.getLong("template"));
                templateIds.remove(id);
            }
        });
        return existReport;
    }

    public static Set<Long> getRightTplIdByYearAndPeriod(Long modelId, Long yearId, Long periodId, Set<Long> templateIds) {
        DynamicObject[] tpls;
        String currentEndTime;
        String currentBeginTime;
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        HashSet<Long> returnSet = new HashSet<Long>(10);
        Member yearMember = modelCache.getMember(SysDimensionEnum.Year.getNumber(), Long.valueOf(0L), yearId);
        Member periodMember = modelCache.getMember(SysDimensionEnum.Period.getNumber(), Long.valueOf(0L), periodId);
        if (yearMember == null || periodMember == null) {
            return returnSet;
        }
        if (!periodMember.isLeaf()) {
            List leafMember = periodMember.getLeaf();
            currentBeginTime = yearMember.getNumber() + "/" + ((Member)leafMember.get(0)).getNumber();
            currentEndTime = yearMember.getNumber() + "/" + ((Member)leafMember.get(leafMember.size() - 1)).getNumber();
        } else {
            currentBeginTime = yearMember.getNumber() + "/" + periodMember.getNumber();
            currentEndTime = yearMember.getNumber() + "/" + periodMember.getNumber();
        }
        for (DynamicObject t : tpls = BusinessDataServiceHelper.load((String)"eb_templateentity_bg", (String)"id, group, begintime, endtime", (QFilter[])new QFBuilder("id", "in", templateIds).add("status", "=", (Object)"1").toArray(), (String)"id")) {
            Long id = t.getLong("id");
            String begintime = t.getString("begintime");
            if (StringUtils.isEmpty((String)begintime)) {
                returnSet.add(id);
                continue;
            }
            String endtime = t.getString("endtime");
            if (begintime.compareTo(currentBeginTime) >= 0) {
                if (begintime.compareTo(currentEndTime) > 0) continue;
                returnSet.add(t.getLong("id"));
                continue;
            }
            if (!StringUtils.isEmpty((String)endtime) && endtime.compareTo(currentBeginTime) < 0) continue;
            returnSet.add(t.getLong("id"));
        }
        return returnSet;
    }
}

