/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.budget.formplugin.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.ebcommon.common.enums.StorageTypeEnum;

public class TreeEntryEntityUtil {
    public static final String treeentryentity = "treeentryentity";
    public static final String NAME = "name";

    public static void fillTreeEntryEntityUserSeq(IDataModel model, DynamicObjectCollection memberColls, List<String> propertyList, boolean checkIsLeaf) {
        TreeEntryEntityUtil.fillTreeEntryEntityUserSeq(model, memberColls, propertyList, checkIsLeaf, 0L);
    }

    public static void fillTreeEntryEntityUserSeq(IDataModel model, DynamicObjectCollection memberColls, List<String> propertyList, boolean checkIsLeaf, Long parentid) {
        model.getDataEntity(true);
        DynamicObject root = null;
        ArrayList<Long> allMembIds = new ArrayList<Long>();
        if (memberColls != null && memberColls.size() > 0) {
            model.batchCreateNewEntryRow(treeentryentity, memberColls.size());
            String parentKey = "parent";
            if (!(((DynamicObject)memberColls.get(memberColls.size() - 1)).get("parent") instanceof Long)) {
                parentKey = "parent.id";
            }
            for (DynamicObject memb : memberColls) {
                if (root == null && memb.getLong(parentKey) == parentid.longValue()) {
                    root = memb;
                }
                allMembIds.add(memb.getLong("id"));
            }
            HashMap<Long, TreeSet<DynamicObject>> searchChild = new HashMap<Long, TreeSet<DynamicObject>>();
            if (root != null) {
                Comparator<DynamicObject> comparator = TreeEntryEntityUtil.getMembDseqComparator();
                for (int i = 0; i < memberColls.size(); ++i) {
                    TreeSet treeSet;
                    DynamicObject memberObject = (DynamicObject)memberColls.get(i);
                    long parent = memberObject.getLong(parentKey);
                    if (parent == parentid) continue;
                    if (!allMembIds.contains(parent)) {
                        parent = root.getLong("id");
                    }
                    if ((treeSet = (TreeSet)searchChild.get(parent)) != null) {
                        treeSet.add(memberObject);
                        continue;
                    }
                    TreeSet<DynamicObject> children = new TreeSet<DynamicObject>(comparator);
                    children.add(memberObject);
                    searchChild.put(parent, children);
                }
                DynamicObject rowObj = model.getEntryRowEntity(treeentryentity, 0);
                for (int k = 0; k < propertyList.size(); ++k) {
                    String property = propertyList.get(k);
                    if ("showdproperty".equals(property)) {
                        StringBuilder sb = new StringBuilder();
                        for (int i = 1; i <= 10; ++i) {
                            String dpname = root.getString("dpname" + i);
                            String dppaname = root.getString("dppaname" + i);
                            if (!StringUtils.isNotEmpty((String)dpname) || !StringUtils.isNotEmpty((String)dppaname)) continue;
                            sb.append(dppaname).append(':').append(dpname).append(';');
                        }
                        rowObj.set(property, (Object)sb.toString());
                        continue;
                    }
                    if ("cycle".equals(property)) {
                        rowObj.set("daterangefield_startdate", root.get("daterangefield_startdate1"));
                        rowObj.set("daterangefield_enddate", root.get("daterangefield_enddate1"));
                        continue;
                    }
                    if ("drcrdirect1".equals(property)) {
                        rowObj.set("drcrdirect1", (Object)"");
                        continue;
                    }
                    if ("memberid".equals(property)) {
                        rowObj.set(property, (Object)root.getLong("id"));
                        continue;
                    }
                    rowObj.set(property, root.get(property));
                }
                rowObj.set("id", (Object)root.getLong("id"));
                rowObj.set("pid", (Object)0);
                if (checkIsLeaf && !root.getBoolean("isleaf") && searchChild.size() > 1) {
                    rowObj.set("isgroupnode", (Object)true);
                }
                TreeEntryEntityUtil.expandNextLevel(model, propertyList, 0, root, searchChild, checkIsLeaf);
            }
        }
    }

    private static Comparator<DynamicObject> getMembDseqComparator() {
        Comparator<DynamicObject> comparator = new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                int dseq = o1.getInt("dseq") - o2.getInt("dseq");
                if (dseq == 0) {
                    Long id1 = o1.getLong("id");
                    Long id2 = o2.getLong("id");
                    return id1.compareTo(id2);
                }
                return dseq;
            }
        };
        return comparator;
    }

    private static int expandNextLevel(IDataModel model, List<String> propertyList, int row, DynamicObject parent, Map<Long, TreeSet<DynamicObject>> searchChild, boolean checkIsLeaf) {
        if (searchChild.containsKey(parent.getLong("id"))) {
            TreeSet<DynamicObject> childrenMap = searchChild.get(parent.getLong("id"));
            for (DynamicObject child : childrenMap) {
                DynamicObject rowObj = model.getEntryRowEntity(treeentryentity, ++row);
                for (int k = 0; k < propertyList.size(); ++k) {
                    String property = propertyList.get(k);
                    if ("showdproperty".equals(property)) {
                        StringBuilder sb = new StringBuilder();
                        for (int i = 1; i <= 10; ++i) {
                            String dpname = child.getString("dpname" + i);
                            String dppaname = child.getString("dppaname" + i);
                            if (!StringUtils.isNotEmpty((String)dpname) || !StringUtils.isNotEmpty((String)dppaname)) continue;
                            sb.append(dppaname).append(':').append(dpname).append(';');
                        }
                        rowObj.set(property, (Object)sb.toString());
                        continue;
                    }
                    if ("cycle".equals(property)) {
                        rowObj.set("daterangefield_startdate", child.get("daterangefield_startdate1"));
                        rowObj.set("daterangefield_enddate", child.get("daterangefield_enddate1"));
                        continue;
                    }
                    if ("drcrdirect1".equals(property)) {
                        rowObj.set("drcrdirect1", child.get("drcrdirect"));
                        continue;
                    }
                    if ("memberid".equals(property)) {
                        rowObj.set(property, (Object)child.getLong("id"));
                        continue;
                    }
                    rowObj.set(property, child.get(property));
                }
                rowObj.set("id", (Object)child.getLong("id"));
                rowObj.set("pid", (Object)parent.getLong("id"));
                if (checkIsLeaf && !child.getBoolean("isleaf")) {
                    rowObj.set("isgroupnode", (Object)true);
                }
                row = TreeEntryEntityUtil.expandNextLevel(model, propertyList, row, child, searchChild, checkIsLeaf);
            }
        }
        return row;
    }

    public static void fillTreeEntryEntityUserSeq(IDataModel model, DynamicObjectCollection memberColls, List<String> propertyList, List<String> dynamicObjecPpropertyList, Boolean noRoot) {
        HashMap<Long, TreeMap<Integer, DynamicObject>> searchChild = new HashMap<Long, TreeMap<Integer, DynamicObject>>();
        TreeMap children = null;
        for (DynamicObject memberObject : memberColls) {
            Long parent = memberObject.getLong("parent");
            int dseq = memberObject.getInt("dseq");
            children = searchChild.computeIfAbsent(parent, k -> new TreeMap());
            children.put(TreeEntryEntityUtil.getSeqKey(children.keySet(), dseq), memberObject);
        }
        int rows = TreeEntryEntityUtil.countRows(searchChild, 0L, 0);
        int realRows = noRoot != false ? --rows : rows;
        model.getDataEntity(true);
        if (realRows > 0) {
            model.batchCreateNewEntryRow(treeentryentity, realRows);
        }
        if (noRoot.booleanValue()) {
            TreeEntryEntityUtil.expandNextLevelNoRoot(model, propertyList, 0, 0L, searchChild, dynamicObjecPpropertyList);
        } else {
            TreeEntryEntityUtil.expandNextLevel(model, propertyList, 0, 0L, searchChild, dynamicObjecPpropertyList);
        }
    }

    private static int countRows(Map<Long, TreeMap<Integer, DynamicObject>> searchChild, long rootId, int rows) {
        TreeMap<Integer, DynamicObject> children = searchChild.get(rootId);
        if (children != null && !children.isEmpty()) {
            for (DynamicObject child : children.values()) {
                ++rows;
                rows = TreeEntryEntityUtil.countRows(searchChild, child.getLong("id"), rows);
            }
        }
        return rows;
    }

    private static int expandNextLevel(IDataModel model, List<String> propertyList, int row, Long parentid, Map<Long, TreeMap<Integer, DynamicObject>> searchChild, List<String> dynamicObjecPpropertyList) {
        if (searchChild.containsKey(parentid)) {
            TreeMap<Integer, DynamicObject> childrenMap = searchChild.get(parentid);
            Collection<DynamicObject> children = childrenMap.values();
            for (DynamicObject child : children) {
                DynamicObject rowObj = model.getEntryRowEntity(treeentryentity, row++);
                rowObj.set("id", (Object)child.getLong("id"));
                rowObj.set("pid", (Object)parentid);
                for (int k = 0; k < propertyList.size(); ++k) {
                    String property = propertyList.get(k);
                    if ("storagetype".equals(property)) {
                        if (StringUtils.isEmpty((String)child.getString(dynamicObjecPpropertyList.get(k)))) {
                            rowObj.set(property, (Object)StorageTypeEnum.getStorageTypeEnumByIndex((String)"2").getName());
                            continue;
                        }
                        rowObj.set(property, (Object)StorageTypeEnum.getStorageTypeEnumByIndex((String)child.getString(dynamicObjecPpropertyList.get(k))).getName());
                        continue;
                    }
                    rowObj.set(property, child.get(dynamicObjecPpropertyList.get(k)));
                }
                row = TreeEntryEntityUtil.expandNextLevel(model, propertyList, row, child.getLong("id"), searchChild, dynamicObjecPpropertyList);
            }
        }
        return row;
    }

    private static int expandNextLevelNoRoot(IDataModel model, List<String> propertyList, int row, Long parentid, Map<Long, TreeMap<Integer, DynamicObject>> searchChild, List<String> dynamicObjecPpropertyList) {
        if (searchChild.containsKey(parentid)) {
            TreeMap<Integer, DynamicObject> childrenMap = searchChild.get(parentid);
            Collection<DynamicObject> children = childrenMap.values();
            for (DynamicObject child : children) {
                row = TreeEntryEntityUtil.expandNextLevel(model, propertyList, row, child.getLong("id"), searchChild, dynamicObjecPpropertyList);
            }
        }
        return row;
    }

    public static int[] focus(IDataModel model, int row) {
        ArrayList<Integer> pids = new ArrayList<Integer>();
        DynamicObjectCollection objs = model.getEntryEntity(treeentryentity);
        ArrayList<String> ids = new ArrayList<String>(10);
        for (int i = 0; i < objs.size(); ++i) {
            ids.add(((DynamicObject)objs.get(i)).getString("id"));
        }
        DynamicObject oo = (DynamicObject)objs.get(row);
        String pid = oo.getString("pid");
        while (StringUtils.isNotEmpty((String)pid)) {
            int i = -1;
            if (ids.contains(pid)) {
                i = ids.indexOf(pid);
                pids.add(i);
            }
            if (i != -1) {
                pid = ((DynamicObject)objs.get(i)).getString("pid");
                continue;
            }
            pid = "";
        }
        Collections.sort(pids);
        int[] exids = new int[pids.size()];
        for (int i = 0; i < exids.length; ++i) {
            exids[i] = (Integer)pids.get(i);
        }
        return exids;
    }

    private static Integer getSeqKey(Set<Integer> keys, int seq) {
        while (keys.contains(seq)) {
            ++seq;
        }
        return seq;
    }
}

