/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.budget.formplugin.util;

import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.util.StringUtils;
import kd.epm.eb.budget.formplugin.util.ModelUtil;
import kd.epm.eb.common.ebcommon.common.enums.ApplicationTypeEnum;
import kd.epm.eb.common.ebcommon.common.log.BcmLogFactory;
import kd.epm.eb.common.ebcommon.common.log.WatchLogger;
import kd.epm.eb.common.utils.UserUtils;
import kd.epm.eb.ebBusiness.model.UserSelectModel;
import kd.epm.eb.ebBusiness.serviceHelper.BcmFunPermissionHelper;
import kd.epm.eb.ebBusiness.serviceHelper.MemberPermHelper;
import kd.epm.eb.ebBusiness.serviceHelper.UserSelectServiceHelper;

public class UserSelectUtil {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance(UserSelectUtil.class);
    public static final String model = "model";
    public static final String year = "year";
    public static final String period = "period";
    public static final String scene = "scenario";
    public static final String entity = "entity";
    public static final String currency = "currency";
    public static final String version = "version";
    public static final String cslScheme = "cslscheme";

    public static String getF7SelectId(IFormView formView, String f7key) {
        String f7SelectId = null;
        try {
            DynamicObject dynamicObject = (DynamicObject)formView.getModel().getValue(f7key);
            if (dynamicObject == null) {
                return null;
            }
            f7SelectId = dynamicObject.getString("id");
        }
        catch (Exception e) {
            log.error("error", (Throwable)e);
        }
        return f7SelectId == null || f7SelectId.equals("0") ? null : f7SelectId;
    }

    public static String getModelIdAfterCreateNewData(IFormView formView, String model, boolean byForm) {
        UserSelectModel userselect = UserSelectUtil.getUserSelectAfterCreateNewData(formView, model, byForm);
        if (scene.equals(model)) {
            return userselect != null ? userselect.getScene() : null;
        }
        if (userselect != null) {
            return userselect.getModel();
        }
        return UserSelectUtil.getF7SelectId(formView, model);
    }

    public static UserSelectModel getUserSelectAfterCreateNewData(IFormView formView, String model, boolean byForm) {
        Boolean hasPublicModel;
        UserSelectModel userSelect = null;
        String modelId = "";
        userSelect = new UserSelectModel();
        ApplicationTypeEnum application = ModelUtil.queryApp(formView);
        String formsign = formView.getFormShowParameter().getFormId();
        if (StringUtils.isEmpty((String)modelId) || modelId.equals("0")) {
            userSelect = byForm ? UserSelectServiceHelper.getUserSelectByForm((Long)UserUtils.getUserId(), (String)"id,model,application,entity,year,period,scenario,currency,modifier,onlymodel,formid,version,modeltype", (ApplicationTypeEnum)application, (String)formsign) : UserSelectServiceHelper.getUserSelect((Long)UserUtils.getUserId(), (String)"id,model,application,entity,year,period,scenario,currency,modifier,onlymodel,formid,version,modeltype", (ApplicationTypeEnum)application);
            modelId = userSelect == null || userSelect.getModel() == null || userSelect.getModel().equals("0") ? "0" : userSelect.getModel();
        }
        Set permIdSet = MemberPermHelper.getLimitedModelListByUser((ApplicationTypeEnum)application);
        Set haspermids = BcmFunPermissionHelper.getEffectiveByPermModel((String)formView.getEntityId(), (ApplicationTypeEnum)application);
        Set perRoleids = BcmFunPermissionHelper.getRoleModel((long)UserUtils.getUserId(), (String)"epm_model", (ApplicationTypeEnum)application, (String)formView.getEntityId(), (String)"47150e89000000ac");
        if (permIdSet != null) {
            permIdSet.addAll(perRoleids);
            permIdSet.addAll(haspermids);
        }
        if (application != ApplicationTypeEnum.RPT || !(hasPublicModel = BcmFunPermissionHelper.existPublicModel()).booleanValue()) {
            // empty if block
        }
        if (permIdSet != null && permIdSet.size() > 0) {
            if (!permIdSet.contains(Long.valueOf(modelId))) {
                modelId = String.valueOf(permIdSet.iterator().next());
                if (userSelect == null) {
                    userSelect = new UserSelectModel();
                }
                userSelect.setModel(modelId);
            }
        } else {
            switch (application) {
                case RPT: {
                    formView.showTipNotification(ResManager.loadKDString((String)"\u65e0\u4efb\u4f55\u62a5\u8868\u4f53\u7cfb\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u4f53\u7cfb\u7ba1\u7406\u5458\u3002", (String)"UserSelectUtil_0", (String)"epm-eb-budget", (Object[])new Object[0]));
                    break;
                }
            }
            return null;
        }
        return userSelect;
    }

    public static void saveUserSelectWhenModelChange(IFormView formView, String modelId) {
        ApplicationTypeEnum application = ModelUtil.queryApp(formView);
        UserSelectUtil.savetUserSelectOnlyModel(modelId, application);
    }

    public static void savetUserSelectOnlyModel(String modelId, ApplicationTypeEnum application) {
        if (modelId == null || modelId.equals("0")) {
            return;
        }
        UserSelectModel userSelectModel = new UserSelectModel();
        userSelectModel.setModel(modelId);
        userSelectModel.setModifier(UserUtils.getUserId());
        userSelectModel.setApplication(application);
        userSelectModel.setOnlyModel(true);
        UserSelectServiceHelper.saveUserSelect((UserSelectModel)userSelectModel);
    }

    public static void savetUserSelect(UserSelectModel userSelectModel) {
        if (userSelectModel == null) {
            return;
        }
        String modelId = userSelectModel.getModel();
        if (modelId == null || modelId.equals("0")) {
            return;
        }
        UserSelectServiceHelper.saveUserSelect((UserSelectModel)userSelectModel);
    }
}

