/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.budget.opplugin.approvebill;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class AuditOp
extends AbstractOperationServicePlugIn {
    private static final Log LOG = LogFactory.getLog(AuditOp.class);
    private static final String BTN_UNSUBMIT = "unsubmit";
    private static final String BTN_SUBMIT = "submit";
    private static final String BTN_AUDITPASS = "auditpass";
    private static final String BTN_AUDIT = "audit";
    private static final String BTN_UNAUDIT = "unaudit";
    private static final String CON_BILLSTATUS = "billstatus";
    private static final String CON_BILLNO = "billno";

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        switch (e.getOperationKey().toLowerCase()) {
            case "unsubmit": {
                this.updateBillStatus(e, "A");
                break;
            }
            case "submit": {
                this.updateBillStatus(e, "B");
                break;
            }
            case "auditpass": 
            case "audit": {
                this.updateBillStatus(e, "E");
                break;
            }
        }
        LOG.info(String.format("bcm_eb_approvebill getOperationKey is %s", e.getOperationKey().toLowerCase()));
    }

    private void updateBillStatus(EndOperationTransactionArgs e, String status) {
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities.length > 0) {
            LOG.info(String.format("bcm_eb_approvebill billstatus changed %s", status));
            DynamicObject[] dynamicObjectArray = dataEntities;
            int n = dynamicObjectArray.length;
            for (int i = 0; i < n; ++i) {
                DynamicObject dataEntity;
                DynamicObject doc = dataEntity = dynamicObjectArray[i];
                String billnumber = doc.getString(CON_BILLNO);
                try {
                    DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"bcm_eb_approvebill", (String)CON_BILLSTATUS, (QFilter[])new QFilter[]{new QFilter(CON_BILLNO, "=", (Object)billnumber)});
                    dynamicObject.set(CON_BILLSTATUS, (Object)status);
                    DynamicObject[] dy = new DynamicObject[]{dynamicObject};
                    SaveServiceHelper.save((DynamicObject[])dy);
                    continue;
                }
                catch (Exception ex) {
                    throw new KDBizException(ex.getMessage());
                }
            }
        }
    }
}

