/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.budget.opplugin.jslint4java;

import kd.epm.eb.budget.opplugin.jslint4java.Util;
import org.mozilla.javascript.Scriptable;

public class Issue {
    private final int character;
    private final String evidence;
    private final int line;
    private final String raw;
    private final String reason;
    private final String systemId;

    private Issue(IssueBuilder ib) {
        this.systemId = ib.systemId;
        this.reason = ib.reason;
        this.line = ib.line;
        this.character = ib.character;
        this.evidence = ib.evidence;
        this.raw = ib.raw;
    }

    public int getCharacter() {
        return this.character;
    }

    public String getEvidence() {
        return this.evidence;
    }

    public int getLine() {
        return this.line;
    }

    public String getRaw() {
        return this.raw;
    }

    public String getReason() {
        return this.reason;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public String toString() {
        return this.getSystemId() + ":" + this.getLine() + ":" + this.getCharacter() + ":" + this.getReason();
    }

    public static class IssueBuilder {
        private final int character;
        private String evidence;
        private final int line;
        private String raw;
        private final String reason;
        private final String systemId;

        public static Issue fromJavaScript(String systemId, Scriptable err) {
            int line = Util.intValue("line", err);
            int col = Util.intValue("character", err);
            return new IssueBuilder(systemId, line, col, Util.stringValue("reason", err)).evidence(Util.stringValue("evidence", err)).raw(Util.stringValue("raw", err)).build();
        }

        public IssueBuilder(String systemId, int line, int character, String reason) {
            this.character = character;
            this.line = line;
            this.reason = reason;
            this.systemId = systemId;
        }

        public Issue build() {
            return new Issue(this);
        }

        public IssueBuilder evidence(String evidence) {
            this.evidence = evidence;
            return this;
        }

        public IssueBuilder raw(String raw) {
            this.raw = raw;
            return this;
        }
    }
}

