/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.budget.opplugin.jslint4java;

import java.util.ArrayList;
import java.util.List;

public class JSFunction {
    private final List<String> closure = new ArrayList<String>();
    private final List<String> exception = new ArrayList<String>();
    private final List<String> global = new ArrayList<String>();
    private final List<String> label = new ArrayList<String>();
    private final int last;
    private final int line;
    private final String name;
    private final List<String> outer = new ArrayList<String>();
    private final List<String> params = new ArrayList<String>();
    private final List<String> unused = new ArrayList<String>();
    private final List<String> undef = new ArrayList<String>();
    private final List<String> vars = new ArrayList<String>();

    private JSFunction(Builder builder) {
        this.name = builder.name;
        this.line = builder.line;
        this.last = builder.last;
        this.closure.addAll(builder.closures);
        this.exception.addAll(builder.exceptions);
        this.global.addAll(builder.globals);
        this.label.addAll(builder.labels);
        this.outer.addAll(builder.outers);
        this.params.addAll(builder.params);
        this.unused.addAll(builder.unuseds);
        this.undef.addAll(builder.undefs);
        this.vars.addAll(builder.vars);
    }

    public List<String> getClosure() {
        return this.closure;
    }

    public List<String> getException() {
        return this.exception;
    }

    public List<String> getGlobal() {
        return this.global;
    }

    public List<String> getLabel() {
        return this.label;
    }

    public int getLast() {
        return this.last;
    }

    public int getLine() {
        return this.line;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getOuter() {
        return this.outer;
    }

    public List<String> getParams() {
        return this.params;
    }

    public List<String> getUnused() {
        return this.unused;
    }

    public List<String> getUndef() {
        return this.undef;
    }

    public List<String> getVars() {
        return this.vars;
    }

    public String toString() {
        return String.format("function %s()", this.getName());
    }

    public static class Builder {
        private final List<String> closures = new ArrayList<String>();
        private final List<String> exceptions = new ArrayList<String>();
        private final List<String> globals = new ArrayList<String>();
        private final List<String> labels = new ArrayList<String>();
        private int last;
        private final int line;
        private final String name;
        private final List<String> outers = new ArrayList<String>();
        private final List<String> params = new ArrayList<String>();
        private final List<String> unuseds = new ArrayList<String>();
        private final List<String> undefs = new ArrayList<String>();
        private final List<String> vars = new ArrayList<String>();

        public Builder(String name, int line) {
            this.name = name;
            this.line = line;
        }

        public Builder addClosure(String closure) {
            this.closures.add(closure);
            return this;
        }

        public Builder addException(String exception) {
            this.exceptions.add(exception);
            return this;
        }

        public Builder addGlobal(String global) {
            this.globals.add(global);
            return this;
        }

        public Builder addLabel(String label) {
            this.labels.add(label);
            return this;
        }

        public Builder addOuter(String outer) {
            this.outers.add(outer);
            return this;
        }

        public Builder addParam(String param) {
            this.params.add(param);
            return this;
        }

        public Builder addUnused(String unused) {
            this.unuseds.add(unused);
            return this;
        }

        public Builder addUndef(String unused) {
            this.undefs.add(unused);
            return this;
        }

        public Builder addVar(String var) {
            this.vars.add(var);
            return this;
        }

        public JSFunction build() {
            return new JSFunction(this);
        }

        public Builder last(int last) {
            this.last = last;
            return this;
        }
    }
}

