/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.budget.opplugin.jslint4java;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.budget.opplugin.jslint4java.JSLint;
import kd.epm.eb.budget.opplugin.jslint4java.TimeLimitedContextFactory;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JSLintBuilder {
    private static final Log log = LogFactory.getLog(JSLintBuilder.class);
    private static final String JSLINT_FILE = "jslint4java/jslint.js";
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private ContextFactory contextFactory = new ContextFactory();

    public JSLint fromClasspathResource(String resource) throws IOException {
        return this.fromClasspathResource(resource, UTF8);
    }

    public JSLint fromClasspathResource(String resource, Charset encoding) throws IOException {
        Reader reader = null;
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream(resource), encoding);
            reader = new BufferedReader(inputStreamReader);
            JSLint jSLint = this.fromReader(reader, resource);
            return jSLint;
        }
        catch (IOException ex) {
            log.error((Throwable)ex);
            throw ex;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage());
                }
            }
            if (inputStreamReader != null) {
                try {
                    inputStreamReader.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage());
                }
            }
        }
    }

    public JSLint fromDefault() {
        try {
            return this.fromClasspathResource(JSLINT_FILE);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public JSLint fromFile(File f) throws IOException {
        return this.fromFile(f, UTF8);
    }

    public JSLint fromFile(File f, Charset encoding) throws IOException {
        Reader reader = null;
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(f), encoding);
            reader = new BufferedReader(inputStreamReader);
            JSLint jSLint = this.fromReader(reader, f.toString());
            return jSLint;
        }
        catch (IOException ex) {
            log.error((Throwable)ex);
            throw ex;
        }
        finally {
            if (inputStreamReader != null) {
                try {
                    inputStreamReader.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage());
                }
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSLint fromReader(Reader reader, String name) throws IOException {
        try {
            Context cx = this.contextFactory.enterContext();
            ScriptableObject scope = cx.initStandardObjects();
            cx.evaluateReader((Scriptable)scope, reader, name, 1, null);
            JSLint jSLint = new JSLint(this.contextFactory, scope);
            return jSLint;
        }
        finally {
            Context.exit();
        }
    }

    public JSLintBuilder timeout(long maxTimeInSeconds) {
        return this.timeout(maxTimeInSeconds, TimeUnit.SECONDS);
    }

    public JSLintBuilder timeout(long maxTime, TimeUnit timeUnit) {
        this.contextFactory = new TimeLimitedContextFactory(maxTime, timeUnit);
        return this;
    }
}

