/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.budget.opplugin.jslint4java.formatter;

import java.util.List;
import java.util.Locale;
import kd.epm.eb.budget.opplugin.jslint4java.Issue;
import kd.epm.eb.budget.opplugin.jslint4java.JSLintResult;
import kd.epm.eb.budget.opplugin.jslint4java.formatter.JSLintResultFormatter;
import kd.epm.eb.budget.opplugin.jslint4java.formatter.XmlFormatter;

public class JUnitXmlFormatter
extends XmlFormatter
implements JSLintResultFormatter {
    private static final String TEST_CLASSNAME = "kd.epm.eb.budget.opplugin.jslint4java";

    @Override
    public String format(JSLintResult result) {
        StringBuilder sb = new StringBuilder("<testsuite");
        List<Issue> issues = result.getIssues();
        String testFailures = issues.isEmpty() ? "0" : "1";
        sb.append(this.attr("failures", testFailures));
        sb.append(this.attr("time", this.formatTimeAsSeconds(result.getDuration())));
        sb.append(this.attr("skipped", "0"));
        sb.append(this.attr("errors", testFailures));
        sb.append(this.attr("tests", "1"));
        sb.append(this.attr("name", result.getName()));
        sb.append(">");
        sb.append("<testcase");
        sb.append(this.attr("time", this.formatTimeAsSeconds(result.getDuration())));
        sb.append(this.attr("classname", TEST_CLASSNAME));
        sb.append(this.attr("name", result.getName()));
        sb.append(">");
        if (!issues.isEmpty()) {
            sb.append("<failure");
            String msg = String.format("Found %d problem%s", issues.size(), this.s(issues.size()));
            sb.append(this.attr("message", msg));
            sb.append(this.attr("type", AssertionError.class.getName()));
            sb.append(">");
            for (Issue issue : issues) {
                sb.append(this.escape(issue.toString()));
                sb.append(System.getProperty("line.separator"));
            }
            sb.append("</failure>");
        }
        sb.append("</testcase>");
        sb.append("</testsuite>");
        return sb.toString();
    }

    private String formatTimeAsSeconds(long duration) {
        return String.format(Locale.ENGLISH, "%.3f", (double)duration / 1000.0);
    }

    private String s(int size) {
        return size == 1 ? "" : "s";
    }

    @Override
    protected String root() {
        return "testsuites";
    }
}

