/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.budget.opplugin.jslint4java.formatter;

import kd.epm.eb.budget.opplugin.jslint4java.Issue;
import kd.epm.eb.budget.opplugin.jslint4java.JSLintResult;
import kd.epm.eb.budget.opplugin.jslint4java.formatter.JSLintResultFormatter;

public class PlainFormatter
implements JSLintResultFormatter {
    @Override
    public String footer() {
        return null;
    }

    @Override
    public String format(JSLintResult result) {
        StringBuilder sb = new StringBuilder();
        for (Issue issue : result.getIssues()) {
            sb.append(this.outputOneIssue(issue));
        }
        return sb.toString();
    }

    @Override
    public String header() {
        return null;
    }

    private String outputOneIssue(Issue issue) {
        String nl = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        sb.append(issue.getSystemId());
        sb.append(':');
        sb.append(issue.getLine());
        sb.append(':');
        sb.append(issue.getCharacter());
        sb.append(": ");
        sb.append(issue.getReason());
        sb.append(nl);
        String evidence = issue.getEvidence();
        if (evidence != null && !"".equals(evidence)) {
            sb.append(evidence);
            sb.append(nl);
            if (issue.getCharacter() > 0) {
                sb.append(this.spaces(issue.getCharacter() - 1));
            }
            sb.append("^");
            sb.append(nl);
        }
        return sb.toString();
    }

    protected String spaces(int howmany) {
        StringBuilder sb = new StringBuilder(howmany);
        for (int i = 0; i < howmany; ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }
}

