/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.olap;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.constant.OlapConstant;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.Member;
import kd.epm.eb.common.utils.BgDimensionServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.olap.IOlapServiceCaller;
import kd.epm.eb.olap.api.dataSource.IKDOlapRequest;
import kd.epm.eb.olap.api.query.IKDQuery;
import kd.epm.eb.olap.impl.utils.PropertyUtils;

public abstract class AbstractOlapServiceCaller
implements IOlapServiceCaller {
    protected void verifySave(IKDOlapRequest request) {
        if (request == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u4fdd\u5b58\u9519\u8bef\uff0c\u8bf7\u6c42\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractOlapServiceCaller_0", (String)"epm-eb-olap", (Object[])new Object[0]));
        }
        if (request.getCubeId() == null || request.getCubeId() == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u4fdd\u5b58\u9519\u8bef\uff0c\u4f53\u7cfbid\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractOlapServiceCaller_1", (String)"epm-eb-olap", (Object[])new Object[0]));
        }
        if (request.getOlapData() == null || !request.getOlapData().check()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u4fdd\u5b58\u9519\u8bef\uff0c\u7528\u6237\u4e0d\u80fd\u4e3a\u7a7a\u62160\u3002", (String)"AbstractOlapServiceCaller_2", (String)"epm-eb-olap", (Object[])new Object[0]));
        }
    }

    protected void verifyQuery(IKDOlapRequest request) {
        if (request == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u67e5\u8be2\u9519\u8bef\uff0c\u8bf7\u6c42\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractOlapServiceCaller_3", (String)"epm-eb-olap", (Object[])new Object[0]));
        }
        if (IDUtils.isNull((Long)request.getCubeId())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u67e5\u8be2\u9519\u8bef\uff0c\u8bf7\u586b\u5199\u4f53\u7cfbid\u3002", (String)"AbstractOlapServiceCaller_4", (String)"epm-eb-olap", (Object[])new Object[0]));
        }
        if (IDUtils.isNull((Long)request.getOlapQuery().getBusModelId())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u67e5\u8be2\u9519\u8bef\uff0c\u4e1a\u52a1\u6a21\u578bid\u4e0d\u80fd\u4e3a\u7a7a\u62160\uff0c\u8bf7\u68c0\u67e5\u4e1a\u52a1\u6a21\u578b\u662f\u5426\u8bbe\u7f6e\u63a7\u5236\u7ef4\u5ea6\u3002", (String)"AbstractOlapServiceCaller_5", (String)"epm-eb-olap", (Object[])new Object[0]));
        }
        boolean ignDataset = PropertyUtils.isIgnDataset(request.getProperties());
        if (!ignDataset && IDUtils.isNull((Long)request.getOlapQuery().getDatasetId())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u67e5\u8be2\u9519\u8bef\uff0c\u6570\u636e\u96c6id\u4e0d\u80fd\u4e3a\u7a7a\u62160\u3002", (String)"AbstractOlapServiceCaller_6", (String)"epm-eb-olap", (Object[])new Object[0]));
        }
    }

    protected void verifyDimension(IKDOlapRequest request, boolean hasFloatQuery) {
        if (request == null || request.getOlapQuery() == null) {
            return;
        }
        IModelCacheHelper cacheHelper = request.getOlapQuery().getModelCacheHelper();
        if (cacheHelper == null) {
            cacheHelper = ModelCacheContext.getOrCreate((Long)request.getOlapQuery().getModelId());
            request.getOlapQuery().setModelCacheHelper(cacheHelper);
        }
        boolean ignDataset = PropertyUtils.isIgnDataset(request.getProperties());
        Map dimensionMap = null;
        if (!ignDataset) {
            dimensionMap = cacheHelper.getDimensionMap(request.getOlapQuery().getDatasetId());
        }
        for (IKDQuery query : request.getOlapQuery().getQueries()) {
            if (query.getDimension() == null || query.getDimension().isEmpty()) {
                if (hasFloatQuery) {
                    if (query.getFloatRows().isEmpty() && query.getFloatCols().isEmpty()) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u67e5\u8be2\u9519\u8bef\uff0c\u6570\u636e\u67e5\u8be2\u7684\u7ef4\u5ea6\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractOlapServiceCaller_7", (String)"epm-eb-olap", (Object[])new Object[0]));
                    }
                } else {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u67e5\u8be2\u9519\u8bef\uff0c\u6570\u636e\u67e5\u8be2\u7684\u7ef4\u5ea6\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractOlapServiceCaller_7", (String)"epm-eb-olap", (Object[])new Object[0]));
                }
            }
            for (kd.epm.eb.common.model.Dimension dimension : query.getDimension()) {
                if (!dimension.getMembers().isEmpty()) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u67e5\u8be2\u9519\u8bef\uff0c\u6570\u636e\u67e5\u8be2\u7684\u7ef4\u5ea6\u6210\u5458\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractOlapServiceCaller_8", (String)"epm-eb-olap", (Object[])new Object[0]));
            }
            Set queryDims = query.getDimension().stream().map(kd.epm.eb.common.model.Dimension::getNumber).collect(Collectors.toSet());
            if (hasFloatQuery) {
                kd.epm.eb.common.model.Dimension[] dimensions;
                if (!query.getFloatRows().isEmpty() && (dimensions = query.getFloatRows().get(0)) != null) {
                    kd.epm.eb.common.model.Dimension[] dimensionArray = dimensions;
                    int n = dimensionArray.length;
                    for (int i = 0; i < n; ++i) {
                        kd.epm.eb.common.model.Dimension _floatRow = dimensionArray[i];
                        queryDims.add(_floatRow.getNumber());
                    }
                }
                if (!query.getFloatCols().isEmpty()) {
                    for (kd.epm.eb.common.model.Dimension _floatCol : query.getFloatCols()) {
                        queryDims.add(_floatCol.getNumber());
                    }
                }
            }
            if (dimensionMap != null) {
                for (Dimension dimension : dimensionMap.values()) {
                    if (queryDims.contains(dimension.getNumber())) continue;
                    if (BgDimensionServiceHelper.hasUserDefinedDimension((Dimension)dimension) || SysDimensionEnum.InternalCompany.getNumber().equals(dimension.getNumber())) {
                        kd.epm.eb.common.model.Dimension _dimension = kd.epm.eb.common.model.Dimension.loadFormCache((Dimension)dimension);
                        Long viewId = query.getViews().get(dimension.getNumber());
                        _dimension.add(Member.loadFormCache((kd.epm.eb.common.cache.impl.Member)dimension.getMember(viewId, dimension.getNoneNumber())));
                        query.getDimension().add(_dimension);
                        continue;
                    }
                    throw new KDBizException(ResManager.loadResFormat((String)"\u6570\u636e\u67e5\u8be2\u9519\u8bef\uff0c\u53c2\u6570\u7f3a\u5c11 %1 \u7ef4\u5ea6(%2)\u3002", (String)"AbstractOlapServiceCaller_9", (String)"epm-eb-olap", (Object[])new Object[]{dimension.getName(), dimension.getNumber()}));
                }
                continue;
            }
            for (String dimNumber : OlapConstant.DEFAULT_EPM_FIX_DIMENSION) {
                if (queryDims.contains(dimNumber)) continue;
                throw new KDBizException(ResManager.loadResFormat((String)"\u6570\u636e\u67e5\u8be2\u9519\u8bef\uff0c\u53c2\u6570\u7f3a\u5c11\u201c%1\u201d\u7ef4\u5ea6\u3002", (String)"AbstractOlapServiceCaller_10", (String)"epm-eb-olap", (Object[])new Object[]{dimNumber}));
            }
        }
    }
}

